/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.ObjectProxyCache;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSupport {
    private static final Map<String, Class> PRIMITIVE_CLASSES = new HashMap<String, Class>();
    private final Ruby runtime;
    private final Map<String, RubyProc> exceptionHandlers = new HashMap<String, RubyProc>();
    private final ObjectProxyCache<IRubyObject, RubyClass> objectProxyCache = new ObjectProxyCache<IRubyObject, RubyClass>(ObjectProxyCache.ReferenceType.WEAK){

        @Override
        public IRubyObject allocateProxy(Object object, RubyClass rubyClass) {
            IRubyObject iRubyObject = rubyClass.allocate();
            iRubyObject.getInstanceVariables().fastSetInstanceVariable("@java_object", JavaObject.wrap(rubyClass.getRuntime(), object));
            return iRubyObject;
        }
    };
    private final ConcurrentHashMap<Class, JavaClass> javaClassCache = new ConcurrentHashMap(128);
    private final Map matchCache = Collections.synchronizedMap(new HashMap(128));
    private Callback concreteProxyCallback;
    private RubyModule javaModule;
    private RubyModule javaUtilitiesModule;
    private RubyClass javaObjectClass;
    private RubyClass javaClassClass;
    private RubyClass javaArrayClass;
    private RubyClass javaProxyClass;
    private RubyModule javaInterfaceTemplate;
    private RubyModule packageModuleTemplate;
    private RubyClass arrayProxyClass;
    private RubyClass concreteProxyClass;

    public static Class getPrimitiveClass(String string) {
        return PRIMITIVE_CLASSES.get(string);
    }

    public JavaSupport(Ruby ruby) {
        this.runtime = ruby;
    }

    final synchronized void setConcreteProxyCallback(Callback callback) {
        if (this.concreteProxyCallback == null) {
            this.concreteProxyCallback = callback;
        }
    }

    final Callback getConcreteProxyCallback() {
        return this.concreteProxyCallback;
    }

    final Map getMatchCache() {
        return this.matchCache;
    }

    private Class loadJavaClass(String string) throws ClassNotFoundException {
        Class clazz = PRIMITIVE_CLASSES.get(string);
        if (clazz == null) {
            if (!Ruby.isSecurityRestricted()) {
                return Class.forName(string, true, this.runtime.getJRubyClassLoader());
            }
            return Class.forName(string);
        }
        return clazz;
    }

    public Class loadJavaClassVerbose(String string) {
        try {
            return this.loadJavaClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.runtime.newNameError("cannot load Java class " + string, string, classNotFoundException);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw this.runtime.newNameError("cannot initialize Java class " + string, string, exceptionInInitializerError);
        }
        catch (LinkageError linkageError) {
            throw this.runtime.newNameError("cannot link Java class " + string, string, linkageError);
        }
        catch (SecurityException securityException) {
            throw this.runtime.newNameError("security: cannot load Java class " + string, string, securityException);
        }
    }

    public Class loadJavaClassQuiet(String string) {
        try {
            return this.loadJavaClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.runtime.newNameError("cannot load Java class " + string, string, classNotFoundException, false);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw this.runtime.newNameError("cannot initialize Java class " + string, string, exceptionInInitializerError, false);
        }
        catch (LinkageError linkageError) {
            throw this.runtime.newNameError("cannot link Java class " + string, string, linkageError, false);
        }
        catch (SecurityException securityException) {
            throw this.runtime.newNameError("security: cannot load Java class " + string, string, securityException, false);
        }
    }

    public JavaClass getJavaClassFromCache(Class clazz) {
        return this.javaClassCache.get(clazz);
    }

    public void putJavaClassIntoCache(JavaClass javaClass) {
        this.javaClassCache.put(javaClass.javaClass(), javaClass);
    }

    public void defineExceptionHandler(String string, RubyProc rubyProc) {
        this.exceptionHandlers.put(string, rubyProc);
    }

    public void handleNativeException(Throwable throwable) {
        Class<?> clazz;
        if (throwable instanceof RaiseException) {
            throw (RaiseException)throwable;
        }
        RubyProc rubyProc = this.exceptionHandlers.get(clazz.getName());
        for (clazz = throwable.getClass(); rubyProc == null && clazz != Throwable.class; clazz = clazz.getSuperclass()) {
        }
        if (rubyProc == null) {
            throw this.createRaiseException(throwable);
        }
        rubyProc.call(this.runtime.getCurrentContext(), new IRubyObject[]{JavaUtil.convertJavaToRuby(this.runtime, throwable)});
    }

    private RaiseException createRaiseException(Throwable throwable) {
        RaiseException raiseException = RaiseException.createNativeRaiseException(this.runtime, throwable);
        return raiseException;
    }

    public ObjectProxyCache<IRubyObject, RubyClass> getObjectProxyCache() {
        return this.objectProxyCache;
    }

    public RubyModule getJavaModule() {
        if (this.javaModule == null) {
            this.javaModule = this.runtime.fastGetModule("Java");
        }
        return this.javaModule;
    }

    public RubyModule getJavaUtilitiesModule() {
        if (this.javaUtilitiesModule == null) {
            this.javaUtilitiesModule = this.runtime.fastGetModule("JavaUtilities");
        }
        return this.javaUtilitiesModule;
    }

    public RubyClass getJavaObjectClass() {
        if (this.javaObjectClass == null) {
            this.javaObjectClass = this.getJavaModule().fastGetClass("JavaObject");
        }
        return this.javaObjectClass;
    }

    public RubyClass getJavaArrayClass() {
        if (this.javaArrayClass == null) {
            this.javaArrayClass = this.getJavaModule().fastGetClass("JavaArray");
        }
        return this.javaArrayClass;
    }

    public RubyClass getJavaClassClass() {
        if (this.javaClassClass == null) {
            this.javaClassClass = this.getJavaModule().fastGetClass("JavaClass");
        }
        return this.javaClassClass;
    }

    public RubyModule getJavaInterfaceTemplate() {
        if (this.javaInterfaceTemplate == null) {
            this.javaInterfaceTemplate = this.runtime.fastGetModule("JavaInterfaceTemplate");
        }
        return this.javaInterfaceTemplate;
    }

    public RubyModule getPackageModuleTemplate() {
        if (this.packageModuleTemplate == null) {
            this.packageModuleTemplate = this.runtime.fastGetModule("JavaPackageModuleTemplate");
        }
        return this.packageModuleTemplate;
    }

    public RubyClass getJavaProxyClass() {
        if (this.javaProxyClass == null) {
            this.javaProxyClass = this.runtime.fastGetClass("JavaProxy");
        }
        return this.javaProxyClass;
    }

    public RubyClass getConcreteProxyClass() {
        if (this.concreteProxyClass == null) {
            this.concreteProxyClass = this.runtime.fastGetClass("ConcreteJavaProxy");
        }
        return this.concreteProxyClass;
    }

    public RubyClass getArrayProxyClass() {
        if (this.arrayProxyClass == null) {
            this.arrayProxyClass = this.runtime.fastGetClass("ArrayJavaProxy");
        }
        return this.arrayProxyClass;
    }

    static {
        PRIMITIVE_CLASSES.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
    }
}

