/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class JavaUtil {
    public static final RubyConverter RUBY_BOOLEAN_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            return iRubyObject.isTrue();
        }
    };
    public static final RubyConverter RUBY_BYTE_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject.respondsTo("to_i")) {
                return new Byte((byte)((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Byte(0);
        }
    };
    public static final RubyConverter RUBY_SHORT_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject.respondsTo("to_i")) {
                return new Short((short)((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Short(0);
        }
    };
    public static final RubyConverter RUBY_INTEGER_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject.respondsTo("to_i")) {
                return new Integer((int)((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Integer(0);
        }
    };
    public static final RubyConverter RUBY_LONG_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject.respondsTo("to_i")) {
                return new Long(((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Long(0L);
        }
    };
    public static final RubyConverter RUBY_FLOAT_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject.respondsTo("to_f")) {
                return new Float((float)((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_F, "to_f")).getDoubleValue());
            }
            return new Float(0.0);
        }
    };
    public static final RubyConverter RUBY_DOUBLE_CONVERTER = new RubyConverter(){

        public Object convert(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (iRubyObject.respondsTo("to_f")) {
                return new Double(((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_F, "to_f")).getDoubleValue());
            }
            return new Double(0.0);
        }
    };
    public static final Map<Class, RubyConverter> RUBY_CONVERTERS = new HashMap<Class, RubyConverter>();
    public static final JavaConverter JAVA_DEFAULT_CONVERTER;
    public static final JavaConverter JAVA_BOOLEAN_CONVERTER;
    public static final JavaConverter JAVA_FLOAT_CONVERTER;
    public static final JavaConverter JAVA_DOUBLE_CONVERTER;
    public static final JavaConverter JAVA_CHAR_CONVERTER;
    public static final JavaConverter JAVA_BYTE_CONVERTER;
    public static final JavaConverter JAVA_SHORT_CONVERTER;
    public static final JavaConverter JAVA_INT_CONVERTER;
    public static final JavaConverter JAVA_LONG_CONVERTER;
    public static final JavaConverter JAVA_STRING_CONVERTER;
    public static final JavaConverter BYTELIST_CONVERTER;
    public static final JavaConverter JAVA_BIGINTEGER_CONVERTER;
    private static final Map<Class, JavaConverter> JAVA_CONVERTERS;

    public static Object convertRubyToJava(IRubyObject iRubyObject) {
        return JavaUtil.convertRubyToJava(iRubyObject, null);
    }

    public static Object convertRubyToJava(IRubyObject iRubyObject, Class clazz) {
        if (iRubyObject == null || iRubyObject.isNil()) {
            return null;
        }
        ThreadContext threadContext = iRubyObject.getRuntime().getCurrentContext();
        if (iRubyObject.respondsTo("java_object")) {
            iRubyObject = iRubyObject.callMethod(threadContext, "java_object");
        }
        if (iRubyObject.respondsTo("to_java_object")) {
            iRubyObject = iRubyObject.callMethod(threadContext, "to_java_object");
        }
        if (iRubyObject instanceof JavaObject) {
            Object object = ((JavaObject)iRubyObject).getValue();
            return JavaUtil.convertArgument(iRubyObject.getRuntime(), object, clazz);
        }
        if (clazz == Object.class || clazz == null) {
            clazz = iRubyObject.getJavaClass();
        }
        if (clazz.isInstance(iRubyObject)) {
            return iRubyObject;
        }
        if (clazz.isPrimitive()) {
            RubyConverter rubyConverter = RUBY_CONVERTERS.get(clazz);
            if (rubyConverter != null) {
                return rubyConverter.convert(threadContext, iRubyObject);
            }
            String string = ((RubyString)iRubyObject.callMethod(threadContext, MethodIndex.TO_S, "to_s")).toString();
            if (string.length() > 0) {
                return new Character(string.charAt(0));
            }
            return new Character('\u0000');
        }
        if (clazz == String.class) {
            RubyString rubyString = (RubyString)iRubyObject.callMethod(threadContext, MethodIndex.TO_S, "to_s");
            ByteList byteList = rubyString.getByteList();
            try {
                return new String(byteList.unsafeBytes(), byteList.begin(), byteList.length(), "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(byteList.unsafeBytes(), byteList.begin(), byteList.length());
            }
        }
        if (clazz == ByteList.class) {
            return iRubyObject.convertToString().getByteList();
        }
        if (clazz == BigInteger.class) {
            if (iRubyObject instanceof RubyBignum) {
                return ((RubyBignum)iRubyObject).getValue();
            }
            if (iRubyObject instanceof RubyNumeric) {
                return BigInteger.valueOf(((RubyNumeric)iRubyObject).getLongValue());
            }
            if (iRubyObject.respondsTo("to_i")) {
                RubyNumeric rubyNumeric = (RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_F, "to_f");
                return BigInteger.valueOf(rubyNumeric.getLongValue());
            }
        } else if (clazz == BigDecimal.class && !(iRubyObject instanceof JavaObject) && iRubyObject.respondsTo("to_f")) {
            double d = ((RubyNumeric)iRubyObject.callMethod(threadContext, MethodIndex.TO_F, "to_f")).getDoubleValue();
            return new BigDecimal(d);
        }
        try {
            return ((JavaObject)iRubyObject).getValue();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            return null;
        }
    }

    public static IRubyObject[] convertJavaArrayToRuby(Ruby ruby, Object[] objectArray) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            iRubyObjectArray[i] = JavaUtil.convertJavaToRuby(ruby, objectArray[i]);
        }
        return iRubyObjectArray;
    }

    public static JavaConverter getJavaConverter(Class clazz) {
        JavaConverter javaConverter = JAVA_CONVERTERS.get(clazz);
        if (javaConverter == null) {
            javaConverter = JAVA_DEFAULT_CONVERTER;
        }
        return javaConverter;
    }

    public static IRubyObject convertJavaToRuby(Ruby ruby, Object object) {
        if (object == null) {
            return ruby.getNil();
        }
        return JavaUtil.convertJavaToRuby(ruby, object, object.getClass());
    }

    public static IRubyObject convertJavaToRuby(Ruby ruby, Object object, Class clazz) {
        return JavaUtil.getJavaConverter(clazz).convert(ruby, object);
    }

    public static IRubyObject convertJavaToUsableRubyObject(Ruby ruby, Object object) {
        if (object == null) {
            return ruby.getNil();
        }
        JavaConverter javaConverter = JAVA_CONVERTERS.get(object.getClass());
        if (javaConverter == null || javaConverter == JAVA_DEFAULT_CONVERTER) {
            return Java.getInstance(ruby, object);
        }
        return javaConverter.convert(ruby, object);
    }

    public static Class primitiveToWrapper(Class clazz) {
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz;
    }

    public static Object convertArgument(Ruby ruby, Object object, Class clazz) {
        Serializable serializable;
        if (object == null && clazz.isPrimitive()) {
            throw ruby.newTypeError("primitives do not accept null");
        }
        if (object instanceof JavaObject && (object = ((JavaObject)object).getValue()) == null) {
            return null;
        }
        Class clazz2 = JavaUtil.primitiveToWrapper(clazz);
        if (clazz2 == Void.class) {
            return null;
        }
        if (object instanceof Number) {
            serializable = (Number)object;
            if (clazz2 == Long.class) {
                return new Long(((Number)serializable).longValue());
            }
            if (clazz2 == Integer.class) {
                return new Integer(((Number)serializable).intValue());
            }
            if (clazz2 == Short.class) {
                return new Short(((Number)serializable).shortValue());
            }
            if (clazz2 == Byte.class) {
                return new Byte(((Number)serializable).byteValue());
            }
            if (clazz2 == Character.class) {
                return new Character((char)((Number)serializable).intValue());
            }
            if (clazz2 == Double.class) {
                return new Double(((Number)serializable).doubleValue());
            }
            if (clazz2 == Float.class) {
                return new Float(((Number)serializable).floatValue());
            }
        }
        if (JavaUtil.isDuckTypeConvertable(object.getClass(), clazz) && !((RubyObject)(serializable = (RubyObject)object)).respondsTo("java_object")) {
            RubyModule rubyModule = ruby.getJavaSupport().getJavaUtilitiesModule();
            IRubyObject iRubyObject = Java.get_interface_module(rubyModule, JavaClass.get(ruby, clazz));
            if (!((RubyModule)iRubyObject).isInstance((IRubyObject)((Object)serializable))) {
                ((RubyObject)serializable).extend(new IRubyObject[]{iRubyObject});
            }
            ThreadContext threadContext = ruby.getCurrentContext();
            if (serializable instanceof RubyProc) {
                ((RubyObject)serializable).instance_eval(threadContext, new IRubyObject[]{ruby.newString("extend Proc::CatchAll")}, Block.NULL_BLOCK);
            }
            JavaObject javaObject = (JavaObject)((RubyObject)serializable).instance_eval(threadContext, new IRubyObject[]{ruby.newString("send :__jcreate_meta!")}, Block.NULL_BLOCK);
            return javaObject.getValue();
        }
        return object;
    }

    public static boolean isDuckTypeConvertable(Class clazz, Class clazz2) {
        return clazz2.isInterface() && !clazz2.isAssignableFrom(clazz) && RubyObject.class.isAssignableFrom(clazz);
    }

    static {
        RUBY_CONVERTERS.put(Boolean.class, RUBY_BOOLEAN_CONVERTER);
        RUBY_CONVERTERS.put(Boolean.TYPE, RUBY_BOOLEAN_CONVERTER);
        RUBY_CONVERTERS.put(Byte.class, RUBY_BYTE_CONVERTER);
        RUBY_CONVERTERS.put(Byte.TYPE, RUBY_BYTE_CONVERTER);
        RUBY_CONVERTERS.put(Short.class, RUBY_SHORT_CONVERTER);
        RUBY_CONVERTERS.put(Short.TYPE, RUBY_SHORT_CONVERTER);
        RUBY_CONVERTERS.put(Integer.class, RUBY_INTEGER_CONVERTER);
        RUBY_CONVERTERS.put(Integer.TYPE, RUBY_INTEGER_CONVERTER);
        RUBY_CONVERTERS.put(Long.class, RUBY_LONG_CONVERTER);
        RUBY_CONVERTERS.put(Long.TYPE, RUBY_LONG_CONVERTER);
        RUBY_CONVERTERS.put(Float.class, RUBY_FLOAT_CONVERTER);
        RUBY_CONVERTERS.put(Float.TYPE, RUBY_FLOAT_CONVERTER);
        RUBY_CONVERTERS.put(Double.class, RUBY_DOUBLE_CONVERTER);
        RUBY_CONVERTERS.put(Double.TYPE, RUBY_DOUBLE_CONVERTER);
        JAVA_DEFAULT_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                if (object instanceof IRubyObject) {
                    return (IRubyObject)object;
                }
                return JavaObject.wrap(ruby, object);
            }
        };
        JAVA_BOOLEAN_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyBoolean.newBoolean(ruby, (Boolean)object);
            }
        };
        JAVA_FLOAT_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyFloat.newFloat(ruby, ((Float)object).doubleValue());
            }
        };
        JAVA_DOUBLE_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyFloat.newFloat(ruby, (Double)object);
            }
        };
        JAVA_CHAR_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyFixnum.newFixnum(ruby, ((Character)object).charValue());
            }
        };
        JAVA_BYTE_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyFixnum.newFixnum(ruby, ((Byte)object).byteValue());
            }
        };
        JAVA_SHORT_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyFixnum.newFixnum(ruby, ((Short)object).shortValue());
            }
        };
        JAVA_INT_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyFixnum.newFixnum(ruby, ((Integer)object).intValue());
            }
        };
        JAVA_LONG_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyFixnum.newFixnum(ruby, (Long)object);
            }
        };
        JAVA_STRING_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyString.newUnicodeString(ruby, (String)object);
            }
        };
        BYTELIST_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyString.newString(ruby, (ByteList)object);
            }
        };
        JAVA_BIGINTEGER_CONVERTER = new JavaConverter(){

            public IRubyObject convert(Ruby ruby, Object object) {
                if (object == null) {
                    return ruby.getNil();
                }
                return RubyBignum.newBignum(ruby, (BigInteger)object);
            }
        };
        JAVA_CONVERTERS = new HashMap<Class, JavaConverter>();
        JAVA_CONVERTERS.put(Byte.class, JAVA_BYTE_CONVERTER);
        JAVA_CONVERTERS.put(Byte.TYPE, JAVA_BYTE_CONVERTER);
        JAVA_CONVERTERS.put(Short.class, JAVA_SHORT_CONVERTER);
        JAVA_CONVERTERS.put(Short.TYPE, JAVA_SHORT_CONVERTER);
        JAVA_CONVERTERS.put(Character.class, JAVA_CHAR_CONVERTER);
        JAVA_CONVERTERS.put(Character.TYPE, JAVA_CHAR_CONVERTER);
        JAVA_CONVERTERS.put(Integer.class, JAVA_INT_CONVERTER);
        JAVA_CONVERTERS.put(Integer.TYPE, JAVA_INT_CONVERTER);
        JAVA_CONVERTERS.put(Long.class, JAVA_LONG_CONVERTER);
        JAVA_CONVERTERS.put(Long.TYPE, JAVA_LONG_CONVERTER);
        JAVA_CONVERTERS.put(Float.class, JAVA_FLOAT_CONVERTER);
        JAVA_CONVERTERS.put(Float.TYPE, JAVA_FLOAT_CONVERTER);
        JAVA_CONVERTERS.put(Double.class, JAVA_DOUBLE_CONVERTER);
        JAVA_CONVERTERS.put(Double.TYPE, JAVA_DOUBLE_CONVERTER);
        JAVA_CONVERTERS.put(Boolean.class, JAVA_BOOLEAN_CONVERTER);
        JAVA_CONVERTERS.put(Boolean.TYPE, JAVA_BOOLEAN_CONVERTER);
        JAVA_CONVERTERS.put(String.class, JAVA_STRING_CONVERTER);
        JAVA_CONVERTERS.put(ByteList.class, BYTELIST_CONVERTER);
        JAVA_CONVERTERS.put(BigInteger.class, JAVA_BIGINTEGER_CONVERTER);
    }

    public static interface JavaConverter {
        public IRubyObject convert(Ruby var1, Object var2);
    }

    public static interface RubyConverter {
        public Object convert(ThreadContext var1, IRubyObject var2);
    }
}

