/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.ext.posix.util.Platform;
import org.jruby.runtime.Constants;
import org.jruby.runtime.load.Library;
import org.jruby.util.NormalizedFile;

public class RbConfigLibrary
implements Library {
    private static final String RUBY_DARWIN = "darwin";
    private static final String RUBY_LINUX = "linux";
    private static final String RUBY_WIN32 = "mswin32";
    private static final String RUBY_SOLARIS = "solaris";
    private static final String RUBY_FREEBSD = "freebsd";
    private static final String RUBY_AIX = "aix";
    public static final Map<String, String> RUBY_OS_NAMES = new HashMap<String, String>();

    public static String getOSName() {
        String string = Platform.getOSName();
        String string2 = RUBY_OS_NAMES.get(string);
        return string2 == null ? string : string2;
    }

    public void load(Ruby ruby, boolean bl) {
        Object object;
        RubyModule rubyModule = ruby.defineModule("Config");
        RubyHash rubyHash = RubyHash.newHash(ruby);
        rubyModule.defineConstant("CONFIG", rubyHash);
        ruby.getObject().defineConstant("RbConfig", rubyModule);
        String[] stringArray = Constants.RUBY_VERSION.split("\\.");
        RbConfigLibrary.setConfig(rubyHash, "MAJOR", stringArray[0]);
        RbConfigLibrary.setConfig(rubyHash, "MINOR", stringArray[1]);
        RbConfigLibrary.setConfig(rubyHash, "TEENY", stringArray[2]);
        RbConfigLibrary.setConfig(rubyHash, "ruby_version", stringArray[0] + '.' + stringArray[1]);
        RbConfigLibrary.setConfig(rubyHash, "arch", "universal-java" + System.getProperty("java.specification.version"));
        String string = Ruby.isSecurityRestricted() ? "SECURITY RESTRICTED" : ruby.getJRubyHome();
        RbConfigLibrary.setConfig(rubyHash, "bindir", new NormalizedFile(string, "bin").getPath());
        RbConfigLibrary.setConfig(rubyHash, "RUBY_INSTALL_NAME", RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(rubyHash, "ruby_install_name", RbConfigLibrary.jrubyScript());
        RbConfigLibrary.setConfig(rubyHash, "SHELL", RbConfigLibrary.jrubyShell());
        RbConfigLibrary.setConfig(rubyHash, "prefix", string);
        RbConfigLibrary.setConfig(rubyHash, "exec_prefix", string);
        RbConfigLibrary.setConfig(rubyHash, "host_os", Platform.getOSName());
        RbConfigLibrary.setConfig(rubyHash, "host_vendor", System.getProperty("java.vendor"));
        RbConfigLibrary.setConfig(rubyHash, "host_cpu", Platform.ARCH);
        RbConfigLibrary.setConfig(rubyHash, "target_os", Platform.getOSName());
        RbConfigLibrary.setConfig(rubyHash, "target_cpu", Platform.ARCH);
        String string2 = "jruby.jar";
        URL uRL = Ruby.class.getClassLoader().getResource("/org/jruby/jruby.properties");
        if (uRL != null) {
            object = Pattern.compile("jar:file:.*?([a-zA-Z0-9.\\-]+\\.jar)!/org/jruby/jruby.properties");
            Matcher matcher = ((Pattern)object).matcher(uRL.toString());
            matcher.find();
            if (matcher.matches()) {
                string2 = matcher.group(1);
            }
        }
        RbConfigLibrary.setConfig(rubyHash, "LIBRUBY", string2);
        RbConfigLibrary.setConfig(rubyHash, "LIBRUBY_SO", string2);
        RbConfigLibrary.setConfig(rubyHash, "build", Constants.BUILD);
        RbConfigLibrary.setConfig(rubyHash, "target", Constants.TARGET);
        object = System.getProperty("jruby.lib");
        if (object == null) {
            object = new NormalizedFile(string, "lib").getPath();
        } else {
            try {
                object = new NormalizedFile((String)object).getCanonicalPath();
            }
            catch (IOException iOException) {
                object = new NormalizedFile((String)object).getAbsolutePath();
            }
        }
        RbConfigLibrary.setConfig(rubyHash, "libdir", (String)object);
        RbConfigLibrary.setConfig(rubyHash, "rubylibdir", new NormalizedFile((String)object, "ruby/1.8").getPath());
        RbConfigLibrary.setConfig(rubyHash, "sitedir", new NormalizedFile((String)object, "ruby/site_ruby").getPath());
        RbConfigLibrary.setConfig(rubyHash, "sitelibdir", new NormalizedFile((String)object, "ruby/site_ruby/1.8").getPath());
        RbConfigLibrary.setConfig(rubyHash, "sitearchdir", new NormalizedFile((String)object, "ruby/site_ruby/1.8/java").getPath());
        RbConfigLibrary.setConfig(rubyHash, "archdir", new NormalizedFile((String)object, "ruby/site_ruby/1.8/java").getPath());
        RbConfigLibrary.setConfig(rubyHash, "configure_args", "");
        RbConfigLibrary.setConfig(rubyHash, "datadir", new NormalizedFile(string, "share").getPath());
        RbConfigLibrary.setConfig(rubyHash, "mandir", new NormalizedFile(string, "man").getPath());
        RbConfigLibrary.setConfig(rubyHash, "sysconfdir", new NormalizedFile(string, "etc").getPath());
        RbConfigLibrary.setConfig(rubyHash, "localstatedir", new NormalizedFile(string, "var").getPath());
        RbConfigLibrary.setConfig(rubyHash, "DLEXT", "jar");
        if (Platform.IS_WINDOWS) {
            RbConfigLibrary.setConfig(rubyHash, "EXEEXT", ".exe");
        } else {
            RbConfigLibrary.setConfig(rubyHash, "EXEEXT", "");
        }
    }

    private static void setConfig(RubyHash rubyHash, String string, String string2) {
        Ruby ruby = rubyHash.getRuntime();
        rubyHash.op_aset(ruby.getCurrentContext(), ruby.newString(string), ruby.newString(string2));
    }

    public static String jrubyScript() {
        return System.getProperty("jruby.script", Platform.IS_WINDOWS ? "jruby.bat" : "jruby").replace('\\', '/');
    }

    public static String jrubyShell() {
        return System.getProperty("jruby.shell", Platform.IS_WINDOWS ? "cmd.exe" : "/bin/sh").replace('\\', '/');
    }

    static {
        RUBY_OS_NAMES.put("Mac OS X", RUBY_DARWIN);
        RUBY_OS_NAMES.put("Darwin", RUBY_DARWIN);
        RUBY_OS_NAMES.put("Linux", RUBY_LINUX);
        RUBY_OS_NAMES.put("Windows 95", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 98", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Me", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows NT", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows XP", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows 2003", RUBY_WIN32);
        RUBY_OS_NAMES.put("Windows Vista", RUBY_WIN32);
        RUBY_OS_NAMES.put("Solaris", RUBY_SOLARIS);
        RUBY_OS_NAMES.put("FreeBSD", RUBY_FREEBSD);
        RUBY_OS_NAMES.put("AIX", RUBY_AIX);
    }
}

