/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.io.IOException;
import java.util.LinkedList;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class ThreadLibrary
implements Library {
    public void load(Ruby ruby, boolean bl) throws IOException {
        Mutex.setup(ruby);
        ConditionVariable.setup(ruby);
        Queue.setup(ruby);
        SizedQueue.setup(ruby);
    }

    static boolean wait_timeout(IRubyObject iRubyObject, Double d) throws InterruptedException {
        if (d != null) {
            long l;
            long l2 = (long)(d * 1.0E9);
            long l3 = System.nanoTime();
            if (l2 > 0L) {
                l = l2 / 1000000L;
                int n = (int)(l2 % 1000000L);
                iRubyObject.wait(l, n);
            }
            return (l = System.nanoTime()) - l3 <= l2;
        }
        iRubyObject.wait();
        return true;
    }

    public static class SizedQueue
    extends Queue {
        private int capacity = 1;

        public static IRubyObject newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            SizedQueue sizedQueue = new SizedQueue(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
            sizedQueue.callInit(iRubyObjectArray, block);
            return sizedQueue;
        }

        public SizedQueue(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        public static void setup(Ruby ruby) {
            RubyClass rubyClass = ruby.defineClass("SizedQueue", ruby.fastGetClass("Queue"), new ObjectAllocator(){

                public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                    return new SizedQueue(ruby, rubyClass);
                }
            });
            CallbackFactory callbackFactory = ruby.callbackFactory(SizedQueue.class);
            rubyClass.getMetaClass().defineMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
            rubyClass.defineFastMethod("initialize", callbackFactory.getFastMethod("max_set", RubyInteger.class));
            rubyClass.defineFastMethod("clear", callbackFactory.getFastMethod("clear"));
            rubyClass.defineFastMethod("max", callbackFactory.getFastMethod("max"));
            rubyClass.defineFastMethod("max=", callbackFactory.getFastMethod("max_set", RubyInteger.class));
            rubyClass.defineFastMethod("pop", callbackFactory.getFastOptMethod("pop"));
            rubyClass.defineFastMethod("push", callbackFactory.getFastMethod("push", IRubyObject.class));
            rubyClass.defineAlias("<<", "push");
            rubyClass.defineAlias("deq", "pop");
            rubyClass.defineAlias("shift", "pop");
        }

        public synchronized IRubyObject clear() {
            super.clear();
            this.notifyAll();
            return this.getRuntime().getNil();
        }

        public synchronized RubyNumeric max() {
            return RubyNumeric.int2fix(this.getRuntime(), this.capacity);
        }

        public synchronized IRubyObject max_set(RubyInteger rubyInteger) {
            int n = RubyNumeric.fix2int(rubyInteger);
            if (n <= 0) {
                this.getRuntime().newArgumentError("queue size must be positive");
            }
            int n2 = n > this.capacity ? n - this.capacity : 0;
            this.capacity = n;
            if (n2 > 0) {
                this.notifyAll();
            }
            return this.getRuntime().getNil();
        }

        public synchronized IRubyObject pop(IRubyObject[] iRubyObjectArray) {
            IRubyObject iRubyObject = super.pop(iRubyObjectArray);
            this.notifyAll();
            return iRubyObject;
        }

        public synchronized IRubyObject push(IRubyObject iRubyObject) {
            while (RubyNumeric.fix2int(this.length()) >= this.capacity) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            super.push(iRubyObject);
            this.notifyAll();
            return this.getRuntime().getNil();
        }
    }

    public static class Queue
    extends RubyObject {
        private LinkedList entries = new LinkedList();

        public static IRubyObject newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            Queue queue = new Queue(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
            queue.callInit(iRubyObjectArray, block);
            return queue;
        }

        public Queue(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        public static void setup(Ruby ruby) {
            RubyClass rubyClass = ruby.defineClass("Queue", ruby.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                    return new Queue(ruby, rubyClass);
                }
            });
            CallbackFactory callbackFactory = ruby.callbackFactory(Queue.class);
            rubyClass.getMetaClass().defineMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
            rubyClass.defineFastMethod("clear", callbackFactory.getFastMethod("clear"));
            rubyClass.defineFastMethod("empty?", callbackFactory.getFastMethod("empty_p"));
            rubyClass.defineFastMethod("length", callbackFactory.getFastMethod("length"));
            rubyClass.defineFastMethod("num_waiting", callbackFactory.getFastMethod("num_waiting"));
            rubyClass.defineFastMethod("pop", callbackFactory.getFastOptMethod("pop"));
            rubyClass.defineFastMethod("push", callbackFactory.getFastMethod("push", IRubyObject.class));
            rubyClass.defineAlias("<<", "push");
            rubyClass.defineAlias("deq", "pop");
            rubyClass.defineAlias("shift", "pop");
            rubyClass.defineAlias("size", "length");
            rubyClass.defineAlias("enq", "push");
        }

        public synchronized IRubyObject clear() {
            this.entries.clear();
            return this.getRuntime().getNil();
        }

        public synchronized RubyBoolean empty_p() {
            return this.entries.size() == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        public synchronized RubyNumeric length() {
            return RubyNumeric.int2fix(this.getRuntime(), this.entries.size());
        }

        public RubyNumeric num_waiting() {
            return this.getRuntime().newFixnum(0L);
        }

        public synchronized IRubyObject pop(IRubyObject[] iRubyObjectArray) {
            boolean bl = true;
            if (Arity.checkArgumentCount(this.getRuntime(), iRubyObjectArray, 0, 1) == 1) {
                boolean bl2 = bl = !iRubyObjectArray[0].isTrue();
            }
            if (!bl && this.entries.size() == 0) {
                throw new RaiseException(this.getRuntime(), this.getRuntime().fastGetClass("ThreadError"), "queue empty", false);
            }
            while (this.entries.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return (IRubyObject)this.entries.removeFirst();
        }

        public synchronized IRubyObject push(IRubyObject iRubyObject) {
            this.entries.addLast(iRubyObject);
            this.notify();
            return this.getRuntime().getNil();
        }
    }

    public static class ConditionVariable
    extends RubyObject {
        public static ConditionVariable newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            ConditionVariable conditionVariable = new ConditionVariable(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
            conditionVariable.callInit(iRubyObjectArray, block);
            return conditionVariable;
        }

        public ConditionVariable(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        public static void setup(Ruby ruby) {
            RubyClass rubyClass = ruby.defineClass("ConditionVariable", ruby.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                    return new ConditionVariable(ruby, rubyClass);
                }
            });
            CallbackFactory callbackFactory = ruby.callbackFactory(ConditionVariable.class);
            rubyClass.getMetaClass().defineMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
            rubyClass.defineFastMethod("wait", callbackFactory.getFastOptMethod("wait_ruby"));
            rubyClass.defineFastMethod("broadcast", callbackFactory.getFastMethod("broadcast"));
            rubyClass.defineFastMethod("signal", callbackFactory.getFastMethod("signal"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IRubyObject wait_ruby(IRubyObject[] iRubyObjectArray) throws InterruptedException {
            if (iRubyObjectArray.length < 1) {
                throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 1);
            }
            if (iRubyObjectArray.length > 2) {
                throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
            }
            if (!(iRubyObjectArray[0] instanceof Mutex)) {
                throw this.getRuntime().newTypeError(iRubyObjectArray[0], this.getRuntime().fastGetClass("Mutex"));
            }
            Mutex mutex = (Mutex)iRubyObjectArray[0];
            Double d = null;
            if (iRubyObjectArray.length > 1 && !iRubyObjectArray[1].isNil()) {
                d = iRubyObjectArray[1].convertToFloat().getDoubleValue();
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            boolean bl = false;
            try {
                ConditionVariable conditionVariable = this;
                synchronized (conditionVariable) {
                    mutex.unlock();
                    try {
                        bl = ThreadLibrary.wait_timeout(this, d);
                        Object var7_6 = null;
                        if (!bl) {
                            this.notify();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (!bl) {
                            this.notify();
                        }
                        throw throwable;
                    }
                }
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                mutex.lock();
                throw throwable;
            }
            mutex.lock();
            if (d != null) {
                return this.getRuntime().newBoolean(bl);
            }
            return this.getRuntime().getNil();
        }

        public synchronized IRubyObject broadcast() {
            this.notifyAll();
            return this.getRuntime().getNil();
        }

        public synchronized IRubyObject signal() {
            this.notify();
            return this.getRuntime().getNil();
        }
    }

    public static class Mutex
    extends RubyObject {
        private RubyThread owner = null;

        public static Mutex newInstance(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            Mutex mutex = new Mutex(iRubyObject.getRuntime(), (RubyClass)iRubyObject);
            mutex.callInit(iRubyObjectArray, block);
            return mutex;
        }

        public Mutex(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        public static void setup(Ruby ruby) {
            RubyClass rubyClass = ruby.defineClass("Mutex", ruby.getObject(), new ObjectAllocator(){

                public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                    return new Mutex(ruby, rubyClass);
                }
            });
            CallbackFactory callbackFactory = ruby.callbackFactory(Mutex.class);
            rubyClass.getMetaClass().defineMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
            rubyClass.defineFastMethod("locked?", callbackFactory.getFastMethod("locked_p"));
            rubyClass.defineFastMethod("try_lock", callbackFactory.getFastMethod("try_lock"));
            rubyClass.defineFastMethod("lock", callbackFactory.getFastMethod("lock"));
            rubyClass.defineFastMethod("unlock", callbackFactory.getFastMethod("unlock"));
            rubyClass.defineMethod("synchronize", callbackFactory.getMethod("synchronize"));
        }

        public synchronized RubyBoolean locked_p() {
            return this.owner != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RubyBoolean try_lock() throws InterruptedException {
            Mutex mutex = this;
            synchronized (mutex) {
                if (this.owner != null) {
                    return this.getRuntime().getFalse();
                }
                this.lock();
            }
            return this.getRuntime().getTrue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IRubyObject lock() throws InterruptedException {
            Mutex mutex = this;
            synchronized (mutex) {
                try {
                    while (this.owner != null) {
                        this.wait();
                    }
                    this.owner = this.getRuntime().getCurrentContext().getThread();
                }
                catch (InterruptedException interruptedException) {
                    if (this.owner == null) {
                        this.notify();
                    }
                    throw interruptedException;
                }
            }
            return this;
        }

        public synchronized RubyBoolean unlock() {
            if (this.owner != null) {
                this.owner = null;
                this.notify();
                return this.getRuntime().getTrue();
            }
            return this.getRuntime().getFalse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IRubyObject synchronize(Block block) throws InterruptedException {
            IRubyObject iRubyObject;
            try {
                this.lock();
                iRubyObject = block.yield(this.getRuntime().getCurrentContext(), null);
                Object var4_3 = null;
                this.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.unlock();
                throw throwable;
            }
            return iRubyObject;
        }
    }
}

