/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.types.INameNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.lexer.yacc.Token;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.RubyParserResult;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.util.ByteList;

public class ParserSupport {
    private StaticScope currentScope;
    private int inSingleton;
    private boolean inDefinition;
    private IRubyWarnings warnings;
    private ParserConfiguration configuration;
    private RubyParserResult result;

    public void reset() {
        this.inSingleton = 0;
        this.inDefinition = false;
    }

    public StaticScope getCurrentScope() {
        return this.currentScope;
    }

    public ParserConfiguration getConfiguration() {
        return this.configuration;
    }

    public void popCurrentScope() {
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    public void pushBlockScope() {
        this.currentScope = new BlockStaticScope(this.currentScope);
    }

    public void pushLocalScope() {
        this.currentScope = new LocalStaticScope(this.currentScope);
    }

    public Node arg_concat(ISourcePosition iSourcePosition, Node node, Node node2) {
        return node2 == null ? node : new ArgsCatNode(iSourcePosition, node, node2);
    }

    public Node arg_blk_pass(Node node, BlockPassNode blockPassNode) {
        if (blockPassNode != null) {
            blockPassNode.setArgsNode(node);
            return blockPassNode;
        }
        return node;
    }

    public Node gettable2(Node node) {
        switch (node.nodeId) {
            case DASGNNODE: 
            case LOCALASGNNODE: {
                return this.currentScope.declare(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case CONSTDECLNODE: {
                return this.currentScope.declare(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case INSTASGNNODE: {
                return new InstVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case CLASSVARDECLNODE: 
            case CLASSVARASGNNODE: {
                return new ClassVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case GLOBALASGNNODE: {
                return new GlobalVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
        }
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, node.getPosition(), "identifier " + ((INameNode)((Object)node)).getName() + " is not valid", ((INameNode)((Object)node)).getName());
    }

    public Node gettable(Token token) {
        switch (token.getType()) {
            case 286: {
                return new SelfNode(token.getPosition());
            }
            case 287: {
                return new NilNode(token.getPosition());
            }
            case 288: {
                return new TrueNode(token.getPosition());
            }
            case 289: {
                return new FalseNode(token.getPosition());
            }
            case 303: {
                return new StrNode(token.getPosition(), ByteList.create(token.getPosition().getFile()));
            }
            case 302: {
                return new FixnumNode(token.getPosition(), token.getPosition().getEndLine() + 1);
            }
            case 304: {
                return this.currentScope.declare(token.getPosition(), (String)token.getValue());
            }
            case 308: {
                return new ConstNode(token.getPosition(), (String)token.getValue());
            }
            case 307: {
                return new InstVarNode(token.getPosition(), (String)token.getValue());
            }
            case 309: {
                return new ClassVarNode(token.getPosition(), (String)token.getValue());
            }
            case 306: {
                return new GlobalVarNode(token.getPosition(), (String)token.getValue());
            }
        }
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, token.getPosition(), "identifier " + (String)token.getValue() + " is not valid", token.getValue());
    }

    public AssignableNode assignable(Token token, Node node) {
        this.checkExpression(node);
        switch (token.getType()) {
            case 286: {
                throw new SyntaxException(SyntaxException.PID.CANNOT_CHANGE_SELF, token.getPosition(), "Can't change the value of self", new Object[0]);
            }
            case 287: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, token.getPosition(), "Can't assign to nil", "nil");
            }
            case 288: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, token.getPosition(), "Can't assign to true", "true");
            }
            case 289: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, token.getPosition(), "Can't assign to false", "false");
            }
            case 303: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, token.getPosition(), "Can't assign to __FILE__", "__FILE__");
            }
            case 302: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, token.getPosition(), "Can't assign to __LINE__", "__LINE__");
            }
            case 304: {
                return this.currentScope.assign(node != null ? this.union(token, node) : token.getPosition(), (String)token.getValue(), node);
            }
            case 308: {
                if (this.isInDef() || this.isInSingle()) {
                    throw new SyntaxException(SyntaxException.PID.DYNAMIC_CONSTANT_ASSIGNMENT, token.getPosition(), "dynamic constant assignment", new Object[0]);
                }
                return new ConstDeclNode(token.getPosition(), (String)token.getValue(), null, node);
            }
            case 307: {
                return new InstAsgnNode(token.getPosition(), (String)token.getValue(), node);
            }
            case 309: {
                if (this.isInDef() || this.isInSingle()) {
                    return new ClassVarAsgnNode(token.getPosition(), (String)token.getValue(), node);
                }
                return new ClassVarDeclNode(token.getPosition(), (String)token.getValue(), node);
            }
            case 306: {
                return new GlobalAsgnNode(token.getPosition(), (String)token.getValue(), node);
            }
        }
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, token.getPosition(), "identifier " + (String)token.getValue() + " is not valid", token.getValue());
    }

    public Node newline_node(Node node, ISourcePosition iSourcePosition) {
        if (node == null) {
            return null;
        }
        return node instanceof NewlineNode ? node : new NewlineNode(iSourcePosition, node);
    }

    public ISourcePosition union(ISourcePositionHolder iSourcePositionHolder, ISourcePositionHolder iSourcePositionHolder2) {
        while (iSourcePositionHolder instanceof NewlineNode) {
            iSourcePositionHolder = ((NewlineNode)iSourcePositionHolder).getNextNode();
        }
        while (iSourcePositionHolder2 instanceof NewlineNode) {
            iSourcePositionHolder2 = ((NewlineNode)iSourcePositionHolder2).getNextNode();
        }
        if (iSourcePositionHolder2 == null) {
            return iSourcePositionHolder.getPosition();
        }
        if (iSourcePositionHolder == null) {
            return iSourcePositionHolder2.getPosition();
        }
        return iSourcePositionHolder.getPosition().union(iSourcePositionHolder2.getPosition());
    }

    public ISourcePosition union(ISourcePosition iSourcePosition, ISourcePosition iSourcePosition2) {
        if (iSourcePosition.getStartOffset() < iSourcePosition2.getStartOffset()) {
            return iSourcePosition.union(iSourcePosition2);
        }
        return iSourcePosition2.union(iSourcePosition);
    }

    public Node addRootNode(Node node, ISourcePosition iSourcePosition) {
        ISourcePosition iSourcePosition2 = iSourcePosition = node != null ? node.getPosition() : iSourcePosition;
        if (this.result.getBeginNodes().size() == 0) {
            return new RootNode(iSourcePosition, this.result.getScope(), node);
        }
        BlockNode blockNode = new BlockNode(iSourcePosition);
        for (Node node2 : this.result.getBeginNodes()) {
            this.appendToBlock(blockNode, node2);
        }
        if (node != null) {
            blockNode.add(node);
        }
        return new RootNode(iSourcePosition, this.result.getScope(), blockNode);
    }

    public Node appendToBlock(Node node, Node node2) {
        if (node2 == null) {
            return node;
        }
        if (node == null) {
            return node2;
        }
        if (!this.configuration.hasExtraPositionInformation()) {
            Node node3;
            while (node instanceof NewlineNode && (node3 = ((NewlineNode)node).getNextNode()) instanceof NewlineNode) {
                node = node3;
            }
        }
        if (!(node instanceof BlockNode)) {
            node = new BlockNode(node.getPosition()).add(node);
        }
        if (this.warnings.isVerbose() && this.isBreakStatement(((ListNode)node).getLast())) {
            this.warnings.warning(IRubyWarnings.ID.STATEMENT_NOT_REACHED, node2.getPosition(), "Statement not reached.", new Object[0]);
        }
        ((ListNode)node).addAll(node2);
        node.setPosition(this.union(node, node2));
        return node;
    }

    public Node getOperatorCallNode(Node node, String string) {
        this.checkExpression(node);
        return new CallNode(node.getPosition(), node, string, null);
    }

    public Node getOperatorCallNode(Node node, String string, Node node2) {
        return this.getOperatorCallNode(node, string, node2, null);
    }

    public Node getOperatorCallNode(Node node, String string, Node node2, ISourcePosition iSourcePosition) {
        if (iSourcePosition != null) {
            node = this.checkForNilNode(node, iSourcePosition);
            node2 = this.checkForNilNode(node2, iSourcePosition);
        }
        this.checkExpression(node);
        this.checkExpression(node2);
        return new CallNode(this.union(node.getPosition(), node2.getPosition()), node, string, new ArrayNode(node2.getPosition(), node2));
    }

    public Node getMatchNode(Node node, Node node2) {
        if (node instanceof DRegexpNode || node instanceof RegexpNode) {
            return new Match2Node(node.getPosition(), node, node2);
        }
        if (node2 instanceof DRegexpNode || node2 instanceof RegexpNode) {
            return new Match3Node(node.getPosition(), node2, node);
        }
        return this.getOperatorCallNode(node, "=~", node2);
    }

    public Node aryset(Node node, Node node2) {
        this.checkExpression(node);
        return new AttrAssignNode(node.getPosition(), node, "[]=", node2);
    }

    public Node attrset(Node node, String string) {
        this.checkExpression(node);
        return new AttrAssignNode(node.getPosition(), node, string + "=", null);
    }

    public void backrefAssignError(Node node) {
        if (node instanceof NthRefNode) {
            String string = "$" + ((NthRefNode)node).getMatchNumber();
            throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, node.getPosition(), "Can't set variable " + string + '.', string);
        }
        if (node instanceof BackRefNode) {
            String string = "$" + ((BackRefNode)node).getType();
            throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, node.getPosition(), "Can't set variable " + string + '.', string);
        }
    }

    public Node arg_add(ISourcePosition iSourcePosition, Node node, Node node2) {
        if (node == null) {
            return new ArrayNode(node2 == null ? iSourcePosition : node2.getPosition(), node2);
        }
        if (node instanceof ArrayNode) {
            return ((ArrayNode)node).add(node2);
        }
        return new ArgsPushNode(iSourcePosition, node, node2);
    }

    public Node node_assign(Node node, Node node2) {
        if (node == null) {
            return null;
        }
        Node node3 = node;
        this.checkExpression(node2);
        if (node instanceof AssignableNode) {
            ((AssignableNode)node).setValueNode(node2);
            node.setPosition(this.union(node, node2));
        } else if (node instanceof IArgumentNode) {
            IArgumentNode iArgumentNode = (IArgumentNode)((Object)node);
            iArgumentNode.setArgsNode(this.arg_add(node.getPosition(), iArgumentNode.getArgsNode(), node2));
        }
        return node3;
    }

    public Node ret_args(Node node, ISourcePosition iSourcePosition) {
        if (node != null) {
            if (node instanceof BlockPassNode) {
                throw new SyntaxException(SyntaxException.PID.DYNAMIC_CONSTANT_ASSIGNMENT, iSourcePosition, "Dynamic constant assignment.", new Object[0]);
            }
            if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
                node = ((ArrayNode)node).get(0);
            } else if (node instanceof SplatNode) {
                node = new SValueNode(iSourcePosition, node);
            }
        }
        return node;
    }

    public boolean isBreakStatement(Node node) {
        block4: while (true) {
            if (node == null) {
                return false;
            }
            switch (node.nodeId) {
                case NEWLINENODE: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block4;
                }
                case BREAKNODE: 
                case NEXTNODE: 
                case REDONODE: 
                case RETRYNODE: 
                case RETURNNODE: {
                    return true;
                }
            }
            break;
        }
        return false;
    }

    public void warnUnlessEOption(IRubyWarnings.ID iD, Node node, String string) {
        if (!this.configuration.isInlineSource()) {
            this.warnings.warn(iD, node.getPosition(), string, new Object[0]);
        }
    }

    public void warningUnlessEOption(IRubyWarnings.ID iD, Node node, String string) {
        if (!this.configuration.isInlineSource()) {
            this.warnings.warning(iD, node.getPosition(), string, new Object[0]);
        }
    }

    public void checkExpression(Node node) {
        if (!this.isExpression(node)) {
            this.warnings.warning(IRubyWarnings.ID.VOID_VALUE_EXPRESSION, node.getPosition(), "void value expression", new Object[0]);
        }
    }

    private boolean isExpression(Node node) {
        block8: while (true) {
            if (node == null) {
                return true;
            }
            switch (node.nodeId) {
                case BEGINNODE: {
                    node = ((BeginNode)node).getBodyNode();
                    continue block8;
                }
                case BLOCKNODE: {
                    node = ((BlockNode)node).getLast();
                    continue block8;
                }
                case BREAKNODE: {
                    node = ((BreakNode)node).getValueNode();
                    continue block8;
                }
                case NEXTNODE: 
                case REDONODE: 
                case RETRYNODE: 
                case RETURNNODE: 
                case CLASSNODE: 
                case DEFNNODE: 
                case DEFSNODE: 
                case MODULENODE: 
                case UNTILNODE: 
                case WHILENODE: {
                    return false;
                }
                case IFNODE: {
                    return this.isExpression(((IfNode)node).getThenBody()) && this.isExpression(((IfNode)node).getElseBody());
                }
                case NEWLINENODE: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block8;
                }
            }
            break;
        }
        return true;
    }

    public boolean isLiteral(Node node) {
        return node != null && (node instanceof FixnumNode || node instanceof BignumNode || node instanceof FloatNode || node instanceof SymbolNode || node instanceof RegexpNode && (((RegexpNode)node).getOptions() & 0xFFFFFF7F) == 0);
    }

    private void handleUselessWarn(Node node, String string) {
        this.warnings.warn(IRubyWarnings.ID.USELESS_EXPRESSION, node.getPosition(), "Useless use of " + string + " in void context.", string);
    }

    public void checkUselessStatement(Node node) {
        if (!this.warnings.isVerbose()) {
            return;
        }
        block11: while (true) {
            if (node == null) {
                return;
            }
            switch (node.nodeId) {
                case NEWLINENODE: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block11;
                }
                case CALLNODE: {
                    String string = ((CallNode)node).getName();
                    if (string == "+" || string == "-" || string == "*" || string == "/" || string == "%" || string == "**" || string == "+@" || string == "-@" || string == "|" || string == "^" || string == "&" || string == "<=>" || string == ">" || string == ">=" || string == "<" || string == "<=" || string == "==" || string == "!=") {
                        this.handleUselessWarn(node, string);
                    }
                    return;
                }
                case BACKREFNODE: 
                case DVARNODE: 
                case GLOBALVARNODE: 
                case LOCALVARNODE: 
                case NTHREFNODE: 
                case CLASSVARNODE: 
                case INSTVARNODE: {
                    this.handleUselessWarn(node, "a variable");
                    return;
                }
                case BIGNUMNODE: 
                case DREGEXPNODE: 
                case DSTRNODE: 
                case DSYMBOLNODE: 
                case FIXNUMNODE: 
                case FLOATNODE: 
                case REGEXPNODE: 
                case STRNODE: 
                case SYMBOLNODE: {
                    this.handleUselessWarn(node, "a literal");
                    return;
                }
                case DOTNODE: {
                    this.handleUselessWarn(node, ((DotNode)node).isExclusive() ? "..." : "..");
                    return;
                }
                case DEFINEDNODE: {
                    this.handleUselessWarn(node, "defined?");
                    return;
                }
                case FALSENODE: {
                    this.handleUselessWarn(node, "false");
                    return;
                }
                case NILNODE: {
                    this.handleUselessWarn(node, "nil");
                    return;
                }
                case TRUENODE: {
                    this.handleUselessWarn(node, "true");
                    return;
                }
            }
            break;
        }
    }

    public void checkUselessStatements(BlockNode blockNode) {
        if (this.warnings.isVerbose()) {
            Node node = blockNode.getLast();
            for (int i = 0; i < blockNode.size(); ++i) {
                Node node2 = blockNode.get(i);
                if (node == node2) continue;
                this.checkUselessStatement(node2);
            }
        }
    }

    private boolean checkAssignmentInCondition(Node node) {
        if (node instanceof MultipleAsgnNode) {
            throw new SyntaxException(SyntaxException.PID.MULTIPLE_ASSIGNMENT_IN_CONDITIONAL, node.getPosition(), "Multiple assignment in conditional.", new Object[0]);
        }
        if (node instanceof LocalAsgnNode || node instanceof DAsgnNode || node instanceof GlobalAsgnNode || node instanceof InstAsgnNode) {
            Node node2 = ((AssignableNode)node).getValueNode();
            if (node2 instanceof ILiteralNode || node2 instanceof NilNode || node2 instanceof TrueNode || node2 instanceof FalseNode) {
                this.warnings.warn(IRubyWarnings.ID.ASSIGNMENT_IN_CONDITIONAL, node.getPosition(), "Found '=' in conditional, should be '=='.", new Object[0]);
            }
            return true;
        }
        return false;
    }

    private Node cond0(Node node) {
        this.checkAssignmentInCondition(node);
        switch (node.nodeId) {
            case DREGEXPNODE: {
                ISourcePosition iSourcePosition = node.getPosition();
                return new Match2Node(iSourcePosition, node, new GlobalVarNode(iSourcePosition, "$_"));
            }
            case ANDNODE: {
                return new AndNode(node.getPosition(), this.cond0(((AndNode)node).getFirstNode()), this.cond0(((AndNode)node).getSecondNode()));
            }
            case ORNODE: {
                return new OrNode(node.getPosition(), this.cond0(((OrNode)node).getFirstNode()), this.cond0(((OrNode)node).getSecondNode()));
            }
            case DOTNODE: {
                DotNode dotNode = (DotNode)node;
                if (dotNode.isLiteral()) {
                    return node;
                }
                String string = String.valueOf("FLIP" + node.hashCode());
                this.currentScope.getLocalScope().addVariable(string);
                int n = this.currentScope.isDefined(string);
                return new FlipNode(node.getPosition(), this.getFlipConditionNode(((DotNode)node).getBeginNode()), this.getFlipConditionNode(((DotNode)node).getEndNode()), dotNode.isExclusive(), n);
            }
            case REGEXPNODE: {
                this.warningUnlessEOption(IRubyWarnings.ID.REGEXP_LITERAL_IN_CONDITION, node, "regex literal in condition");
                return new MatchNode(node.getPosition(), node);
            }
        }
        return node;
    }

    public Node getConditionNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof NewlineNode) {
            return new NewlineNode(node.getPosition(), this.cond0(((NewlineNode)node).getNextNode()));
        }
        return this.cond0(node);
    }

    private Node getFlipConditionNode(Node node) {
        if (!this.configuration.isInlineSource()) {
            return node;
        }
        if ((node = this.getConditionNode(node)) instanceof NewlineNode) {
            return ((NewlineNode)node).getNextNode();
        }
        if (node instanceof FixnumNode) {
            this.warnUnlessEOption(IRubyWarnings.ID.LITERAL_IN_CONDITIONAL_RANGE, node, "integer literal in conditional range");
            return this.getOperatorCallNode(node, "==", new GlobalVarNode(node.getPosition(), "$."));
        }
        return node;
    }

    public AndNode newAndNode(Node node, Node node2) {
        this.checkExpression(node);
        return new AndNode(this.union(node, node2), node, node2);
    }

    public OrNode newOrNode(Node node, Node node2) {
        this.checkExpression(node);
        return new OrNode(this.union(node, node2), node, node2);
    }

    public Node getReturnArgsNode(Node node) {
        if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
            return ((ListNode)node).get(0);
        }
        if (node instanceof BlockPassNode) {
            throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, node.getPosition(), "Block argument should not be given.", new Object[0]);
        }
        return node;
    }

    public Node new_call(Node node, Token token, Node node2, Node node3) {
        if (node2 == null) {
            return new CallNode(this.union(node, token), node, (String)token.getValue(), null, node3);
        }
        if (node2 instanceof BlockPassNode) {
            if (node3 != null) {
                throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, node3.getPosition(), "Both block arg and actual block given.", new Object[0]);
            }
            return new CallNode(this.union(node, node2), node, (String)token.getValue(), ((BlockPassNode)node2).getArgsNode(), node2);
        }
        return new CallNode(this.union(node, node2), node, (String)token.getValue(), node2, node3);
    }

    public Node new_fcall(Token token, Node node, Node node2) {
        String string = (String)token.getValue();
        if (node == null) {
            return new FCallNode(token.getPosition(), string, node, node2);
        }
        if (node instanceof BlockPassNode) {
            if (node2 != null) {
                throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, node2.getPosition(), "Both block arg and actual block given.", new Object[0]);
            }
            return new FCallNode(this.union(token, node), string, ((BlockPassNode)node).getArgsNode(), node);
        }
        return new FCallNode(this.union(token, node), string, node, node2);
    }

    public Node new_super(Node node, Token token) {
        if (node != null && node instanceof BlockPassNode) {
            return new SuperNode(this.union(token, node), ((BlockPassNode)node).getArgsNode(), node);
        }
        return new SuperNode(token.getPosition(), node);
    }

    public void initTopLocalVariables() {
        DynamicScope dynamicScope = this.configuration.getScope();
        this.currentScope = dynamicScope.getStaticScope();
        this.result.setScope(dynamicScope);
    }

    public boolean isInSingle() {
        return this.inSingleton != 0;
    }

    public void setInSingle(int n) {
        this.inSingleton = n;
    }

    public boolean isInDef() {
        return this.inDefinition;
    }

    public void setInDef(boolean bl) {
        this.inDefinition = bl;
    }

    public int getInSingle() {
        return this.inSingleton;
    }

    public RubyParserResult getResult() {
        return this.result;
    }

    public void setResult(RubyParserResult rubyParserResult) {
        this.result = rubyParserResult;
    }

    public void setConfiguration(ParserConfiguration parserConfiguration) {
        this.configuration = parserConfiguration;
    }

    public void setWarnings(IRubyWarnings iRubyWarnings) {
        this.warnings = iRubyWarnings;
    }

    public Node literal_concat(ISourcePosition iSourcePosition, Node node, Node node2) {
        if (node == null) {
            return node2;
        }
        if (node2 == null) {
            return node;
        }
        if (node instanceof EvStrNode) {
            node = new DStrNode(this.union(node.getPosition(), iSourcePosition)).add(node);
        }
        if (node2 instanceof StrNode) {
            if (node instanceof StrNode) {
                return new StrNode(this.union(node, node2), (StrNode)node, (StrNode)node2);
            }
            node.setPosition(this.union(node, node2));
            return ((ListNode)node).add(node2);
        }
        if (node2 instanceof DStrNode) {
            if (node instanceof StrNode) {
                ((DStrNode)node2).prepend(node);
                return node2;
            }
            return ((ListNode)node).addAll(node2);
        }
        if (node instanceof StrNode) {
            if (((StrNode)node).getValue().length() == 0) {
                node = new DStrNode(node.getPosition());
            } else {
                node.getPosition().adjustStartOffset(-1);
                node = new DStrNode(node.getPosition()).add(node);
            }
        }
        return ((DStrNode)node).add(node2);
    }

    public Node newEvStrNode(ISourcePosition iSourcePosition, Node node) {
        Node node2 = node;
        while (node != null) {
            if (node instanceof StrNode || node instanceof DStrNode || node instanceof EvStrNode) {
                return node;
            }
            if (!(node instanceof NewlineNode)) break;
            node = ((NewlineNode)node).getNextNode();
        }
        return new EvStrNode(iSourcePosition, node2);
    }

    public Node new_yield(ISourcePosition iSourcePosition, Node node) {
        boolean bl = true;
        if (node != null) {
            if (node instanceof BlockPassNode) {
                throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, node.getPosition(), "Block argument should not be given.", new Object[0]);
            }
            if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
                node = ((ArrayNode)node).get(0);
                bl = false;
            }
            if (node != null && node instanceof SplatNode) {
                bl = true;
            }
        } else {
            bl = false;
        }
        return new YieldNode(iSourcePosition, node, bl);
    }

    public Node negateInteger(Node node) {
        if (node instanceof FixnumNode) {
            FixnumNode fixnumNode = (FixnumNode)node;
            fixnumNode.setValue(-fixnumNode.getValue());
            return fixnumNode;
        }
        if (node instanceof BignumNode) {
            BignumNode bignumNode = (BignumNode)node;
            bignumNode.setValue(bignumNode.getValue().negate());
        }
        return node;
    }

    public FloatNode negateFloat(FloatNode floatNode) {
        floatNode.setValue(-floatNode.getValue());
        return floatNode;
    }

    public ISourcePosition createEmptyArgsNodePosition(ISourcePosition iSourcePosition) {
        return new IDESourcePosition(iSourcePosition.getFile(), iSourcePosition.getStartLine(), iSourcePosition.getEndLine(), iSourcePosition.getEndOffset() - 1, iSourcePosition.getEndOffset() - 1);
    }

    public Node unwrapNewlineNode(Node node) {
        if (node instanceof NewlineNode) {
            return ((NewlineNode)node).getNextNode();
        }
        return node;
    }

    private Node checkForNilNode(Node node, ISourcePosition iSourcePosition) {
        return node == null ? new NilNode(iSourcePosition) : node;
    }

    public ArgumentNode getRestArgNode(Token token) {
        int n = (Integer)token.getValue();
        if (n < 0) {
            return null;
        }
        String string = this.getCurrentScope().getLocalScope().getVariables()[n];
        IDESourcePosition iDESourcePosition = new IDESourcePosition(token.getPosition().getFile(), token.getPosition().getStartLine(), token.getPosition().getEndLine(), token.getPosition().getStartOffset(), token.getPosition().getEndOffset() + string.length());
        return new ArgumentNode((ISourcePosition)iDESourcePosition, string);
    }
}

