/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.util.collections.WeakHashSet;

public class CacheMap {
    private final Map<DynamicMethod, Set<CacheSite>> mappings = new WeakHashMap<DynamicMethod, Set<CacheSite>>();

    public synchronized void add(DynamicMethod dynamicMethod, CacheSite cacheSite) {
        Set<CacheSite> set = this.mappings.get(dynamicMethod);
        if (set == null) {
            set = new WeakHashSet<CacheSite>();
            this.mappings.put(dynamicMethod, set);
        }
        set.add(cacheSite);
    }

    public synchronized void remove(DynamicMethod dynamicMethod) {
        Set<CacheSite> set = this.mappings.remove(dynamicMethod);
        if (set == null) {
            return;
        }
        for (CacheSite cacheSite : set) {
            if (cacheSite == null) continue;
            cacheSite.removeCachedMethod();
        }
    }

    public synchronized void moduleIncluded(RubyModule rubyModule, RubyModule rubyModule2) {
        for (String string : rubyModule2.getMethods().keySet()) {
            for (RubyModule rubyModule3 = rubyModule; rubyModule3 != null; rubyModule3 = rubyModule3.getSuperClass()) {
                Set<CacheSite> set;
                DynamicMethod dynamicMethod;
                if (rubyModule3 == rubyModule2 || (dynamicMethod = rubyModule3.getMethods().get(string)) == null || (set = this.mappings.remove(dynamicMethod)) == null) continue;
                for (CacheSite cacheSite : set) {
                    cacheSite.removeCachedMethod();
                }
            }
        }
    }

    public static interface CacheSite {
        public void removeCachedMethod();
    }
}

