/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledBlock
extends BlockBody {
    protected final CompiledBlockCallback callback;
    protected final boolean hasMultipleArgsHead;
    protected final Arity arity;
    protected final StaticScope scope;

    public static Block newCompiledClosure(IRubyObject iRubyObject, Frame frame, Visibility visibility, RubyModule rubyModule, DynamicScope dynamicScope, Arity arity, StaticScope staticScope, CompiledBlockCallback compiledBlockCallback, boolean bl, int n) {
        Binding binding = new Binding(iRubyObject, frame, visibility, rubyModule, dynamicScope);
        CompiledBlock compiledBlock = new CompiledBlock(arity, staticScope, compiledBlockCallback, bl, n);
        return new Block(compiledBlock, binding);
    }

    public static Block newCompiledClosure(ThreadContext threadContext, IRubyObject iRubyObject, Arity arity, StaticScope staticScope, CompiledBlockCallback compiledBlockCallback, boolean bl, int n) {
        return CompiledBlock.newCompiledClosure(iRubyObject, threadContext.getCurrentFrame(), Visibility.PUBLIC, threadContext.getRubyClass(), threadContext.getCurrentScope(), arity, staticScope, compiledBlockCallback, bl, n);
    }

    protected CompiledBlock(Arity arity, StaticScope staticScope, CompiledBlockCallback compiledBlockCallback, boolean bl, int n) {
        super(n);
        this.arity = arity;
        this.scope = staticScope;
        this.callback = compiledBlockCallback;
        this.hasMultipleArgsHead = bl;
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Binding binding, Block.Type type) {
        iRubyObjectArray = this.prepareArgumentsForCall(threadContext, iRubyObjectArray, type);
        return this.yield(threadContext, threadContext.getRuntime().newArrayNoCopy(iRubyObjectArray), null, null, true, binding, type);
    }

    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, Binding binding, Block.Type type) {
        return this.yield(threadContext, iRubyObject, null, null, false, binding, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, RubyModule rubyModule, boolean bl, Binding binding, Block.Type type) {
        if (rubyModule == null) {
            iRubyObject2 = binding.getSelf();
            binding.getFrame().setSelf(iRubyObject2);
        }
        Visibility visibility = binding.getFrame().getVisibility();
        IRubyObject[] iRubyObjectArray = bl ? this.setupBlockArgs(threadContext, iRubyObject, iRubyObject2) : this.setupBlockArg(threadContext, iRubyObject, iRubyObject2);
        this.pre(threadContext, rubyModule, binding);
        try {
            IRubyObject iRubyObject3 = this.callback.call(threadContext, iRubyObject2, iRubyObjectArray);
            return iRubyObject3;
        }
        catch (JumpException.BreakJump breakJump) {
            if (breakJump.getTarget() == null) {
                breakJump.setTarget(this);
            }
            throw breakJump;
        }
        catch (JumpException.NextJump nextJump) {
            IRubyObject iRubyObject4 = type == Block.Type.LAMBDA ? threadContext.getRuntime().getNil() : (IRubyObject)nextJump.getValue();
            return iRubyObject4;
        }
        finally {
            binding.getFrame().setVisibility(visibility);
            this.post(threadContext, binding);
        }
    }

    protected void pre(ThreadContext threadContext, RubyModule rubyModule, Binding binding) {
        threadContext.preYieldSpecificBlock(binding, this.scope, rubyModule);
    }

    protected void post(ThreadContext threadContext, Binding binding) {
        threadContext.postYield(binding);
    }

    private IRubyObject[] setupBlockArgs(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        switch (this.argumentType) {
            case 0: {
                return IRubyObject.NULL_ARRAY;
            }
            case 1: 
            case 3: {
                return new IRubyObject[]{iRubyObject};
            }
        }
        int n = this.arrayLength(iRubyObject);
        switch (n) {
            case 0: {
                iRubyObject = threadContext.getRuntime().getNil();
                break;
            }
            case 1: {
                iRubyObject = ((RubyArray)iRubyObject).eltInternal(0);
                break;
            }
            default: {
                threadContext.getRuntime().getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + n + " for 1)", new Object[0]);
            }
        }
        return new IRubyObject[]{iRubyObject};
    }

    private IRubyObject[] setupBlockArg(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        switch (this.argumentType) {
            case 0: {
                return IRubyObject.NULL_ARRAY;
            }
            case 1: 
            case 3: {
                return new IRubyObject[]{ArgsUtil.convertToRubyArray(threadContext.getRuntime(), iRubyObject, this.hasMultipleArgsHead)};
            }
        }
        if (iRubyObject == null) {
            threadContext.getRuntime().getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (0 for 1)", new Object[0]);
            return new IRubyObject[]{threadContext.getRuntime().getNil()};
        }
        return new IRubyObject[]{iRubyObject};
    }

    public StaticScope getStaticScope() {
        return this.scope;
    }

    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), binding.getFrame().duplicate(), binding.getVisibility(), binding.getKlass(), binding.getDynamicScope());
        return new Block(this, binding);
    }

    public Arity arity() {
        return this.arity;
    }
}

