/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.runtime.Block;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class Frame
implements JumpTarget {
    private RubyModule klazz;
    private IRubyObject self;
    private String name;
    private Block block;
    private boolean isBindingFrame = false;
    private Visibility visibility = Visibility.PUBLIC;
    private JumpTarget jumpTarget;
    private IRubyObject backref;
    private IRubyObject lastline;
    private String fileName;
    private int line;

    public JumpTarget getJumpTarget() {
        return this.jumpTarget;
    }

    public void setJumpTarget(JumpTarget jumpTarget) {
        this.jumpTarget = jumpTarget;
    }

    public void updateFrame(String string, int n) {
        this.updateFrame(null, null, null, Block.NULL_BLOCK, string, n, null);
    }

    public void updateFrame(Frame frame) {
        assert (frame.block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = frame.self;
        this.name = frame.name;
        this.klazz = frame.klazz;
        this.fileName = frame.fileName;
        this.line = frame.line;
        this.block = frame.block;
        this.jumpTarget = frame.jumpTarget;
        this.visibility = frame.visibility;
        this.isBindingFrame = frame.isBindingFrame;
        this.backref = frame.backref;
        this.lastline = frame.lastline;
    }

    public void updateFrame(RubyModule rubyModule, IRubyObject iRubyObject, String string, Block block, String string2, int n, JumpTarget jumpTarget) {
        assert (block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = iRubyObject;
        this.name = string;
        this.klazz = rubyModule;
        this.fileName = string2;
        this.line = n;
        this.block = block;
        this.jumpTarget = jumpTarget;
        this.visibility = Visibility.PUBLIC;
        this.isBindingFrame = false;
        this.backref = null;
        this.lastline = null;
    }

    public void updateFrame(String string, String string2, int n) {
        this.name = string;
        this.fileName = string2;
        this.line = n;
    }

    public Frame duplicate() {
        Frame frame = new Frame();
        frame.updateFrame(this);
        return frame;
    }

    public IRubyObject getBackRef() {
        return this.backref == null ? this.self.getRuntime().getNil() : this.backref;
    }

    public void setBackRef(IRubyObject iRubyObject) {
        this.backref = iRubyObject;
    }

    public IRubyObject getLastLine() {
        return this.lastline == null ? this.self.getRuntime().getNil() : this.lastline;
    }

    public void setLastLine(IRubyObject iRubyObject) {
        this.lastline = iRubyObject;
    }

    public String getFile() {
        return this.fileName;
    }

    public int getLine() {
        return this.line;
    }

    public void setFile(String string) {
        this.fileName = string;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public RubyModule getKlazz() {
        return this.klazz;
    }

    public void setKlazz(RubyModule rubyModule) {
        this.klazz = rubyModule;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    IRubyObject getSelf() {
        return this.self;
    }

    public void setSelf(IRubyObject iRubyObject) {
        this.self = iRubyObject;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public boolean isBindingFrame() {
        return this.isBindingFrame;
    }

    public void setIsBindingFrame(boolean bl) {
        this.isBindingFrame = bl;
    }

    public Block getBlock() {
        return this.block;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this.fileName).append(':').append(this.line + 1).append(':').append(this.klazz);
        if (this.name != null) {
            stringBuffer.append(" in ").append(this.name);
        }
        return stringBuffer.toString();
    }
}

