/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.util.JRubyClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCache<T> {
    private ReferenceQueue referenceQueue = new ReferenceQueue();
    private Map<Object, KeyedClassReference> cache = new ConcurrentHashMap<Object, KeyedClassReference>();
    private ClassLoader classLoader;
    private int max;

    public ClassCache(ClassLoader classLoader, int n) {
        this.classLoader = classLoader;
        this.max = n;
    }

    public ClassCache(ClassLoader classLoader) {
        this(classLoader, -1);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public int getMax() {
        return this.max;
    }

    public Class<T> cacheClassByKey(Object object, ClassGenerator classGenerator) throws ClassNotFoundException {
        WeakReference weakReference = this.cache.get(object);
        Class<?> clazz = null;
        if (weakReference != null) {
            clazz = (Class<?>)weakReference.get();
        }
        if (weakReference == null || clazz == null) {
            if (this.isFull()) {
                return null;
            }
            OneShotClassLoader oneShotClassLoader = new OneShotClassLoader(this.getClassLoader());
            clazz = oneShotClassLoader.defineClass(classGenerator.name(), classGenerator.bytecode());
            this.cache.put(object, new KeyedClassReference(object, clazz, this.referenceQueue));
        }
        return clazz;
    }

    public boolean isFull() {
        this.cleanup();
        return this.max > 0 && this.cache.size() >= this.max;
    }

    private void cleanup() {
        KeyedClassReference keyedClassReference;
        while ((keyedClassReference = (KeyedClassReference)this.referenceQueue.poll()) != null) {
            this.cache.remove(keyedClassReference.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OneShotClassLoader
    extends URLClassLoader {
        private static final ProtectionDomain DEFAULT_DOMAIN = JRubyClassLoader.class.getProtectionDomain();

        public OneShotClassLoader(ClassLoader classLoader) {
            super(new URL[0], classLoader);
        }

        @Override
        public void addURL(URL uRL) {
            super.addURL(uRL);
        }

        public Class<?> defineClass(String string, byte[] byArray) {
            return super.defineClass(string, byArray, 0, byArray.length, DEFAULT_DOMAIN);
        }

        public Class<?> defineClass(String string, byte[] byArray, ProtectionDomain protectionDomain) {
            return super.defineClass(string, byArray, 0, byArray.length, protectionDomain);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyedClassReference<T>
    extends WeakReference<Class<T>> {
        private Object key;

        public KeyedClassReference(Object object, Class<T> clazz, ReferenceQueue<Class<T>> referenceQueue) {
            super(clazz, referenceQueue);
            this.key = object;
        }

        public Object getKey() {
            return this.key;
        }
    }

    public static interface ClassGenerator {
        public byte[] bytecode();

        public String name();
    }
}

