/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.OutputStream;
import org.jruby.RubyString;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOOutputStream
extends OutputStream {
    private IRubyObject io;
    private CallSite writeAdapter;
    private CallSite closeAdapter = new CallSite.InlineCachingCallSite("close", CallType.FUNCTIONAL);

    public IOOutputStream(IRubyObject iRubyObject) {
        if (iRubyObject.respondsTo("write")) {
            this.writeAdapter = new CallSite.InlineCachingCallSite("write", CallType.FUNCTIONAL);
        } else if (iRubyObject.respondsTo("<<")) {
            this.writeAdapter = new CallSite.InlineCachingCallSite("<<", CallType.FUNCTIONAL);
        } else {
            throw new IllegalArgumentException("Object: " + iRubyObject + " is not a legal argument to this wrapper, cause it doesn't respond to \"write\".");
        }
        this.io = iRubyObject;
    }

    public void write(int n) throws IOException {
        this.writeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, RubyString.newStringLight(this.io.getRuntime(), new ByteList(new byte[]{(byte)n}, false)));
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, RubyString.newStringLight(this.io.getRuntime(), new ByteList(byArray, n, n2, false)));
    }

    public void close() throws IOException {
        this.closeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io);
    }
}

