/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;

public class SimpleSampler {
    private static final Map<ThreadContext, Object> CURRENT = new WeakHashMap<ThreadContext, Object>();
    private static boolean reported = false;
    private static final Map<String, Integer> SAMPLES = new HashMap<String, Integer>();
    private static final List<List<String>> TRACES = new ArrayList<List<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerThreadContext(ThreadContext threadContext) {
        Map<ThreadContext, Object> map = CURRENT;
        synchronized (map) {
            CURRENT.put(threadContext, null);
        }
    }

    public static void startSampleThread() {
        new Thread(new Runnable(){

            public void run() {
                SimpleSampler.runSampling();
            }
        }).start();
    }

    public static void report() {
        if (!reported) {
            System.err.println();
            System.err.println("Samples - ");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(SAMPLES.keySet());
            Collections.sort(arrayList, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return (Integer)SAMPLES.get(string2) - (Integer)SAMPLES.get(string);
                }
            });
            for (List<String> list : TRACES) {
                if (list.size() <= 1) continue;
                System.err.println("Trace #" + System.identityHashCode(list));
                for (String string : list) {
                    System.err.println("  " + string);
                }
                System.err.println();
            }
            String string = "                                                            ";
            for (String string2 : arrayList) {
                int n = Math.max(60 - string2.length(), 0);
                System.err.println(" " + string2 + string.substring(0, n) + "==> " + SAMPLES.get(string2));
            }
            reported = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runSampling() {
        long l = Long.parseLong(System.getProperty("jruby.sampling.interval", "10"));
        int n = Integer.parseInt(System.getProperty("jruby.sampling.depth", "5"));
        System.err.println("[Sampling with");
        System.err.println(" - interval: " + l);
        System.err.println(" - depth: " + n + "]");
        Map<ThreadContext, Object> map = CURRENT;
        synchronized (map) {
            while (!reported) {
                try {
                    CURRENT.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    for (ThreadContext threadContext : CURRENT.keySet()) {
                        Frame[] frameArray;
                        if (threadContext == null || (frameArray = threadContext.createBacktrace(1, false)) == null) continue;
                        ArrayList<String> arrayList = new ArrayList<String>(n);
                        for (int i = Math.max(frameArray.length - n, 0); i < frameArray.length; ++i) {
                            Frame frame = frameArray[i];
                            String string = frame.getKlazz() + "#" + frame.getName();
                            if (frame.isBindingFrame() || string.equals("null#null")) continue;
                            arrayList.add(string);
                            Integer n2 = SAMPLES.get(string);
                            if (n2 == null) {
                                n2 = 1;
                            } else {
                                Integer n3 = n2;
                                Integer n4 = n2 = Integer.valueOf(n2 + 1);
                            }
                            SAMPLES.put(string, n2);
                        }
                        TRACES.add(arrayList);
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

