/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ZlibInflate {
    private Inflater flater = new Inflater(false);
    private ByteList collected = new ByteList(100);
    private Ruby runtime;
    public static final int BASE_SIZE = 100;

    public ZlibInflate(IRubyObject iRubyObject) {
        this.runtime = iRubyObject.getRuntime();
    }

    public static IRubyObject s_inflate(IRubyObject iRubyObject, ByteList byteList) throws DataFormatException {
        ZlibInflate zlibInflate = new ZlibInflate(iRubyObject);
        IRubyObject iRubyObject2 = zlibInflate.inflate(byteList);
        zlibInflate.finish();
        zlibInflate.close();
        return iRubyObject2;
    }

    public Inflater getInflater() {
        return this.flater;
    }

    public void append(IRubyObject iRubyObject) {
        this.append(iRubyObject.convertToString().getByteList());
    }

    public void append(ByteList byteList) {
        this.collected.append(byteList);
    }

    public IRubyObject sync_point() {
        return this.runtime.getFalse();
    }

    public IRubyObject set_dictionary(IRubyObject iRubyObject) throws UnsupportedEncodingException {
        this.flater.setDictionary(iRubyObject.convertToString().getBytes());
        return iRubyObject;
    }

    public IRubyObject inflate(ByteList byteList) throws DataFormatException {
        if (null != byteList) {
            this.append(byteList);
        }
        ByteList byteList2 = new ByteList(this.collected.realSize);
        byte[] byArray = new byte[1024];
        ByteList byteList3 = this.collected;
        this.collected = new ByteList(100);
        int n = -1;
        try {
            this.flater.setInput(byteList3.bytes, byteList3.begin, byteList3.realSize);
            while (!this.flater.finished() && n != 0) {
                n = this.flater.inflate(byArray);
                byteList2.append(byArray, 0, n);
            }
        }
        catch (DataFormatException dataFormatException) {
            this.flater = new Inflater(true);
            this.flater.setInput(byteList3.bytes, byteList3.begin, byteList3.realSize);
            while (!this.flater.finished() && n != 0) {
                n = this.flater.inflate(byArray);
                byteList2.append(byArray, 0, n);
            }
        }
        return RubyString.newString(this.runtime, byteList2);
    }

    public IRubyObject sync(IRubyObject iRubyObject) {
        this.append(iRubyObject);
        return this.runtime.getFalse();
    }

    public void finish() {
        this.flater.end();
    }

    public void close() {
    }
}

