/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.string;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.jruby.util.string.UstrException;

public class Ustr
implements Comparable,
Serializable {
    private static final long serialVersionUID = -7263880042540200296L;
    private static final byte[] encLength = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, -1, -1, -1, -1, -1, -1, -1, -1};
    private static Hashtable interns = new Hashtable();
    public byte[] s;
    public int base = 0;
    public int offset = 0;

    public Ustr() {
        this.offset = 0;
        this.base = 0;
    }

    public Ustr(int n) {
        this.s = new byte[n];
        this.offset = 0;
        this.base = 0;
        this.s[0] = 0;
    }

    public Ustr(byte[] byArray) {
        this.s = byArray;
        this.offset = 0;
        this.base = 0;
    }

    public Ustr(byte[] byArray, int n) {
        this.s = byArray;
        this.base = this.offset = n;
    }

    public Ustr(Ustr ustr) {
        this.s = new byte[ustr.strlen() + 1];
        this.offset = 0;
        this.base = 0;
        this.strcpy(ustr);
    }

    public Ustr(char[] cArray) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < cArray.length; ++n2) {
            n = cArray[n2];
            n3 += Ustr.bytesInChar(n);
        }
        this.s = new byte[n3 + 1];
        this.base = 0;
        this.prepareAppend();
        for (n2 = 0; n2 < cArray.length; ++n2) {
            n = cArray[n2];
            if (n >= 55296 && n <= 57343) {
                if (n > 56319) {
                    throw new UstrException("Mangled surrogate pair");
                }
                if (++n2 == cArray.length) {
                    throw new UstrException("Mangled surrogate pair");
                }
                int n4 = cArray[n2];
                if (n4 < 56320 || n4 > 57343) {
                    throw new UstrException("Mangled surrogate pair");
                }
                n &= 0x3FF;
                n <<= 10;
                n |= (n4 &= 0x3FF);
                n += 65536;
            }
            this.appendChar(n);
        }
        this.s[this.s.length - 1] = 0;
    }

    public Ustr(int[] nArray) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (n < 0) {
                throw new UstrException("Negative character value");
            }
            if (n > 0x10FFFF) {
                throw new UstrException("Character out of Unicode range");
            }
            n3 += Ustr.bytesInChar(n);
        }
        this.s = new byte[n3 + 1];
        this.offset = 0;
        this.base = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            this.appendChar(n);
        }
    }

    public Ustr(Object object) {
        byte[] byArray;
        this.offset = 0;
        this.base = 0;
        try {
            byArray = object.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UstrException("UTF8 not supported!?!?");
        }
        this.s = new byte[byArray.length + 1];
        for (int i = 0; i < byArray.length; ++i) {
            this.s[i] = byArray[i];
        }
        this.s[byArray.length] = 0;
    }

    public Ustr(int n, Object object) {
        byte[] byArray;
        this.s = new byte[n];
        this.offset = 0;
        this.base = 0;
        try {
            byArray = object.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF8 not supported!?!?");
        }
        for (int i = 0; i < byArray.length; ++i) {
            this.s[i] = byArray[i];
        }
        this.s[byArray.length] = 0;
    }

    public void init() {
        this.s[this.base] = 0;
        this.offset = this.base;
    }

    public int compareTo(Object object) {
        Ustr ustr = object instanceof Ustr ? (Ustr)object : new Ustr(object);
        return Ustr.strcmp(this.s, this.base, ustr.s, ustr.base);
    }

    public String toString() {
        try {
            return new String(this.s, this.base, this.strlen(), "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UstrException("UTF8 not supported!?!?");
        }
    }

    public int length() {
        int n = this.offset;
        int n2 = 0;
        this.prepareNext();
        while (this.nextChar() != 0) {
            ++n2;
        }
        this.offset = n;
        return n2;
    }

    public static int length(byte[] byArray, int n) {
        return new Ustr(byArray, n).length();
    }

    public static int length(byte[] byArray) {
        return Ustr.length(byArray, 0);
    }

    public static int length(String string) {
        return new Ustr(string).length();
    }

    public void prepareAppend() {
        this.offset = this.strlen();
    }

    public void appendChar(int n) {
        this.offset = Ustr.appendChar(n, this.s, this.offset);
    }

    public static int appendChar(int n, byte[] byArray, int n2) {
        if (n < 0) {
            throw new UstrException("Appended negative character");
        }
        if (n < 128) {
            byArray[n2++] = (byte)n;
        } else if (n <= 2047) {
            byArray[n2++] = (byte)(n >> 6 | 0xC0);
            byArray[n2++] = (byte)(n & 0x3F | 0x80);
        } else if (n <= 65535) {
            byArray[n2++] = (byte)(n >> 12 | 0xE0);
            byArray[n2++] = (byte)(n >> 6 & 0x3F | 0x80);
            byArray[n2++] = (byte)(n & 0x3F | 0x80);
        } else if (n <= 0x10FFFF) {
            byArray[n2++] = (byte)(n >> 18 | 0xF0);
            byArray[n2++] = (byte)(n >> 12 & 0x3F | 0x80);
            byArray[n2++] = (byte)(n >> 6 & 0x3F | 0x80);
            byArray[n2++] = (byte)(n & 0x3F | 0x80);
        } else {
            throw new UstrException("Appended character > 0x10ffff");
        }
        byArray[n2] = 0;
        return n2;
    }

    public void prepareNext() {
        this.offset = this.base;
    }

    public int nextChar() {
        if (this.s[this.offset] == 0) {
            return 0;
        }
        if ((this.s[this.offset] & 0x80) == 0) {
            return this.s[this.offset++];
        }
        if ((this.s[this.offset] & 0xE0) == 192) {
            int n = (this.s[this.offset++] & 0x1F) << 6;
            return n |= this.s[this.offset++] & 0x3F;
        }
        if ((this.s[this.offset] & 0xF0) == 224) {
            int n = (this.s[this.offset++] & 0xF) << 12;
            n |= (this.s[this.offset++] & 0x3F) << 6;
            return n |= this.s[this.offset++] & 0x3F;
        }
        int n = (this.s[this.offset++] & 7) << 18;
        n |= (this.s[this.offset++] & 0x3F) << 12;
        n |= (this.s[this.offset++] & 0x3F) << 6;
        return n |= this.s[this.offset++] & 0x3F;
    }

    public int strlen() {
        return Ustr.strlen(this.s, this.base);
    }

    public static int strlen(byte[] byArray) {
        int n = 0;
        while (byArray[n] != 0) {
            ++n;
        }
        return n;
    }

    public static int strlen(byte[] byArray, int n) {
        int n2 = n;
        while (byArray[n2] != 0) {
            ++n2;
        }
        return n2 - n;
    }

    public static byte[] strcpy(byte[] byArray, byte[] byArray2) {
        return Ustr.strcpy(byArray, 0, byArray2, 0);
    }

    public static byte[] strcpy(byte[] byArray, int n, byte[] byArray2, int n2) {
        while (byArray2[n2] != 0) {
            byArray[n++] = byArray2[n2++];
        }
        byArray[n] = 0;
        return byArray;
    }

    public Ustr strcpy(Ustr ustr) {
        Ustr.strcpy(this.s, this.base, ustr.s, ustr.base);
        return this;
    }

    public Ustr strcpy(Object object) {
        this.strcpy(new Ustr(object));
        return this;
    }

    public Ustr strcpy(byte[] byArray) {
        Ustr.strcpy(this.s, byArray);
        return this;
    }

    public Ustr strcpy(byte[] byArray, int n) {
        Ustr.strcpy(this.s, 0, byArray, n);
        return this;
    }

    public static byte[] strcpy(byte[] byArray, String string) {
        return Ustr.strcpy(byArray, 0, string);
    }

    public static byte[] strcpy(byte[] byArray, int n, String string) {
        byte[] byArray2;
        try {
            byArray2 = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF8 not supported!?!?");
        }
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[n + i] = byArray2[i];
        }
        byArray[n + byArray2.length] = 0;
        return byArray;
    }

    public Ustr sstrcat(Ustr ustr) {
        Ustr.sstrcat(this.s, this.base, ustr.s, ustr.base);
        return this;
    }

    public byte[] sstrcat(byte[] byArray, byte[] byArray2) {
        return Ustr.sstrcat(byArray, 0, byArray2, 0);
    }

    public static byte[] sstrcat(byte[] byArray, int n, byte[] byArray2, int n2) {
        while (byArray[n] != 0) {
            ++n;
        }
        try {
            while (byArray2[n2] != 0) {
                byArray[n++] = byArray2[n2++];
            }
            byArray[n] = 0;
            return byArray;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n < byArray.length) {
                throw arrayIndexOutOfBoundsException;
            }
            byArray[byArray.length - 1] = 0;
            return byArray;
        }
    }

    public static byte[] sstrcpy(byte[] byArray, int n, byte[] byArray2, int n2) {
        try {
            while (byArray2[n2] != 0) {
                byArray[n++] = byArray2[n2++];
            }
            byArray[n] = 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n >= byArray.length) {
                byArray[byArray.length - 1] = 0;
            }
            throw arrayIndexOutOfBoundsException;
        }
        return byArray;
    }

    public static byte[] sstrcpy(byte[] byArray, byte[] byArray2) {
        return Ustr.sstrcpy(byArray, 0, byArray2, 0);
    }

    public Ustr sstrcpy(Ustr ustr) {
        Ustr.sstrcpy(this.s, this.base, ustr.s, ustr.base);
        return this;
    }

    public static byte[] strcat(byte[] byArray, int n, byte[] byArray2, int n2) {
        while (byArray[n] != 0) {
            ++n;
        }
        while (byArray2[n2] != 0) {
            byArray[n++] = byArray2[n2++];
        }
        byArray[n] = 0;
        return byArray;
    }

    public static byte[] strcat(byte[] byArray, byte[] byArray2) {
        return Ustr.strcat(byArray, 0, byArray2, 0);
    }

    public Ustr strcat(Ustr ustr) {
        Ustr.strcat(this.s, ustr.s);
        return this;
    }

    public static int strcmp(byte[] byArray, byte[] byArray2) {
        return Ustr.strcmp(byArray, 0, byArray2, 0);
    }

    public static int strcmp(byte[] byArray, int n, byte[] byArray2, int n2) {
        Ustr ustr = new Ustr(byArray, n);
        Ustr ustr2 = new Ustr(byArray2, n2);
        int n3 = ustr.nextChar();
        int n4 = ustr2.nextChar();
        while (n3 != 0 && n4 != 0 && n3 == n4) {
            n3 = ustr.nextChar();
            n4 = ustr2.nextChar();
        }
        return n3 - n4;
    }

    public int strcmp(Ustr ustr) {
        return Ustr.strcmp(this.s, this.base, ustr.s, ustr.base);
    }

    public int strcmp(Object object) {
        return this.strcmp(new Ustr(object));
    }

    public Ustr strchr(int n) {
        int n2 = Ustr.strchr(this.s, n);
        return n2 == -1 ? null : new Ustr(this.s, n2);
    }

    public static int strchr(byte[] byArray, int n) {
        byte[] byArray2 = new byte[10];
        Ustr.appendChar(n, byArray2, 0);
        return Ustr.strstr(byArray, byArray2);
    }

    public Ustr strrchr(int n) {
        int n2 = Ustr.strrchr(this.s, n);
        return n2 == -1 ? null : new Ustr(this.s, n2);
    }

    public static int strrchr(byte[] byArray, int n) {
        byte[] byArray2 = new byte[10];
        Ustr.appendChar(n, byArray2, 0);
        for (int i = byArray.length - Ustr.strlen(byArray2); i >= 0; --i) {
            int n2 = 0;
            while (byArray2[n2] != 0 && byArray[i + n2] == byArray2[n2]) {
                ++n2;
            }
            if (byArray2[n2] != 0) continue;
            return i;
        }
        return -1;
    }

    public Ustr strstr(Ustr ustr) {
        int n = Ustr.strstr(this.s, ustr.s);
        return n == -1 ? null : new Ustr(this.s, n);
    }

    public static int strstr(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (byArray[n] != 0) {
            int n2 = 0;
            while (byArray2[n2] != 0 && byArray[n + n2] == byArray2[n2]) {
                ++n2;
            }
            if (byArray2[n2] == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static Ustr copyValueOf(char[] cArray) {
        return new Ustr(cArray);
    }

    static Ustr copyValueOf(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray2[i] = cArray[n + i];
        }
        return new Ustr(cArray2);
    }

    public int charAt(int n) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Negative Ustr charAt");
        }
        int n2 = 0;
        this.offset = 0;
        this.prepareNext();
        while ((n2 = this.nextChar()) != 0 && --n >= 0) {
        }
        if (n > 0) {
            throw new IndexOutOfBoundsException("Ustr charAt too large");
        }
        return n2;
    }

    public Ustr concat(String string) {
        Ustr ustr = new Ustr(string);
        return this.concat(ustr);
    }

    public Ustr concat(Ustr ustr) {
        Ustr ustr2 = new Ustr(this.strlen() + ustr.strlen() + 1);
        ustr2.strcpy(this);
        ustr2.strcat(ustr);
        return ustr2;
    }

    public boolean endsWith(Ustr ustr) {
        int n = this.strlen() - ustr.strlen();
        if (n < 0) {
            return false;
        }
        int n2 = 0;
        while (this.s[this.base + n + n2] != 0 && ustr.s[ustr.base + n2] != 0 && this.s[this.base + n + n2] == ustr.s[ustr.base + n2]) {
            ++n2;
        }
        return this.s[this.base + n + n2] == ustr.s[ustr.base + n2];
    }

    public boolean endsWith(String string) {
        return this.endsWith(new Ustr(string));
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public byte[] getBytes() {
        return this.toString().getBytes();
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        return this.toString().getBytes(string);
    }

    public static void getChars(String string, int n, int n2, char[] cArray, int n3) {
        Ustr ustr = new Ustr(string);
        ustr.getChars(n, n2, cArray, n3);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n > n2 || n3 < 0) {
            throw new IndexOutOfBoundsException("bogus getChars index bounds");
        }
        if (cArray == null) {
            throw new NullPointerException("null 'dst' argument to getChars");
        }
        this.prepareNext();
        while (n > 0) {
            --n;
            this.nextChar();
        }
        int n4 = n2 - n;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = this.nextChar();
            if (n7 == 0 && n6 < n4 - 1) {
                throw new IndexOutOfBoundsException("getChars ran off buffer");
            }
            if (n7 < 65536) {
                cArray[n3 + n5] = (char)n7;
            } else {
                int n8 = (n7 -= 65536) >> 10 & 0x3FF;
                cArray[n3 + n5] = (char)(0xD800 | n8);
                int n9 = n7 & 0x3FF;
                cArray[n3 + ++n5] = (char)(0xDC00 | n9);
            }
            ++n6;
            ++n5;
        }
    }

    public int hashCode() {
        long l;
        long l2 = 0L;
        long l3 = this.length() - 1;
        this.prepareNext();
        while ((l = (long)this.nextChar()) != 0L) {
            l2 += l * Ustr.pow(31L, l3);
            --l3;
        }
        return (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
    }

    private static long pow(long l, long l2) {
        long l3 = 1L;
        while (l2-- > 0L) {
            l3 *= l;
        }
        return l3;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        int n3;
        int n4 = 0;
        this.prepareNext();
        while (n2-- > 0) {
            this.nextChar();
            ++n4;
        }
        while ((n3 = this.nextChar()) != 0) {
            if (n3 == n) {
                return n4;
            }
            ++n4;
        }
        if (n == 0) {
            return n4;
        }
        return -1;
    }

    public int indexOf(Ustr ustr) {
        return this.indexOf(ustr, 0);
    }

    public int indexOf(Ustr ustr, int n) {
        int n2 = 0;
        this.prepareNext();
        while (n-- > 0) {
            this.nextChar();
            ++n2;
        }
        do {
            int n3 = 0;
            while (this.s[this.base + this.offset + n3] != 0 && ustr.s[ustr.base + n3] != 0 && this.s[this.base + this.offset + n3] == ustr.s[ustr.base + n3]) {
                ++n3;
            }
            if (ustr.s[this.base + n3] == 0) {
                return n2;
            }
            ++n2;
        } while (this.nextChar() != 0);
        return -1;
    }

    public Ustr intern() {
        Ustr ustr = (Ustr)interns.get(this);
        if (ustr != null) {
            return ustr;
        }
        ustr = new Ustr(this.strlen() + 1);
        ustr.strcpy(this);
        interns.put(ustr, ustr);
        return ustr;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.length());
    }

    public int lastIndexOf(int n, int n2) {
        int n3 = 0;
        this.prepareNext();
        int n4 = -1;
        do {
            if (n != this.nextChar()) continue;
            n4 = n3;
        } while (++n3 <= n2);
        return n4;
    }

    public int lastIndexOf(Ustr ustr) {
        return this.lastIndexOf(ustr, this.length());
    }

    public int lastIndexOf(Ustr ustr, int n) {
        int n2 = 0;
        int n3 = -1;
        this.prepareNext();
        do {
            int n4 = 0;
            while (this.s[this.base + this.offset + n4] != 0 && ustr.s[ustr.base + n4] != 0 && this.s[this.base + this.offset + n4] == ustr.s[ustr.base + n4]) {
                ++n4;
            }
            if (ustr.s[this.base + n4] != 0) continue;
            n3 = n2;
        } while (this.nextChar() != 0 && ++n2 <= n);
        return n3;
    }

    private static int bytesInChar(int n) {
        if (n < 128) {
            return 1;
        }
        if (n < 2048) {
            return 2;
        }
        if (n < 65536) {
            return 3;
        }
        return 4;
    }

    public Ustr replace(int n, int n2) {
        int n3;
        if (n2 < 0) {
            throw new UstrException("Negative replacement character");
        }
        if (n2 > 0x10FFFF) {
            throw new UstrException("Replacement character > 0x10ffff");
        }
        int n4 = this.strlen() + 1;
        int n5 = Ustr.bytesInChar(n2) - Ustr.bytesInChar(n2);
        if (n5 != 0) {
            int n6;
            while ((n6 = this.nextChar()) != 0) {
                if (n6 != n) continue;
                n4 += n5;
            }
        }
        Ustr ustr = new Ustr(n4);
        this.prepareNext();
        ustr.prepareAppend();
        while ((n3 = this.nextChar()) != 0) {
            ustr.appendChar(n3 == n ? n2 : n3);
        }
        return ustr;
    }

    public boolean startsWith(Ustr ustr) {
        return this.startsWith(ustr, 0);
    }

    public boolean startsWith(Ustr ustr, int n) {
        this.prepareNext();
        while (n-- > 0) {
            this.nextChar();
        }
        int n2 = 0;
        while (ustr.s[this.base + n2] != 0) {
            if (this.s[this.base + this.offset + n2] != ustr.s[ustr.base + n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Ustr substring(int n) {
        return this.substring(n, this.length());
    }

    public Ustr substring(int n, int n2) {
        int n3;
        int n4;
        if (n < 0 || n2 < n || n2 > this.length()) {
            throw new IndexOutOfBoundsException("bogus start/end");
        }
        int n5 = n2 - n;
        this.offset = 0;
        while (n-- > 0) {
            n4 = this.s[this.base + this.offset] & 0xFF;
            if (n4 == 0) {
                throw new IndexOutOfBoundsException("substring too long");
            }
            this.offset += encLength[n4];
        }
        n4 = this.offset;
        for (n3 = 0; n3 < n5; ++n3) {
            int n6 = this.s[this.base + this.offset] & 0xFF;
            if (n6 == 0) {
                throw new IndexOutOfBoundsException("substring too long");
            }
            this.offset += encLength[n6];
        }
        n3 = this.offset - n4;
        Ustr ustr = new Ustr(n3 + 1);
        System.arraycopy(this.s, n4, ustr.s, 0, n3);
        ustr.s[n3] = 0;
        return ustr;
    }

    public char[] toCharArray() {
        return this.toString().toCharArray();
    }
}

