/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.util.ByteList;
import org.jvyamlb.Composer;
import org.jvyamlb.ComposerException;
import org.jvyamlb.Parser;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.Resolver;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.events.AliasEvent;
import org.jvyamlb.events.Event;
import org.jvyamlb.events.MappingEndEvent;
import org.jvyamlb.events.MappingStartEvent;
import org.jvyamlb.events.NodeEvent;
import org.jvyamlb.events.ScalarEvent;
import org.jvyamlb.events.SequenceEndEvent;
import org.jvyamlb.events.SequenceStartEvent;
import org.jvyamlb.events.StreamEndEvent;
import org.jvyamlb.events.StreamStartEvent;
import org.jvyamlb.nodes.MappingNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;
import org.jvyamlb.nodes.SequenceNode;

public class ComposerImpl
implements Composer {
    private Parser parser;
    private Resolver resolver;
    private Map anchors;
    private static final boolean[] FALS = new boolean[]{false};
    private static final boolean[] TRU = new boolean[]{true};

    public ComposerImpl(Parser parser, Resolver resolver) {
        this.parser = parser;
        this.resolver = resolver;
        this.anchors = new HashMap();
    }

    public boolean checkNode() {
        return !(this.parser.peekEvent() instanceof StreamEndEvent);
    }

    public Node getNode() {
        return this.checkNode() ? this.composeDocument() : (Node)null;
    }

    public Iterator eachNode() {
        return new NodeIterator();
    }

    public Iterator iterator() {
        return this.eachNode();
    }

    public Node composeDocument() {
        if (this.parser.peekEvent() instanceof StreamStartEvent) {
            this.parser.getEvent();
        }
        this.parser.getEvent();
        Node node = this.composeNode(null, null);
        this.parser.getEvent();
        this.anchors.clear();
        return node;
    }

    public Node composeNode(Node node, Object object) {
        if (this.parser.peekEvent() instanceof AliasEvent) {
            AliasEvent aliasEvent = (AliasEvent)this.parser.getEvent();
            String string = aliasEvent.getAnchor();
            if (!this.anchors.containsKey(string)) {
                throw new ComposerException(null, "found undefined alias " + string, null);
            }
            return (Node)this.anchors.get(string);
        }
        Event event = this.parser.peekEvent();
        String string = null;
        if (event instanceof NodeEvent) {
            string = ((NodeEvent)event).getAnchor();
        }
        this.resolver.descendResolver(node, object);
        Node node2 = null;
        if (event instanceof ScalarEvent) {
            ScalarEvent scalarEvent = (ScalarEvent)this.parser.getEvent();
            String string2 = scalarEvent.getTag();
            if (string2 == null || string2.equals("!")) {
                string2 = this.resolver.resolve(ScalarNode.class, scalarEvent.getValue(), scalarEvent.getImplicit());
            }
            node2 = new ScalarNode(string2, scalarEvent.getValue(), scalarEvent.getStyle());
            if (null != string) {
                this.anchors.put(string, node2);
            }
        } else if (event instanceof SequenceStartEvent) {
            SequenceStartEvent sequenceStartEvent = (SequenceStartEvent)this.parser.getEvent();
            String string3 = sequenceStartEvent.getTag();
            if (string3 == null || string3.equals("!")) {
                string3 = this.resolver.resolve(SequenceNode.class, null, sequenceStartEvent.getImplicit() ? TRU : FALS);
            }
            node2 = new SequenceNode(string3, new ArrayList(), sequenceStartEvent.getFlowStyle());
            if (null != string) {
                this.anchors.put(string, node2);
            }
            int n = 0;
            while (!(this.parser.peekEvent() instanceof SequenceEndEvent)) {
                ((List)node2.getValue()).add(this.composeNode(node2, new Integer(n++)));
            }
            this.parser.getEvent();
        } else if (event instanceof MappingStartEvent) {
            MappingStartEvent mappingStartEvent = (MappingStartEvent)this.parser.getEvent();
            String string4 = mappingStartEvent.getTag();
            if (string4 == null || string4.equals("!")) {
                string4 = this.resolver.resolve(MappingNode.class, null, mappingStartEvent.getImplicit() ? TRU : FALS);
            }
            node2 = new MappingNode(string4, new HashMap(), mappingStartEvent.getFlowStyle());
            if (null != string) {
                this.anchors.put(string, node2);
            }
            while (!(this.parser.peekEvent() instanceof MappingEndEvent)) {
                Event event2 = this.parser.peekEvent();
                Node node3 = this.composeNode(node2, null);
                if (((Map)node2.getValue()).containsKey(node3)) {
                    this.composeNode(node2, node3);
                    continue;
                }
                ((Map)node2.getValue()).put(node3, this.composeNode(node2, node3));
            }
            this.parser.getEvent();
        }
        this.resolver.ascendResolver();
        return node2;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        System.out.println("Reading of file: \"" + string + "\"");
        ByteList byteList = new ByteList(1024);
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[1024];
        int n = 0;
        do {
            n = ((InputStream)fileInputStream).read(byArray);
            byteList.append(byArray, 0, n);
        } while (n >= 1024);
        ((InputStream)fileInputStream).close();
        long l = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            ComposerImpl composerImpl = new ComposerImpl(new ParserImpl(new ScannerImpl(byteList)), new ResolverImpl());
            Iterator iterator = composerImpl.eachNode();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        double d = (double)(l2 - l) / 1000.0;
        System.out.println("Walking through the nodes for the file: " + string + " took " + l3 + "ms, or " + d + " seconds");
    }

    private class NodeIterator
    implements Iterator {
        private NodeIterator() {
        }

        public boolean hasNext() {
            return ComposerImpl.this.checkNode();
        }

        public Object next() {
            return ComposerImpl.this.getNode();
        }

        public void remove() {
        }
    }
}

