/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.util.ByteList;
import org.jvyamlb.Emitter;
import org.jvyamlb.Resolver;
import org.jvyamlb.Serializer;
import org.jvyamlb.SerializerException;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.events.AliasEvent;
import org.jvyamlb.events.DocumentEndEvent;
import org.jvyamlb.events.DocumentStartEvent;
import org.jvyamlb.events.MappingEndEvent;
import org.jvyamlb.events.MappingStartEvent;
import org.jvyamlb.events.ScalarEvent;
import org.jvyamlb.events.SequenceEndEvent;
import org.jvyamlb.events.SequenceStartEvent;
import org.jvyamlb.events.StreamEndEvent;
import org.jvyamlb.events.StreamStartEvent;
import org.jvyamlb.nodes.CollectionNode;
import org.jvyamlb.nodes.LinkNode;
import org.jvyamlb.nodes.MappingNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;
import org.jvyamlb.nodes.SequenceNode;

public class SerializerImpl
implements Serializer {
    private Emitter emitter;
    private Resolver resolver;
    private YAMLConfig options;
    private boolean useExplicitStart;
    private boolean useExplicitEnd;
    private int[] useVersion;
    private boolean useTags;
    private String anchorTemplate;
    private Map serializedNodes;
    private Map anchors;
    private int lastAnchorId;
    private boolean closed;
    private boolean opened;

    public SerializerImpl(Emitter emitter, Resolver resolver, YAMLConfig yAMLConfig) {
        this.emitter = emitter;
        this.resolver = resolver;
        this.options = yAMLConfig;
        this.useExplicitStart = yAMLConfig.explicitStart();
        this.useExplicitEnd = yAMLConfig.explicitEnd();
        int[] nArray = new int[2];
        if (yAMLConfig.useVersion()) {
            String string = yAMLConfig.version();
            int n = string.indexOf(46);
            nArray[0] = Integer.parseInt(string.substring(0, n));
            nArray[1] = Integer.parseInt(string.substring(n + 1));
        } else {
            nArray = null;
        }
        this.useVersion = nArray;
        this.useTags = yAMLConfig.useHeader();
        this.anchorTemplate = yAMLConfig.anchorFormat() == null ? "id{0,number,000}" : yAMLConfig.anchorFormat();
        this.serializedNodes = new IdentityHashMap();
        this.anchors = new IdentityHashMap();
        this.lastAnchorId = 0;
        this.closed = false;
        this.opened = false;
    }

    protected boolean ignoreAnchor(Node node) {
        return false;
    }

    public void open() throws IOException {
        if (this.closed || this.opened) {
            if (this.closed) {
                throw new SerializerException("serializer is closed");
            }
            throw new SerializerException("serializer is already opened");
        }
        this.emitter.emit(new StreamStartEvent());
        this.opened = true;
    }

    public void close() throws IOException {
        if (!this.opened) {
            throw new SerializerException("serializer is not opened");
        }
        if (!this.closed) {
            this.emitter.emit(new StreamEndEvent());
            this.closed = true;
            this.opened = false;
        }
    }

    public void serialize(Node node) throws IOException {
        if (!this.closed && !this.opened) {
            throw new SerializerException("serializer is not opened");
        }
        if (this.closed) {
            throw new SerializerException("serializer is closed");
        }
        this.emitter.emit(new DocumentStartEvent(this.useExplicitStart, this.useVersion, null));
        this.anchorNode(node);
        this.serializeNode(node, null, null);
        this.emitter.emit(new DocumentEndEvent(this.useExplicitEnd));
        this.serializedNodes = new IdentityHashMap();
        this.anchors = new IdentityHashMap();
        this.lastAnchorId = 0;
    }

    private void anchorNode(Node node) {
        block6: {
            block7: {
                while (node instanceof LinkNode) {
                    node = ((LinkNode)node).getAnchor();
                }
                if (this.ignoreAnchor(node)) break block6;
                if (!this.anchors.containsKey(node)) break block7;
                String string = (String)this.anchors.get(node);
                if (null != string) break block6;
                string = this.generateAnchor(node);
                this.anchors.put(node, string);
                break block6;
            }
            this.anchors.put(node, null);
            if (node instanceof SequenceNode) {
                Iterator iterator = ((List)node.getValue()).iterator();
                while (iterator.hasNext()) {
                    this.anchorNode((Node)iterator.next());
                }
            } else if (node instanceof MappingNode) {
                Map map = (Map)node.getValue();
                for (Map.Entry entry : map.entrySet()) {
                    this.anchorNode((Node)entry.getKey());
                    this.anchorNode((Node)entry.getValue());
                }
            }
        }
    }

    private String generateAnchor(Node node) {
        ++this.lastAnchorId;
        return new MessageFormat(this.anchorTemplate).format(new Object[]{new Integer(this.lastAnchorId)});
    }

    private void serializeNode(Node node, Node node2, Object object) throws IOException {
        while (node instanceof LinkNode) {
            node = ((LinkNode)node).getAnchor();
        }
        String string = (String)this.anchors.get(node);
        if (this.serializedNodes.containsKey(node) && string != null) {
            this.emitter.emit(new AliasEvent(string));
        } else {
            this.serializedNodes.put(node, null);
            this.resolver.descendResolver(node2, object);
            if (node instanceof ScalarNode) {
                String string2 = this.resolver.resolve(ScalarNode.class, (ByteList)node.getValue(), new boolean[]{true, false});
                String string3 = this.resolver.resolve(ScalarNode.class, (ByteList)node.getValue(), new boolean[]{false, true});
                boolean[] blArray = new boolean[]{false, false};
                if (!this.options.explicitTypes()) {
                    blArray[0] = node.getTag().equals(string2);
                    blArray[1] = node.getTag().equals(string3);
                }
                this.emitter.emit(new ScalarEvent(string, node.getTag(), blArray, (ByteList)node.getValue(), ((ScalarNode)node).getStyle()));
            } else if (node instanceof SequenceNode) {
                boolean bl = !this.options.explicitTypes() && node.getTag().equals(this.resolver.resolve(SequenceNode.class, null, new boolean[]{true, true}));
                this.emitter.emit(new SequenceStartEvent(string, node.getTag(), bl, ((CollectionNode)node).getFlowStyle()));
                int n = 0;
                Iterator iterator = ((List)node.getValue()).iterator();
                while (iterator.hasNext()) {
                    this.serializeNode((Node)iterator.next(), node, new Integer(n++));
                }
                this.emitter.emit(new SequenceEndEvent());
            } else if (node instanceof MappingNode) {
                boolean bl = !this.options.explicitTypes() && node.getTag().equals(this.resolver.resolve(MappingNode.class, null, new boolean[]{true, true}));
                this.emitter.emit(new MappingStartEvent(string, node.getTag(), bl, ((CollectionNode)node).getFlowStyle()));
                Map map = (Map)node.getValue();
                for (Map.Entry entry : map.entrySet()) {
                    Node node3 = (Node)entry.getKey();
                    Node node4 = (Node)entry.getValue();
                    this.serializeNode(node3, node, null);
                    this.serializeNode(node4, node, node3);
                }
                this.emitter.emit(new MappingEndEvent());
            }
        }
    }
}

