/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.service.layout.constraints;

import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEDockableDialog;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEImage;
import com.tomsawyer.editor.TSELocalization;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.command.TSEIncrementalLayoutCommand;
import com.tomsawyer.editor.command.TSELayoutCommand;
import com.tomsawyer.editor.dialog.TSDialogCallBackListener;
import com.tomsawyer.editor.dialog.TSDialogWithCallBack;
import com.tomsawyer.editor.dialog.TSIntegerField;
import com.tomsawyer.editor.dialog.TSUnsignedIntegerField;
import com.tomsawyer.editor.event.TSEEventManager;
import com.tomsawyer.editor.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.editor.service.layout.constraints.TSECategoryTreeNode;
import com.tomsawyer.editor.service.layout.constraints.TSEConstraintTypeTreeNode;
import com.tomsawyer.editor.service.layout.constraints.TSEEdgeListTreeNode;
import com.tomsawyer.editor.service.layout.constraints.TSEEdgeTreeNode;
import com.tomsawyer.editor.service.layout.constraints.TSELayoutConstraintTreeNode;
import com.tomsawyer.editor.service.layout.constraints.TSEListTreeNode;
import com.tomsawyer.editor.service.layout.constraints.TSENodeListTreeNode;
import com.tomsawyer.editor.service.layout.constraints.TSENodeTreeNode;
import com.tomsawyer.editor.service.layout.constraints.TSEObjectTreeNode;
import com.tomsawyer.editor.service.layout.constraints.TSESecondNodeListTreeNode;
import com.tomsawyer.editor.service.layout.constraints.TSESingleNodeTreeNode;
import com.tomsawyer.editor.service.layout.constraints.TSETreeNode;
import com.tomsawyer.editor.service.layout.constraints.TSEValueTreeNode;
import com.tomsawyer.editor.service.layout.constraints.da;
import com.tomsawyer.editor.service.layout.constraints.hn;
import com.tomsawyer.editor.service.layout.constraints.ho;
import com.tomsawyer.editor.service.layout.constraints.hp;
import com.tomsawyer.editor.service.layout.constraints.hq;
import com.tomsawyer.editor.service.layout.constraints.hr;
import com.tomsawyer.editor.service.layout.constraints.hs;
import com.tomsawyer.editor.service.layout.constraints.ht;
import com.tomsawyer.editor.service.layout.constraints.hu;
import com.tomsawyer.editor.service.layout.constraints.hv;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.service.TSConstraint;
import com.tomsawyer.service.client.TSServiceProxy;
import com.tomsawyer.service.dl;
import com.tomsawyer.service.dp;
import com.tomsawyer.service.layout.TSLayoutConstraint;
import com.tomsawyer.service.layout.TSLayoutConstraintManager;
import com.tomsawyer.util.command.TSCommand;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class TSEBaseLayoutConstraintsDialog
extends TSEDockableDialog
implements ActionListener,
MouseListener,
KeyListener,
TreeSelectionListener,
TreeExpansionListener,
TSDialogWithCallBack {
    TSEGraphWindow graphWindow;
    EventListener eventListener;
    private JToolBar toolBar = null;
    protected JScrollPane scrollPane;
    protected JTree tree = null;
    public static int WIDTH = 350;
    public static int HEIGHT = 450;
    TSDialogCallBackListener callBackListener;
    TSETreeNode selectedNode;
    protected TSUnsignedIntegerField editor;
    protected JComboBox directionEditor;
    protected JComboBox alignmentEditor;
    protected JComponent currentEditor;
    protected hq treeCellRenderer;
    boolean editing = false;
    TSEValueTreeNode nodeEdited;
    TSServiceProxy layoutProxy;
    protected TSEAllOptionsServiceInputData inputData;
    hv listener;
    DragSource dragSource;
    DropTarget dropTarget;
    boolean whileDragging = false;
    boolean showToolTips = true;
    boolean enableDragAndDrop = true;
    boolean markInvalidNodes = true;
    boolean supportUndoRedo = true;
    JButton layoutButton;
    JButton incrementalLayoutButton;
    JToggleButton showAllButton;
    JButton newButton;
    JButton stylesButton;
    JButton discardButton;
    JButton removeButton;
    JButton addSelectedButton;
    JButton assignSelectedButton;
    JButton deleteAllButton;
    JPopupMenu constraintTypeMenu;
    JPopupMenu constraintMenu;
    JPopupMenu listMenu;
    JPopupMenu graphObjectMenu;
    Color textSelectionColor;
    ho stylesDialog;
    protected TSEResourceBundleWrapper labels;
    protected Hashtable table;
    protected Hashtable constraints;
    protected List fulfilledNodes;
    protected boolean preserveDataMode;
    protected boolean blank;
    protected JLabel blankLabel;
    protected List highlightedObjects;
    static final String LAYOUT = "Global Layout";
    static final String INCREMENTAL_LAYOUT = "Incremental Layout";
    static final String SHOW_ALL = "Show_All";
    private static final String DRAG_OPERATION = "Constraints dialog drag operation";
    boolean ignoreMoveGesture = false;
    protected dp layoutHelper = null;
    TSEColor invalidColor = new TSEColor("#2A1FFF");
    static /* synthetic */ Class class$com$tomsawyer$editor$service$layout$constraints$TSELayoutConstraintTreeNode;
    static /* synthetic */ Class class$com$tomsawyer$editor$service$layout$constraints$TSENodeTreeNode;
    static /* synthetic */ Class class$com$tomsawyer$editor$service$layout$constraints$TSEEdgeTreeNode;

    public TSEBaseLayoutConstraintsDialog(Frame frame, String string, TSEGraphWindow tSEGraphWindow, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData) {
        super(frame, string);
        this.graphWindow = tSEGraphWindow;
        this.layoutProxy = tSServiceProxy;
        this.inputData = tSEAllOptionsServiceInputData;
        this.setDefaults();
    }

    public TSEBaseLayoutConstraintsDialog(Dialog dialog, String string, TSEGraphWindow tSEGraphWindow, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData) {
        super(dialog, string);
        this.graphWindow = tSEGraphWindow;
        this.layoutProxy = tSServiceProxy;
        this.inputData = tSEAllOptionsServiceInputData;
        this.setDefaults();
    }

    public void setDefaults() {
        this.eventListener = this.newListener();
        this.labels = TSEResourceBundleWrapper.getSystemLabelBundle();
        this.fulfilledNodes = new Vector();
        this.adjustSize();
        this.blankLabel = this.createBlankLabel();
        ((Component)((Object)this)).setBounds(0, 0, this.getDefaultWidth(), this.getDefaultHeight());
        ((JDialog)((Object)this)).setDefaultCloseOperation(1);
        this.editor = new TSIntegerField(6, 0, Integer.MAX_VALUE);
        this.editor.addActionListener(this);
        this.editor.addKeyListener(this);
        Color color = new JTree().getBackground();
        String[] stringArray = new String[]{this.getDirectionString(0), this.getDirectionString(1), this.getDirectionString(2), this.getDirectionString(3)};
        this.directionEditor = new JComboBox<String>(stringArray);
        this.directionEditor.setBackground(color);
        this.directionEditor.addActionListener(this);
        this.directionEditor.addKeyListener(this);
        String[] stringArray2 = new String[]{this.getAlignmentString(1), this.getAlignmentString(0), this.getAlignmentString(2)};
        this.alignmentEditor = new JComboBox<String>(stringArray2);
        this.alignmentEditor.setBackground(color);
        this.alignmentEditor.addActionListener(this);
        this.alignmentEditor.addKeyListener(this);
        this.highlightedObjects = new Vector();
        this.showToolTips = true;
        this.constraints = new Hashtable();
        if (this.supportMultipleStyles()) {
            this.stylesDialog = new ho(this, (Dialog)((Object)this), this.translateText("Styles"), this.getLayoutStyles());
            this.stylesDialog.setBackground(color);
            ((Component)this.stylesDialog).setVisible(false);
        }
        this.initButtons();
        this.initPopups();
        this.init();
    }

    protected void init() {
        if (this.graphWindow == null) {
            this.setBlank(true);
            this.layoutButton.setEnabled(false);
            this.incrementalLayoutButton.setEnabled(false);
            this.showAllButton.setEnabled(false);
        } else {
            this.setBlank(false);
            this.registerListeners();
            this.table = new Hashtable(Math.max(50, this.graphWindow.getGraphManager().numberOfNodes()));
            this.fulfilledNodes = new Vector();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.createRoot();
            if (this.getTree() != null) {
                ToolTipManager.sharedInstance().unregisterComponent(this.getTree());
                this.tree = null;
            }
            this.tree = this.newTree(this.newTreeModel(defaultMutableTreeNode));
            this.treeCellRenderer = new hq(this);
            this.getTree().setCellRenderer(this.treeCellRenderer);
            this.textSelectionColor = this.treeCellRenderer.getTextSelectionColor();
            this.getTree().setCellEditor(new hr(this, this.getTree(), this.treeCellRenderer));
            this.getTree().putClientProperty("JTree.lineStyle", "Angled");
            this.getTree().setSelectionModel(new hs(this));
            this.getTree().getSelectionModel().setSelectionMode(4);
            this.getTree().setRootVisible(false);
            this.getTree().setEditable(true);
            this.getTree().addMouseListener(this);
            this.getTree().addKeyListener(this);
            this.getTree().addTreeSelectionListener(this);
            this.getTree().addTreeExpansionListener(this);
            this.getTree().setInvokesStopCellEditing(true);
            this.getTree().setToggleClickCount(0);
            BasicTreeUI basicTreeUI = (BasicTreeUI)this.getTree().getUI();
            basicTreeUI.setExpandedIcon(new ht(null));
            basicTreeUI.setCollapsedIcon(new hu(null));
            if (this.isShowingToolTips()) {
                ToolTipManager.sharedInstance().registerComponent(this.getTree());
            }
            if (this.isDragAndDropEnabled()) {
                this.listener = new hv(this);
                this.dragSource = new DragSource();
                this.dragSource.createDefaultDragGestureRecognizer(this.getTree(), 3, this.listener);
                this.dropTarget = new DropTarget(this.getTree(), 3, this.listener);
            }
            ((JDialog)((Object)this)).getContentPane().setBackground(this.getTree().getBackground());
            ((JDialog)((Object)this)).getContentPane().removeAll();
            this.scrollPane = new JScrollPane(this.getTree());
            ((JDialog)((Object)this)).getContentPane().add((Component)this.scrollPane, "Center");
            this.expandNode(defaultMutableTreeNode, new TreePath(defaultMutableTreeNode.getPath()));
            this.initToolBar();
            this.toggleButtons();
            ((JDialog)((Object)this)).getContentPane().repaint();
            TSELocalization.setComponentOrientation((Component)((Object)this));
            this.selectedNode = null;
        }
    }

    protected abstract MutableTreeNode createRoot();

    public void initToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setVisible(true);
        this.toolBar.setBackground(this.getTree().getBackground());
        this.resetToolBar();
        ((JDialog)((Object)this)).getContentPane().add((Component)this.toolBar, "North");
    }

    public void resetToolBar() {
        if (this.toolBar.getComponentCount() > 0) {
            this.toolBar.removeAll();
        }
        this.toolBar.add(this.getLayoutButton());
        this.toolBar.add(Box.createRigidArea(new Dimension(5, 5)));
        this.toolBar.add(this.getIncrementalLayoutButton());
        this.toolBar.add(Box.createRigidArea(new Dimension(5, 5)));
        if (this.supportMultipleStyles()) {
            this.toolBar.add(this.getShowAllButton());
            this.toolBar.add(Box.createRigidArea(new Dimension(5, 5)));
        }
    }

    public void addToToolbar(Component component) {
        this.toolBar.add(component);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.treeCellRenderer != null && !((Component)((Object)this)).getFont().equals(((Component)this.treeCellRenderer).getFont())) {
            this.treeCellRenderer.setFont(((Component)((Object)this)).getFont());
        }
        this.init();
    }

    public TSECategoryTreeNode newCategoryTreeNode(String string) {
        return new TSECategoryTreeNode(string, this);
    }

    public TSEConstraintTypeTreeNode newConstraintTypeTreeNode(String string) {
        return new TSEConstraintTypeTreeNode(string, this);
    }

    public TSELayoutConstraintTreeNode newLayoutConstraintTreeNode(TSLayoutConstraint tSLayoutConstraint) {
        return new TSELayoutConstraintTreeNode(tSLayoutConstraint, this);
    }

    public TSEValueTreeNode newValueTreeNode(TSLayoutConstraint tSLayoutConstraint, String string, String string2, String string3) {
        return new TSEValueTreeNode(tSLayoutConstraint, string, string2, string3, this);
    }

    public TSESingleNodeTreeNode newSingleNodeTreeNode(TSLayoutConstraint tSLayoutConstraint) {
        return new TSESingleNodeTreeNode(tSLayoutConstraint, this);
    }

    public TSENodeListTreeNode newNodeListTreeNode(TSLayoutConstraint tSLayoutConstraint) {
        return new TSENodeListTreeNode(tSLayoutConstraint, this);
    }

    public da newFirstNodeListTreeNode(TSLayoutConstraint tSLayoutConstraint) {
        return new da(tSLayoutConstraint, this);
    }

    public TSESecondNodeListTreeNode newSecondNodeListTreeNode(TSLayoutConstraint tSLayoutConstraint) {
        return new TSESecondNodeListTreeNode(tSLayoutConstraint, this);
    }

    public TSENodeTreeNode newNodeTreeNode(TSLayoutConstraint tSLayoutConstraint, TSENode tSENode) {
        return new TSENodeTreeNode(tSLayoutConstraint, tSENode, this);
    }

    public abstract TSEEdgeListTreeNode newEdgeListTreeNode(TSLayoutConstraint var1);

    public TSEEdgeTreeNode newEdgeTreeNode(TSLayoutConstraint tSLayoutConstraint, TSEEdge tSEEdge) {
        return new TSEEdgeTreeNode(tSLayoutConstraint, tSEEdge, this);
    }

    protected hn newListener() {
        return new hn(this);
    }

    public void dispose() {
        this.unregisterListeners();
        this.unhighlightObjects();
        ToolTipManager.sharedInstance().unregisterComponent(this.getTree());
        super.dispose();
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.unhighlightObjects();
        }
        super.setVisible(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        TSETreeNode tSETreeNode = this.getSelectedTreeNode();
        if (string.equals("New")) {
            TSLayoutConstraint tSLayoutConstraint = this.newConstraint(tSETreeNode);
            this.onNewConstraint(tSETreeNode, tSLayoutConstraint);
        } else if (string.equals(LAYOUT)) {
            this.onLayout(false);
        } else if (string.equals(INCREMENTAL_LAYOUT)) {
            this.onLayout(true);
        } else if (string.equals(SHOW_ALL)) {
            this.onShowAll();
        } else if (string.equals("Remove")) {
            this.deleteSelected();
            this.unhighlightObjects();
        } else if (string.equals("Styles") && this.supportMultipleStyles()) {
            if (!this.stylesDialog.isVisible()) {
                ((Component)this.stylesDialog).setVisible(true);
                ((Component)this.stylesDialog).setLocation(new Point((int)this.scrollPane.getLocationOnScreen().getX() + this.scrollPane.getWidth() - this.stylesDialog.getWidth(), (int)this.scrollPane.getLocationOnScreen().getY()));
            } else {
                ((Component)this.stylesDialog).setVisible(false);
            }
        } else if (string.equals("Discard")) {
            this.discardConstraints();
        } else if (string.equals("Add Selected")) {
            boolean bl = this.getGraph().isCoalesce();
            this.getGraph().setCoalesce(true);
            this.addSelected((TSEListTreeNode)tSETreeNode);
            this.highlightObjects((TSEListTreeNode)tSETreeNode);
            this.getGraph().setCoalesce(bl);
        } else if (string.equals("Assign Selected")) {
            boolean bl = this.getGraph().isCoalesce();
            this.getGraph().setCoalesce(true);
            this.deleteAll((TSEListTreeNode)tSETreeNode);
            this.addSelected((TSEListTreeNode)tSETreeNode);
            this.getGraph().setCoalesce(bl);
            this.highlightObjects((TSEListTreeNode)tSETreeNode);
        } else if (string.equals("Delete All")) {
            boolean bl = this.getGraph().isCoalesce();
            this.getGraph().setCoalesce(true);
            this.deleteAll((TSEListTreeNode)tSETreeNode);
            this.highlightObjects((TSEListTreeNode)tSETreeNode);
            this.getGraph().setCoalesce(bl);
        } else if (string.startsWith("Edit")) {
            String string2 = "";
            if (this.currentEditor instanceof JTextField) {
                string2 = ((JTextField)this.currentEditor).getText();
            } else if (this.currentEditor instanceof JComboBox) {
                string2 = ((JComboBox)this.currentEditor).getSelectedItem().toString();
            }
            this.setProperty((TSEValueTreeNode)tSETreeNode, string2);
        }
        this.cancelEditing();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        TreePath treePath = this.getTree().getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (mouseEvent.isPopupTrigger()) {
            this.doneEditing();
            this.setSelectedTreeNode((TSETreeNode)treeNode);
            this.getTree().setSelectionPath(treePath);
            this.showPopup(this.getSelectedTreeNode(), mouseEvent.getPoint());
        } else if ((mouseEvent.getModifiers() & 0x10) != 0) {
            if (treeNode instanceof TSEValueTreeNode) {
                if (!((TSEValueTreeNode)treeNode).getAction().equals("Fulfilled")) {
                    this.doneEditing();
                    this.setSelectedTreeNode((TSETreeNode)treeNode);
                    this.startEditing(treePath);
                }
            } else if (treeNode == this.getSelectedTreeNode() && (treeNode instanceof TSEObjectTreeNode || treeNode instanceof TSEListTreeNode)) {
                ((TSETreeNode)treeNode).onSelect();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            TreePath treePath = this.getTree().getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            this.getTree().setSelectionPath(treePath);
            this.doneEditing();
            this.setSelectedTreeNode((TSETreeNode)treeNode);
            this.showPopup(this.getSelectedTreeNode(), mouseEvent.getPoint());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.getTree() && mouseEvent.getClickCount() > 1) {
            TSETreeNode tSETreeNode = this.getSelectedTreeNode();
            if (tSETreeNode instanceof TSEConstraintTypeTreeNode) {
                TSLayoutConstraint tSLayoutConstraint = this.newConstraint(tSETreeNode);
                this.onNewConstraint(tSETreeNode, tSLayoutConstraint);
            } else if (tSETreeNode instanceof TSEListTreeNode) {
                this.addSelected((TSEListTreeNode)tSETreeNode);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127 && this.getTree().hasFocus()) {
            TSETreeNode tSETreeNode = this.getSelectedTreeNode();
            if (tSETreeNode instanceof TSEObjectTreeNode) {
                this.deleteSelected();
            } else if (tSETreeNode instanceof TSEListTreeNode) {
                this.deleteAll((TSEListTreeNode)tSETreeNode);
            } else if (tSETreeNode instanceof TSELayoutConstraintTreeNode) {
                this.discardConstraints();
            }
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 27) {
            this.cancelEditing();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.getTree().getLastSelectedPathComponent() instanceof TSETreeNode) {
            TSETreeNode tSETreeNode = (TSETreeNode)this.getTree().getLastSelectedPathComponent();
            if (tSETreeNode != null && !this.whileDragging) {
                Object object;
                TSETreeNode tSETreeNode2 = this.getSelectedTreeNode();
                if (tSETreeNode2 != null && (object = tSETreeNode2.getPopupMenu()) != null) {
                    ((JPopupMenu)object).setVisible(false);
                }
                this.setSelectedTreeNode(tSETreeNode);
                this.unhighlightObjects();
                if (this.editing) {
                    object = "";
                    if (this.currentEditor instanceof JTextField) {
                        object = ((JTextField)this.currentEditor).getText();
                    } else if (this.currentEditor instanceof JComboBox) {
                        object = ((JComboBox)this.currentEditor).getSelectedItem().toString();
                    }
                    this.setProperty((TSEValueTreeNode)tSETreeNode2, (String)object);
                }
                tSETreeNode.onSelect();
                if (this.supportMultipleStyles()) {
                    if (tSETreeNode instanceof TSELayoutConstraintTreeNode) {
                        this.stylesDialog.a(((TSELayoutConstraintTreeNode)tSETreeNode).getConstraint());
                    } else {
                        ((Component)this.stylesDialog).setVisible(false);
                    }
                }
                this.toggleButtons();
            }
        } else {
            this.unhighlightObjects();
            this.resetToolBar();
            this.toolBar.repaint();
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.doneEditing();
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.doneEditing();
    }

    protected void afterLayout() {
        if (this.fulfilledNodes.size() > 0) {
            Iterator iterator = this.fulfilledNodes.iterator();
            while (iterator.hasNext()) {
                TSEValueTreeNode tSEValueTreeNode = (TSEValueTreeNode)iterator.next();
                TSLayoutConstraint tSLayoutConstraint = tSEValueTreeNode.getConstraint();
                String string = tSEValueTreeNode.getValue();
                String string2 = tSLayoutConstraint.isFulfilled() ? this.translateText("Yes") : this.translateText("No");
                if (string2.equals(string)) continue;
                tSEValueTreeNode.setValue(string2);
                this.getTree().getModel().valueForPathChanged(new TreePath(tSEValueTreeNode), tSEValueTreeNode.getUserObject());
            }
        }
    }

    protected void onObjectRenamed(TSEObject tSEObject, Object object) {
        if (tSEObject != null) {
            Integer n = new Integer(tSEObject.hashCode());
            List list = (List)this.table.get(n);
            Vector vector = new Vector();
            if (list != null) {
                vector.addAll(list);
            }
            if (!vector.isEmpty()) {
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    TSEObjectTreeNode tSEObjectTreeNode = (TSEObjectTreeNode)iterator.next();
                    if (object == null || object.equals("")) {
                        object = tSEObjectTreeNode.getDefaultName();
                    }
                    this.getTree().getModel().valueForPathChanged(new TreePath(tSEObjectTreeNode), object);
                }
            }
        }
    }

    public void startEditing(TSEValueTreeNode tSEValueTreeNode) {
        this.currentEditor = this.editor;
        this.editor.setText(String.valueOf(tSEValueTreeNode.getValue()));
        this.editor.setActionCommand(tSEValueTreeNode.getAction());
    }

    public void startEditing(TreePath treePath) {
        if (treePath.getLastPathComponent() instanceof TSEValueTreeNode) {
            TSEValueTreeNode tSEValueTreeNode = (TSEValueTreeNode)treePath.getLastPathComponent();
            this.startEditing(tSEValueTreeNode);
            this.editing = true;
            this.nodeEdited = tSEValueTreeNode;
            this.getTree().getModel().valueForPathChanged(new TreePath(tSEValueTreeNode), tSEValueTreeNode.getLabel() + ":");
            Rectangle rectangle = this.getTree().getUI().getPathBounds(this.getTree(), treePath);
            Dimension dimension = this.currentEditor.getPreferredSize();
            if (dimension.height != rectangle.height) {
                dimension.height = rectangle.height;
            }
            this.currentEditor.setMaximumSize(this.currentEditor.getPreferredSize());
            this.getTree().add(this.currentEditor);
            this.currentEditor.setBounds(rectangle.x + rectangle.width, rectangle.y, dimension.width, dimension.height + 1);
            this.currentEditor.validate();
            this.currentEditor.requestFocus();
            Rectangle rectangle2 = this.getTree().getVisibleRect();
            this.getTree().paintImmediately(rectangle.x, rectangle.y, rectangle2.width + rectangle2.x - rectangle.x + rectangle.width, dimension.height);
        }
    }

    public void stopEditing() {
        if (this.editing) {
            this.editing = false;
            this.getTree().requestFocus();
            this.getTree().remove(this.currentEditor);
            this.getTree().repaint();
            this.nodeEdited = null;
        }
        this.getTree().getCellEditor().stopCellEditing();
    }

    protected void doneEditing() {
        String string = "";
        if (this.currentEditor instanceof JTextField) {
            string = ((JTextField)this.currentEditor).getText();
        } else if (this.currentEditor instanceof JComboBox) {
            string = ((JComboBox)this.currentEditor).getSelectedItem().toString();
        }
        if (this.getSelectedTreeNode() instanceof TSEValueTreeNode && this.editing) {
            this.setProperty((TSEValueTreeNode)this.getSelectedTreeNode(), string);
        }
        this.stopEditing();
    }

    public void cancelEditing() {
        if (this.editing) {
            if (this.nodeEdited != null) {
                this.nodeEdited.reset();
                this.getTree().getModel().valueForPathChanged(new TreePath(this.nodeEdited), this.nodeEdited.getUserObject());
            }
            this.stopEditing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onLayout(boolean bl) {
        try {
            block5: {
                try {
                    if (this.layoutProxy == null || this.graphWindow == null) break block5;
                    ((JDialog)((Object)this)).getContentPane().setCursor(Cursor.getPredefinedCursor(3));
                    this.getGraphWindow().setUserActionEnabled(false);
                    if (!bl) {
                        this.graphWindow.transmit((TSCommand)new TSELayoutCommand(this.graphWindow, this.layoutProxy, this.inputData));
                        break block5;
                    }
                    this.graphWindow.transmit((TSCommand)new TSEIncrementalLayoutCommand(this.graphWindow, this.layoutProxy, this.inputData));
                }
                catch (Exception exception) {
                    this.callBack(exception);
                    Object var4_3 = null;
                    ((JDialog)((Object)this)).getContentPane().setCursor(Cursor.getPredefinedCursor(0));
                    this.getGraphWindow().setUserActionEnabled(true);
                    return;
                }
            }
            Object var4_2 = null;
            ((JDialog)((Object)this)).getContentPane().setCursor(Cursor.getPredefinedCursor(0));
            this.getGraphWindow().setUserActionEnabled(true);
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((JDialog)((Object)this)).getContentPane().setCursor(Cursor.getPredefinedCursor(0));
            this.getGraphWindow().setUserActionEnabled(true);
            throw throwable;
        }
    }

    void onShowAll() {
        this.init();
        ((JPanel)((JDialog)((Object)this)).getContentPane()).revalidate();
    }

    public void addSelected(TSEListTreeNode tSEListTreeNode) {
        Vector vector = new Vector();
        TSEGraphManager tSEGraphManager = this.getGraphWindow().getGraphManager();
        vector.addAll(tSEGraphManager.selectedNodes());
        vector.addAll(tSEGraphManager.selectedEdges(false));
        this.addObjects(tSEListTreeNode, vector, tSEListTreeNode.getChildCount());
        this.toggleButtons();
    }

    public List addObjects(TSEListTreeNode tSEListTreeNode, List list) {
        return this.addObjects(tSEListTreeNode, list, 0, true);
    }

    public List addObjects(TSEListTreeNode tSEListTreeNode, List list, int n) {
        return this.addObjects(tSEListTreeNode, list, n, false);
    }

    List addObjects(TSEListTreeNode tSEListTreeNode, List list, int n, boolean bl) {
        TSLayoutConstraint tSLayoutConstraint = tSEListTreeNode.getConstraint();
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        int n2 = this.getGraphWindow().getGraphManager().getEventManager().getContext();
        this.getGraphWindow().getGraphManager().getEventManager().setContext(18);
        if (!list.isEmpty()) {
            int n3 = n;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                TSEObject tSEObject = (TSEObject)iterator.next();
                if (!tSEListTreeNode.canAdd(tSEObject) && !bl || tSEObject == null || tSEObject.getOwner() != this.getGraph()) continue;
                List list2 = tSEListTreeNode.getList();
                if (!bl && list2.contains(tSEObject)) continue;
                if (!bl) {
                    tSEListTreeNode.add(n3, tSEObject);
                }
                defaultMutableTreeNode = tSEObject instanceof TSENode ? this.newNodeTreeNode(tSLayoutConstraint, (TSENode)tSEObject) : this.newEdgeTreeNode(tSLayoutConstraint, (TSEEdge)tSEObject);
                vector.add(defaultMutableTreeNode);
                if (!bl) {
                    ((DefaultTreeModel)this.getTree().getModel()).insertNodeInto(defaultMutableTreeNode, tSEListTreeNode, n3);
                } else {
                    tSEListTreeNode.add(defaultMutableTreeNode);
                }
                ((TSEObjectTreeNode)defaultMutableTreeNode).setParentNode(tSEListTreeNode);
                Integer n4 = new Integer(tSEObject.hashCode());
                LinkedList<DefaultMutableTreeNode> linkedList = (LinkedList<DefaultMutableTreeNode>)this.table.get(n4);
                if (linkedList == null) {
                    linkedList = new LinkedList<DefaultMutableTreeNode>();
                    linkedList.add(defaultMutableTreeNode);
                    this.table.put(n4, linkedList);
                } else {
                    linkedList.add(defaultMutableTreeNode);
                }
                ++n3;
            }
            if (defaultMutableTreeNode != null && !bl) {
                this.getTree().scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
            }
        }
        this.getGraphWindow().getGraphManager().getEventManager().setContext(n2);
        return vector;
    }

    public void deleteSelected() {
        Vector<TreeNode> vector = new Vector<TreeNode>();
        for (int i = 0; i < this.getTree().getSelectionPaths().length; ++i) {
            TreeNode treeNode = (TreeNode)this.getTree().getSelectionPaths()[i].getLastPathComponent();
            if (!(treeNode instanceof TSEObjectTreeNode)) continue;
            vector.add(treeNode);
        }
        this.deleteObjects(vector);
        this.setSelectedTreeNode(null);
        this.resetToolBar();
        this.toolBar.repaint();
    }

    public void deleteAll(TSEListTreeNode tSEListTreeNode) {
        this.deleteObjects(tSEListTreeNode.getChildren());
        this.toggleButtons();
    }

    public void deleteObjects(List list) {
        this.deleteObjects(list, true);
    }

    void deleteObjects(List list, boolean bl) {
        if (list != null) {
            int n = this.getGraphWindow().getGraphManager().getEventManager().getContext();
            this.getGraphWindow().getGraphManager().getEventManager().setContext(18);
            LinkedList linkedList = new LinkedList();
            linkedList.addAll(list);
            Iterator iterator = linkedList.iterator();
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getTree().getModel();
            while (iterator.hasNext()) {
                TSEObjectTreeNode tSEObjectTreeNode = (TSEObjectTreeNode)iterator.next();
                TSEObject tSEObject = tSEObjectTreeNode.getObject();
                TSEListTreeNode tSEListTreeNode = (TSEListTreeNode)tSEObjectTreeNode.getParent();
                if (tSEObject == null) continue;
                if (bl) {
                    this.updateHashtableOnRemove(tSEObject, tSEObjectTreeNode);
                    if (!this.preserveDataMode) {
                        tSEListTreeNode.remove(tSEObject);
                    }
                }
                if (tSEObjectTreeNode.getParent() == null) continue;
                defaultTreeModel.removeNodeFromParent(tSEObjectTreeNode);
            }
            this.getGraphWindow().getGraphManager().getEventManager().setContext(n);
        }
    }

    private void updateHashtableOnRemove(TSEObject tSEObject, TSETreeNode tSETreeNode) {
        Integer n = new Integer(tSEObject.hashCode());
        List list = (List)this.table.get(n);
        if (list != null) {
            if (tSETreeNode != null) {
                list.remove(tSETreeNode);
            }
            if (list.isEmpty()) {
                this.table.remove(n);
            }
        }
    }

    public int parsePropertyValue(TSEValueTreeNode tSEValueTreeNode, String string) {
        return Integer.parseInt(string);
    }

    public void setProperty(TSEValueTreeNode tSEValueTreeNode, String string) {
        int n = 0;
        if (this.currentEditor instanceof JTextField) {
            if (string.startsWith("0") && string.length() > 1) {
                string = string.substring(1);
            }
        }
        try {
            n = this.parsePropertyValue(tSEValueTreeNode, string);
        }
        catch (Exception exception) {
            n = 0;
            string = String.valueOf(n);
        }
        tSEValueTreeNode.setValue(string);
        this.stopEditing();
        this.getTree().getModel().valueForPathChanged(new TreePath(tSEValueTreeNode), tSEValueTreeNode.getUserObject());
        this.setProperty(tSEValueTreeNode, n);
    }

    public void setProperty(TSEValueTreeNode tSEValueTreeNode, int n) {
        TSLayoutConstraint tSLayoutConstraint = tSEValueTreeNode.getConstraint();
        int n2 = this.getGraphWindow().getGraphManager().getEventManager().getContext();
        this.getGraphWindow().getGraphManager().getEventManager().setContext(18);
        if (tSEValueTreeNode.getAction().equals("Edit Priority")) {
            tSLayoutConstraint.setPriority(n);
        }
        this.getGraphWindow().getGraphManager().getEventManager().setContext(n2);
    }

    public void onNewConstraint(MutableTreeNode mutableTreeNode, TSLayoutConstraint tSLayoutConstraint) {
        this.onNewConstraint(mutableTreeNode, tSLayoutConstraint, mutableTreeNode.getChildCount());
    }

    public void onNewConstraint(MutableTreeNode mutableTreeNode, TSLayoutConstraint tSLayoutConstraint, int n) {
        if (!this.preserveDataMode) {
            this.getOrAddConstraintManager().a(tSLayoutConstraint);
        }
        TSELayoutConstraintTreeNode tSELayoutConstraintTreeNode = this.newLayoutConstraintTreeNode(tSLayoutConstraint);
        this.initializeConstraintTreeNode(tSELayoutConstraintTreeNode);
        ((DefaultTreeModel)this.getTree().getModel()).insertNodeInto(tSELayoutConstraintTreeNode, mutableTreeNode, n);
        this.expandNode(tSELayoutConstraintTreeNode, new TreePath(tSELayoutConstraintTreeNode.getPath()));
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)tSELayoutConstraintTreeNode.getLastChild();
        this.getTree().setSelectionPath(new TreePath(tSELayoutConstraintTreeNode.getFirstListTreeNode().getPath()));
        this.tree.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
        this.getConstraints().put(tSLayoutConstraint, tSELayoutConstraintTreeNode);
    }

    public abstract void initializeConstraintTreeNode(TSELayoutConstraintTreeNode var1);

    public void expandNode(TreeNode treeNode, TreePath treePath) {
        this.tree.expandPath(treePath);
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            this.expandNode(treeNode2, treePath.pathByAddingChild(treeNode2));
        }
    }

    public void discardConstraints() {
        TreeNode treeNode;
        Vector<TreeNode> vector = new Vector<TreeNode>();
        for (int i = 0; i < this.getTree().getSelectionPaths().length; ++i) {
            treeNode = (TreeNode)this.getTree().getSelectionPaths()[i].getLastPathComponent();
            if (!(treeNode instanceof TSELayoutConstraintTreeNode)) continue;
            vector.add(treeNode);
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            treeNode = (TSELayoutConstraintTreeNode)iterator.next();
            this.removeConstraint((TSELayoutConstraintTreeNode)treeNode);
        }
        this.setSelectedTreeNode(null);
        this.resetToolBar();
        this.toolBar.repaint();
    }

    public void removeConstraint(TSELayoutConstraintTreeNode tSELayoutConstraintTreeNode) {
        TSLayoutConstraint tSLayoutConstraint = tSELayoutConstraintTreeNode.getConstraint();
        this.deleteAllGraphObjectsInConstraint(tSELayoutConstraintTreeNode);
        ((DefaultTreeModel)this.getTree().getModel()).removeNodeFromParent(tSELayoutConstraintTreeNode);
        if (!this.preserveDataMode) {
            this.getConstraintManager().b(tSLayoutConstraint);
        }
        this.getConstraints().remove(tSLayoutConstraint);
        this.fulfilledNodes.remove(tSELayoutConstraintTreeNode.getFulfilledTreeNode());
    }

    public void deleteAllGraphObjectsInConstraint(TSELayoutConstraintTreeNode tSELayoutConstraintTreeNode) {
        TSEListTreeNode tSEListTreeNode = tSELayoutConstraintTreeNode.getFirstListTreeNode();
        TSEListTreeNode tSEListTreeNode2 = tSELayoutConstraintTreeNode.getSecondListTreeNode();
        if (tSEListTreeNode != null) {
            this.deleteAll(tSEListTreeNode);
        }
        if (tSEListTreeNode2 != null) {
            this.deleteAll(tSEListTreeNode2);
        }
    }

    public void highlightSelectedObjects() {
        Vector<TreeNode> vector = new Vector<TreeNode>();
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                TreeNode treeNode = (TreeNode)treePathArray[i].getLastPathComponent();
                if (!(treeNode instanceof TSEObjectTreeNode)) continue;
                vector.add(treeNode);
            }
            this.highlightObjects(vector);
        }
    }

    public void unhighlightObjects() {
        this.unhighlightObjects(true);
    }

    void unhighlightObjects(boolean bl) {
        if (this.highlightedObjects.isEmpty()) {
            return;
        }
        Iterator iterator = this.highlightedObjects.iterator();
        while (iterator.hasNext()) {
            TSEObject tSEObject = (TSEObject)iterator.next();
            if (tSEObject instanceof TSENode) {
                ((TSENode)tSEObject).setHighlighted(false);
                continue;
            }
            if (!(tSEObject instanceof TSEEdge)) continue;
            ((TSEEdge)tSEObject).setHighlighted(false);
        }
        this.highlightedObjects.clear();
        if (bl && this.graphWindow != null) {
            this.graphWindow.drawGraph();
            this.graphWindow.fastRepaint();
        }
    }

    public void highlightObjects(TSEListTreeNode tSEListTreeNode) {
        this.highlightObjects(tSEListTreeNode.getChildren());
    }

    public void highlightObjects(List list) {
        if (((Component)((Object)this)).isVisible() || this.isDocked()) {
            boolean bl = !this.highlightedObjects.isEmpty() || list != null && !list.isEmpty();
            TSEGraphWindow tSEGraphWindow = this.getGraphWindow();
            this.unhighlightObjects(false);
            boolean bl2 = false;
            if (list != null && !list.isEmpty()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    TSENode tSENode;
                    TSEObjectTreeNode tSEObjectTreeNode = (TSEObjectTreeNode)iterator.next();
                    TSEObject tSEObject = tSEObjectTreeNode.getObject();
                    TSEListTreeNode tSEListTreeNode = tSEObjectTreeNode.getParentNode();
                    bl2 = this.orderMattersInConstraint(tSEListTreeNode.getConstraint());
                    if (tSEObject instanceof TSENode) {
                        tSENode = (TSENode)tSEObject;
                        TSENodeUI tSENodeUI = tSENode.getNodeUI();
                        tSENode.setHighlighted(true);
                        if (bl2) {
                            tSENodeUI.setConstraintBadge(tSEListTreeNode.getList().indexOf(tSEObject) + 1);
                        } else {
                            tSENodeUI.setConstraintBadge(0);
                        }
                        this.highlightedObjects.add(tSENode);
                        continue;
                    }
                    if (!(tSEObject instanceof TSEEdge)) continue;
                    tSENode = (TSEEdge)tSEObject;
                    tSENode.setHighlighted(true);
                    this.highlightedObjects.add(tSENode);
                }
            }
            if (bl) {
                tSEGraphWindow.drawGraph();
                tSEGraphWindow.fastRepaint();
            }
        }
    }

    public abstract boolean supportMultipleStyles();

    public abstract List getLayoutStyles();

    public abstract int getStyleFlag(int var1);

    public abstract boolean isSupported(TSConstraint var1, int var2);

    public abstract boolean isSupported(Class var1, int var2);

    public abstract boolean checkValidity(TSELayoutConstraintTreeNode var1);

    public int getCurrentLayoutStyle() {
        return this.layoutHelper.c(this.inputData, this.getGraph(), "layout:all:graph:layoutStyle");
    }

    public int getCurrentLayoutStyleFlag() {
        return this.getStyleFlag(this.getCurrentLayoutStyle());
    }

    String getStyleName(int n) {
        String string = null;
        if (n == 4) {
            string = this.translateText("Circular");
        } else if (n == 1) {
            string = this.translateText("Hierarchical");
        } else if (n == 2) {
            string = this.translateText("Orthogonal");
        } else if (n == 3) {
            string = this.translateText("Symmetric");
        } else if (n == 5) {
            string = this.translateText("Tree");
        } else if (n == 6) {
            string = this.translateText("Grid");
        }
        return string;
    }

    protected abstract TSLayoutConstraint newConstraint(MutableTreeNode var1);

    protected abstract boolean orderMattersInConstraint(TSConstraint var1);

    protected JTree newTree(TreeModel treeModel) {
        return new hp(this, treeModel);
    }

    protected DefaultTreeModel newTreeModel(TreeNode treeNode) {
        return new DefaultTreeModel(treeNode);
    }

    public void initButtons() {
        this.layoutButton = new JButton();
        this.configureButton(this.layoutButton, LAYOUT, "images/globalLayout.gif");
        this.incrementalLayoutButton = new JButton();
        this.configureButton(this.incrementalLayoutButton, INCREMENTAL_LAYOUT, "images/incrementalLayout.gif");
        this.showAllButton = new JToggleButton();
        this.configureButton(this.showAllButton, SHOW_ALL, "images/allConstraints.gif");
        this.newButton = new JButton();
        this.configureButton(this.newButton, "New", "images/new.gif");
        if (this.supportMultipleStyles()) {
            this.stylesButton = new JButton();
            this.configureButton(this.stylesButton, "Styles", "images/allStyles.gif");
        }
        this.discardButton = new JButton();
        this.configureButton(this.discardButton, "Discard", "images/delete.gif");
        this.removeButton = new JButton();
        this.configureButton(this.removeButton, "Remove", "images/delete.gif");
        this.addSelectedButton = new JButton();
        this.configureButton(this.addSelectedButton, "Add Selected", "images/addtoconstraint.gif");
        this.assignSelectedButton = new JButton();
        this.configureButton(this.assignSelectedButton, "Assign Selected", "images/assigntoconstraint.gif");
        this.deleteAllButton = new JButton();
        this.configureButton(this.deleteAllButton, "Delete All", "images/delete.gif");
    }

    protected void configureButton(AbstractButton abstractButton, String string, String string2) {
        abstractButton.setMaximumSize(new Dimension(29, 23));
        ImageIcon imageIcon = null;
        Image image = TSEImage.loadImage((String)string2);
        if (image != null) {
            imageIcon = new ImageIcon(image);
        }
        if (imageIcon != null) {
            abstractButton.setIcon(imageIcon);
        }
        abstractButton.setActionCommand(string);
        abstractButton.setToolTipText(this.translateText(string.replace(' ', '_')));
        abstractButton.addActionListener(this);
    }

    public JButton getLayoutButton() {
        return this.layoutButton;
    }

    public JButton getIncrementalLayoutButton() {
        return this.incrementalLayoutButton;
    }

    public JToggleButton getShowAllButton() {
        return this.showAllButton;
    }

    public JButton getNewButton() {
        return this.newButton;
    }

    public JButton getStylesButton() {
        return this.stylesButton;
    }

    public JButton getDiscardButton() {
        return this.discardButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public JButton getAddSelectedButton() {
        return this.addSelectedButton;
    }

    public JButton getAssignSelectedButton() {
        return this.assignSelectedButton;
    }

    public JButton getDeleteAllButton() {
        return this.deleteAllButton;
    }

    public void toggleButtons() {
        for (int i = 0; i < this.getToolBar().getComponentCount(); ++i) {
            Component component = this.getToolBar().getComponent(i);
            if (!(component instanceof JButton)) continue;
            this.chooseState((JButton)component);
        }
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getPopupMenu() != null) {
            this.setPopupState(this.getSelectedTreeNode().getPopupMenu());
        }
    }

    protected JLabel createBlankLabel() {
        JLabel jLabel = new JLabel(this.processToolTip("No_window_visible"));
        jLabel.setBorder(BorderFactory.createTitledBorder(""));
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(0);
        return jLabel;
    }

    public void initPopups() {
        this.constraintTypeMenu = new JPopupMenu();
        JMenuItem jMenuItem = this.createMenuItem("New", 'n');
        this.constraintTypeMenu.add(jMenuItem);
        this.constraintMenu = new JPopupMenu();
        JMenuItem jMenuItem2 = this.createMenuItem("Styles", 's');
        JMenuItem jMenuItem3 = this.createMenuItem("Discard", 'd');
        this.constraintMenu.add(jMenuItem2);
        this.constraintMenu.addSeparator();
        this.constraintMenu.add(jMenuItem3);
        this.listMenu = new JPopupMenu();
        JMenuItem jMenuItem4 = this.createMenuItem("Add Selected", 'a');
        JMenuItem jMenuItem5 = this.createMenuItem("Assign Selected", 's');
        JMenuItem jMenuItem6 = this.createMenuItem("Delete All", 'd');
        this.listMenu.add(jMenuItem4);
        this.listMenu.add(jMenuItem5);
        this.listMenu.addSeparator();
        this.listMenu.add(jMenuItem6);
        this.graphObjectMenu = new JPopupMenu();
        JMenuItem jMenuItem7 = this.createMenuItem("Remove", 'r');
        this.graphObjectMenu.add(jMenuItem7);
    }

    public void showPopup(TSETreeNode tSETreeNode, Point point) {
        JPopupMenu jPopupMenu;
        if (tSETreeNode != null && tSETreeNode.getParent() != null && (jPopupMenu = tSETreeNode.getPopupMenu()) != null) {
            this.setPopupState(jPopupMenu);
            Point point2 = SwingUtilities.convertPoint(this.getTree(), point, this.scrollPane);
            String string = System.getProperty("os.name");
            if (!string.startsWith("Windows")) {
                this.ignoreMoveGesture = true;
            }
            jPopupMenu.show(this.scrollPane, point2.x, point2.y);
        }
    }

    private void setPopupState(JPopupMenu jPopupMenu) {
        for (int i = jPopupMenu.getComponentCount() - 1; i >= 0; --i) {
            Component component = jPopupMenu.getComponent(i);
            if (!(component instanceof JMenuItem)) continue;
            this.chooseState((JMenuItem)component);
        }
    }

    public void chooseState(AbstractButton abstractButton) {
        String string = abstractButton.getActionCommand();
        if (this.getSelectedTreeNode() instanceof TSEListTreeNode && this.getGraph() != null) {
            boolean bl;
            TSEListTreeNode tSEListTreeNode = (TSEListTreeNode)this.getSelectedTreeNode();
            boolean bl2 = bl = this.getSelectedTreeNode() instanceof TSESingleNodeTreeNode && this.getGraph().hasSelectedNodes() || this.getSelectedTreeNode() instanceof TSENodeListTreeNode && this.getGraph().hasSelectedNodes() || this.getSelectedTreeNode() instanceof TSEEdgeListTreeNode && this.getGraph().hasSelectedEdges(false);
            if (string.equals("Add Selected")) {
                if (this.getSelectedTreeNode() instanceof TSESingleNodeTreeNode) {
                    boolean bl3 = ((TSESingleNodeTreeNode)this.getSelectedTreeNode()).getList().isEmpty();
                    abstractButton.setEnabled(bl && bl3);
                } else {
                    abstractButton.setEnabled(bl);
                }
            } else if (string.equals("Assign Selected")) {
                abstractButton.setEnabled(bl);
            } else if (string.equals("Delete All")) {
                abstractButton.setEnabled(tSEListTreeNode.getChildCount() > 0);
            }
        }
        if (string.equals(LAYOUT) || string.equals(INCREMENTAL_LAYOUT)) {
            abstractButton.setEnabled(this.layoutProxy != null && this.getGraphWindow().getGraph().numberOfNodes() > 0);
        }
    }

    public JPopupMenu getConstraintTypeMenu() {
        return this.constraintTypeMenu;
    }

    public JPopupMenu getConstraintMenu() {
        return this.constraintMenu;
    }

    public JPopupMenu getListMenu() {
        return this.listMenu;
    }

    public JPopupMenu getGraphObjectMenu() {
        return this.graphObjectMenu;
    }

    protected JMenuItem createMenuItem(String string, char c) {
        JMenuItem jMenuItem = new JMenuItem(this.translateText(string.replace(' ', '_')), c);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string);
        return jMenuItem;
    }

    protected String getDescriptionForType(String string) {
        String string2 = null;
        if (string.startsWith("Edit Priority")) {
            string2 = this.processToolTip("The_constraints_with_lower_priority_numbers_take_precedence");
        } else if (string.startsWith("Fulfilled")) {
            string2 = this.processToolTip("Indicates_whether_the_constraint_is_fulfilled");
        } else if (string.startsWith("Edit Level")) {
            string2 = this.processToolTip("Specify_the_level_at_which_the_nodes_should_appear");
        } else if (string.startsWith(this.translateText("Node_List"))) {
            string2 = this.processToolTip("The_list_of_nodes_affected_by_the_constraint");
        } else if (string.startsWith(this.translateText("Node"))) {
            string2 = this.processToolTip("The_node_affected_by_the_constraint");
        } else if (string.startsWith(this.translateText("Edge_List"))) {
            string2 = this.processToolTip("The_list_of_edges_affected_by_the_constraint");
        } else if (string.startsWith(this.translateText("First_Node_List"))) {
            string2 = this.processToolTip("The_first_node_list_of_the_constraint");
        } else if (string.startsWith(this.translateText("Second_Node_List"))) {
            string2 = this.processToolTip("The_second_node_list_of_the_constraint");
        }
        return string2;
    }

    protected String processToolTip(String string) {
        String string2 = this.translateText(string);
        int n = 0;
        while ((n = string2.indexOf("\n", n)) != -1) {
            string2 = string2.substring(0, n) + "<br>" + string2.substring(n + 1);
        }
        string2 = "<html>" + string2 + "</html>";
        return string2;
    }

    public boolean isShowingToolTips() {
        return this.showToolTips;
    }

    public void setShowingToolTips(boolean bl) {
        if (this.isShowingToolTips() != bl) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            if (bl) {
                toolTipManager.registerComponent(this.getTree());
            } else {
                toolTipManager.unregisterComponent(this.getTree());
            }
            this.showToolTips = bl;
        }
    }

    public String translateText(String string) {
        return this.labels.getStringSafely(string);
    }

    public String getDefaultConstraintName() {
        return this.translateText("Constraint_#");
    }

    public int getDefaultWidth() {
        return WIDTH;
    }

    public int getDefaultHeight() {
        return HEIGHT;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setSelectedTreeNode(TSETreeNode tSETreeNode) {
        this.selectedNode = tSETreeNode;
    }

    public TSETreeNode getSelectedTreeNode() {
        return this.selectedNode;
    }

    public void setGraphWindow(TSEGraphWindow tSEGraphWindow, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData) {
        if (this.getGraphWindow() != null) {
            this.unregisterListeners();
        }
        this.unhighlightObjects(true);
        this.graphWindow = tSEGraphWindow;
        this.inputData = tSEAllOptionsServiceInputData;
        if (this.getGraphWindow() != null) {
            this.registerListeners();
        }
        this.init();
        ((JPanel)((JDialog)((Object)this)).getContentPane()).revalidate();
    }

    public TSEGraphWindow getGraphWindow() {
        return this.graphWindow;
    }

    public TSEGraph getGraph() {
        return this.getGraphWindow().getGraphManager().selectedGraph();
    }

    public JTree getTree() {
        return this.tree;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setBlank(boolean bl) {
        String string = this.processToolTip("No_window_visible");
        this.setBlank(bl, string);
    }

    public void setBlank(boolean bl, String string) {
        String string2 = this.blankLabel.getText();
        this.blankLabel.setText(string);
        JPanel jPanel = (JPanel)((JDialog)((Object)this)).getContentPane();
        if (bl && !this.isBlank()) {
            jPanel.remove(this.scrollPane);
            this.resetToolBar();
            jPanel.add((Component)this.blankLabel, "Center");
            this.unhighlightObjects();
            jPanel.revalidate();
            jPanel.repaint();
            this.blank = true;
        } else if (!bl && this.isBlank()) {
            jPanel.remove(this.blankLabel);
            jPanel.add((Component)this.scrollPane, "Center");
            if (this.getSelectedTreeNode() != null) {
                this.getSelectedTreeNode().onSelect();
                this.unhighlightObjects();
            }
            jPanel.revalidate();
            jPanel.repaint();
            this.blank = false;
        } else if (bl && this.isBlank()) {
            boolean bl2 = string2 == null && string != null || !string2.equals(string);
            jPanel.revalidate();
            jPanel.repaint();
        }
    }

    public boolean isBlank() {
        return this.blank;
    }

    public boolean isMarkingInvalidNodes() {
        return this.markInvalidNodes;
    }

    public void setMarkingInvalidNodes(boolean bl) {
        this.markInvalidNodes = bl;
    }

    public boolean isDragAndDropEnabled() {
        return this.enableDragAndDrop;
    }

    public void setDragAndDropEnabled(boolean bl) {
        this.enableDragAndDrop = bl;
        if (this.dropTarget != null) {
            this.dropTarget.setActive(bl);
        }
    }

    public boolean isUndoRedoEnabled() {
        return this.supportUndoRedo;
    }

    public void setUndoRedoEnabled(boolean bl) {
        this.supportUndoRedo = bl;
    }

    public void setConstraintNameEditable(boolean bl) {
        this.getTree().setEditable(bl);
    }

    public boolean isConstraintNameEditable() {
        return this.getTree().isEditable();
    }

    protected void adjustSize() {
        block2: {
            int n;
            block4: {
                block3: {
                    if (!TSEDockableDialog.heightCompensatedInApplet()) break block2;
                    n = 25;
                    String string = System.getProperty("os.name");
                    String string2 = System.getProperty("os.version");
                    if (string.endsWith("XP")) break block3;
                    if (!string.endsWith("2000")) break block4;
                    if (!string2.endsWith("5.1")) break block4;
                }
                n = 35;
            }
            HEIGHT += n;
        }
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        if (this.scrollPane != null) {
            TSELocalization.setComponentOrientation((Component)this.scrollPane);
        }
        if (this.toolBar != null) {
            TSELocalization.setComponentOrientation((Component)this.toolBar);
        }
        if (this.tree != null) {
            TSELocalization.setComponentOrientation((Component)this.tree);
        }
        if (this.constraintTypeMenu != null) {
            TSELocalization.setComponentOrientation((Component)this.constraintTypeMenu);
        }
        if (this.constraintMenu != null) {
            TSELocalization.setComponentOrientation((Component)this.constraintMenu);
        }
        if (this.listMenu != null) {
            TSELocalization.setComponentOrientation((Component)this.listMenu);
        }
        if (this.graphObjectMenu != null) {
            TSELocalization.setComponentOrientation((Component)this.graphObjectMenu);
        }
    }

    public void registerListeners() {
        TSEGraphManager tSEGraphManager = this.graphWindow.getGraphManager();
        TSEEventManager tSEEventManager = (TSEEventManager)tSEGraphManager.getEventManager();
        tSEEventManager.addGraphChangeListener((Object)this.getGraph(), this.eventListener, 3126L);
        tSEEventManager.addDrawingChangeListener((Object)tSEGraphManager, this.eventListener, 0x1000000L);
        tSEEventManager.addSelectionChangeListener((Object)tSEGraphManager, this.eventListener);
        tSEEventManager.addServiceInputChangeListener((Object)tSEGraphManager, this.eventListener);
        tSEEventManager.addConstraintChangeListener((Object)tSEGraphManager, this.eventListener);
    }

    public void unregisterListeners() {
        if (this.graphWindow != null) {
            this.getGraphWindow().getGraphManager().getEventManager().removeListener(this.eventListener);
        }
    }

    public String getDirectionString(int n) {
        if (n == 0) {
            return this.translateText("Left_To_Right");
        }
        if (n == 1) {
            return this.translateText("Bottom_To_Top");
        }
        if (n == 2) {
            return this.translateText("Right_To_Left");
        }
        return this.translateText("Top_To_Bottom");
    }

    public String getAlignmentString(int n) {
        if (n == 0) {
            return this.translateText("Center");
        }
        if (n == 1) {
            return this.translateText("Left_or_Top");
        }
        return this.translateText("Right_or_Bottom");
    }

    protected Map getConstraints() {
        return this.constraints;
    }

    public int getDirectionValue(String string) {
        if (this.getDirectionString(0).equals(string)) {
            return 0;
        }
        if (this.getDirectionString(1).equals(string)) {
            return 1;
        }
        if (this.getDirectionString(2).equals(string)) {
            return 2;
        }
        return 3;
    }

    public int getAlignmentValue(String string) {
        if (this.getAlignmentString(1).equals(string)) {
            return 1;
        }
        if (this.getAlignmentString(0).equals(string)) {
            return 0;
        }
        return 2;
    }

    public void registerCallBackListener(TSDialogCallBackListener tSDialogCallBackListener) {
        this.callBackListener = tSDialogCallBackListener;
    }

    public Object callBack(Object object) {
        Object object2 = null;
        if (this.callBackListener != null) {
            object2 = this.callBackListener.uponCallBack(object);
        }
        return object2;
    }

    public void setInvalidColor(TSEColor tSEColor) {
        this.invalidColor = tSEColor;
    }

    public TSEColor getInvalidColor() {
        return this.invalidColor;
    }

    public void onConstraintChanged(TSLayoutConstraint tSLayoutConstraint) {
        boolean bl = this.getGraphWindow().getGraphManager().getEventManager().isFiringEvents();
        this.getGraphWindow().getGraphManager().getEventManager().setFireEvents(false);
        TSELayoutConstraintTreeNode tSELayoutConstraintTreeNode = (TSELayoutConstraintTreeNode)this.getConstraints().get(tSLayoutConstraint);
        if (tSELayoutConstraintTreeNode != null) {
            TSETreeNode tSETreeNode = (TSETreeNode)tSELayoutConstraintTreeNode.getParent();
            int n = tSETreeNode.getIndex(tSELayoutConstraintTreeNode);
            this.preserveDataMode = true;
            this.removeConstraint(tSELayoutConstraintTreeNode);
            this.onNewConstraint(tSETreeNode, tSLayoutConstraint, n);
            this.preserveDataMode = false;
        }
        this.getGraphWindow().getGraphManager().getEventManager().setFireEvents(bl);
    }

    private dl getOrAddConstraintManager() {
        TSLayoutConstraintManager tSLayoutConstraintManager = this.getConstraintManager();
        if (tSLayoutConstraintManager == null) {
            tSLayoutConstraintManager = new TSLayoutConstraintManager();
            tSLayoutConstraintManager.setGraphManager((TSDGraphManager)this.getGraphWindow().getGraphManager());
            this.inputData.setOption((Object)this.getGraphWindow().getGraphManager(), "all:all:graphManager:constraintManager", tSLayoutConstraintManager);
        }
        return tSLayoutConstraintManager;
    }

    public TSLayoutConstraintManager getConstraintManager() {
        return (TSLayoutConstraintManager)this.inputData.getValue(this.getGraphWindow().getGraphManager(), "all:all:graphManager:constraintManager");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

