/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.service.layout.jlayout;

import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.dialog.TSUnsignedDoubleField;
import com.tomsawyer.editor.service.layout.TSEInteractiveLayoutInputTailor;
import com.tomsawyer.editor.service.layout.properties.TSETabComponent;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.layout.jlayout.TSGeneralLayoutInputTailor;
import com.tomsawyer.service.layout.jlayout.es;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TSEDisconnectedTab
extends TSETabComponent
implements ActionListener {
    static final String DETECT_COMPONENTS = "DETECT_COMPONENTS";
    static final String DETECT_DISCONNECTED_NODES = "DETECT_DISCONNECTED_NODES";
    static final String ASPECT_RATIO_AUTOMATIC = "AUTOMATIC";
    static final String ASPECT_RATIO_CUSTOM = "CUSTOM";
    JCheckBox detectConn;
    protected TSUnsignedDoubleField connConstantSpacingField;
    protected TSUnsignedDoubleField connProportionalSpacingField;
    JCheckBox detectDisc;
    protected TSUnsignedDoubleField discConstantSpacingField;
    protected TSUnsignedDoubleField discProportionalSpacingField;
    protected JRadioButton aspectRatioAutomaticRadioButton;
    protected JRadioButton aspectRatioCustomRadioButton;
    TSUnsignedDoubleField aspectRatioCustomField;

    public TSEDisconnectedTab(TSEGraph tSEGraph, TSServiceInputData tSServiceInputData, JDialog jDialog) {
        super(tSEGraph, tSServiceInputData, jDialog);
    }

    protected void init() {
        super.init();
        this.layoutHelper = new es();
        this.setLayout(new BoxLayout(this, 0));
        this.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel2.setAlignmentY(0.0f);
        JPanel jPanel3 = this.makeComponentsPanel();
        JPanel jPanel4 = this.makeDisconnectedPanel();
        JPanel jPanel5 = this.makeAspectRatioPanel();
        jPanel3.setAlignmentX(0.0f);
        jPanel4.setAlignmentX(0.0f);
        jPanel3.setAlignmentX(0.0f);
        Vector<JPanel> vector = new Vector<JPanel>();
        vector.add(jPanel3);
        vector.add(jPanel4);
        this.normalizeComponentDimensions(vector, true, false);
        jPanel.add(jPanel3);
        jPanel.add(this.createVerticalRigidArea(6));
        jPanel.add(jPanel4);
        jPanel2.add(jPanel5);
        this.add(jPanel);
        this.add(this.createHorizontalRigidArea(6));
        this.add(jPanel2);
        this.add(this.createHorizontalRigidArea(6));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    protected JPanel makeComponentsPanel() {
        JPanel jPanel = new JPanel();
        this.detectConn = this.createCheckbox("Detect_Components", DETECT_COMPONENTS);
        JLabel jLabel = this.createLabel("Constant_Spacing:");
        this.connConstantSpacingField = this.createDoubleField(4, 0.0, 1000.0);
        JLabel jLabel2 = this.createLabel("Proportional_Spacing:");
        this.connProportionalSpacingField = this.createDoubleField(4, 0.0, 1000.0);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel2.setAlignmentX(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel4.setAlignmentX(0.0f);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.connConstantSpacingField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.connProportionalSpacingField);
        jPanel4.add(jPanel2);
        jPanel4.add(this.createHorizontalRigidArea(40));
        jPanel4.add(jPanel3);
        jPanel.add(this.detectConn);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(jPanel4);
        this.createCompoundBorder(jPanel, "Components", 0, 6, 5, 5);
        return jPanel;
    }

    protected JPanel makeDisconnectedPanel() {
        JPanel jPanel = new JPanel();
        this.detectDisc = this.createCheckbox("Detect_Disconnected_Nodes", DETECT_DISCONNECTED_NODES);
        JLabel jLabel = this.createLabel("Constant_Spacing:");
        this.discConstantSpacingField = this.createDoubleField(4, 0.0, 1000.0);
        JLabel jLabel2 = this.createLabel("Proportional_Spacing:");
        this.discProportionalSpacingField = this.createDoubleField(4, 0.0, 1000.0);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel2.setAlignmentX(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel4.setAlignmentX(0.0f);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.discConstantSpacingField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.discProportionalSpacingField);
        jPanel4.add(jPanel2);
        jPanel4.add(this.createHorizontalRigidArea(40));
        jPanel4.add(jPanel3);
        jPanel.add(this.detectDisc);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(jPanel4);
        this.createCompoundBorder(jPanel, "Disconnected_Nodes", 0, 6, 5, 5);
        return jPanel;
    }

    protected JPanel makeAspectRatioPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel2.setAlignmentX(0.0f);
        jPanel3.setAlignmentX(0.0f);
        this.aspectRatioAutomaticRadioButton = this.createRadioButton("Automatic", ASPECT_RATIO_AUTOMATIC);
        this.aspectRatioCustomRadioButton = this.createRadioButton("Custom:", ASPECT_RATIO_CUSTOM);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.aspectRatioAutomaticRadioButton);
        buttonGroup.add(this.aspectRatioCustomRadioButton);
        this.aspectRatioCustomField = this.createDoubleField(4, 1.0E-8, 9999.0);
        jPanel2.add(this.aspectRatioAutomaticRadioButton);
        jPanel3.add(this.aspectRatioCustomRadioButton);
        jPanel3.add(this.createHorizontalRigidArea(20));
        jPanel3.add((Component)this.aspectRatioCustomField);
        jPanel.add(jPanel2);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Aspect_Ratio", 0, 6, 5, 5);
        return jPanel;
    }

    public void setValues(TSServiceInputData tSServiceInputData) {
        TSGeneralLayoutInputTailor tSGeneralLayoutInputTailor = new TSGeneralLayoutInputTailor(tSServiceInputData, (TSDGraph)this.getGraph());
        this.detectConn.setSelected(tSGeneralLayoutInputTailor.getDetectComponents());
        this.connConstantSpacingField.setText(String.valueOf(tSGeneralLayoutInputTailor.getComponentConstantSpacing()));
        this.connProportionalSpacingField.setText(String.valueOf(tSGeneralLayoutInputTailor.getComponentProportionalSpacing()));
        this.onDetectComponents();
        this.detectDisc.setSelected(tSGeneralLayoutInputTailor.getDetectDisconnectedNodes());
        this.discConstantSpacingField.setText(String.valueOf(tSGeneralLayoutInputTailor.getDisconnectedNodeConstantSpacing()));
        this.onDetectDisconnectedNodes();
        this.discProportionalSpacingField.setText(String.valueOf(tSGeneralLayoutInputTailor.getDisconnectedNodeProportionalSpacing()));
        this.aspectRatioCustomField.setText(String.valueOf(tSGeneralLayoutInputTailor.getComponentAspectRatio()));
        TSEInteractiveLayoutInputTailor tSEInteractiveLayoutInputTailor = new TSEInteractiveLayoutInputTailor(tSServiceInputData, this.getGraph());
        if (tSEInteractiveLayoutInputTailor.getDisconnectedAspectRatio() == 1) {
            this.aspectRatioAutomaticRadioButton.setSelected(true);
            this.onAspectRatioAutomatic();
        } else {
            this.aspectRatioCustomRadioButton.setSelected(true);
            this.onAspectRatioCustom();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(DETECT_COMPONENTS)) {
            this.onDetectComponents();
        } else if (string.equals(DETECT_DISCONNECTED_NODES)) {
            this.onDetectDisconnectedNodes();
        } else if (string.equals(ASPECT_RATIO_AUTOMATIC)) {
            this.onAspectRatioAutomatic();
        } else if (string.equals(ASPECT_RATIO_CUSTOM)) {
            this.onAspectRatioCustom();
        }
        this.activateButtons();
    }

    protected void onDetectComponents() {
        if (this.detectConn.isSelected()) {
            this.enable((JComponent)this.connConstantSpacingField);
            this.enable((JComponent)this.connProportionalSpacingField);
        } else {
            this.disable((JComponent)this.connConstantSpacingField);
            this.disable((JComponent)this.connProportionalSpacingField);
        }
    }

    protected void onDetectDisconnectedNodes() {
        if (this.detectDisc.isSelected()) {
            this.enable((JComponent)this.discConstantSpacingField);
            this.enable((JComponent)this.discProportionalSpacingField);
        } else {
            this.disable((JComponent)this.discConstantSpacingField);
            this.disable((JComponent)this.discProportionalSpacingField);
        }
    }

    protected void onAspectRatioAutomatic() {
        this.disable((JComponent)this.aspectRatioCustomField);
    }

    protected void onAspectRatioCustom() {
        this.enable((JComponent)this.aspectRatioCustomField);
    }

    public void onApply() {
        super.onApply();
        this.processCheckbox("layout:all:graph:detectComponents", this.detectConn);
        this.processDoubleField("layout:all:graph:componentConstantSpacing", this.connConstantSpacingField);
        this.processDoubleField("layout:all:graph:componentProportionalSpacing", this.connProportionalSpacingField);
        this.processCheckbox("layout:all:graph:detectDisconnectedNodes", this.detectDisc);
        this.processDoubleField("layout:all:graph:disconnectedNodesConstantSpacing", this.discConstantSpacingField);
        this.processDoubleField("layout:all:graph:disconnectedNodesProportionalSpacing", this.discProportionalSpacingField);
        TSEInteractiveLayoutInputTailor tSEInteractiveLayoutInputTailor = new TSEInteractiveLayoutInputTailor(this.getServiceInputData(), this.getGraph());
        if (this.aspectRatioAutomaticRadioButton.isSelected()) {
            tSEInteractiveLayoutInputTailor.setDisconnectedAspectRatioAsAutomatic();
        } else {
            tSEInteractiveLayoutInputTailor.setDisconnectedAspectRatioAsCustom();
            this.processDoubleField("layout:all:graph:componentAspectRatio", this.aspectRatioCustomField);
        }
    }
}

