/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.service.layout.jlayout;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.command.TSESetMarginsCommand;
import com.tomsawyer.editor.dialog.TSUnsignedDoubleField;
import com.tomsawyer.editor.service.layout.properties.TSETabComponent;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.layout.jlayout.TSLayoutInputTailor;
import com.tomsawyer.service.layout.jlayout.es;
import com.tomsawyer.util.command.TSCommand;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TSEGeneralTab
extends TSETabComponent {
    static final String CONSTANT_MARGIN_SPACING = "CONSTANT_MARGIN_SPACING";
    static final String PROPORTIONAL_MARGIN_SPACING = "PROPORTIONAL_MARGIN_SPACING";
    static final String CONSTANT_NESTED_VIEW_SPACING = "CONSTANT_NESTED_VIEW_SPACING";
    static final String PROPORTIONAL_NESTED_VIEW_SPACING = "PROPORTIONAL_NESTED_VIEW_SPACING";
    protected JRadioButton proportionalMarginSpacing;
    protected JRadioButton constantMarginSpacing;
    protected TSUnsignedDoubleField leftMarginSpacingField;
    protected TSUnsignedDoubleField topMarginSpacingField;
    protected TSUnsignedDoubleField rightMarginSpacingField;
    protected TSUnsignedDoubleField bottomMarginSpacingField;
    public String marginSpacingSelected;
    protected String proportionalLeftMargin;
    protected String proportionalRightMargin;
    protected String proportionalTopMargin;
    protected String proportionalBottomMargin;
    protected String constantLeftMargin;
    protected String constantRightMargin;
    protected String constantTopMargin;
    protected String constantBottomMargin;
    protected JRadioButton proportionalNestedViewSpacing;
    protected JRadioButton constantNestedViewSpacing;
    protected TSUnsignedDoubleField leftNestedViewSpacingField;
    protected TSUnsignedDoubleField topNestedViewSpacingField;
    protected TSUnsignedDoubleField rightNestedViewSpacingField;
    protected TSUnsignedDoubleField bottomNestedViewSpacingField;
    public String nestedViewSpacingSelected;
    protected String proportionalLeftNestedViewSpacing;
    protected String proportionalRightNestedViewSpacing;
    protected String proportionalTopNestedViewSpacing;
    protected String proportionalBottomNestedViewSpacing;
    protected String constantLeftNestedViewSpacing;
    protected String constantRightNestedViewSpacing;
    protected String constantTopNestedViewSpacing;
    protected String constantBottomNestedViewSpacing;
    protected TSUnsignedDoubleField intergraphEdgeHorizontalSpacingField;
    protected TSUnsignedDoubleField intergraphEdgeVerticalSpacingField;

    public TSEGeneralTab(TSEGraph tSEGraph, TSServiceInputData tSServiceInputData, JDialog jDialog) {
        super(tSEGraph, tSServiceInputData, jDialog);
    }

    protected void init() {
        super.init();
        this.layoutHelper = new es();
        JPanel jPanel = this.makeMarginSpacingPanel();
        JPanel jPanel2 = this.makeNestedViewSpacingPanel();
        JPanel jPanel3 = this.makeIntergraphEdgeSpacingPanel();
        this.setLayout(new BoxLayout(this, 0));
        jPanel.setAlignmentY(0.0f);
        jPanel2.setAlignmentY(0.0f);
        jPanel3.setAlignmentY(0.0f);
        this.add(jPanel);
        this.add(this.createHorizontalRigidArea(6));
        this.add(jPanel2);
        this.add(this.createHorizontalRigidArea(6));
        this.add(jPanel3);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 20, 20));
        this.marginSpacingSelected = CONSTANT_MARGIN_SPACING;
        this.nestedViewSpacingSelected = CONSTANT_NESTED_VIEW_SPACING;
        this.checkNestedViewSpacing();
    }

    protected JPanel makeMarginSpacingPanel() {
        JPanel jPanel = new JPanel();
        this.proportionalMarginSpacing = this.createRadioButton("Proportional_Spacing", PROPORTIONAL_MARGIN_SPACING);
        this.constantMarginSpacing = this.createRadioButton("Constant_Spacing", CONSTANT_MARGIN_SPACING);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.proportionalMarginSpacing);
        buttonGroup.add(this.constantMarginSpacing);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.proportionalMarginSpacing.setAlignmentX(0.0f);
        this.constantMarginSpacing.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = this.createLabel("Left:");
        this.leftMarginSpacingField = this.createDoubleField(4, 0.0, 9999.0);
        JLabel jLabel2 = this.createLabel("Top:");
        this.topMarginSpacingField = this.createDoubleField(4, 0.0, 9999.0);
        JLabel jLabel3 = this.createLabel("Right:");
        this.rightMarginSpacingField = this.createDoubleField(4, 0.0, 9999.0);
        JLabel jLabel4 = this.createLabel("Bottom:");
        this.bottomMarginSpacingField = this.createDoubleField(4, 0.0, 9999.0);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel3.add(jLabel);
        jPanel3.add(this.createVerticalRigidArea(9));
        jPanel3.add(jLabel2);
        jPanel3.add(this.createVerticalRigidArea(9));
        jPanel3.add(jLabel3);
        jPanel3.add(this.createVerticalRigidArea(9));
        jPanel3.add(jLabel4);
        jPanel4.add((Component)this.leftMarginSpacingField);
        jPanel4.add(this.createVerticalRigidArea(5));
        jPanel4.add((Component)this.topMarginSpacingField);
        jPanel4.add(this.createVerticalRigidArea(5));
        jPanel4.add((Component)this.rightMarginSpacingField);
        jPanel4.add(this.createVerticalRigidArea(5));
        jPanel4.add((Component)this.bottomMarginSpacingField);
        jPanel2.add(jPanel3);
        jPanel2.add(this.createHorizontalRigidArea(40));
        jPanel2.add(jPanel4);
        this.createCompoundBorder(jPanel2, "", 6, 6, 5, 5);
        jPanel3.setAlignmentY(0.0f);
        jPanel4.setAlignmentY(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(this.constantMarginSpacing);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.proportionalMarginSpacing);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(jPanel2);
        this.createCompoundBorder(jPanel, "Margin_Spacing", 0, 6, 6, 6);
        return jPanel;
    }

    protected JPanel makeNestedViewSpacingPanel() {
        JPanel jPanel = new JPanel();
        this.proportionalNestedViewSpacing = this.createRadioButton("Proportional_Spacing", PROPORTIONAL_NESTED_VIEW_SPACING);
        this.constantNestedViewSpacing = this.createRadioButton("Constant_Spacing", CONSTANT_NESTED_VIEW_SPACING);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.proportionalNestedViewSpacing);
        buttonGroup.add(this.constantNestedViewSpacing);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.proportionalNestedViewSpacing.setAlignmentX(0.0f);
        this.constantNestedViewSpacing.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = this.createLabel("Left:");
        this.leftNestedViewSpacingField = this.createDoubleField(4, 0.0, 9999.0);
        JLabel jLabel2 = this.createLabel("Top:");
        this.topNestedViewSpacingField = this.createDoubleField(4, 0.0, 9999.0);
        JLabel jLabel3 = this.createLabel("Right:");
        this.rightNestedViewSpacingField = this.createDoubleField(4, 0.0, 9999.0);
        JLabel jLabel4 = this.createLabel("Bottom:");
        this.bottomNestedViewSpacingField = this.createDoubleField(4, 0.0, 9999.0);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel3.add(jLabel);
        jPanel3.add(this.createVerticalRigidArea(9));
        jPanel3.add(jLabel2);
        jPanel3.add(this.createVerticalRigidArea(9));
        jPanel3.add(jLabel3);
        jPanel3.add(this.createVerticalRigidArea(9));
        jPanel3.add(jLabel4);
        jPanel4.add((Component)this.leftNestedViewSpacingField);
        jPanel4.add(this.createVerticalRigidArea(5));
        jPanel4.add((Component)this.topNestedViewSpacingField);
        jPanel4.add(this.createVerticalRigidArea(5));
        jPanel4.add((Component)this.rightNestedViewSpacingField);
        jPanel4.add(this.createVerticalRigidArea(5));
        jPanel4.add((Component)this.bottomNestedViewSpacingField);
        jPanel2.add(jPanel3);
        jPanel2.add(this.createHorizontalRigidArea(40));
        jPanel2.add(jPanel4);
        this.createCompoundBorder(jPanel2, "", 6, 6, 5, 5);
        jPanel3.setAlignmentY(0.0f);
        jPanel4.setAlignmentY(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(this.constantNestedViewSpacing);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.proportionalNestedViewSpacing);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(jPanel2);
        this.createCompoundBorder(jPanel, "Nested_View_Spacing", 0, 6, 6, 6);
        return jPanel;
    }

    protected JPanel makeIntergraphEdgeSpacingPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel3.setAlignmentY(0.0f);
        JLabel jLabel = this.createLabel("Horizontal_Spacing:");
        this.intergraphEdgeHorizontalSpacingField = this.createDoubleField(4, 0.0, 9999.0);
        JLabel jLabel2 = this.createLabel("Vertical_Spacing:");
        this.intergraphEdgeVerticalSpacingField = this.createDoubleField(4, 0.0, 9999.0);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.intergraphEdgeHorizontalSpacingField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.intergraphEdgeVerticalSpacingField);
        jPanel.add(jPanel2);
        jPanel.add(this.createHorizontalRigidArea(20));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Intergraph_Edge_Spacing", 0, 6, 5, 5);
        return jPanel;
    }

    public void setValues(TSServiceInputData tSServiceInputData) {
        TSEGraph tSEGraph = this.getGraph();
        if (tSServiceInputData == this.getServiceInputData()) {
            this.constantLeftMargin = String.valueOf(tSEGraph.getTailor().getLeftConstantMargin());
            this.constantRightMargin = String.valueOf(tSEGraph.getTailor().getRightConstantMargin());
            this.constantTopMargin = String.valueOf(tSEGraph.getTailor().getTopConstantMargin());
            this.constantBottomMargin = String.valueOf(tSEGraph.getTailor().getBottomConstantMargin());
            this.proportionalLeftMargin = String.valueOf(tSEGraph.getTailor().getLeftProportionalMargin() * 1000.0);
            this.proportionalRightMargin = String.valueOf(tSEGraph.getTailor().getRightProportionalMargin() * 1000.0);
            this.proportionalTopMargin = String.valueOf(tSEGraph.getTailor().getTopProportionalMargin() * 1000.0);
            this.proportionalBottomMargin = String.valueOf(tSEGraph.getTailor().getBottomProportionalMargin() * 1000.0);
        } else {
            this.constantTopMargin = String.valueOf(20.0);
            this.constantBottomMargin = String.valueOf(20.0);
            this.constantLeftMargin = String.valueOf(20.0);
            this.constantRightMargin = String.valueOf(20.0);
            this.proportionalTopMargin = String.valueOf(0.0);
            this.proportionalBottomMargin = String.valueOf(0.0);
            this.proportionalLeftMargin = String.valueOf(0.0);
            this.proportionalRightMargin = String.valueOf(0.0);
        }
        if (tSServiceInputData == this.getServiceInputData()) {
            if (this.marginSpacingSelected.equals(CONSTANT_MARGIN_SPACING)) {
                this.constantMarginSpacing.setSelected(true);
                this.leftMarginSpacingField.setText(this.constantLeftMargin);
                this.rightMarginSpacingField.setText(this.constantRightMargin);
                this.topMarginSpacingField.setText(this.constantTopMargin);
                this.bottomMarginSpacingField.setText(this.constantBottomMargin);
            } else {
                this.proportionalMarginSpacing.setSelected(true);
                this.leftMarginSpacingField.setText(this.proportionalLeftMargin);
                this.rightMarginSpacingField.setText(this.proportionalRightMargin);
                this.topMarginSpacingField.setText(this.proportionalTopMargin);
                this.bottomMarginSpacingField.setText(this.proportionalBottomMargin);
            }
        } else if (this.marginSpacingSelected.equals(CONSTANT_MARGIN_SPACING)) {
            this.constantMarginSpacing.setSelected(true);
            this.leftMarginSpacingField.setText(this.constantLeftMargin);
            this.rightMarginSpacingField.setText(this.constantRightMargin);
            this.topMarginSpacingField.setText(this.constantTopMargin);
            this.bottomMarginSpacingField.setText(this.constantBottomMargin);
        } else {
            this.proportionalMarginSpacing.setSelected(true);
            this.leftMarginSpacingField.setText(this.proportionalLeftMargin);
            this.rightMarginSpacingField.setText(this.proportionalRightMargin);
            this.topMarginSpacingField.setText(this.proportionalTopMargin);
            this.bottomMarginSpacingField.setText(this.proportionalBottomMargin);
        }
        if (tSServiceInputData == this.getServiceInputData()) {
            this.constantLeftNestedViewSpacing = String.valueOf(tSEGraph.getTailor().getLeftNestedViewConstant());
            this.constantRightNestedViewSpacing = String.valueOf(tSEGraph.getTailor().getRightNestedViewConstant());
            this.constantTopNestedViewSpacing = String.valueOf(tSEGraph.getTailor().getTopNestedViewConstant());
            this.constantBottomNestedViewSpacing = String.valueOf(tSEGraph.getTailor().getBottomNestedViewConstant());
            this.proportionalLeftNestedViewSpacing = String.valueOf(tSEGraph.getTailor().getLeftNestedViewProportional() * 1000.0);
            this.proportionalRightNestedViewSpacing = String.valueOf(tSEGraph.getTailor().getRightNestedViewProportional() * 1000.0);
            this.proportionalTopNestedViewSpacing = String.valueOf(tSEGraph.getTailor().getTopNestedViewProportional() * 1000.0);
            this.proportionalBottomNestedViewSpacing = String.valueOf(tSEGraph.getTailor().getBottomNestedViewProportional() * 1000.0);
        } else {
            this.constantTopNestedViewSpacing = String.valueOf(10.0);
            this.constantBottomNestedViewSpacing = String.valueOf(10.0);
            this.constantLeftNestedViewSpacing = String.valueOf(10.0);
            this.constantRightNestedViewSpacing = String.valueOf(10.0);
            this.proportionalTopNestedViewSpacing = String.valueOf(0.0);
            this.proportionalBottomNestedViewSpacing = String.valueOf(0.0);
            this.proportionalLeftNestedViewSpacing = String.valueOf(0.0);
            this.proportionalRightNestedViewSpacing = String.valueOf(0.0);
        }
        if (this.nestedViewSpacingSelected.equals(CONSTANT_NESTED_VIEW_SPACING)) {
            this.constantNestedViewSpacing.setSelected(true);
            this.leftNestedViewSpacingField.setText(this.constantLeftNestedViewSpacing);
            this.rightNestedViewSpacingField.setText(this.constantRightNestedViewSpacing);
            this.topNestedViewSpacingField.setText(this.constantTopNestedViewSpacing);
            this.bottomNestedViewSpacingField.setText(this.constantBottomNestedViewSpacing);
        } else {
            this.proportionalNestedViewSpacing.setSelected(true);
            this.leftNestedViewSpacingField.setText(this.proportionalLeftNestedViewSpacing);
            this.rightNestedViewSpacingField.setText(this.proportionalRightNestedViewSpacing);
            this.topNestedViewSpacingField.setText(this.proportionalTopNestedViewSpacing);
            this.bottomNestedViewSpacingField.setText(this.proportionalBottomNestedViewSpacing);
        }
        TSLayoutInputTailor tSLayoutInputTailor = new TSLayoutInputTailor(tSServiceInputData);
        this.intergraphEdgeHorizontalSpacingField.setText(String.valueOf(tSLayoutInputTailor.getHorizontalSpacingBetweenIntergraphEdges()));
        this.intergraphEdgeVerticalSpacingField.setText(String.valueOf(tSLayoutInputTailor.getVerticalSpacingBetweenIntergraphEdges()));
    }

    public void setGraph(TSEGraph tSEGraph) {
        super.setGraph(tSEGraph);
        this.checkNestedViewSpacing();
    }

    protected void checkNestedViewSpacing() {
        if (this.getGraph() != null) {
            if (this.getGraph().getParent() != null && this.getGraph().getParent() instanceof TSENode) {
                this.topNestedViewSpacingField.enable();
                this.leftNestedViewSpacingField.enable();
                this.bottomNestedViewSpacingField.enable();
                this.rightNestedViewSpacingField.enable();
            } else {
                this.topNestedViewSpacingField.disable();
                this.leftNestedViewSpacingField.disable();
                this.bottomNestedViewSpacingField.disable();
                this.rightNestedViewSpacingField.disable();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(PROPORTIONAL_MARGIN_SPACING)) {
            if (this.marginSpacingSelected.equals(CONSTANT_MARGIN_SPACING)) {
                this.onProportionalMarginSpacing();
            }
        } else if (string.equals(CONSTANT_MARGIN_SPACING)) {
            if (this.marginSpacingSelected.equals(PROPORTIONAL_MARGIN_SPACING)) {
                this.onConstantMarginSpacing();
            }
        } else if (string.equals(PROPORTIONAL_NESTED_VIEW_SPACING)) {
            if (this.nestedViewSpacingSelected.equals(CONSTANT_NESTED_VIEW_SPACING)) {
                this.onProportionalNestedViewSpacing();
            }
        } else if (string.equals(CONSTANT_NESTED_VIEW_SPACING)) {
            if (this.nestedViewSpacingSelected.equals(PROPORTIONAL_NESTED_VIEW_SPACING)) {
                this.onConstantNestedViewSpacing();
            }
        } else {
            this.activateButtons();
        }
    }

    protected void onProportionalMarginSpacing() {
        this.marginSpacingSelected = PROPORTIONAL_MARGIN_SPACING;
        this.constantLeftMargin = this.leftMarginSpacingField.getText();
        this.constantRightMargin = this.rightMarginSpacingField.getText();
        this.constantTopMargin = this.topMarginSpacingField.getText();
        this.constantBottomMargin = this.bottomMarginSpacingField.getText();
        this.leftMarginSpacingField.setText(this.proportionalLeftMargin);
        this.rightMarginSpacingField.setText(this.proportionalRightMargin);
        this.topMarginSpacingField.setText(this.proportionalTopMargin);
        this.bottomMarginSpacingField.setText(this.proportionalBottomMargin);
    }

    protected void onConstantMarginSpacing() {
        this.marginSpacingSelected = CONSTANT_MARGIN_SPACING;
        this.proportionalLeftMargin = this.leftMarginSpacingField.getText();
        this.proportionalRightMargin = this.rightMarginSpacingField.getText();
        this.proportionalTopMargin = this.topMarginSpacingField.getText();
        this.proportionalBottomMargin = this.bottomMarginSpacingField.getText();
        this.leftMarginSpacingField.setText(this.constantLeftMargin);
        this.rightMarginSpacingField.setText(this.constantRightMargin);
        this.topMarginSpacingField.setText(this.constantTopMargin);
        this.bottomMarginSpacingField.setText(this.constantBottomMargin);
    }

    protected void onProportionalNestedViewSpacing() {
        this.nestedViewSpacingSelected = PROPORTIONAL_NESTED_VIEW_SPACING;
        this.constantLeftNestedViewSpacing = this.leftNestedViewSpacingField.getText();
        this.constantRightNestedViewSpacing = this.rightNestedViewSpacingField.getText();
        this.constantTopNestedViewSpacing = this.topNestedViewSpacingField.getText();
        this.constantBottomNestedViewSpacing = this.bottomNestedViewSpacingField.getText();
        this.leftNestedViewSpacingField.setText(this.proportionalLeftNestedViewSpacing);
        this.rightNestedViewSpacingField.setText(this.proportionalRightNestedViewSpacing);
        this.topNestedViewSpacingField.setText(this.proportionalTopNestedViewSpacing);
        this.bottomNestedViewSpacingField.setText(this.proportionalBottomNestedViewSpacing);
    }

    protected void onConstantNestedViewSpacing() {
        this.nestedViewSpacingSelected = CONSTANT_NESTED_VIEW_SPACING;
        this.proportionalLeftNestedViewSpacing = this.leftNestedViewSpacingField.getText();
        this.proportionalRightNestedViewSpacing = this.rightNestedViewSpacingField.getText();
        this.proportionalTopNestedViewSpacing = this.topNestedViewSpacingField.getText();
        this.proportionalBottomNestedViewSpacing = this.bottomNestedViewSpacingField.getText();
        this.leftNestedViewSpacingField.setText(this.constantLeftNestedViewSpacing);
        this.rightNestedViewSpacingField.setText(this.constantRightNestedViewSpacing);
        this.topNestedViewSpacingField.setText(this.constantTopNestedViewSpacing);
        this.bottomNestedViewSpacingField.setText(this.constantBottomNestedViewSpacing);
    }

    public void onApply() {
        super.onApply();
        this.applyMarginSpacingOptions();
        this.applyNestedViewSpacingOptions();
        this.applyIntergraphEdgeSpacingOptions();
    }

    protected void applyMarginSpacingOptions() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        TSEGraph tSEGraph = this.getGraph();
        TSGraphTailor tSGraphTailor = null;
        if (tSEGraph == null) {
            return;
        }
        tSGraphTailor = tSEGraph.getTailor();
        if (this.marginSpacingSelected.equals(PROPORTIONAL_MARGIN_SPACING)) {
            d8 = this.chooseProperValue(this.leftMarginSpacingField.getText(), tSGraphTailor.getLeftProportionalMargin());
            d7 = this.chooseProperValue(this.rightMarginSpacingField.getText(), tSGraphTailor.getRightProportionalMargin());
            d6 = this.chooseProperValue(this.topMarginSpacingField.getText(), tSGraphTailor.getTopProportionalMargin());
            d5 = this.chooseProperValue(this.bottomMarginSpacingField.getText(), tSGraphTailor.getBottomProportionalMargin());
            d4 = this.chooseProperValue(this.constantLeftMargin, tSGraphTailor.getLeftConstantMargin());
            d3 = this.chooseProperValue(this.constantRightMargin, tSGraphTailor.getRightConstantMargin());
            d2 = this.chooseProperValue(this.constantTopMargin, tSGraphTailor.getTopConstantMargin());
            d = this.chooseProperValue(this.constantBottomMargin, tSGraphTailor.getBottomConstantMargin());
        } else {
            d4 = this.chooseProperValue(this.leftMarginSpacingField.getText(), tSGraphTailor.getLeftConstantMargin());
            d3 = this.chooseProperValue(this.rightMarginSpacingField.getText(), tSGraphTailor.getRightConstantMargin());
            d2 = this.chooseProperValue(this.topMarginSpacingField.getText(), tSGraphTailor.getTopConstantMargin());
            d = this.chooseProperValue(this.bottomMarginSpacingField.getText(), tSGraphTailor.getBottomConstantMargin());
            d8 = this.chooseProperValue(this.proportionalLeftMargin, tSGraphTailor.getLeftProportionalMargin());
            d7 = this.chooseProperValue(this.proportionalRightMargin, tSGraphTailor.getRightProportionalMargin());
            d6 = this.chooseProperValue(this.proportionalTopMargin, tSGraphTailor.getTopProportionalMargin());
            d5 = this.chooseProperValue(this.proportionalBottomMargin, tSGraphTailor.getBottomProportionalMargin());
        }
        if (tSGraphTailor.getLeftConstantMargin() != d4 || tSGraphTailor.getRightConstantMargin() != d3 || tSGraphTailor.getTopConstantMargin() != d2 || tSGraphTailor.getBottomConstantMargin() != d || tSGraphTailor.getLeftProportionalMargin() != d8 / 1000.0 || tSGraphTailor.getRightProportionalMargin() != d7 / 1000.0 || tSGraphTailor.getTopProportionalMargin() != d6 / 1000.0 || tSGraphTailor.getBottomProportionalMargin() != d5 / 1000.0) {
            TSEGraphWindow tSEGraphWindow = tSEGraph.getGraphWindow();
            TSESetMarginsCommand tSESetMarginsCommand = new TSESetMarginsCommand(tSEGraph, d4, d2, d3, d, d8 / 1000.0, d6 / 1000.0, d7 / 1000.0, d5 / 1000.0);
            tSEGraphWindow.transmit((TSCommand)tSESetMarginsCommand);
        }
        if (this.marginSpacingSelected.equals(PROPORTIONAL_MARGIN_SPACING)) {
            this.leftMarginSpacingField.setText(String.valueOf(d8));
            this.rightMarginSpacingField.setText(String.valueOf(d7));
            this.topMarginSpacingField.setText(String.valueOf(d6));
            this.bottomMarginSpacingField.setText(String.valueOf(d5));
        } else {
            this.leftMarginSpacingField.setText(String.valueOf(d4));
            this.rightMarginSpacingField.setText(String.valueOf(d3));
            this.topMarginSpacingField.setText(String.valueOf(d2));
            this.bottomMarginSpacingField.setText(String.valueOf(d));
        }
    }

    protected void applyNestedViewSpacingOptions() {
        TSEGraph tSEGraph = this.getGraph();
        TSGraphTailor tSGraphTailor = null;
        if (tSEGraph == null) {
            return;
        }
        tSGraphTailor = tSEGraph.getTailor();
        if (this.nestedViewSpacingSelected.equals(PROPORTIONAL_NESTED_VIEW_SPACING)) {
            this.proportionalTopNestedViewSpacing = this.topNestedViewSpacingField.getText();
            this.proportionalBottomNestedViewSpacing = this.bottomNestedViewSpacingField.getText();
            this.proportionalLeftNestedViewSpacing = this.leftNestedViewSpacingField.getText();
            this.proportionalRightNestedViewSpacing = this.rightNestedViewSpacingField.getText();
        } else {
            this.constantTopNestedViewSpacing = this.topNestedViewSpacingField.getText();
            this.constantBottomNestedViewSpacing = this.bottomNestedViewSpacingField.getText();
            this.constantLeftNestedViewSpacing = this.leftNestedViewSpacingField.getText();
            this.constantRightNestedViewSpacing = this.rightNestedViewSpacingField.getText();
        }
        double d = this.chooseProperValue(this.proportionalTopNestedViewSpacing, tSGraphTailor.getTopNestedViewProportional() * 1000.0);
        double d2 = this.chooseProperValue(this.proportionalBottomNestedViewSpacing, tSGraphTailor.getBottomNestedViewProportional() * 1000.0);
        double d3 = this.chooseProperValue(this.proportionalLeftNestedViewSpacing, tSGraphTailor.getLeftNestedViewProportional() * 1000.0);
        double d4 = this.chooseProperValue(this.proportionalRightNestedViewSpacing, tSGraphTailor.getRightNestedViewProportional() * 1000.0);
        double d5 = this.chooseProperValue(this.constantTopNestedViewSpacing, tSGraphTailor.getTopNestedViewConstant());
        double d6 = this.chooseProperValue(this.constantBottomNestedViewSpacing, tSGraphTailor.getBottomNestedViewConstant());
        double d7 = this.chooseProperValue(this.constantLeftNestedViewSpacing, tSGraphTailor.getLeftNestedViewConstant());
        double d8 = this.chooseProperValue(this.constantRightNestedViewSpacing, tSGraphTailor.getRightNestedViewConstant());
        tSGraphTailor.setTopNestedViewProportional(d / 1000.0);
        tSGraphTailor.setBottomNestedViewProportional(d2 / 1000.0);
        tSGraphTailor.setLeftNestedViewProportional(d3 / 1000.0);
        tSGraphTailor.setRightNestedViewProportional(d4 / 1000.0);
        tSGraphTailor.setTopNestedViewConstant(d5);
        tSGraphTailor.setBottomNestedViewConstant(d6);
        tSGraphTailor.setLeftNestedViewConstant(d7);
        tSGraphTailor.setRightNestedViewConstant(d8);
        if (this.nestedViewSpacingSelected.equals(PROPORTIONAL_NESTED_VIEW_SPACING)) {
            this.topNestedViewSpacingField.setText(String.valueOf(d));
            this.bottomNestedViewSpacingField.setText(String.valueOf(d2));
            this.leftNestedViewSpacingField.setText(String.valueOf(d3));
            this.rightNestedViewSpacingField.setText(String.valueOf(d4));
            this.constantTopNestedViewSpacing = String.valueOf(d5);
            this.constantBottomNestedViewSpacing = String.valueOf(d6);
            this.constantLeftNestedViewSpacing = String.valueOf(d7);
            this.constantRightNestedViewSpacing = String.valueOf(d8);
        } else {
            this.topNestedViewSpacingField.setText(String.valueOf(d5));
            this.bottomNestedViewSpacingField.setText(String.valueOf(d6));
            this.leftNestedViewSpacingField.setText(String.valueOf(d7));
            this.rightNestedViewSpacingField.setText(String.valueOf(d8));
            this.proportionalTopNestedViewSpacing = String.valueOf(d);
            this.proportionalBottomNestedViewSpacing = String.valueOf(d2);
            this.proportionalLeftNestedViewSpacing = String.valueOf(d3);
            this.proportionalRightNestedViewSpacing = String.valueOf(d4);
        }
        if (tSEGraph.getParent() instanceof TSENode && tSEGraph.getParent().isExpanded()) {
            TSExpTransform tSExpTransform = TSNestingManager.fitToNestedGraph((TSDNode)((TSENode)tSEGraph.getParent()));
            tSEGraph.updateTransform(tSExpTransform);
            tSEGraph.getGraphWindow().drawGraph();
            tSEGraph.getGraphWindow().repaint();
        }
    }

    protected void applyIntergraphEdgeSpacingOptions() {
        if (this.getGraph() == null || this.getGraph().getOwnerGraphManager() == null) {
            return;
        }
        this.processDoubleField(this.getGraph().getOwnerGraphManager(), "layout:all:graphManager:horizontalSpacingBetweenIntergraphEdges", this.intergraphEdgeHorizontalSpacingField);
        this.processDoubleField(this.getGraph().getOwnerGraphManager(), "layout:all:graphManager:verticalSpacingBetweenIntergraphEdges", this.intergraphEdgeVerticalSpacingField);
    }

    public void onLayout() {
        super.onLayout();
        TSGraphTailor tSGraphTailor = this.getGraph().getTailor();
        this.constantLeftMargin = String.valueOf(tSGraphTailor.getLeftConstantMargin());
        this.constantRightMargin = String.valueOf(tSGraphTailor.getRightConstantMargin());
        this.constantTopMargin = String.valueOf(tSGraphTailor.getTopConstantMargin());
        this.constantBottomMargin = String.valueOf(tSGraphTailor.getBottomConstantMargin());
        if (this.marginSpacingSelected.equals(CONSTANT_MARGIN_SPACING)) {
            this.leftMarginSpacingField.setText(this.constantLeftMargin);
            this.rightMarginSpacingField.setText(this.constantRightMargin);
            this.topMarginSpacingField.setText(this.constantTopMargin);
            this.bottomMarginSpacingField.setText(this.constantBottomMargin);
        }
    }

    double chooseProperValue(String string, double d) {
        double d2;
        try {
            d2 = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d2 = d;
        }
        return d2;
    }
}

