/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.service.layout.jlayout;

import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.dialog.TSUnsignedDoubleField;
import com.tomsawyer.editor.service.layout.properties.TSETabComponent;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.layout.jlayout.TSHierarchicalLayoutInputTailor;
import com.tomsawyer.service.layout.jlayout.es;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TSEHierarchicalTab
extends TSETabComponent {
    static final String ORIENTATION_TOP_TO_BOTTOM = "ORIENTATION_TOP_TO_BOTTOM";
    static final String ORIENTATION_LEFT_TO_RIGHT = "ORIENTATION_LEFT_TO_RIGHT";
    static final String ORIENTATION_BOTTOM_TO_TOP = "ORIENTATION_BOTTOM_TO_TOP";
    static final String ORIENTATION_RIGHT_TO_LEFT = "ORIENTATION_RIGHT_TO_LEFT";
    static final String ROUTING_ORTHOGONAL = "ROUTING_ORTHOGONAL";
    static final String ROUTING_POLYLINE = "ROUTING_POLYLINE";
    protected JRadioButton orientationLeftToRight;
    protected JRadioButton orientationBottomToTop;
    protected JRadioButton orientationRightToLeft;
    protected JRadioButton orientationTopToBottom;
    protected JRadioButton alignmentTop;
    protected JRadioButton alignmentCenter;
    protected JRadioButton alignmentBottom;
    protected JCheckBox variableLevelSpacing;
    protected TSUnsignedDoubleField horizontalSpacingBetweenNodesField;
    protected TSUnsignedDoubleField verticalSpacingBetweenNodesField;
    protected TSUnsignedDoubleField spacingBetweenBendsField;
    protected TSUnsignedDoubleField horizontalSpacingBetweenEdgesField;
    protected TSUnsignedDoubleField verticalSpacingBetweenEdgesField;
    protected JCheckBox undirected;
    protected JRadioButton qualityDraftRadioButton;
    protected JRadioButton qualityDefaultRadioButton;
    protected JRadioButton qualityProofRadioButton;
    protected JRadioButton routingOrthogonalRadioButton;
    protected JRadioButton routingPolylineRadioButton;
    protected JCheckBox fixNodeSizesCheckBox;

    public TSEHierarchicalTab(TSEGraph tSEGraph, TSServiceInputData tSServiceInputData, JDialog jDialog) {
        super(tSEGraph, tSServiceInputData, jDialog);
    }

    protected void init() {
        super.init();
        this.layoutHelper = new es();
        this.setLayout(new BoxLayout(this, 0));
        this.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setAlignmentY(0.0f);
        JPanel jPanel4 = this.makeOrientationPanel();
        JPanel jPanel5 = this.makeLevelAlignmentPanel();
        JPanel jPanel6 = this.makeLayoutQualityPanel();
        JPanel jPanel7 = this.makeHorizontalSpacingPanel();
        JPanel jPanel8 = this.makeVerticalSpacingPanel();
        JPanel jPanel9 = this.makeRoutingPanel();
        JPanel jPanel10 = this.makeOrthogonalRoutingPanel();
        JPanel jPanel11 = this.makePolylineRoutingPanel();
        JPanel jPanel12 = this.makeMiscPanel();
        jPanel.add(jPanel4);
        jPanel.add(this.createVerticalRigidArea(6));
        jPanel.add(jPanel5);
        Vector<JPanel> vector = new Vector<JPanel>();
        vector.add(jPanel4);
        vector.add(jPanel5);
        this.normalizeComponentDimensions(vector, true, false);
        jPanel2.add(jPanel6);
        jPanel2.add(this.createVerticalRigidArea(6));
        jPanel2.add(jPanel7);
        jPanel2.add(this.createVerticalRigidArea(6));
        jPanel2.add(jPanel8);
        Vector<JPanel> vector2 = new Vector<JPanel>();
        vector2.add(jPanel6);
        vector2.add(jPanel7);
        vector2.add(jPanel8);
        this.normalizeComponentDimensions(vector2, true, false);
        jPanel3.add(jPanel9);
        jPanel3.add(this.createVerticalRigidArea(6));
        jPanel3.add(jPanel10);
        jPanel3.add(this.createVerticalRigidArea(6));
        jPanel3.add(jPanel11);
        jPanel3.add(this.createVerticalRigidArea(6));
        jPanel3.add(jPanel12);
        Vector<JPanel> vector3 = new Vector<JPanel>();
        vector3.add(jPanel9);
        vector3.add(jPanel10);
        vector3.add(jPanel11);
        vector3.add(jPanel12);
        this.normalizeComponentDimensions(vector3, true, false);
        this.add(jPanel);
        this.add(this.createHorizontalRigidArea(6));
        this.add(jPanel2);
        this.add(this.createHorizontalRigidArea(6));
        this.add(jPanel3);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    protected JPanel makeOrientationPanel() {
        JPanel jPanel = new JPanel();
        this.orientationTopToBottom = this.createRadioButton("Top_To_Bottom", ORIENTATION_TOP_TO_BOTTOM);
        this.orientationLeftToRight = this.createRadioButton("Left_To_Right", ORIENTATION_LEFT_TO_RIGHT);
        this.orientationBottomToTop = this.createRadioButton("Bottom_To_Top", ORIENTATION_BOTTOM_TO_TOP);
        this.orientationRightToLeft = this.createRadioButton("Right_To_Left", ORIENTATION_RIGHT_TO_LEFT);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.orientationTopToBottom);
        buttonGroup.add(this.orientationLeftToRight);
        buttonGroup.add(this.orientationBottomToTop);
        buttonGroup.add(this.orientationRightToLeft);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.orientationTopToBottom);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.orientationLeftToRight);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.orientationBottomToTop);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.orientationRightToLeft);
        this.createCompoundBorder(jPanel, "Orientation", 0, 6, 5, 5);
        return jPanel;
    }

    protected JPanel makeLevelAlignmentPanel() {
        this.alignmentTop = this.createRadioButton("Top");
        this.alignmentCenter = this.createRadioButton("Center");
        this.alignmentBottom = this.createRadioButton("Bottom");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.alignmentCenter);
        buttonGroup.add(this.alignmentTop);
        buttonGroup.add(this.alignmentBottom);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.alignmentTop);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.alignmentCenter);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.alignmentBottom);
        this.createCompoundBorder(jPanel, "Level_Alignment", 0, 6, 5, 5);
        return jPanel;
    }

    protected JPanel makeLayoutQualityPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        this.qualityDraftRadioButton = this.createRadioButton("Draft");
        this.qualityDefaultRadioButton = this.createRadioButton("Default");
        this.qualityProofRadioButton = this.createRadioButton("Proof");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.qualityDraftRadioButton);
        buttonGroup.add(this.qualityDefaultRadioButton);
        buttonGroup.add(this.qualityProofRadioButton);
        jPanel.add(this.qualityDraftRadioButton);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.qualityDefaultRadioButton);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.qualityProofRadioButton);
        this.createCompoundBorder(jPanel, "Layout_Quality", 0, 6, 5, 5);
        return jPanel;
    }

    protected JPanel makeHorizontalSpacingPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(true);
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = this.createBoxLayoutPanel(false);
        JPanel jPanel3 = this.createBoxLayoutPanel(false);
        jPanel2.setAlignmentY(0.0f);
        jPanel3.setAlignmentY(0.0f);
        JLabel jLabel = this.createLabel("Spacing_Between_Nodes:");
        JLabel jLabel2 = this.createLabel("Spacing_Between_Edges:");
        this.horizontalSpacingBetweenNodesField = this.createDoubleField(4, 0.0, 9999.0);
        this.horizontalSpacingBetweenEdgesField = this.createDoubleField(4, 0.0, 9999.0);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.horizontalSpacingBetweenNodesField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.horizontalSpacingBetweenEdgesField);
        jPanel.add(jPanel2);
        jPanel.add(this.createHorizontalRigidArea(20));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Horizontal_Spacing", 0, 6, 5, 6);
        return jPanel;
    }

    protected JPanel makeVerticalSpacingPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(true);
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = this.createBoxLayoutPanel(false);
        JPanel jPanel3 = this.createBoxLayoutPanel(false);
        jPanel2.setAlignmentY(0.0f);
        jPanel3.setAlignmentY(0.0f);
        JLabel jLabel = this.createLabel("Spacing_Between_Nodes:");
        JLabel jLabel2 = this.createLabel("Spacing_Between_Edges:");
        this.verticalSpacingBetweenNodesField = this.createDoubleField(4, 0.0, 9999.0);
        this.verticalSpacingBetweenEdgesField = this.createDoubleField(4, 0.0, 9999.0);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.verticalSpacingBetweenNodesField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.verticalSpacingBetweenEdgesField);
        jPanel.add(jPanel2);
        jPanel.add(this.createHorizontalRigidArea(20));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Vertical_Spacing", 0, 6, 5, 6);
        return jPanel;
    }

    protected JPanel makeRoutingPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        this.routingOrthogonalRadioButton = this.createRadioButton("Orthogonal", ROUTING_ORTHOGONAL);
        this.routingPolylineRadioButton = this.createRadioButton("Polyline", ROUTING_POLYLINE);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.routingOrthogonalRadioButton);
        buttonGroup.add(this.routingPolylineRadioButton);
        jPanel.add(this.routingOrthogonalRadioButton);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.routingPolylineRadioButton);
        this.createCompoundBorder(jPanel, "Routing", 0, 6, 5, 5);
        return jPanel;
    }

    protected JPanel makeOrthogonalRoutingPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        this.fixNodeSizesCheckBox = this.createCheckbox("Fix_Node_Sizes");
        jPanel.add(this.fixNodeSizesCheckBox);
        this.createCompoundBorder(jPanel, "Orthogonal_Routing", 0, 6, 5, 5);
        return jPanel;
    }

    protected JPanel makePolylineRoutingPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(true);
        jPanel.setAlignmentX(0.0f);
        JLabel jLabel = this.createLabel("Spacing_Between_Bends:");
        this.spacingBetweenBendsField = this.createDoubleField(4, 0.0, 9999.0);
        jPanel.add(jLabel);
        jPanel.add(this.createHorizontalRigidArea(20));
        jPanel.add((Component)this.spacingBetweenBendsField);
        this.createCompoundBorder(jPanel, "Polyline_Routing", 0, 6, 5, 5);
        return jPanel;
    }

    protected JPanel makeMiscPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(false);
        jPanel.setAlignmentX(0.0f);
        this.variableLevelSpacing = this.createCheckbox("Variable_Level_Spacing");
        this.undirected = this.createCheckbox("Undirected_Layout");
        jPanel.add(this.variableLevelSpacing);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.undirected);
        this.createEmptyBorder(jPanel, 3, 2, 0, 0);
        return jPanel;
    }

    public void setValues(TSServiceInputData tSServiceInputData) {
        TSHierarchicalLayoutInputTailor tSHierarchicalLayoutInputTailor = new TSHierarchicalLayoutInputTailor(tSServiceInputData, (TSDGraph)this.getGraph());
        int n = tSHierarchicalLayoutInputTailor.getLevelDirection();
        if (n == 0) {
            this.orientationLeftToRight.setSelected(true);
        } else if (n == 1) {
            this.orientationBottomToTop.setSelected(true);
        } else if (n == 2) {
            this.orientationRightToLeft.setSelected(true);
        } else {
            this.orientationTopToBottom.setSelected(true);
        }
        this.onOrientationChanged();
        int n2 = tSHierarchicalLayoutInputTailor.getLevelAlignment();
        if (n2 == 0) {
            this.alignmentCenter.setSelected(true);
        } else if (n2 == 1) {
            this.alignmentTop.setSelected(true);
        } else {
            this.alignmentBottom.setSelected(true);
        }
        int n3 = tSHierarchicalLayoutInputTailor.getQuality();
        if (n3 == 0) {
            this.qualityDraftRadioButton.setSelected(true);
        } else if (n3 == 1) {
            this.qualityDefaultRadioButton.setSelected(true);
        } else {
            this.qualityProofRadioButton.setSelected(true);
        }
        this.horizontalSpacingBetweenNodesField.setText(String.valueOf(tSHierarchicalLayoutInputTailor.getConstantHorizontalSpacingBetweenNodes()));
        this.verticalSpacingBetweenNodesField.setText(String.valueOf(tSHierarchicalLayoutInputTailor.getConstantVerticalSpacingBetweenNodes()));
        this.horizontalSpacingBetweenEdgesField.setText(String.valueOf(tSHierarchicalLayoutInputTailor.getHorizontalSpacingBetweenEdges()));
        this.verticalSpacingBetweenEdgesField.setText(String.valueOf(tSHierarchicalLayoutInputTailor.getVerticalSpacingBetweenEdges()));
        boolean bl = tSHierarchicalLayoutInputTailor.getOrthogonalRouting();
        if (bl) {
            this.routingOrthogonalRadioButton.setSelected(true);
        } else {
            this.routingPolylineRadioButton.setSelected(true);
        }
        this.onRoutingChanged();
        this.fixNodeSizesCheckBox.setSelected(tSHierarchicalLayoutInputTailor.getKeepNodeSizes());
        this.spacingBetweenBendsField.setText(String.valueOf(tSHierarchicalLayoutInputTailor.getEdgeSpacing()));
        this.variableLevelSpacing.setSelected(tSHierarchicalLayoutInputTailor.getVariableLevelSpacing());
        this.undirected.setSelected(tSHierarchicalLayoutInputTailor.getUndirected());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.startsWith("ORIENTATION")) {
            this.onOrientationChanged();
        } else if (string.startsWith("ROUTING")) {
            this.onRoutingChanged();
        }
        this.activateButtons();
    }

    protected void onOrientationChanged() {
        if (this.orientationLeftToRight.isSelected() || this.orientationRightToLeft.isSelected()) {
            this.alignmentTop.setText(" " + this.translateText("Left"));
            this.alignmentBottom.setText(" " + this.translateText("Right"));
        } else {
            this.alignmentTop.setText(" " + this.translateText("Top"));
            this.alignmentBottom.setText(" " + this.translateText("Bottom"));
        }
        this.activateButtons();
    }

    protected void onRoutingChanged() {
        if (this.routingOrthogonalRadioButton.isSelected()) {
            this.enable((JComponent)this.horizontalSpacingBetweenEdgesField);
            this.enable((JComponent)this.verticalSpacingBetweenEdgesField);
            this.enable(this.fixNodeSizesCheckBox);
            this.disable((JComponent)this.spacingBetweenBendsField);
        } else {
            this.disable((JComponent)this.horizontalSpacingBetweenEdgesField);
            this.disable((JComponent)this.verticalSpacingBetweenEdgesField);
            this.disable(this.fixNodeSizesCheckBox);
            this.enable((JComponent)this.spacingBetweenBendsField);
        }
    }

    public void onApply() {
        super.onApply();
        int n = this.orientationLeftToRight.isSelected() ? 0 : (this.orientationBottomToTop.isSelected() ? 1 : (this.orientationRightToLeft.isSelected() ? 2 : 3));
        this.processChoices("layout:hierarchical:graph:levelDirection", n);
        int n2 = this.alignmentCenter.isSelected() ? 0 : (this.alignmentTop.isSelected() ? 1 : 2);
        this.processChoices("layout:hierarchical:graph:levelAlignment", n2);
        int n3 = this.qualityDraftRadioButton.isSelected() ? 0 : (this.qualityDefaultRadioButton.isSelected() ? 1 : 2);
        this.processChoices("layout:hierarchical:graph:quality", n3);
        this.processDoubleField("layout:hierarchical:graph:constantVerticalSpacingBetweenNodes", this.verticalSpacingBetweenNodesField);
        this.processDoubleField("layout:hierarchical:graph:constantHorizontalSpacingBetweenNodes", this.horizontalSpacingBetweenNodesField);
        this.processDoubleField("layout:hierarchical:graph:horizontalSpacingBetweenEdges", this.horizontalSpacingBetweenEdgesField);
        this.processDoubleField("layout:hierarchical:graph:verticalSpacingBetweenEdges", this.verticalSpacingBetweenEdgesField);
        this.processChoices("layout:hierarchical:graph:orthogonalRouting", this.routingOrthogonalRadioButton.isSelected());
        this.processCheckbox("layout:hierarchical:graph:keepNodeSizes", this.fixNodeSizesCheckBox);
        this.processDoubleField("layout:hierarchical:graph:edgeSpacing", this.spacingBetweenBendsField);
        this.processCheckbox("layout:hierarchical:graph:variableLevelSpacing", this.variableLevelSpacing);
        this.processCheckbox("layout:hierarchical:graph:undirected", this.undirected);
    }

    public int getLayoutStyle() {
        return 1;
    }
}

