/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.service.layout.jlayout;

import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.dialog.TSUnsignedDoubleField;
import com.tomsawyer.editor.service.layout.properties.TSETabComponent;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.layout.jlayout.TSRoutingInputTailor;
import com.tomsawyer.service.layout.jlayout.es;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TSERoutingTab
extends TSETabComponent {
    TSUnsignedDoubleField horizontalSpacingBetweenNodesField;
    TSUnsignedDoubleField verticalSpacingBetweenNodesField;
    TSUnsignedDoubleField horizontalSpacingBetweenEdgesField;
    TSUnsignedDoubleField verticalSpacingBetweenEdgesField;
    JCheckBox fixNodeSizesCheckBox;
    JCheckBox fixNodePositionsCheckBox;

    public TSERoutingTab(TSEGraph tSEGraph, TSServiceInputData tSServiceInputData, JDialog jDialog) {
        super(tSEGraph, tSServiceInputData, jDialog);
    }

    protected void init() {
        super.init();
        super.init();
        this.layoutHelper = new es();
        this.setLayout(new BoxLayout(this, 0));
        this.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        JPanel jPanel2 = this.makeHorizontalSpacingPanel();
        JPanel jPanel3 = this.makeVerticalSpacingPanel();
        JPanel jPanel4 = this.makeMiscPanel();
        jPanel.add(jPanel2);
        jPanel.add(this.createVerticalRigidArea(6));
        jPanel.add(jPanel3);
        jPanel.add(this.createVerticalRigidArea(6));
        jPanel.add(jPanel4);
        Vector<JPanel> vector = new Vector<JPanel>();
        vector.add(jPanel2);
        vector.add(jPanel3);
        vector.add(jPanel4);
        this.normalizeComponentDimensions(vector, true, false);
        this.add(jPanel);
        this.createEmptyBorder(this, 5, 5, 5, 5);
    }

    protected JPanel makeHorizontalSpacingPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(true);
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = this.createBoxLayoutPanel(false);
        JPanel jPanel3 = this.createBoxLayoutPanel(false);
        jPanel2.setAlignmentY(0.0f);
        jPanel3.setAlignmentY(0.0f);
        JLabel jLabel = this.createLabel("Spacing_Between_Nodes:");
        JLabel jLabel2 = this.createLabel("Spacing_Between_Edges:");
        this.horizontalSpacingBetweenNodesField = this.createDoubleField(4, 0.0, 9999.0);
        this.horizontalSpacingBetweenEdgesField = this.createDoubleField(4, 0.0, 9999.0);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.horizontalSpacingBetweenNodesField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.horizontalSpacingBetweenEdgesField);
        jPanel.add(jPanel2);
        jPanel.add(this.createHorizontalRigidArea(20));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Horizontal_Spacing", 0, 6, 5, 6);
        return jPanel;
    }

    protected JPanel makeVerticalSpacingPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(true);
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = this.createBoxLayoutPanel(false);
        JPanel jPanel3 = this.createBoxLayoutPanel(false);
        jPanel2.setAlignmentY(0.0f);
        jPanel3.setAlignmentY(0.0f);
        JLabel jLabel = this.createLabel("Spacing_Between_Nodes:");
        JLabel jLabel2 = this.createLabel("Spacing_Between_Edges:");
        this.verticalSpacingBetweenNodesField = this.createDoubleField(4, 0.0, 9999.0);
        this.verticalSpacingBetweenEdgesField = this.createDoubleField(4, 0.0, 9999.0);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.verticalSpacingBetweenNodesField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.verticalSpacingBetweenEdgesField);
        jPanel.add(jPanel2);
        jPanel.add(this.createHorizontalRigidArea(20));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Vertical_Spacing", 0, 6, 5, 6);
        return jPanel;
    }

    protected JPanel makeMiscPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        this.fixNodeSizesCheckBox = this.createCheckbox("Fix_Node_Sizes");
        this.fixNodePositionsCheckBox = this.createCheckbox("Fix_Node_Positions");
        jPanel.add(this.fixNodeSizesCheckBox);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.fixNodePositionsCheckBox);
        this.createEmptyBorder(jPanel, 3, 2, 0, 0);
        return jPanel;
    }

    public void setValues(TSServiceInputData tSServiceInputData) {
        TSRoutingInputTailor tSRoutingInputTailor = new TSRoutingInputTailor(tSServiceInputData);
        this.horizontalSpacingBetweenNodesField.setText(String.valueOf(tSRoutingInputTailor.getHorizontalSpacingBetweenNodes()));
        this.verticalSpacingBetweenNodesField.setText(String.valueOf(tSRoutingInputTailor.getVerticalSpacingBetweenNodes()));
        this.verticalSpacingBetweenEdgesField.setText(String.valueOf(tSRoutingInputTailor.getVerticalSpacingBetweenEdges()));
        this.horizontalSpacingBetweenEdgesField.setText(String.valueOf(tSRoutingInputTailor.getHorizontalSpacingBetweenEdges()));
        this.fixNodePositionsCheckBox.setSelected(tSRoutingInputTailor.getFixedPositions());
        this.fixNodeSizesCheckBox.setSelected(tSRoutingInputTailor.getFixedSizes());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.activateButtons();
    }

    public int getOperation() {
        return 1001;
    }

    public void onApply() {
        super.onApply();
        TSEGraphManager tSEGraphManager = (TSEGraphManager)this.getGraph().getOwnerGraphManager();
        this.processDoubleField(tSEGraphManager, "routing:all:graphManager:horizontalSpacingBetweenNodes", this.horizontalSpacingBetweenNodesField);
        this.processDoubleField(tSEGraphManager, "routing:all:graphManager:verticalSpacingBetweenNodes", this.verticalSpacingBetweenNodesField);
        this.processDoubleField(tSEGraphManager, "routing:all:graphManager:verticalSpacingBetweenEdges", this.verticalSpacingBetweenEdgesField);
        this.processDoubleField(tSEGraphManager, "routing:all:graphManager:horizontalSpacingBetweenEdges", this.horizontalSpacingBetweenEdgesField);
        this.processCheckbox(tSEGraphManager, "routing:all:graphManager:fixedPosition", this.fixNodePositionsCheckBox);
        this.processCheckbox(tSEGraphManager, "routing:all:graphManager:fixedSize", this.fixNodeSizesCheckBox);
    }
}

