/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.service.layout.jlayout;

import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.service.TSConstraint;
import com.tomsawyer.service.layout.TSSingleNodeListLayoutConstraint;
import com.tomsawyer.service.layout.jlayout.TSHasAlignmentConstraint;
import com.tomsawyer.service.layout.jlayout.TSHasOrientationConstraint;
import com.tomsawyer.util.TSParser;
import java.io.IOException;

public class TSAlignmentConstraint
extends TSSingleNodeListLayoutConstraint
implements TSHasOrientationConstraint,
TSHasAlignmentConstraint {
    private int orientation;
    private int alignment = 0;

    public TSAlignmentConstraint() {
        this(-1, 0, 0);
    }

    public TSAlignmentConstraint(int n, int n2, int n3) {
        super(n, n2);
        this.orientation = n3;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new RuntimeException("Invalid parameter.");
        }
        int n2 = this.orientation;
        this.orientation = n;
        if (n2 != n) {
            this.fireConstraintChangedEvent();
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 2 && n != 1) {
            throw new RuntimeException("Invalid parameter.");
        }
        int n2 = this.alignment;
        this.alignment = n;
        if (n2 != n) {
            this.fireConstraintChangedEvent();
        }
    }

    public boolean checkValidity() {
        return this.getNodeList().size() >= 2 && super.checkValidity();
    }

    public TSConstraint cloneWithAttributes() {
        TSAlignmentConstraint tSAlignmentConstraint = new TSAlignmentConstraint(this.getStyle(), this.getPriority(), this.getOrientation());
        tSAlignmentConstraint.setAlignment(this.getAlignment());
        return tSAlignmentConstraint;
    }

    protected void copy(TSConstraint tSConstraint) {
        super.copy(tSConstraint);
        if (tSConstraint instanceof TSAlignmentConstraint) {
            this.alignment = ((TSAlignmentConstraint)tSConstraint).getAlignment();
            this.orientation = ((TSAlignmentConstraint)tSConstraint).getOrientation();
        }
    }

    public void read(TSGraphObjectTable tSGraphObjectTable, TSParser tSParser) throws IOException {
        super.read(tSGraphObjectTable, tSParser);
        tSParser.parseInputString("orientation");
        this.setOrientation(tSParser.getInt());
        tSParser.parseInputString("alignment");
        this.setAlignment(tSParser.getInt());
    }
}

