/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.apisupport.project.universe.TestModuleDependency;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectXMLManager {
    private static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    private static final String BINARY_ORIGIN = "binary-origin";
    private static final String BUILD_PREREQUISITE = "build-prerequisite";
    private static final String CLASS_PATH_BINARY_ORIGIN = "binary-origin";
    private static final String CLASS_PATH_EXTENSION = "class-path-extension";
    private static final String CLASS_PATH_RUNTIME_PATH = "runtime-relative-path";
    private static final String CODE_NAME_BASE = "code-name-base";
    private static final String COMPILE_DEPENDENCY = "compile-dependency";
    private static final String DATA = "data";
    private static final String DEPENDENCY = "dependency";
    private static final String EXTRA_COMPILATION_UNIT = "extra-compilation-unit";
    private static final String FRIEND = "friend";
    private static final String FRIEND_PACKAGES = "friend-packages";
    private static final String IMPLEMENTATION_VERSION = "implementation-version";
    private static final String MODULE_DEPENDENCIES = "module-dependencies";
    private static final String PACKAGE = "package";
    private static final String PUBLIC_PACKAGES = "public-packages";
    private static final String RELEASE_VERSION = "release-version";
    private static final String RUN_DEPENDENCY = "run-dependency";
    private static final String SPECIFICATION_VERSION = "specification-version";
    private static final String STANDALONE = "standalone";
    private static final String SUBPACKAGES = "subpackages";
    private static final String SUITE_COMPONENT = "suite-component";
    private static final String TEST_DEPENDENCIES = "test-dependencies";
    private static final String TEST_TYPE_NAME = "name";
    private static final String TEST_DEPENDENCY = "test-dependency";
    private static final String TEST_DEPENDENCY_CNB = "code-name-base";
    private static final String TEST_DEPENDENCY_RECURSIVE = "recursive";
    private static final String TEST_DEPENDENCY_COMPILE = "compile-dependency";
    private static final String TEST_DEPENDENCY_TEST = "test";
    private static final String TEST_TYPE = "test-type";
    private final NbModuleProject project;
    private NbPlatform customPlaf;
    private String cnb;
    private SortedSet<ModuleDependency> directDeps;
    private ManifestManager.PackageExport[] publicPackages;
    private String[] cpExtensions;
    private String[] friends;
    private Element confData;

    public ProjectXMLManager(NbModuleProject nbModuleProject) {
        this.project = nbModuleProject;
    }

    public static ProjectXMLManager getInstance(File file) throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        NbModuleProject nbModuleProject = (NbModuleProject)ProjectManager.getDefault().findProject(fileObject);
        return new ProjectXMLManager(nbModuleProject);
    }

    public void setModuleType(NbModuleProvider.NbModuleType nbModuleType) {
        Element element;
        Element element2 = this.getConfData();
        Document document = element2.getOwnerDocument();
        Element element3 = ProjectXMLManager.findElement(element2, STANDALONE);
        if (element3 != null && nbModuleType == NbModuleProvider.STANDALONE) {
            return;
        }
        Element element4 = ProjectXMLManager.findElement(element2, SUITE_COMPONENT);
        if (element4 != null && nbModuleType == NbModuleProvider.SUITE_COMPONENT) {
            return;
        }
        if (element4 == null && element3 == null && nbModuleType == NbModuleProvider.NETBEANS_ORG) {
            return;
        }
        if (element4 != null) {
            element2.removeChild(element4);
        }
        if (element3 != null) {
            element2.removeChild(element3);
        }
        if ((element = ProjectXMLManager.createTypeElement(document, nbModuleType)) != null) {
            element2.insertBefore(element, ProjectXMLManager.findModuleDependencies(element2));
        }
        this.project.putPrimaryConfigurationData(element2);
    }

    public SortedSet<ModuleDependency> getDirectDependencies() throws IOException {
        return this.getDirectDependencies(null);
    }

    public SortedSet<ModuleDependency> getDirectDependencies(NbPlatform nbPlatform) throws IOException {
        if (this.customPlaf == nbPlatform && this.directDeps != null) {
            return this.directDeps;
        }
        this.customPlaf = nbPlatform;
        TreeSet<ModuleDependency> treeSet = new TreeSet<ModuleDependency>(ModuleDependency.CNB_COMPARATOR);
        Element element = ProjectXMLManager.findModuleDependencies(this.getConfData());
        assert (element != null) : "Cannot find <module-dependencies> for: " + this.project;
        File file = this.project.getProjectDirectoryFile();
        ModuleList moduleList = nbPlatform != null ? ModuleList.getModuleList(file, nbPlatform.getDestDir()) : ModuleList.getModuleList(file);
        for (Element element2 : Util.findSubElements(element)) {
            Element element3;
            Element element4;
            ModuleDependency moduleDependency;
            Object object;
            Element element5 = ProjectXMLManager.findElement(element2, "code-name-base");
            String string = Util.findText(element5);
            ModuleEntry moduleEntry = moduleList.getEntry(string);
            if (moduleEntry == null) {
                Util.err.log(16, "Detected dependency on module which cannot be found in the current module's universe (platform, suite): " + string + " (skipping)");
                continue;
            }
            Element element6 = ProjectXMLManager.findElement(element2, RUN_DEPENDENCY);
            if (element6 == null) {
                if (treeSet.add(new ModuleDependency(moduleEntry))) continue;
                object = "Corrupted project metadata (project.xml). Duplicate dependency entry found: " + moduleEntry;
                Util.err.log(16, (String)object);
                throw new IllegalStateException((String)object);
            }
            object = ProjectXMLManager.findElement(element6, RELEASE_VERSION);
            String string2 = null;
            if (object != null) {
                string2 = Util.findText((Element)object);
            }
            Element element7 = ProjectXMLManager.findElement(element6, SPECIFICATION_VERSION);
            String string3 = null;
            if (element7 != null) {
                string3 = Util.findText(element7);
            }
            if (treeSet.add(moduleDependency = new ModuleDependency(moduleEntry, string2, string3, (element4 = ProjectXMLManager.findElement(element2, "compile-dependency")) != null, (element3 = ProjectXMLManager.findElement(element6, IMPLEMENTATION_VERSION)) != null))) continue;
            String string4 = "Corrupted project metadata (project.xml). Duplicate dependency entry found: " + moduleDependency;
            Util.err.log(16, string4);
            throw new IllegalStateException(string4);
        }
        this.directDeps = Collections.unmodifiableSortedSet(treeSet);
        return this.directDeps;
    }

    public void removeDependency(String string) {
        Element element = this.getConfData();
        Element element2 = ProjectXMLManager.findModuleDependencies(element);
        List<Element> list = Util.findSubElements(element2);
        for (Element element3 : list) {
            Element element4 = ProjectXMLManager.findElement(element3, "code-name-base");
            String string2 = Util.findText(element4);
            if (!string.equals(string2)) continue;
            element2.removeChild(element3);
        }
        this.project.putPrimaryConfigurationData(element);
    }

    public void removeDependencies(Collection<ModuleDependency> collection) {
        HashSet<String> hashSet = new HashSet<String>(collection.size());
        for (ModuleDependency moduleDependency : collection) {
            hashSet.add(moduleDependency.getModuleEntry().getCodeNameBase());
        }
        this.removeDependenciesByCNB(hashSet);
    }

    public void removeDependenciesByCNB(Collection<String> collection) {
        Element element = this.getConfData();
        Element element2 = ProjectXMLManager.findModuleDependencies(element);
        for (Element element3 : Util.findSubElements(element2)) {
            Element element4 = ProjectXMLManager.findElement(element3, "code-name-base");
            String string = Util.findText(element4);
            if (collection.remove(string)) {
                element2.removeChild(element3);
            }
            if (collection.size() != 0) continue;
            break;
        }
        if (collection.size() != 0) {
            Util.err.log(16, "Some modules weren't deleted: " + collection);
        }
        this.project.putPrimaryConfigurationData(element);
    }

    public void editDependency(ModuleDependency moduleDependency, ModuleDependency moduleDependency2) {
        Element element = this.getConfData();
        Element element2 = ProjectXMLManager.findModuleDependencies(element);
        List<Element> list = Util.findSubElements(element2);
        Iterator<Element> iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element3 = iterator.next();
            Element element4 = ProjectXMLManager.findElement(element3, "code-name-base");
            String string = Util.findText(element4);
            if (!string.equals(moduleDependency.getModuleEntry().getCodeNameBase())) continue;
            element2.removeChild(element3);
            Element element5 = iterator.hasNext() ? iterator.next() : null;
            ProjectXMLManager.createModuleDependencyElement(element2, moduleDependency2, element5);
            break;
        }
        this.project.putPrimaryConfigurationData(element);
    }

    public void addDependency(ModuleDependency moduleDependency) throws IOException {
        this.addDependencies(Collections.singleton(moduleDependency));
    }

    public void addDependencies(Set<ModuleDependency> set) throws IOException {
        TreeSet<ModuleDependency> treeSet = new TreeSet<ModuleDependency>(this.getDirectDependencies());
        if (treeSet.addAll(set)) {
            this.replaceDependencies(treeSet);
        }
    }

    public void replaceDependencies(Set<ModuleDependency> set) {
        Element element = this.getConfData();
        Document document = element.getOwnerDocument();
        Element element2 = ProjectXMLManager.findModuleDependencies(element);
        element.removeChild(element2);
        element2 = ProjectXMLManager.createModuleElement(document, MODULE_DEPENDENCIES);
        Element element3 = ProjectXMLManager.findTestDependenciesElement(element);
        if (element3 == null) {
            element3 = ProjectXMLManager.findPublicPackagesElement(element);
        }
        if (element3 == null) {
            element3 = ProjectXMLManager.findFriendsElement(element);
        }
        assert (element3 != null) : "There must be public-packages or friend-packages element according to XSD";
        element.insertBefore(element2, element3);
        TreeSet<ModuleDependency> treeSet = new TreeSet<ModuleDependency>(set);
        for (ModuleDependency moduleDependency : treeSet) {
            ProjectXMLManager.createModuleDependencyElement(element2, moduleDependency, null);
        }
        this.project.putPrimaryConfigurationData(element);
        this.directDeps = treeSet;
    }

    public void removeClassPathExtensions() {
        Element element = this.getConfData();
        NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/nb-module-project/3", CLASS_PATH_EXTENSION);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element.removeChild(nodeList.item(i));
        }
        this.project.putPrimaryConfigurationData(element);
    }

    public boolean removeTestDependency(String string, String string2) {
        String string3;
        Element element;
        boolean bl = false;
        Element element2 = this.getConfData();
        Element element3 = ProjectXMLManager.findTestDependenciesElement(element2);
        Element element4 = null;
        for (Element element5 : Util.findSubElements(element3)) {
            element = ProjectXMLManager.findElement(element5, TEST_TYPE_NAME);
            string3 = Util.findText(element);
            if (!string.equals(string3)) continue;
            element4 = element5;
        }
        if (element4 != null) {
            for (Element element5 : Util.findSubElements(element4)) {
                element = ProjectXMLManager.findElement(element5, "code-name-base");
                if (element == null || !string2.equals(string3 = Util.findText(element))) continue;
                element4.removeChild(element5);
                bl = true;
                this.project.putPrimaryConfigurationData(element2);
            }
        }
        return bl;
    }

    public void addTestDependency(String string, TestModuleDependency testModuleDependency) throws IOException {
        Object object;
        Element element5;
        Element element2;
        assert ("unit".equals(string) || "qa-functional".equals(string)) : "Current impl.supports only qa-functional or unit tests";
        File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        ModuleList moduleList = ModuleList.getModuleList(file);
        HashMap<String, Set<TestModuleDependency>> hashMap = new HashMap<String, Set<TestModuleDependency>>(this.getTestDependencies(moduleList));
        TreeSet<TestModuleDependency> treeSet = (TreeSet<TestModuleDependency>)hashMap.get(string);
        if (treeSet == null) {
            treeSet = new TreeSet<TestModuleDependency>();
            hashMap.put(string, treeSet);
        } else {
            treeSet = new TreeSet(treeSet);
        }
        if (!treeSet.add(testModuleDependency)) {
            return;
        }
        Element element3 = this.getConfData();
        Document document = element3.getOwnerDocument();
        Element element4 = ProjectXMLManager.findTestDependenciesElement(element3);
        if (element4 == null) {
            element2 = ProjectXMLManager.findPublicPackagesElement(element3);
            if (element2 == null) {
                element2 = ProjectXMLManager.findFriendsElement(element3);
            }
            assert (element2 != null) : "There must be public-packages or friend-packages element according to XSD";
            element4 = ProjectXMLManager.createModuleElement(document, TEST_DEPENDENCIES);
            element3.insertBefore(element4, element2);
        }
        element2 = null;
        for (Element element5 : Util.findSubElements(element4)) {
            Element element6 = ProjectXMLManager.findElement(element5, TEST_TYPE_NAME);
            assert (element6 != null) : "should be some child with name";
            assert (TEST_TYPE_NAME.equals(element6.getLocalName())) : "name node should be first child, but was:" + element6.getLocalName() + "or" + element6.getNodeName();
            if (!element6.getTextContent().equals(string)) continue;
            element2 = element5;
        }
        if (element2 == null) {
            object = this.createNewTestTypeElement(document, string);
            element4.appendChild((Node)object);
            this.createTestModuleDependencyElement((Element)object, testModuleDependency);
            this.project.putPrimaryConfigurationData(element3);
            return;
        }
        object = element2.getNextSibling();
        element4.removeChild(element2);
        element5 = this.createNewTestTypeElement(document, string);
        if (object == null) {
            element4.appendChild(element5);
        } else {
            element4.insertBefore(element5, (Node)object);
        }
        for (TestModuleDependency testModuleDependency2 : treeSet) {
            this.createTestModuleDependencyElement(element5, testModuleDependency2);
            this.project.putPrimaryConfigurationData(element3);
        }
    }

    private Element createNewTestTypeElement(Document document, String string) {
        Element element = ProjectXMLManager.createModuleElement(document, TEST_TYPE);
        Element element2 = ProjectXMLManager.createModuleElement(document, TEST_TYPE_NAME, string);
        element.appendChild(element2);
        return element;
    }

    private void createTestModuleDependencyElement(Element element, TestModuleDependency testModuleDependency) {
        Document document = element.getOwnerDocument();
        Element element2 = ProjectXMLManager.createModuleElement(document, TEST_DEPENDENCY);
        element.appendChild(element2);
        element2.appendChild(ProjectXMLManager.createModuleElement(document, "code-name-base", testModuleDependency.getModule().getCodeNameBase()));
        if (testModuleDependency.isRecursive()) {
            element2.appendChild(ProjectXMLManager.createModuleElement(document, TEST_DEPENDENCY_RECURSIVE));
        }
        if (testModuleDependency.isCompile()) {
            element2.appendChild(ProjectXMLManager.createModuleElement(document, "compile-dependency"));
        }
        if (testModuleDependency.isTest()) {
            element2.appendChild(ProjectXMLManager.createModuleElement(document, TEST_DEPENDENCY_TEST));
        }
    }

    public Map<String, Set<TestModuleDependency>> getTestDependencies(ModuleList moduleList) {
        Element element = ProjectXMLManager.findTestDependenciesElement(this.getConfData());
        HashMap<String, Set<TestModuleDependency>> hashMap = new HashMap<String, Set<TestModuleDependency>>();
        if (element != null) {
            for (Element element2 : Util.findSubElements(element)) {
                Element element3 = ProjectXMLManager.findElement(element2, TEST_TYPE_NAME);
                String string = null;
                if (element3 != null) {
                    string = Util.findText(element3);
                }
                if (string == null) {
                    string = "unit";
                }
                TreeSet<TestModuleDependency> treeSet = new TreeSet<TestModuleDependency>();
                for (Element element4 : Util.findSubElements(element2)) {
                    TestModuleDependency testModuleDependency;
                    ModuleEntry moduleEntry;
                    boolean bl;
                    if (!element4.getTagName().equals(TEST_DEPENDENCY)) continue;
                    Element element5 = ProjectXMLManager.findElement(element4, "code-name-base");
                    boolean bl2 = ProjectXMLManager.findElement(element4, TEST_DEPENDENCY_TEST) != null;
                    String string2 = null;
                    if (element5 != null) {
                        string2 = Util.findText(element5);
                    }
                    boolean bl3 = ProjectXMLManager.findElement(element4, TEST_DEPENDENCY_RECURSIVE) != null;
                    boolean bl4 = bl = ProjectXMLManager.findElement(element4, "compile-dependency") != null;
                    if (string2 == null || (moduleEntry = moduleList.getEntry(string2)) == null || treeSet.add(testModuleDependency = new TestModuleDependency(moduleEntry, bl2, bl3, bl))) continue;
                    String string3 = this.project.getPathWithinNetBeansOrg();
                    if (string3 == null) {
                        string3 = this.project.getProjectDirectoryFile().getAbsolutePath();
                    }
                    String string4 = "Invalid project.xml (" + string3 + "); testdependency " + testModuleDependency.getModule().getCodeNameBase() + " is duplicated!";
                    Util.err.log(16, string4);
                }
                hashMap.put(string, treeSet);
            }
        }
        return hashMap;
    }

    public void replaceClassPathExtensions(Map map) {
        this.removeClassPathExtensions();
        if (map != null && map.size() > 0) {
            Element element = this.getConfData();
            Document document = element.getOwnerDocument();
            for (Map.Entry entry : map.entrySet()) {
                Element element2 = ProjectXMLManager.createModuleElement(document, CLASS_PATH_EXTENSION);
                Element element3 = ProjectXMLManager.createModuleElement(document, CLASS_PATH_RUNTIME_PATH, (String)entry.getKey());
                Element element4 = ProjectXMLManager.createModuleElement(document, "binary-origin", (String)entry.getValue());
                element2.appendChild(element3);
                element2.appendChild(element4);
                element.appendChild(element2);
            }
            this.project.putPrimaryConfigurationData(element);
        }
    }

    public void replacePublicPackages(String[] stringArray) {
        this.removePublicAndFriends();
        Element element = this.getConfData();
        Document document = element.getOwnerDocument();
        Element element2 = ProjectXMLManager.createModuleElement(document, PUBLIC_PACKAGES);
        this.insertPublicOrFriend(element2);
        for (int i = 0; i < stringArray.length; ++i) {
            element2.appendChild(ProjectXMLManager.createModuleElement(document, PACKAGE, stringArray[i]));
        }
        this.project.putPrimaryConfigurationData(element);
        this.publicPackages = null;
    }

    private void insertPublicOrFriend(Element element) {
        Element element2 = ProjectXMLManager.findElement(this.getConfData(), CLASS_PATH_EXTENSION);
        if (element2 == null) {
            element2 = ProjectXMLManager.findElement(this.getConfData(), EXTRA_COMPILATION_UNIT);
        }
        this.getConfData().insertBefore(element, element2);
    }

    public void replaceFriends(String[] stringArray, String[] stringArray2) {
        int n;
        this.removePublicAndFriends();
        Element element = this.getConfData();
        Document document = element.getOwnerDocument();
        Element element2 = ProjectXMLManager.createModuleElement(document, FRIEND_PACKAGES);
        this.insertPublicOrFriend(element2);
        for (n = 0; n < stringArray.length; ++n) {
            element2.appendChild(ProjectXMLManager.createModuleElement(document, FRIEND, stringArray[n]));
        }
        for (n = 0; n < stringArray2.length; ++n) {
            element2.appendChild(ProjectXMLManager.createModuleElement(document, PACKAGE, stringArray2[n]));
        }
        this.project.putPrimaryConfigurationData(element);
        this.publicPackages = null;
    }

    public ManifestManager.PackageExport[] getPublicPackages() {
        if (this.publicPackages == null) {
            this.publicPackages = ProjectXMLManager.findPublicPackages(this.getConfData());
        }
        return this.publicPackages;
    }

    public String[] getFriends() {
        if (this.friends == null) {
            this.friends = ProjectXMLManager.findFriends(this.getConfData());
        }
        return this.friends;
    }

    public String[] getBinaryOrigins() {
        if (this.cpExtensions != null) {
            return this.cpExtensions;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Element element : Util.findSubElements(this.getConfData())) {
            Element element2;
            if (!CLASS_PATH_EXTENSION.equals(element.getTagName()) || (element2 = ProjectXMLManager.findElement(element, "binary-origin")) == null) continue;
            treeSet.add(Util.findText(element2));
        }
        this.cpExtensions = treeSet.toArray(new String[treeSet.size()]);
        return this.cpExtensions;
    }

    public String getCodeNameBase() {
        if (this.cnb == null) {
            Element element = ProjectXMLManager.findElement(this.getConfData(), "code-name-base");
            this.cnb = Util.findText(element);
        }
        return this.cnb;
    }

    static void createModuleDependencyElement(Element element, ModuleDependency moduleDependency, Element element2) {
        Document document = element.getOwnerDocument();
        Element element3 = ProjectXMLManager.createModuleElement(document, DEPENDENCY);
        element.insertBefore(element3, element2);
        element3.appendChild(ProjectXMLManager.createModuleElement(document, "code-name-base", moduleDependency.getModuleEntry().getCodeNameBase()));
        if (moduleDependency.hasCompileDependency()) {
            element3.appendChild(ProjectXMLManager.createModuleElement(document, BUILD_PREREQUISITE));
            element3.appendChild(ProjectXMLManager.createModuleElement(document, "compile-dependency"));
        }
        Element element4 = ProjectXMLManager.createModuleElement(document, RUN_DEPENDENCY);
        element3.appendChild(element4);
        String string = moduleDependency.getReleaseVersion();
        if (string != null && !string.trim().equals("")) {
            element4.appendChild(ProjectXMLManager.createModuleElement(document, RELEASE_VERSION, string));
        }
        if (moduleDependency.hasImplementationDepedendency()) {
            element4.appendChild(ProjectXMLManager.createModuleElement(document, IMPLEMENTATION_VERSION));
        } else {
            String string2 = moduleDependency.getSpecificationVersion();
            if (string2 != null && !"".equals(string2)) {
                element4.appendChild(ProjectXMLManager.createModuleElement(document, SPECIFICATION_VERSION, string2));
            }
        }
    }

    private void removePublicAndFriends() {
        Element element;
        Element element2 = ProjectXMLManager.findFriendsElement(this.getConfData());
        if (element2 != null) {
            this.getConfData().removeChild(element2);
        }
        if ((element = ProjectXMLManager.findPublicPackagesElement(this.getConfData())) != null) {
            this.getConfData().removeChild(element);
        }
    }

    private static Element findElement(Element element, String string) {
        return Util.findElement(element, string, "http://www.netbeans.org/ns/nb-module-project/3");
    }

    static Element findModuleDependencies(Element element) {
        return ProjectXMLManager.findElement(element, MODULE_DEPENDENCIES);
    }

    private static Element findTestDependenciesElement(Element element) {
        return ProjectXMLManager.findElement(element, TEST_DEPENDENCIES);
    }

    private static Element findPublicPackagesElement(Element element) {
        return ProjectXMLManager.findElement(element, PUBLIC_PACKAGES);
    }

    private static Element findFriendsElement(Element element) {
        return ProjectXMLManager.findElement(element, FRIEND_PACKAGES);
    }

    private static Element createModuleElement(Document document, String string) {
        return document.createElementNS("http://www.netbeans.org/ns/nb-module-project/3", string);
    }

    private static Element createModuleElement(Document document, String string, String string2) {
        Element element = ProjectXMLManager.createModuleElement(document, string);
        element.appendChild(document.createTextNode(string2));
        return element;
    }

    private static Element createSuiteElement(Document document, String string) {
        return document.createElementNS("http://www.netbeans.org/ns/nb-module-suite-project/1", string);
    }

    private static Element createSuiteElement(Document document, String string, String string2) {
        Element element = ProjectXMLManager.createSuiteElement(document, string);
        element.appendChild(document.createTextNode(string2));
        return element;
    }

    private static Set<ManifestManager.PackageExport> findAllPackages(Element element) {
        HashSet<ManifestManager.PackageExport> hashSet = new HashSet<ManifestManager.PackageExport>();
        for (Element element2 : Util.findSubElements(element)) {
            if (PACKAGE.equals(element2.getTagName())) {
                hashSet.add(new ManifestManager.PackageExport(Util.findText(element2), false));
                continue;
            }
            if (!SUBPACKAGES.equals(element2.getTagName())) continue;
            hashSet.add(new ManifestManager.PackageExport(Util.findText(element2), true));
        }
        return hashSet;
    }

    public static ManifestManager.PackageExport[] findPublicPackages(Element element) {
        Element element2 = ProjectXMLManager.findPublicPackagesElement(element);
        HashSet<ManifestManager.PackageExport> hashSet = new HashSet<ManifestManager.PackageExport>();
        if (element2 != null) {
            hashSet.addAll(ProjectXMLManager.findAllPackages(element2));
        }
        if ((element2 = ProjectXMLManager.findFriendsElement(element)) != null) {
            hashSet.addAll(ProjectXMLManager.findAllPackages(element2));
        }
        return hashSet.isEmpty() ? ManifestManager.EMPTY_EXPORTED_PACKAGES : hashSet.toArray(new ManifestManager.PackageExport[hashSet.size()]);
    }

    public static String[] findFriends(Element element) {
        Element element2 = ProjectXMLManager.findFriendsElement(element);
        if (element2 != null) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Element element3 : Util.findSubElements(element2)) {
                if (!FRIEND.equals(element3.getTagName())) continue;
                treeSet.add(Util.findText(element3));
            }
            return treeSet.toArray(new String[treeSet.size()]);
        }
        return null;
    }

    static void generateEmptyModuleTemplate(FileObject fileObject, String string, NbModuleProvider.NbModuleType nbModuleType) throws IOException {
        Document document = XMLUtil.createDocument((String)"project", (String)PROJECT_NS, null, null);
        Element element = document.createElementNS(PROJECT_NS, "type");
        element.appendChild(document.createTextNode("org.netbeans.modules.apisupport.project"));
        document.getDocumentElement().appendChild(element);
        Element element2 = document.createElementNS(PROJECT_NS, "configuration");
        document.getDocumentElement().appendChild(element2);
        Element element3 = ProjectXMLManager.createModuleElement(element2.getOwnerDocument(), DATA);
        element2.appendChild(element3);
        Document document2 = element3.getOwnerDocument();
        element3.appendChild(ProjectXMLManager.createModuleElement(document2, "code-name-base", string));
        Element element4 = ProjectXMLManager.createTypeElement(document2, nbModuleType);
        if (element4 != null) {
            element3.appendChild(element4);
        }
        element3.appendChild(ProjectXMLManager.createModuleElement(document2, MODULE_DEPENDENCIES));
        element3.appendChild(ProjectXMLManager.createModuleElement(document2, PUBLIC_PACKAGES));
        ProjectXMLManager.safelyWrite(fileObject, document);
    }

    static void generateLibraryModuleTemplate(FileObject fileObject, String string, NbModuleProvider.NbModuleType nbModuleType, Set set, Map map) throws IOException {
        Document document = XMLUtil.createDocument((String)"project", (String)PROJECT_NS, null, null);
        Element element = document.createElementNS(PROJECT_NS, "type");
        element.appendChild(document.createTextNode("org.netbeans.modules.apisupport.project"));
        document.getDocumentElement().appendChild(element);
        Element element2 = document.createElementNS(PROJECT_NS, "configuration");
        document.getDocumentElement().appendChild(element2);
        Element element3 = ProjectXMLManager.createModuleElement(element2.getOwnerDocument(), DATA);
        element2.appendChild(element3);
        Document document2 = element3.getOwnerDocument();
        element3.appendChild(ProjectXMLManager.createModuleElement(document2, "code-name-base", string));
        Element element4 = ProjectXMLManager.createTypeElement(document2, nbModuleType);
        if (element4 != null) {
            element3.appendChild(element4);
        }
        element3.appendChild(ProjectXMLManager.createModuleElement(document2, MODULE_DEPENDENCIES));
        Element element5 = ProjectXMLManager.createModuleElement(document2, PUBLIC_PACKAGES);
        element3.appendChild(element5);
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            element5.appendChild(ProjectXMLManager.createModuleElement(document2, PACKAGE, (String)iterator.next()));
        }
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Element element6 = ProjectXMLManager.createModuleElement(document2, CLASS_PATH_EXTENSION);
            element3.appendChild(element6);
            Map.Entry entry = (Map.Entry)iterator.next();
            element6.appendChild(ProjectXMLManager.createModuleElement(document2, CLASS_PATH_RUNTIME_PATH, (String)entry.getKey()));
            element6.appendChild(ProjectXMLManager.createModuleElement(document2, "binary-origin", (String)entry.getValue()));
        }
        ProjectXMLManager.safelyWrite(fileObject, document);
    }

    private static Element createTypeElement(Document document, NbModuleProvider.NbModuleType nbModuleType) {
        Element element = null;
        if (nbModuleType == NbModuleProvider.STANDALONE) {
            element = ProjectXMLManager.createModuleElement(document, STANDALONE);
        } else if (nbModuleType == NbModuleProvider.SUITE_COMPONENT) {
            element = ProjectXMLManager.createModuleElement(document, SUITE_COMPONENT);
        }
        return element;
    }

    public static void generateEmptySuiteTemplate(FileObject fileObject, String string) throws IOException {
        Document document = XMLUtil.createDocument((String)"project", (String)PROJECT_NS, null, null);
        Element element = document.createElementNS(PROJECT_NS, "type");
        element.appendChild(document.createTextNode("org.netbeans.modules.apisupport.project.suite"));
        document.getDocumentElement().appendChild(element);
        Element element2 = document.createElementNS(PROJECT_NS, "configuration");
        document.getDocumentElement().appendChild(element2);
        Element element3 = ProjectXMLManager.createSuiteElement(element2.getOwnerDocument(), DATA);
        element2.appendChild(element3);
        Document document2 = element3.getOwnerDocument();
        element3.appendChild(ProjectXMLManager.createSuiteElement(document2, TEST_TYPE_NAME, string));
        ProjectXMLManager.safelyWrite(fileObject, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void safelyWrite(FileObject fileObject, Document document) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    private Element getConfData() {
        if (this.confData == null) {
            this.confData = this.project.getPrimaryConfigurationData();
        }
        return this.confData;
    }
}

