/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ModuleActions;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizer;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SuiteActions
implements ActionProvider {
    private final SuiteProject project;
    private static final int PROMPT_FOR_APP_NAME_MODE_JNLP = 0;
    private static final int PROMPT_FOR_APP_NAME_MODE_ZIP = 1;

    static Action[] getProjectActions(SuiteProject suiteProject) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(CommonProjectActions.newFileAction());
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_build"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_rebuild"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_clean"), null));
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_run"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_debug"), null));
        SuiteActions.addFromLayers(arrayList, "Projects/Profiler_Actions_temporary");
        arrayList.add(null);
        NbPlatform nbPlatform = suiteProject.getPlatform(true);
        if (nbPlatform != null && nbPlatform.getHarnessVersion() >= 5) {
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_test"), null));
            arrayList.add(null);
        }
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build-zip", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_zip"), null));
        arrayList.add(null);
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build-jnlp", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_build_jnlp"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run-jnlp", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_run_jnlp"), null));
        arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug-jnlp", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_debug_jnlp"), null));
        arrayList.add(null);
        if (nbPlatform != null && nbPlatform.getHarnessVersion() >= 3) {
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build-mac", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_mac"), null));
            arrayList.add(null);
        }
        if (nbPlatform != null && nbPlatform.getHarnessVersion() >= 2) {
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"nbms", (String)NbBundle.getMessage(SuiteActions.class, (String)"SUITE_ACTION_nbms"), null));
            arrayList.add(null);
        }
        arrayList.add(CommonProjectActions.setAsMainProjectAction());
        arrayList.add(CommonProjectActions.openSubprojectsAction());
        arrayList.add(CommonProjectActions.closeProjectAction());
        arrayList.add(null);
        arrayList.add(CommonProjectActions.renameProjectAction());
        arrayList.add(CommonProjectActions.moveProjectAction());
        arrayList.add(CommonProjectActions.deleteProjectAction());
        arrayList.add(null);
        arrayList.add((Action)SystemAction.get(FindAction.class));
        Collection collection = Lookups.forPath((String)"Projects/Actions").lookupAll(Object.class);
        if (!collection.isEmpty()) {
            arrayList.add(null);
            for (Object e : collection) {
                if (e instanceof Action) {
                    arrayList.add((Action)e);
                    continue;
                }
                if (!(e instanceof JSeparator)) continue;
                arrayList.add(null);
            }
        }
        arrayList.add(null);
        arrayList.add(CommonProjectActions.customizeProjectAction());
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private static void addFromLayers(List<Action> list, String string) {
        Lookup lookup = Lookups.forPath((String)string);
        for (Object e : lookup.lookupAll(Object.class)) {
            if (e instanceof Action) {
                list.add((Action)e);
                continue;
            }
            if (!(e instanceof JSeparator)) continue;
            list.add(null);
        }
    }

    public SuiteActions(SuiteProject suiteProject) {
        this.project = suiteProject;
    }

    public String[] getSupportedActions() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("build", "clean", "rebuild", "run", "debug", "build-zip", "build-jnlp", "run-jnlp", "debug-jnlp", "build-mac", "nbms", "profile", "rename", "move", "delete"));
        NbPlatform nbPlatform = this.project.getPlatform(true);
        if (nbPlatform != null && nbPlatform.getHarnessVersion() >= 5) {
            arrayList.add("test");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
        if ("delete".equals(string) || "rename".equals(string) || "move".equals(string)) {
            return true;
        }
        if (Arrays.asList(this.getSupportedActions()).contains(string)) {
            return SuiteActions.findBuildXml(this.project) != null;
        }
        throw new IllegalArgumentException(string);
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
        } else if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
        } else if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
        } else {
            int n;
            NbPlatform nbPlatform = this.project.getPlatform(false);
            if (nbPlatform != null && (n = nbPlatform.getHarnessVersion()) != 0) {
                for (Project project : ((SubprojectProvider)this.project.getLookup().lookup(SubprojectProvider.class)).getSubprojects()) {
                    if (n >= ((NbModuleProject)project).getMinimumHarnessVersion()) continue;
                    ModuleActions.promptForNewerHarness();
                    return;
                }
            }
            try {
                this.invokeActionImpl(string, lookup);
            }
            catch (IOException iOException) {
                Util.err.notify((Throwable)iOException);
            }
        }
    }

    public ExecutorTask invokeActionImpl(String string, Lookup lookup) throws IllegalArgumentException, IOException {
        String[] stringArray;
        if (string.equals("build")) {
            stringArray = new String[]{"build"};
        } else if (string.equals("clean")) {
            stringArray = new String[]{"clean"};
        } else if (string.equals("rebuild")) {
            stringArray = new String[]{"clean", "build"};
        } else if (string.equals("run")) {
            stringArray = new String[]{"run"};
        } else if (string.equals("debug")) {
            stringArray = new String[]{"debug"};
        } else if (string.equals("test")) {
            stringArray = new String[]{"test"};
        } else if (string.equals("build-zip")) {
            if (this.promptForAppName(1)) {
                return null;
            }
            stringArray = new String[]{"build-zip"};
        } else if (string.equals("build-jnlp")) {
            if (this.promptForAppName(0)) {
                return null;
            }
            stringArray = new String[]{"build-jnlp"};
        } else if (string.equals("run-jnlp")) {
            if (this.promptForAppName(0)) {
                return null;
            }
            stringArray = new String[]{"run-jnlp"};
        } else if (string.equals("debug-jnlp")) {
            if (this.promptForAppName(0)) {
                return null;
            }
            stringArray = new String[]{"debug-jnlp"};
        } else if (string.equals("build-mac")) {
            stringArray = new String[]{"build-mac"};
        } else if (string.equals("nbms")) {
            stringArray = new String[]{"nbms"};
        } else if (string.equals("profile")) {
            stringArray = new String[]{"profile"};
        } else {
            throw new IllegalArgumentException(string);
        }
        return ActionUtils.runTarget((FileObject)SuiteActions.findBuildXml(this.project), (String[])stringArray, null);
    }

    private static FileObject findBuildXml(SuiteProject suiteProject) {
        return suiteProject.getProjectDirectory().getFileObject("build.xml");
    }

    private boolean promptForAppName(int n) {
        String string;
        String string2 = this.project.getEvaluator().getProperty("app.name");
        if (string2 != null) {
            return false;
        }
        switch (n) {
            case 0: {
                string = NbBundle.getMessage(ModuleActions.class, (String)"ERR_app_name_jnlp");
                break;
            }
            case 1: {
                string = NbBundle.getMessage(ModuleActions.class, (String)"ERR_app_name_zip");
                break;
            }
            default: {
                throw new AssertionError(n);
            }
        }
        if (UIUtil.showAcceptCancelDialog(NbBundle.getMessage(ModuleActions.class, (String)"TITLE_app_name"), string, NbBundle.getMessage(ModuleActions.class, (String)"LBL_configure_app_name"), NbBundle.getMessage(ModuleActions.class, (String)"ACSD_configure_app_name"), null, 2)) {
            SuiteCustomizer suiteCustomizer = (SuiteCustomizer)this.project.getLookup().lookup(SuiteCustomizer.class);
            suiteCustomizer.showCustomizer("Application", "standaloneApp");
        }
        return true;
    }
}

