/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.ui.ActionFilterNode;
import org.netbeans.modules.apisupport.project.ui.LibrariesNode;
import org.netbeans.modules.apisupport.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel;
import org.netbeans.modules.apisupport.project.ui.customizer.EditTestDependencyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.TestModuleDependency;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class UnitTestLibrariesNode
extends AbstractNode {
    static final String UNIT_TEST_LIBRARIES_NAME = "unit libraries";
    private static final String DISPLAY_NAME = UnitTestLibrariesNode.getMessage("LBL_unit_test_libraries");
    private final Action[] actions;

    public UnitTestLibrariesNode(NbModuleProject nbModuleProject) {
        super((Children)new LibrariesChildren(nbModuleProject));
        this.setName(UNIT_TEST_LIBRARIES_NAME);
        this.setDisplayName(DISPLAY_NAME);
        this.actions = new Action[]{new AddUnitTestDependencyAction(nbModuleProject)};
    }

    public Image getIcon(int n) {
        return this.getIcon(false);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(true);
    }

    private Image getIcon(boolean bl) {
        Image image = Utilities.loadImage((String)"org/netbeans/modules/apisupport/project/ui/resources/libraries-badge.png", (boolean)true);
        return Utilities.mergeImages((Image)UIUtil.getTreeFolderIcon(bl), (Image)image, (int)8, (int)8);
    }

    public Action[] getActions(boolean bl) {
        return this.actions;
    }

    private static String createHtmlDescription(TestModuleDependency testModuleDependency) {
        StringBuffer stringBuffer = new StringBuffer("<html><u>" + testModuleDependency.getModule().getCodeNameBase() + "</u><br>");
        if (testModuleDependency.isTest()) {
            stringBuffer.append("<br>" + UnitTestLibrariesNode.getMessage("CTL_test"));
        }
        if (testModuleDependency.isCompile()) {
            stringBuffer.append("<br>").append(UnitTestLibrariesNode.getMessage("CTL_compile"));
        }
        if (testModuleDependency.isRecursive()) {
            stringBuffer.append("<br>").append(UnitTestLibrariesNode.getMessage("CTL_recursive"));
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(UnitTestLibrariesNode.class, (String)string);
    }

    static final class EditTestDependencyAction
    extends AbstractAction {
        private final TestModuleDependency testDep;
        private final NbModuleProject project;

        EditTestDependencyAction(TestModuleDependency testModuleDependency, NbModuleProject nbModuleProject) {
            super(UnitTestLibrariesNode.getMessage("CTL_EditDependency"));
            this.testDep = testModuleDependency;
            this.project = nbModuleProject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditTestDependencyPanel editTestDependencyPanel = new EditTestDependencyPanel(this.testDep);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editTestDependencyPanel, NbBundle.getMessage(LibrariesNode.class, (String)"CTL_EditModuleDependencyTitle", (Object)this.testDep.getModule().getLocalizedName()));
            dialogDescriptor.setHelpCtx(new HelpCtx(EditTestDependencyPanel.class));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                TestModuleDependency testModuleDependency = editTestDependencyPanel.getEditedDependency();
                try {
                    ProjectXMLManager projectXMLManager = new ProjectXMLManager(this.project);
                    projectXMLManager.removeTestDependency("unit", this.testDep.getModule().getCodeNameBase());
                    projectXMLManager.addTestDependency("unit", testModuleDependency);
                    ProjectManager.getDefault().saveProject((Project)this.project);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().annotate((Throwable)iOException, "Cannot store dependency: " + testModuleDependency);
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
            dialog.dispose();
        }
    }

    static final class RemoveDependencyAction
    extends CookieAction {
        RemoveDependencyAction() {
        }

        protected void performAction(Node[] nodeArray) {
            Set<TestModuleDependency> set;
            NbModuleProject nbModuleProject;
            HashMap<NbModuleProject, HashSet<TestModuleDependency>> hashMap = new HashMap<NbModuleProject, HashSet<TestModuleDependency>>();
            for (int i = 0; i < nodeArray.length; ++i) {
                TestModuleDependency object = (TestModuleDependency)nodeArray[i].getLookup().lookup(TestModuleDependency.class);
                assert (object != null);
                nbModuleProject = (NbModuleProject)nodeArray[i].getLookup().lookup(NbModuleProject.class);
                assert (nbModuleProject != null);
                set = (Set)hashMap.get(nbModuleProject);
                if (set == null) {
                    set = new HashSet<TestModuleDependency>();
                    hashMap.put(nbModuleProject, (HashSet<TestModuleDependency>)set);
                }
                set.add(object);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                nbModuleProject = (NbModuleProject)entry.getKey();
                set = new ProjectXMLManager(nbModuleProject);
                for (TestModuleDependency testModuleDependency : (Set)entry.getValue()) {
                    ((ProjectXMLManager)((Object)set)).removeTestDependency("unit", testModuleDependency.getModule().getCodeNameBase());
                }
                try {
                    ProjectManager.getDefault().saveProject((Project)nbModuleProject);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().annotate((Throwable)iOException, "Problem during test dependencies removing");
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }

        public String getName() {
            return UnitTestLibrariesNode.getMessage("CTL_RemoveDependency");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }

        protected int mode() {
            return 4;
        }

        protected Class[] cookieClasses() {
            return new Class[]{TestModuleDependency.class, NbModuleProject.class};
        }
    }

    static final class AddUnitTestDependencyAction
    extends AbstractAction {
        private final NbModuleProject project;

        AddUnitTestDependencyAction(NbModuleProject nbModuleProject) {
            super(UnitTestLibrariesNode.getMessage("CTL_AddTestDependency"));
            this.project = nbModuleProject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SingleModuleProperties singleModuleProperties = SingleModuleProperties.getInstance(this.project);
            final AddModulePanel addModulePanel = new AddModulePanel(singleModuleProperties);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addModulePanel, UnitTestLibrariesNode.getMessage("CTL_AddTestDependency"));
            dialogDescriptor.setHelpCtx(new HelpCtx(AddModulePanel.class));
            dialogDescriptor.setClosingOptions(new Object[0]);
            final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialogDescriptor.setButtonListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (DialogDescriptor.OK_OPTION.equals(actionEvent.getSource()) && addModulePanel.getSelectedDependencies().length == 0) {
                        return;
                    }
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            });
            dialog.setVisible(true);
            if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                ModuleDependency[] moduleDependencyArray = addModulePanel.getSelectedDependencies();
                ProjectXMLManager projectXMLManager = new ProjectXMLManager(this.project);
                try {
                    for (int i = 0; i < moduleDependencyArray.length; ++i) {
                        projectXMLManager.addTestDependency("unit", new TestModuleDependency(moduleDependencyArray[i].getModuleEntry(), false, false, true));
                        ProjectManager.getDefault().saveProject((Project)this.project);
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().annotate((Throwable)exception, "Cannot add dependencies, probably IO error: " + Arrays.asList(moduleDependencyArray));
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
            dialog.dispose();
        }
    }

    private static final class LibraryDependencyNode
    extends FilterNode {
        private final TestModuleDependency dep;
        private final NbModuleProject project;
        private Action[] actions;

        LibraryDependencyNode(TestModuleDependency testModuleDependency, NbModuleProject nbModuleProject, Node node) {
            super(node, null, (Lookup)new ProxyLookup(new Lookup[]{node.getLookup(), Lookups.fixed((Object[])new Object[]{testModuleDependency, nbModuleProject})}));
            this.dep = testModuleDependency;
            this.project = nbModuleProject;
            this.setShortDescription(UnitTestLibrariesNode.createHtmlDescription(testModuleDependency));
        }

        public Action[] getActions(boolean bl) {
            if (this.actions == null) {
                LinkedHashSet<Action> linkedHashSet = new LinkedHashSet<Action>();
                linkedHashSet.add(new EditTestDependencyAction(this.dep, this.project));
                Action[] actionArray = super.getActions(false);
                for (int i = 0; i < actionArray.length; ++i) {
                    if (!(actionArray[i] instanceof FindAction)) continue;
                    linkedHashSet.add(actionArray[i]);
                }
                linkedHashSet.add(LibrariesChildren.REMOVE_DEPENDENCY_ACTION);
                this.actions = linkedHashSet.toArray(new Action[linkedHashSet.size()]);
            }
            return this.actions;
        }

        public Action getPreferredAction() {
            return this.getActions(false)[0];
        }
    }

    private static final class ProjectDependencyNode
    extends AbstractNode {
        private final TestModuleDependency dep;
        private final NbModuleProject project;
        private Action[] actions;

        ProjectDependencyNode(TestModuleDependency testModuleDependency, NbModuleProject nbModuleProject) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{testModuleDependency, nbModuleProject, testModuleDependency.getModule()}));
            this.dep = testModuleDependency;
            this.project = nbModuleProject;
            ModuleEntry moduleEntry = testModuleDependency.getModule();
            this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/resources/module.png");
            this.setDisplayName(moduleEntry.getLocalizedName());
            this.setShortDescription(UnitTestLibrariesNode.createHtmlDescription(testModuleDependency));
        }

        public Action[] getActions(boolean bl) {
            if (this.actions == null) {
                LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
                linkedHashSet.add(SystemAction.get(LibrariesNode.OpenProjectAction.class));
                linkedHashSet.add(new EditTestDependencyAction(this.dep, this.project));
                linkedHashSet.add(LibrariesChildren.REMOVE_DEPENDENCY_ACTION);
                this.actions = linkedHashSet.toArray(new Action[linkedHashSet.size()]);
            }
            return this.actions;
        }

        public Action getPreferredAction() {
            return this.getActions(false)[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LibrariesChildren
    extends Children.Keys<Object>
    implements AntProjectListener {
        private static final String JUNIT = "junit";
        private static final String JUNIT_CNB = "org.netbeans.modules.junit";
        private static final String NBJUNIT = "nbjunit";
        private static final String NBJUNIT_CNB = "org.netbeans.modules.nbjunit";
        private static final String LIBRARIES_ICON = "org/netbeans/modules/apisupport/project/ui/resources/libraries.gif";
        static final Action REMOVE_DEPENDENCY_ACTION = new RemoveDependencyAction();
        private final NbModuleProject project;
        private ImageIcon librariesIcon;

        LibrariesChildren(NbModuleProject nbModuleProject) {
            this.project = nbModuleProject;
        }

        protected void addNotify() {
            super.addNotify();
            this.project.getHelper().addAntProjectListener((AntProjectListener)this);
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            this.project.getHelper().removeAntProjectListener((AntProjectListener)this);
            super.removeNotify();
        }

        private void refreshKeys() {
            block2: {
                try {
                    ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                        public Object run() throws Exception {
                            ProjectXMLManager projectXMLManager = new ProjectXMLManager(LibrariesChildren.this.project);
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            if (LibrariesChildren.this.isModuleInModuleList(LibrariesChildren.JUNIT_CNB)) {
                                arrayList.add(LibrariesChildren.JUNIT);
                            }
                            if (LibrariesChildren.this.isModuleInModuleList(LibrariesChildren.NBJUNIT_CNB)) {
                                arrayList.add(LibrariesChildren.NBJUNIT);
                            }
                            TreeSet<TestModuleDependency> treeSet = new TreeSet<TestModuleDependency>(TestModuleDependency.CNB_COMPARATOR);
                            Set<TestModuleDependency> set = projectXMLManager.getTestDependencies(LibrariesChildren.this.project.getModuleList()).get("unit");
                            if (set != null) {
                                for (TestModuleDependency testModuleDependency : set) {
                                    if (!testModuleDependency.isCompile()) continue;
                                    treeSet.add(testModuleDependency);
                                }
                                arrayList.addAll(treeSet);
                            }
                            LibrariesChildren.this.setKeys(Collections.unmodifiableList(arrayList));
                            return null;
                        }
                    });
                }
                catch (MutexException mutexException) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)mutexException.getException());
                }
            }
        }

        private boolean isModuleInModuleList(String string) {
            ModuleEntry moduleEntry = null;
            boolean bl = false;
            try {
                moduleEntry = this.project.getModuleList().getEntry(string);
                if (moduleEntry != null) {
                    File file = moduleEntry.getJarLocation();
                    bl = file.exists();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return bl;
        }

        protected Node[] createNodes(Object object) {
            Object object2 = null;
            if (JUNIT.equals(object) || NBJUNIT.equals(object)) {
                String string = null;
                string = JUNIT.equals(object) ? JUNIT_CNB : NBJUNIT_CNB;
                try {
                    ModuleEntry moduleEntry = this.project.getModuleList().getEntry(string);
                    Icon icon = this.getLibrariesIcon();
                    File file = moduleEntry.getJarLocation();
                    URL uRL = FileUtil.urlForArchiveOrDir((File)file);
                    assert (uRL != null);
                    FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                    String string2 = moduleEntry.getLocalizedName();
                    object2 = ActionFilterNode.create(PackageView.createPackageView((SourceGroup)new LibrariesSourceGroup(fileObject, string2, icon, icon)));
                    object2.setName(string2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                TestModuleDependency testModuleDependency = (TestModuleDependency)object;
                File file = testModuleDependency.getModule().getSourceLocation();
                if (file == null) {
                    File file2 = testModuleDependency.getModule().getJarLocation();
                    URL uRL = FileUtil.urlForArchiveOrDir((File)file2);
                    assert (uRL != null);
                    FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                    ModuleEntry moduleEntry = testModuleDependency.getModule();
                    String string = moduleEntry.getLocalizedName() + " - " + moduleEntry.getCodeNameBase();
                    Icon icon = this.getLibrariesIcon();
                    ActionFilterNode actionFilterNode = ActionFilterNode.create(PackageView.createPackageView((SourceGroup)new LibrariesSourceGroup(fileObject, string, icon, icon)));
                    object2 = new LibraryDependencyNode(testModuleDependency, this.project, (Node)actionFilterNode);
                    object2.setName(moduleEntry.getLocalizedName());
                } else {
                    object2 = new ProjectDependencyNode(testModuleDependency, this.project);
                    object2.setName(testModuleDependency.getModule().getLocalizedName());
                }
            }
            assert (object2 != null);
            return new Node[]{object2};
        }

        public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
            if (this.project.getHelper().resolveFileObject("nbproject/project.xml") != null) {
                this.refreshKeys();
            }
        }

        public void propertiesChanged(AntProjectEvent antProjectEvent) {
        }

        private Icon getLibrariesIcon() {
            if (this.librariesIcon == null) {
                this.librariesIcon = new ImageIcon(Utilities.loadImage((String)LIBRARIES_ICON, (boolean)true));
            }
            return this.librariesIcon;
        }
    }
}

