/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicBrandingModel;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SuiteProperties
extends ModuleProperties {
    public static final String DISABLED_MODULES_PROPERTY = "disabled.modules";
    public static final String ENABLED_CLUSTERS_PROPERTY = "enabled.clusters";
    public static final String DISABLED_CLUSTERS_PROPERTY = "disabled.clusters";
    public static final String NB_PLATFORM_PROPERTY = "nbPlatform";
    public static final String JAVA_PLATFORM_PROPERTY = "nbjdk.active";
    private NbPlatform activePlatform;
    private JavaPlatform activeJavaPlatform;
    private SuiteProject project;
    private Set<NbModuleProject> origSubModules;
    private Set<NbModuleProject> subModules;
    private CustomizerComponentFactory.SuiteSubModulesListModel moduleListModel;
    private String[] disabledModules;
    private String[] enabledClusters;
    private boolean changedDisabledModules;
    private boolean changedEnabledClusters;
    private final BasicBrandingModel brandingModel;

    public SuiteProperties(SuiteProject suiteProject, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, Set<NbModuleProject> set) {
        super(antProjectHelper, propertyEvaluator);
        this.project = suiteProject;
        this.refresh(set);
        this.disabledModules = SuiteProperties.getArrayProperty(propertyEvaluator, DISABLED_MODULES_PROPERTY);
        this.enabledClusters = SuiteProperties.getArrayProperty(propertyEvaluator, ENABLED_CLUSTERS_PROPERTY);
        if (this.enabledClusters.length == 0) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (ModuleEntry moduleEntry : this.activePlatform.getModules()) {
                treeSet.add(moduleEntry.getClusterDirectory().getName());
            }
            treeSet.removeAll(Arrays.asList(SuiteProperties.getArrayProperty(propertyEvaluator, DISABLED_CLUSTERS_PROPERTY)));
            this.enabledClusters = treeSet.toArray(new String[treeSet.size()]);
        }
        this.brandingModel = new BasicBrandingModel(this);
    }

    void refresh(Set<NbModuleProject> set) {
        this.reloadProperties();
        this.origSubModules = Collections.unmodifiableSet(set);
        this.subModules = set;
        this.moduleListModel = null;
        this.activePlatform = this.project.getPlatform(true);
        this.activeJavaPlatform = ModuleProperties.findJavaPlatformByID(this.getEvaluator().getProperty(JAVA_PLATFORM_PROPERTY));
        this.firePropertiesRefreshed();
    }

    public SuiteProject getProject() {
        return this.project;
    }

    @Override
    Map<String, String> getDefaultValues() {
        return Collections.emptyMap();
    }

    public NbPlatform getActivePlatform() {
        return this.activePlatform;
    }

    void setActivePlatform(NbPlatform nbPlatform) {
        NbPlatform nbPlatform2 = this.activePlatform;
        this.activePlatform = nbPlatform;
        this.firePropertyChange(NB_PLATFORM_PROPERTY, nbPlatform2, nbPlatform);
    }

    JavaPlatform getActiveJavaPlatform() {
        return this.activeJavaPlatform;
    }

    void setActiveJavaPlatform(JavaPlatform javaPlatform) {
        JavaPlatform javaPlatform2 = this.activeJavaPlatform;
        if (javaPlatform != javaPlatform2) {
            this.activeJavaPlatform = javaPlatform;
            this.firePropertyChange(JAVA_PLATFORM_PROPERTY, javaPlatform2, javaPlatform);
        }
    }

    String[] getEnabledClusters() {
        return this.enabledClusters;
    }

    String[] getDisabledModules() {
        return this.disabledModules;
    }

    public void setEnabledClusters(String[] stringArray) {
        if (((Object)Arrays.asList(this.enabledClusters)).equals(Arrays.asList(stringArray))) {
            return;
        }
        this.enabledClusters = stringArray;
        this.changedEnabledClusters = true;
    }

    public void setDisabledModules(String[] stringArray) {
        if (((Object)Arrays.asList(this.disabledModules)).equals(Arrays.asList(stringArray))) {
            return;
        }
        this.disabledModules = stringArray;
        this.changedDisabledModules = true;
    }

    public static String[] getArrayProperty(PropertyEvaluator propertyEvaluator, String string) {
        String string2 = propertyEvaluator.getProperty(string);
        String[] stringArray = null;
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringTokenizer.nextToken().trim();
            }
        }
        return stringArray == null ? new String[]{} : stringArray;
    }

    @Override
    public void storeProperties() throws IOException {
        ModuleProperties.storePlatform(this.getHelper(), this.getActivePlatform());
        ModuleProperties.storeJavaPlatform(this.getHelper(), this.getEvaluator(), this.getActiveJavaPlatform(), false);
        this.getBrandingModel().store();
        CustomizerComponentFactory.SuiteSubModulesListModel suiteSubModulesListModel = this.getModulesListModel();
        if (suiteSubModulesListModel.isChanged()) {
            SuiteUtils.replaceSubModules(this);
        }
        if (this.changedDisabledModules || this.changedEnabledClusters) {
            int n;
            String[] stringArray;
            EditableProperties editableProperties = this.getHelper().getProperties("nbproject/platform.properties");
            if (this.changedDisabledModules) {
                stringArray = (String[])this.disabledModules.clone();
                for (n = 0; n < this.disabledModules.length - 1; ++n) {
                    stringArray[n] = this.disabledModules[n] + ',';
                }
                editableProperties.setProperty(DISABLED_MODULES_PROPERTY, stringArray);
                this.setProperty(DISABLED_MODULES_PROPERTY, (String)null);
            }
            if (this.changedEnabledClusters) {
                int n2;
                stringArray = (String[])this.enabledClusters.clone();
                for (n = 0; n < this.enabledClusters.length - 1; ++n) {
                    stringArray[n] = this.enabledClusters[n] + ',';
                }
                editableProperties.setProperty(ENABLED_CLUSTERS_PROPERTY, stringArray);
                this.setProperty(ENABLED_CLUSTERS_PROPERTY, (String)null);
                TreeSet<String> treeSet = new TreeSet<String>();
                ModuleEntry[] moduleEntryArray = this.activePlatform.getModules();
                for (n2 = 0; n2 < moduleEntryArray.length; ++n2) {
                    treeSet.add(moduleEntryArray[n2].getClusterDirectory().getName());
                }
                treeSet.removeAll(Arrays.asList(this.enabledClusters));
                stringArray = treeSet.toArray(new String[treeSet.size()]);
                for (n2 = 0; n2 < stringArray.length - 1; ++n2) {
                    stringArray[n2] = stringArray[n2] + ',';
                }
                editableProperties.setProperty(DISABLED_CLUSTERS_PROPERTY, stringArray);
                editableProperties.setComment(DISABLED_CLUSTERS_PROPERTY, new String[]{"# Deprecated since 5.0u1; for compatibility with 5.0:"}, false);
            }
            this.getHelper().putProperties("nbproject/platform.properties", editableProperties);
        }
        super.storeProperties();
    }

    Set<NbModuleProject> getSubModules() {
        return this.getModulesListModel().getSubModules();
    }

    Set<NbModuleProject> getOrigSubModules() {
        return this.origSubModules;
    }

    CustomizerComponentFactory.SuiteSubModulesListModel getModulesListModel() {
        if (this.moduleListModel == null) {
            this.moduleListModel = new CustomizerComponentFactory.SuiteSubModulesListModel(this.subModules);
        }
        return this.moduleListModel;
    }

    public BasicBrandingModel getBrandingModel() {
        return this.brandingModel;
    }
}

