/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NbPlatformCustomizerHarness
extends JPanel {
    private NbPlatform plaf;
    private JButton browseButton;
    private ButtonGroup buttonGroup;
    private JRadioButton ideButton;
    private JRadioButton otherButton;
    private JTextField otherText;
    private JRadioButton platformButton;
    private JLabel versionLabel;
    private JTextField versionText;

    public NbPlatformCustomizerHarness() {
        this.initComponents();
    }

    void setPlatform(NbPlatform nbPlatform) {
        this.plaf = nbPlatform;
        if (nbPlatform.isDefault()) {
            this.ideButton.setSelected(true);
        } else {
            File file = nbPlatform.getHarnessLocation();
            NbPlatform nbPlatform2 = NbPlatform.getDefaultPlatform();
            if (nbPlatform2 != null && file.equals(nbPlatform2.getHarnessLocation())) {
                this.ideButton.setSelected(true);
            } else if (file.equals(nbPlatform.getBundledHarnessLocation())) {
                this.platformButton.setSelected(true);
            } else {
                this.otherButton.setSelected(true);
            }
        }
        this.update();
        UIUtil.setText(this.otherText, nbPlatform.getHarnessLocation().getAbsolutePath());
    }

    private void update() {
        this.versionText.setText(NbPlatform.getHarnessVersionDisplayName(this.plaf.getHarnessVersion()));
        if (this.plaf.isDefault()) {
            this.platformButton.setEnabled(false);
            this.otherButton.setEnabled(false);
        } else {
            this.platformButton.setEnabled(true);
            this.otherButton.setEnabled(true);
        }
        this.browseButton.setEnabled(this.otherButton.isSelected());
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.ideButton = new JRadioButton();
        this.platformButton = new JRadioButton();
        this.otherButton = new JRadioButton();
        this.otherText = new JTextField();
        this.browseButton = new JButton();
        this.versionLabel = new JLabel();
        this.versionText = new JTextField();
        this.buttonGroup.add(this.ideButton);
        Mnemonics.setLocalizedText((AbstractButton)this.ideButton, (String)NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPCH.ideButton"));
        this.ideButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ideButton.setMargin(new Insets(0, 0, 0, 0));
        this.ideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbPlatformCustomizerHarness.this.ideButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup.add(this.platformButton);
        Mnemonics.setLocalizedText((AbstractButton)this.platformButton, (String)NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPCH.platformButton"));
        this.platformButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.platformButton.setMargin(new Insets(0, 0, 0, 0));
        this.platformButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbPlatformCustomizerHarness.this.platformButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup.add(this.otherButton);
        Mnemonics.setLocalizedText((AbstractButton)this.otherButton, (String)NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPCH.otherButton"));
        this.otherButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.otherButton.setMargin(new Insets(0, 0, 0, 0));
        this.otherButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbPlatformCustomizerHarness.this.otherButtonActionPerformed(actionEvent);
            }
        });
        this.otherText.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPCH.browseButton"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbPlatformCustomizerHarness.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.versionLabel.setLabelFor(this.versionText);
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"NbPCH.versionLabel"));
        this.versionText.setEditable(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.ideButton).add((Component)this.platformButton).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.otherButton).addPreferredGap(0).add((Component)this.otherText, -1, 220, Short.MAX_VALUE))).addPreferredGap(0).add((Component)this.browseButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.versionLabel).addPreferredGap(0).add((Component)this.versionText, -1, 231, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.ideButton).addPreferredGap(0).add((Component)this.platformButton).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.otherButton).add((Component)this.browseButton).add((Component)this.otherText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.versionLabel).add((Component)this.versionText, -2, -1, -2)).addContainerGap(196, Short.MAX_VALUE)));
        this.ideButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"ACS_HarnessSuppliedIDE"));
        this.platformButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"ACS_HarnessSuppliedPlatform"));
        this.otherButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"ACS_HarnessOther"));
        this.versionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizerHarness.class, (String)"ACS_HarnessVersion"));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(){

            public void approveSelection() {
                File file = FileUtil.normalizeFile((File)this.getSelectedFile());
                if (NbPlatform.isHarness(file)) {
                    super.approveSelection();
                } else {
                    this.setCurrentDirectory(file);
                }
            }
        };
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setSelectedFile(this.plaf.getHarnessLocation());
        if (jFileChooser.showOpenDialog(this) == 0) {
            try {
                this.plaf.setHarnessLocation(FileUtil.normalizeFile((File)jFileChooser.getSelectedFile()));
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        this.update();
        UIUtil.setText(this.otherText, this.plaf.getHarnessLocation().getAbsolutePath());
    }

    private void otherButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.plaf.setHarnessLocation(FileUtil.normalizeFile((File)new File(this.otherText.getText())));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.update();
    }

    private void platformButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.plaf.setHarnessLocation(this.plaf.getBundledHarnessLocation());
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.update();
    }

    private void ideButtonActionPerformed(ActionEvent actionEvent) {
        try {
            assert (this.plaf != null);
            NbPlatform nbPlatform = NbPlatform.getDefaultPlatform();
            if (nbPlatform != null) {
                this.plaf.setHarnessLocation(nbPlatform.getHarnessLocation());
            } else {
                Logger.getLogger(NbPlatformCustomizerHarness.class.getName()).warning("No default platform found");
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.update();
    }
}

