/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ShortcutEnterPanel
extends JPanel {
    private final Listener listener = new Listener();
    private final JButton bTab;
    private final JButton bClear;
    private JTextField tfShortcut;
    private final JLabel tfShortcutLabel = new JLabel();

    public ShortcutEnterPanel() {
        this.initComponents();
        this.bTab = new JButton();
        this.bClear = new JButton();
        ShortcutEnterPanel.loc(this.bTab, "CTL_Tab");
        ShortcutEnterPanel.loc(this.bClear, "CTL_Clear");
        this.tfShortcut.setFocusTraversalKeys(1, Collections.emptySet());
        this.tfShortcut.setFocusTraversalKeys(3, Collections.emptySet());
        this.tfShortcut.setFocusTraversalKeys(2, Collections.emptySet());
        this.tfShortcut.addKeyListener(this.listener);
    }

    private String getTitle() {
        return ShortcutEnterPanel.loc("LBL_AddShortcutTitle");
    }

    private Object[] getAdditionalOptions() {
        return new Object[]{this.bClear, this.bTab};
    }

    private String getShortcutText() {
        return this.tfShortcut.getText();
    }

    static KeyStroke[] showDialog() {
        Object[] objectArray = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION};
        ShortcutEnterPanel shortcutEnterPanel = new ShortcutEnterPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)shortcutEnterPanel, shortcutEnterPanel.getTitle(), true, objectArray, DialogDescriptor.OK_OPTION, 0, null, (ActionListener)shortcutEnterPanel.listener);
        dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
        dialogDescriptor.setAdditionalOptions(shortcutEnterPanel.getAdditionalOptions());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        String string = shortcutEnterPanel.getShortcutText();
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && string != null && string.trim().length() > 0) {
            return UIUtil.stringToKeyStrokes(string);
        }
        return null;
    }

    private static void loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)ShortcutEnterPanel.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)ShortcutEnterPanel.loc(string));
        }
    }

    private static String loc(String string) {
        return NbBundle.getMessage(ShortcutEnterPanel.class, (String)string);
    }

    private void initComponents() {
        this.tfShortcut = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.tfShortcutLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/action/Bundle").getString("LBL_Shortcut"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.tfShortcutLabel).addPreferredGap(0).add((Component)this.tfShortcut, -1, 300, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.tfShortcutLabel).add((Component)this.tfShortcut, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private class Listener
    implements ActionListener,
    KeyListener {
        private KeyStroke backspaceKS = KeyStroke.getKeyStroke(8, 0);
        private KeyStroke tabKS = KeyStroke.getKeyStroke(9, 0);
        private String key = "";

        private Listener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        /*
         * Unable to fully structure code
         */
        public void keyPressed(KeyEvent var1_1) {
            var2_2 = KeyStroke.getKeyStroke(var1_1.getKeyCode(), var1_1.getModifiers());
            if (var1_1.getKeyCode() == 16) ** GOTO lbl-1000
            if (var1_1.getKeyCode() == 17) ** GOTO lbl-1000
            if (var1_1.getKeyCode() == 18) ** GOTO lbl-1000
            if (var1_1.getKeyCode() == 157) ** GOTO lbl-1000
            if (var1_1.getKeyCode() != 65406) {
                v0 = true;
            } else lbl-1000:
            // 5 sources

            {
                v0 = var3_3 = false;
            }
            if (var2_2.equals(this.backspaceKS) && !this.key.equals("")) {
                var4_4 = this.key.lastIndexOf(32);
                this.key = var4_4 < 0 ? "" : this.key.substring(0, var4_4);
                ShortcutEnterPanel.access$100(ShortcutEnterPanel.this).setText(this.key);
            } else {
                this.addKeyStroke(var2_2, var3_3);
            }
            var1_1.consume();
        }

        public void keyReleased(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ShortcutEnterPanel.this.bClear) {
                this.key = "";
                ShortcutEnterPanel.this.tfShortcut.setText(this.key);
                ShortcutEnterPanel.this.tfShortcut.requestFocusInWindow();
            } else if (actionEvent.getSource() == ShortcutEnterPanel.this.bTab) {
                this.addKeyStroke(this.tabKS, true);
                ShortcutEnterPanel.this.tfShortcut.requestFocusInWindow();
            }
        }

        private void addKeyStroke(KeyStroke keyStroke, boolean bl) {
            String string = UIUtil.keyStrokeToString(keyStroke);
            if (this.key.equals("")) {
                ShortcutEnterPanel.this.tfShortcut.setText(string);
                if (bl) {
                    this.key = string;
                }
            } else {
                ShortcutEnterPanel.this.tfShortcut.setText(this.key + " " + string);
                if (bl) {
                    this.key = this.key + " " + string;
                }
            }
        }
    }
}

