/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class TestEntry {
    private static final String JAR_NAME = "tests.jar";
    private static final String QA_FUNCTIONAL = "qa-functional";
    private static final String UNIT = "unit";
    private static final String TEST_DIST_DIR = "nbbuild/build/testdist";
    private final String codeNameBase;
    private final boolean unit;
    private final String cluster;
    private final File jarFile;

    private TestEntry(File file, String string, boolean bl, String string2) {
        this.jarFile = file;
        this.codeNameBase = string;
        this.unit = bl;
        this.cluster = string2;
    }

    public static TestEntry get(File file) {
        String[] stringArray;
        int n;
        String string = file.getPath().replace(File.separatorChar, '/');
        if (string.endsWith(JAR_NAME) && (n = (stringArray = string.split("/")).length) > 3) {
            String string2 = stringArray[n - 2].replace('-', '.');
            String string3 = stringArray[n - 3];
            String string4 = stringArray[n - 4];
            boolean bl = true;
            if (!string4.equals(UNIT)) {
                if (string4.equals(QA_FUNCTIONAL)) {
                    bl = false;
                } else {
                    return null;
                }
            }
            return new TestEntry(file, string2, bl, string3);
        }
        return null;
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public boolean isUnit() {
        return this.unit;
    }

    public String getCluster() {
        return this.cluster == null ? "cluster" : this.cluster;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public File getTestDistRoot() {
        return this.getJarFile().getParentFile().getParentFile().getParentFile().getParentFile();
    }

    public URL getSrcDir() throws IOException {
        SubprojectProvider subprojectProvider;
        String string = this.getNetBeansOrgPath();
        if (string != null) {
            return new File(this.getNBRoot(), string).toURI().toURL();
        }
        File file = this.getTestDistRoot();
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)file));
        if (project != null && (subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class)) != null) {
            for (Project project2 : subprojectProvider.getSubprojects()) {
                FileObject fileObject;
                NbModuleProject nbModuleProject;
                if (!(project2 instanceof NbModuleProject) || (nbModuleProject = (NbModuleProject)project2) == null || !nbModuleProject.getCodeNameBase().equals(this.getCodeNameBase()) || (fileObject = this.isUnit() ? nbModuleProject.getTestSourceDirectory() : nbModuleProject.getFunctionalTestSourceDirectory()) == null) continue;
                return fileObject.getURL();
            }
        }
        return null;
    }

    File getNBRoot() {
        File file = this.getTestDistRoot();
        String string = file.getAbsolutePath().replace(File.separatorChar, '/');
        File file2 = null;
        if (string.endsWith(TEST_DIST_DIR)) {
            file2 = file.getParentFile().getParentFile().getParentFile();
        }
        return file2;
    }

    public String getNetBeansOrgPath() throws IOException {
        File file = this.getNBRoot();
        if (file != null && ModuleList.isNetBeansOrg(file)) {
            ModuleList moduleList = ModuleList.findOrCreateModuleListFromNetBeansOrgSources(file);
            ModuleEntry moduleEntry = moduleList.getEntry(this.codeNameBase);
            if (moduleEntry == null) {
                return null;
            }
            return moduleEntry.getNetBeansOrgPath() + "/test/" + this.getTestType() + "/src";
        }
        return null;
    }

    public String getTestType() {
        return this.isUnit() ? UNIT : QA_FUNCTIONAL;
    }

    public Project getProject() {
        try {
            URI uRI;
            URL uRL = this.getSrcDir();
            if (uRL != null && (uRI = uRL.toURI()) != null) {
                return FileOwnerQuery.getOwner((URI)uRI);
            }
        }
        catch (IOException iOException) {
            Util.err.notify((Throwable)iOException);
        }
        catch (URISyntaxException uRISyntaxException) {
            Util.err.notify((Throwable)uRISyntaxException);
        }
        return null;
    }
}

