/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JSFConfigHyperlinkProvider
implements HyperlinkProvider {
    private static boolean debug = false;
    private static Hashtable hyperlinkTable;
    private final int JAVA_CLASS = 0;
    private final int RESOURCE_PATH = 2;
    private int valueOffset;
    private String[] ev;

    public JSFConfigHyperlinkProvider() {
        hyperlinkTable = new Hashtable();
        hyperlinkTable.put("managed-bean-class", new Integer(0));
        hyperlinkTable.put("component-class", new Integer(0));
        hyperlinkTable.put("renderer-class", new Integer(0));
        hyperlinkTable.put("property-class", new Integer(0));
        hyperlinkTable.put("validator-class", new Integer(0));
        hyperlinkTable.put("attribute-class", new Integer(0));
        hyperlinkTable.put("message-bundle", new Integer(0));
        hyperlinkTable.put("action-listener", new Integer(0));
        hyperlinkTable.put("application-factory", new Integer(0));
        hyperlinkTable.put("converter-class", new Integer(0));
        hyperlinkTable.put("converter-for-class", new Integer(0));
        hyperlinkTable.put("faces-context-factory", new Integer(0));
        hyperlinkTable.put("key-class", new Integer(0));
        hyperlinkTable.put("lifecycle-factory", new Integer(0));
        hyperlinkTable.put("navigation-handler", new Integer(0));
        hyperlinkTable.put("phase-listener", new Integer(0));
        hyperlinkTable.put("property-resolver", new Integer(0));
        hyperlinkTable.put("referenced-bean-class", new Integer(0));
        hyperlinkTable.put("render-kit-class", new Integer(0));
        hyperlinkTable.put("render-kit-factory", new Integer(0));
        hyperlinkTable.put("value-class", new Integer(0));
        hyperlinkTable.put("variable-resolver", new Integer(0));
        hyperlinkTable.put("from-view-id", new Integer(2));
        hyperlinkTable.put("to-view-id", new Integer(2));
        this.ev = null;
    }

    public int[] getHyperlinkSpan(Document document, int n) {
        if (debug) {
            JSFConfigHyperlinkProvider.debug(":: getHyperlinkSpan");
        }
        if (this.ev != null) {
            return new int[]{this.valueOffset, this.valueOffset + this.ev[1].length() - 1};
        }
        return null;
    }

    public boolean isHyperlinkPoint(Document document, int n) {
        DataObject dataObject;
        if (debug) {
            JSFConfigHyperlinkProvider.debug(":: isHyperlinkSpan - offset: " + n);
        }
        if (!((dataObject = NbEditorUtilities.getDataObject((Document)document)) instanceof JSFConfigDataObject)) {
            return false;
        }
        this.ev = this.getElementValue(document, n);
        return this.ev != null && hyperlinkTable.get(this.ev[0]) != null;
    }

    public void performClickAction(Document document, int n) {
        if (debug) {
            JSFConfigHyperlinkProvider.debug(":: performClickAction");
        }
        if (hyperlinkTable.get(this.ev[0]) != null) {
            int n2 = (Integer)hyperlinkTable.get(this.ev[0]);
            switch (n2) {
                case 0: {
                    this.findJavaClass(this.ev[1], document);
                    break;
                }
                case 2: {
                    this.findResourcePath(this.ev[1], (BaseDocument)document);
                }
            }
        }
    }

    static void debug(String string) {
        System.out.println("JSFConfigHyperlinkProvider: " + string);
    }

    private String[] getElementValue(Document document, int n) {
        String string = null;
        String string2 = null;
        try {
            BaseDocument baseDocument = (BaseDocument)document;
            JTextComponent jTextComponent = Utilities.getFocusedComponent();
            if (jTextComponent == null || jTextComponent.getDocument() != baseDocument) {
                return null;
            }
            ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
            TokenItem tokenItem = extSyntaxSupport.getTokenChain(n, n + 1);
            if (tokenItem == null || tokenItem.getTokenID().getNumericID() != 1) {
                return null;
            }
            string2 = tokenItem.getImage();
            if (string2 != null) {
                String string3 = string2;
                string2 = string2.trim();
                this.valueOffset = tokenItem.getOffset() + string3.indexOf(string2);
            }
            while (tokenItem != null && (tokenItem.getTokenID().getNumericID() != 4 || tokenItem.getImage().equals(">"))) {
                tokenItem = tokenItem.getPrevious();
            }
            if (tokenItem == null) {
                return null;
            }
            string = tokenItem.getImage().substring(1);
            if (debug) {
                JSFConfigHyperlinkProvider.debug("element: " + string);
            }
            if (debug) {
                JSFConfigHyperlinkProvider.debug("value: " + string2);
            }
            return new String[]{string, string2};
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return null;
        }
    }

    private boolean isWhiteChar(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private void findJavaClass(final String string, Document document) {
        WebModule webModule;
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject != null && (webModule = WebModule.getWebModule((FileObject)fileObject)) != null) {
            try {
                final ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)webModule.getDocumentBase());
                JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (Collection)Collections.EMPTY_LIST);
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        Elements elements = compilationController.getElements();
                        TypeElement typeElement = elements.getTypeElement(string.trim());
                        if (typeElement != null && !UiUtils.open((ClasspathInfo)classpathInfo, (Element)typeElement)) {
                            String string3 = "goto_source_not_found";
                            String string2 = NbBundle.getBundle(JSFConfigHyperlinkProvider.class).getString(string3);
                            StatusDisplayer.getDefault().setStatusText(MessageFormat.format(string2, string));
                        }
                    }
                }, false);
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    private void findResourcePath(String string, BaseDocument baseDocument) {
        FileObject fileObject;
        FileObject fileObject2;
        WebModule webModule;
        int n = string.indexOf(63);
        if (n == 0) {
            return;
        }
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((webModule = WebModule.getWebModule((FileObject)NbEditorUtilities.getFileObject((Document)baseDocument))) != null && (fileObject2 = (fileObject = webModule.getDocumentBase()).getFileObject(string)) != null) {
            this.openInEditor(fileObject2);
        }
    }

    private void openInEditor(FileObject fileObject) {
        if (fileObject != null) {
            Node.Cookie cookie;
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                return;
            }
            if (dataObject != null && (cookie = dataObject.getCookie(OpenCookie.class)) != null) {
                ((OpenCookie)cookie).open();
            }
        }
    }
}

