/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext;

import org.netbeans.modules.xml.xpath.ext.StepNodeTest;
import org.netbeans.modules.xml.xpath.ext.StepNodeTestType;

public class StepNodeTypeTest
extends StepNodeTest {
    private static StepNodeTestType[] int2Type = new StepNodeTestType[]{StepNodeTestType.NODETYPE_NODE, StepNodeTestType.NODETYPE_TEXT, StepNodeTestType.NODETYPE_COMMENT, StepNodeTestType.NODETYPE_PI};
    private StepNodeTestType mNodeType;
    private String mInstruction;

    public StepNodeTypeTest(int n, String string) {
        assert (n <= int2Type.length) : "The index of node test type " + n + " is out of possible values";
        this.mNodeType = int2Type[n - 1];
        this.mInstruction = string;
    }

    public StepNodeTypeTest(StepNodeTestType stepNodeTestType, String string) {
        this.mNodeType = stepNodeTestType;
        this.mInstruction = string;
    }

    public StepNodeTestType getNodeType() {
        return this.mNodeType;
    }

    public String getInstruction() {
        return this.mInstruction;
    }

    public boolean equals(Object object) {
        if (object instanceof StepNodeTypeTest) {
            StepNodeTypeTest stepNodeTypeTest = (StepNodeTypeTest)object;
            if (stepNodeTypeTest.mNodeType == this.mNodeType) {
                if (this.mNodeType == StepNodeTestType.NODETYPE_PI) {
                    if (stepNodeTypeTest.mInstruction == null) {
                        return this.mInstruction == null;
                    }
                    return stepNodeTypeTest.mInstruction.equals(this.mInstruction);
                }
                return true;
            }
        }
        return false;
    }

    public String getXPathText() {
        StepNodeTestType stepNodeTestType = this.getNodeType();
        if (stepNodeTestType == StepNodeTestType.NODETYPE_PI && this.mInstruction != null && this.mInstruction.length() != 0) {
            return stepNodeTestType.getXPathText() + "(" + this.mInstruction + ")";
        }
        return stepNodeTestType.getXPathText() + "()";
    }

    public String toString() {
        return this.getXPathText();
    }
}

