/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext;

import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.Form;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.xpath.ext.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.ext.schema.FindAllChildrenSchemaVisitor;

public class XPathUtils {
    public static String qNameObjectToString(QName qName) {
        String string = qName.getPrefix();
        if (string == null || string.length() == 0) {
            return qName.getLocalPart();
        }
        return string + ":" + qName.getLocalPart();
    }

    public static String gNameNamespaceToString(QName qName) {
        String string = qName.getPrefix();
        String string2 = qName.getNamespaceURI();
        if (string == null || string.length() == 0) {
            return "{" + string2 + "}";
        }
        return "{" + string2 + "}" + string;
    }

    public static QName resolvePrefix(NamespaceContext namespaceContext, QName qName) {
        String string;
        String string2 = qName.getNamespaceURI();
        if ((string2 == null || string2.length() == 0 && namespaceContext != null) && (string2 = namespaceContext.getNamespaceURI(string = qName.getPrefix())) != null) {
            QName qName2;
            String string3 = qName.getLocalPart();
            qName = qName2 = new QName(string2, string3);
        }
        return qName;
    }

    public static boolean equalsIgnorNsUri(QName qName, QName qName2) {
        return qName.getLocalPart().equals(qName2.getLocalPart()) && qName.getPrefix().equals(qName2.getPrefix());
    }

    public static boolean samePredicatesArr(XPathPredicateExpression[] xPathPredicateExpressionArray, XPathPredicateExpression[] xPathPredicateExpressionArray2) {
        int n;
        int n2 = xPathPredicateExpressionArray == null ? 0 : xPathPredicateExpressionArray.length;
        int n3 = n = xPathPredicateExpressionArray2 == null ? 0 : xPathPredicateExpressionArray2.length;
        if (n2 != n) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            String string;
            XPathPredicateExpression xPathPredicateExpression = xPathPredicateExpressionArray[i];
            XPathPredicateExpression xPathPredicateExpression2 = xPathPredicateExpressionArray2[i];
            String string2 = xPathPredicateExpression.getExpressionString();
            if (string2.equals(string = xPathPredicateExpression2.getExpressionString())) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrefixRequired(SchemaComponent schemaComponent) {
        if (schemaComponent instanceof LocalElement) {
            Form form = ((LocalElement)schemaComponent).getFormEffective();
            return form == Form.QUALIFIED;
        }
        if (schemaComponent instanceof GlobalElement) {
            return true;
        }
        if (schemaComponent instanceof LocalAttribute) {
            Form form = ((LocalAttribute)schemaComponent).getFormEffective();
            return form == Form.QUALIFIED;
        }
        return schemaComponent instanceof GlobalElement || schemaComponent instanceof ElementReference || schemaComponent instanceof GlobalAttribute;
    }

    public static boolean hasSubcomponents(SchemaComponent schemaComponent) {
        FindAllChildrenSchemaVisitor findAllChildrenSchemaVisitor = new FindAllChildrenSchemaVisitor(true, true);
        findAllChildrenSchemaVisitor.lookForSubcomponents(schemaComponent);
        List<SchemaComponent> list = findAllChildrenSchemaVisitor.getFound();
        return list != null && !list.isEmpty();
    }
}

