/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.TypeContainer;
import org.netbeans.modules.xml.schema.model.visitor.DeepSchemaVisitor;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xpath.ext.schema.AbstractSchemaSearchVisitor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindChildrenSchemaVisitor
extends AbstractSchemaSearchVisitor {
    private String mySoughtName;
    private String mySoughtNamespace;
    private boolean isAttribute;
    private List<SchemaComponent> myFound = new ArrayList<SchemaComponent>();
    private GlobalComplexType myGlobalComplexType;
    private boolean ENABLE;

    public FindChildrenSchemaVisitor(String string, String string2, boolean bl) {
        assert (string != null) : "At least sought name has to be specified!";
        this.mySoughtName = string;
        this.mySoughtNamespace = string2;
        this.isAttribute = bl;
    }

    @Override
    public void visit(ElementReference elementReference) {
        if (!this.isAttribute) {
            String string;
            if (!this.isXdmDomUsed((SchemaComponent)elementReference)) {
                this.checkComponent((SchemaComponent)elementReference);
            }
            if (!this.mySoughtName.equals(string = this.fastGetRefName(elementReference.getRef()))) {
                return;
            }
            super.visit(elementReference);
        }
    }

    @Override
    public void visit(AttributeReference attributeReference) {
        if (this.isAttribute) {
            String string;
            if (!this.isXdmDomUsed((SchemaComponent)attributeReference)) {
                this.checkComponent((SchemaComponent)attributeReference);
            }
            if (!this.mySoughtName.equals(string = this.fastGetRefName(attributeReference.getRef()))) {
                return;
            }
            super.visit(attributeReference);
        }
    }

    public List<SchemaComponent> getFound() {
        return this.myFound;
    }

    private boolean isChildFound() {
        return this.myFound.size() > 0;
    }

    public void lookForSubcomponent(SchemaComponent schemaComponent) {
        if (schemaComponent instanceof org.netbeans.modules.xml.schema.model.Element) {
            if (schemaComponent instanceof TypeContainer) {
                GlobalType globalType;
                NamedComponentReference namedComponentReference = ((TypeContainer)schemaComponent).getType();
                if (namedComponentReference != null && (globalType = (GlobalType)namedComponentReference.get()) != null) {
                    globalType.accept((SchemaVisitor)this);
                }
                if ((globalType = ((TypeContainer)schemaComponent).getInlineType()) != null) {
                    globalType.accept((SchemaVisitor)this);
                }
            } else if (schemaComponent instanceof ElementReference) {
                NamedComponentReference namedComponentReference = ((ElementReference)schemaComponent).getRef();
                if (namedComponentReference != null) {
                    GlobalElement globalElement = (GlobalElement)namedComponentReference.get();
                    this.lookForSubcomponent((SchemaComponent)globalElement);
                } else if (schemaComponent instanceof DocumentComponent) {
                    SchemaComponent schemaComponent2 = schemaComponent;
                    String string = schemaComponent2.getPeer().getAttribute("type");
                    if ((string = this.removePrefix(string)) == null || string.equals("")) {
                        NodeList nodeList = schemaComponent2.getPeer().getElementsByTagName("xs:extension");
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            Node node = nodeList.item(i);
                            if (!(node instanceof Element)) continue;
                            Element element = (Element)node;
                            this.findInType(element.getAttribute("base"), schemaComponent);
                            if (this.isChildFound()) break;
                        }
                        this.findElement(this.mySoughtName, (DocumentComponent)schemaComponent2, schemaComponent);
                    } else {
                        this.findInType(string, schemaComponent);
                    }
                }
            }
        } else if (schemaComponent instanceof ComplexType) {
            this.visitChildren(schemaComponent);
        } else if (schemaComponent instanceof Schema) {
            this.visitChildren(schemaComponent);
        }
    }

    private void findElement(String string, DocumentComponent documentComponent, SchemaComponent schemaComponent) {
        this.findElement(string, documentComponent, schemaComponent, "xs:element");
        this.findElement(string, documentComponent, schemaComponent, "xsd:element");
    }

    private void findElement(String string, DocumentComponent documentComponent, SchemaComponent schemaComponent, String string2) {
        if (string == null || string.equals("")) {
            return;
        }
        NodeList nodeList = documentComponent.getPeer().getElementsByTagName(string2);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !string.equals((element = (Element)node).getAttribute("name"))) continue;
            this.myFound.add(schemaComponent);
            return;
        }
    }

    private String removePrefix(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    private void findInType(String string, SchemaComponent schemaComponent) {
        Schema schema = schemaComponent.getModel().getSchema();
        boolean bl = this.findInType(string, schemaComponent, schema);
        if (bl) {
            return;
        }
        Collection collection = schema.getImports();
        for (Import import_ : collection) {
            try {
                SchemaModel schemaModel = import_.resolveReferencedModel();
                bl = this.findInType(string, schemaComponent, schemaModel.getSchema());
                if (!bl) continue;
                return;
            }
            catch (CatalogModelException catalogModelException) {
            }
        }
    }

    private boolean findInType(final String string, SchemaComponent schemaComponent, Schema schema) {
        if (string == null || string.equals("")) {
            return false;
        }
        this.myGlobalComplexType = null;
        schema.accept((SchemaVisitor)new DeepSchemaVisitor(){

            public void visit(GlobalComplexType globalComplexType) {
                if (string.equals(globalComplexType.getName())) {
                    FindChildrenSchemaVisitor.this.myGlobalComplexType = globalComplexType;
                }
            }
        });
        if (this.myGlobalComplexType != null) {
            this.myGlobalComplexType.accept((SchemaVisitor)this);
            return true;
        }
        return false;
    }

    private String getName(SchemaComponent schemaComponent) {
        if (schemaComponent instanceof Named) {
            return ((Named)schemaComponent).getName();
        }
        return "";
    }

    @Override
    protected void checkComponent(SchemaComponent schemaComponent) {
        String string;
        Object object;
        if (schemaComponent instanceof ElementReference && schemaComponent instanceof DocumentComponent) {
            object = schemaComponent;
            string = object.getPeer().getAttribute("ref");
            if (this.mySoughtName.equals(string = this.removePrefix(string))) {
                this.myFound.add(schemaComponent);
                return;
            }
        }
        if (schemaComponent instanceof Named) {
            object = schemaComponent.getModel().getEffectiveNamespace(schemaComponent);
            string = ((Named)schemaComponent).getName();
            if (this.mySoughtName.equals(string)) {
                if (this.mySoughtNamespace == null || this.mySoughtNamespace.length() == 0) {
                    this.myFound.add(schemaComponent);
                } else if (this.mySoughtNamespace.equals(object)) {
                    this.myFound.add(schemaComponent);
                }
            }
        }
    }

    private void out() {
        if (this.ENABLE) {
            System.out.println();
        }
    }

    private void out(Object object) {
        if (this.ENABLE) {
            System.out.println("*** " + object);
        }
    }
}

