/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext.visitor.impl;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xpath.ext.CoreOperationType;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.XPathCoreFunction;
import org.netbeans.modules.xml.xpath.ext.XPathCoreOperation;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.ext.XPathExtensionFunction;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathNumericLiteral;
import org.netbeans.modules.xml.xpath.ext.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.ext.XPathStringLiteral;
import org.netbeans.modules.xml.xpath.ext.XPathVariableReference;
import org.netbeans.modules.xml.xpath.ext.metadata.OperationMetadata;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathVisitorAdapter;

public class ExpressionWriter
extends XPathVisitorAdapter {
    private StringBuffer mBuffer = new StringBuffer();
    private XPathExpression mParentExpr;
    private XPathModel mXPathModel;

    public ExpressionWriter(XPathModel xPathModel) {
        this.mXPathModel = xPathModel;
    }

    public String getString() {
        return this.mBuffer.toString();
    }

    public void visit(LocationStep locationStep) {
        this.mBuffer.append(locationStep.getString());
        XPathPredicateExpression[] xPathPredicateExpressionArray = locationStep.getPredicates();
        if (xPathPredicateExpressionArray != null) {
            int n = xPathPredicateExpressionArray.length;
            for (int i = 0; i < n; ++i) {
                xPathPredicateExpressionArray[i].accept(this);
            }
        }
    }

    public void visit(XPathPredicateExpression xPathPredicateExpression) {
        XPathExpression xPathExpression = xPathPredicateExpression.getPredicate();
        if (xPathExpression != null) {
            this.mBuffer.append('[');
            this.mParentExpr = xPathPredicateExpression;
            xPathExpression.accept(this);
            this.mBuffer.append(']');
        }
    }

    public void visit(XPathVariableReference xPathVariableReference) {
        this.mBuffer.append("$" + xPathVariableReference.getVariableName());
    }

    public void visit(XPathStringLiteral xPathStringLiteral) {
        String string = xPathStringLiteral.getValue();
        boolean bl = false;
        if (string.length() >= 2) {
            if (string.startsWith("'") && string.endsWith("'")) {
                bl = true;
            } else if (string.startsWith("\"") && string.endsWith("\"")) {
                bl = true;
            }
        }
        if (bl) {
            this.mBuffer.append(string);
        } else if (string.indexOf("'") >= 0) {
            this.mBuffer.append("\"");
            this.mBuffer.append(string);
            this.mBuffer.append("\"");
        } else {
            this.mBuffer.append("'");
            this.mBuffer.append(string);
            this.mBuffer.append("'");
        }
    }

    public void visit(XPathNumericLiteral xPathNumericLiteral) {
        this.mBuffer.append(xPathNumericLiteral.getValue().toString());
    }

    public void visit(XPathLocationPath xPathLocationPath) {
        LocationStep[] locationStepArray = xPathLocationPath.getSteps();
        if (xPathLocationPath.getAbsolute()) {
            this.mBuffer.append("/");
        }
        for (int i = 0; i < locationStepArray.length; ++i) {
            if (i != 0) {
                this.mBuffer.append("/");
            }
            this.mParentExpr = xPathLocationPath;
            locationStepArray[i].accept(this);
        }
    }

    public void visit(XPathExpressionPath xPathExpressionPath) {
        XPathExpression xPathExpression = xPathExpressionPath.getRootExpression();
        if (xPathExpression != null) {
            this.mParentExpr = xPathExpressionPath;
            xPathExpression.accept(this);
        }
        LocationStep[] locationStepArray = xPathExpressionPath.getSteps();
        for (int i = 0; i < locationStepArray.length; ++i) {
            this.mBuffer.append("/");
            this.mParentExpr = xPathExpressionPath;
            locationStepArray[i].accept(this);
        }
    }

    public void visit(XPathCoreOperation xPathCoreOperation) {
        if (CoreOperationType.OP_NEGATIVE == xPathCoreOperation.getOperationType()) {
            this.mBuffer.append((String)xPathCoreOperation.getOperationType().getMetadata().getName());
            if (xPathCoreOperation.getChildCount() > 0) {
                XPathExpression xPathExpression = xPathCoreOperation.getChild(0);
                this.mParentExpr = xPathCoreOperation;
                xPathExpression.accept(this);
            }
        } else {
            int n;
            boolean bl = false;
            OperationMetadata operationMetadata = xPathCoreOperation.getOperationType().getMetadata();
            if (this.mParentExpr != null && this.mParentExpr instanceof XPathCoreOperation) {
                int n2;
                n = ((XPathCoreOperation)this.mParentExpr).getOperationType().getMetadata().getPrecedenceLevel();
                boolean bl2 = bl = n > (n2 = operationMetadata.getPrecedenceLevel());
            }
            if (bl) {
                this.mBuffer.append("(");
            }
            n = 1;
            for (XPathExpression xPathExpression : xPathCoreOperation.getChildren()) {
                if (n != 0) {
                    n = 0;
                } else {
                    this.mBuffer.append(' ');
                    this.mBuffer.append((String)operationMetadata.getName());
                    this.mBuffer.append(' ');
                }
                this.mParentExpr = xPathCoreOperation;
                xPathExpression.accept(this);
            }
            if (bl) {
                this.mBuffer.append(")");
            }
        }
    }

    public void visit(XPathCoreFunction xPathCoreFunction) {
        this.mBuffer.append((String)xPathCoreFunction.getName());
        this.mBuffer.append('(');
        boolean bl = true;
        for (XPathExpression xPathExpression : xPathCoreFunction.getChildren()) {
            if (bl) {
                bl = false;
            } else {
                this.mBuffer.append(", ");
            }
            this.mParentExpr = xPathCoreFunction;
            xPathExpression.accept(this);
        }
        this.mBuffer.append(')');
    }

    public void visit(XPathExtensionFunction xPathExtensionFunction) {
        QName qName = xPathExtensionFunction.getName();
        String string = qName.getPrefix();
        String string2 = qName.getLocalPart();
        if (string == null || string.length() == 0) {
            string = this.calculateFuncPrefix(qName);
        }
        if (string == null || string.length() == 0) {
            this.mBuffer.append(string2);
        } else {
            this.mBuffer.append(string + ":" + string2);
        }
        this.mBuffer.append('(');
        boolean bl = true;
        for (XPathExpression xPathExpression : xPathExtensionFunction.getChildren()) {
            if (bl) {
                bl = false;
            } else {
                this.mBuffer.append(", ");
            }
            this.mParentExpr = xPathExtensionFunction;
            xPathExpression.accept(this);
        }
        this.mBuffer.append(')');
    }

    public String calculateFuncPrefix(QName qName) {
        NamespaceContext namespaceContext;
        if (this.mXPathModel != null && (namespaceContext = this.mXPathModel.getNamespaceContext()) != null) {
            String string = qName.getNamespaceURI();
            return namespaceContext.getPrefix(string);
        }
        return null;
    }
}

