/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.algorithm.layout;

import com.tomsawyer.algorithm.layout.TSLayoutServer;
import com.tomsawyer.algorithm.layout.util.TSProgress;
import com.tomsawyer.drawing.TSDGraphManager;

public class TSLayoutThread
extends Thread {
    private TSLayoutServer layoutProxy;
    private TSDGraphManager graphManager;
    private boolean incremental;
    private TSProgress progress = new TSProgress();

    public TSLayoutThread(TSDGraphManager tSDGraphManager, TSLayoutServer tSLayoutServer, boolean bl) {
        this.graphManager = tSDGraphManager;
        this.layoutProxy = tSLayoutServer;
        this.incremental = bl;
    }

    public void run() {
        try {
            if (this.incremental) {
                this.layoutProxy.incrementalLayout(this.graphManager);
            } else {
                this.layoutProxy.globalLayout(this.graphManager);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void reset() {
        TSProgress tSProgress = TSLayoutThread.getProgress();
        if (tSProgress != null) {
            tSProgress.reset();
        }
    }

    public static void startTask(String string) {
        TSProgress tSProgress = TSLayoutThread.getProgress();
        if (tSProgress != null) {
            tSProgress.startTask(string);
        }
    }

    public static void startStep(String string, double d) {
        TSProgress tSProgress = TSLayoutThread.getProgress();
        if (tSProgress != null) {
            tSProgress.startStep(string, d);
        }
    }

    public static void endTask() {
        TSProgress tSProgress = TSLayoutThread.getProgress();
        if (tSProgress != null) {
            tSProgress.endTask();
        }
    }

    private static TSProgress getProgress() {
        Thread thread = Thread.currentThread();
        if (thread instanceof TSLayoutThread) {
            return ((TSLayoutThread)thread).progress;
        }
        return null;
    }

    public TSProgress getProgressInstance() {
        return this.progress;
    }
}

