/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.service;

import com.tomsawyer.event.TSChildEventSource;
import com.tomsawyer.event.TSEvent;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.service.TSHasPriorityConstraint;
import com.tomsawyer.service.dl;
import com.tomsawyer.service.event.TSConstraintChangeEvent;
import com.tomsawyer.service.event.TSConstraintChangeEventData;
import com.tomsawyer.util.TSParser;
import com.tomsawyer.util.TSSystem;
import java.io.IOException;

public abstract class TSConstraint
implements TSHasPriorityConstraint,
Cloneable,
TSChildEventSource {
    private dl constraintManager = null;
    private boolean fulfilled = false;
    private boolean valid = false;
    private int priority = 0;
    private String name = null;
    private static int nextID = 1;

    public TSConstraint() {
        this(0);
    }

    public TSConstraint(int n) {
        this.priority = n;
    }

    public boolean isFulfilled() {
        return this.fulfilled;
    }

    public void setFulfilled(boolean bl) {
        boolean bl2 = this.fulfilled;
        this.fulfilled = bl;
        if (bl2 != bl) {
            this.fireConstraintChangedEvent();
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        int n10 = this.priority;
        this.priority = n;
        if (n10 != n) {
            this.fireConstraintChangedEvent();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        if (!TSSystem.equals((Object)string2, (Object)string)) {
            this.fireConstraintChangedEvent();
        }
    }

    public void setConstraintManager(dl dl2) {
        this.constraintManager = dl2;
    }

    public dl getConstraintManager() {
        return this.constraintManager;
    }

    public Object clone() {
        TSConstraint tSConstraint = null;
        try {
            tSConstraint = (TSConstraint)super.clone();
            tSConstraint.copy(this);
            tSConstraint.setValid(tSConstraint.checkValidity());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return tSConstraint;
    }

    public void read(TSGraphObjectTable tSGraphObjectTable, TSParser tSParser) throws IOException {
        String string = tSParser.getString();
        if (string.equals("text")) {
            String string2 = tSParser.getText().trim();
            if (!"null".equals(string2)) {
                this.setName(string2);
            }
        } else {
            tSParser.pushBack();
        }
        tSParser.parseInputString("priority");
        this.setPriority(tSParser.getInt());
    }

    public abstract boolean checkValidity();

    public abstract TSConstraint cloneWithAttributes();

    protected void setValid(boolean bl) {
        this.valid = bl;
    }

    protected void copy(TSConstraint tSConstraint) {
        this.fulfilled = false;
        this.valid = false;
        this.priority = tSConstraint.getPriority();
        if (tSConstraint.getName() != null) {
            this.name = new String(tSConstraint.getName());
        }
    }

    public static int nextID() {
        int n = nextID++;
        return n;
    }

    public Object getParentEventSource() {
        return this.constraintManager;
    }

    public void fireConstraintChangedEvent() {
        this.setValid(this.checkValidity());
        if (this.getConstraintManager() != null && this.getConstraintManager().getEventManager() != null) {
            this.getConstraintManager().getEventManager().fireEvent((TSEvent)new TSConstraintChangeEvent(4L, new TSConstraintChangeEventData(this, null, null)));
        }
    }
}

