/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.service.server;

import com.tomsawyer.service.TSService;
import com.tomsawyer.service.TSServiceException;
import com.tomsawyer.util.TSLicenseManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class TSSOAPServiceServer {
    private TSService service = null;
    private int debugLevel = 0;

    public String runRemote(String string, String string2) {
        TSLicenseManager.initTSSLicensing();
        this.setServiceName(string);
        String string3 = null;
        if (this.debugLevel > 0) {
            System.out.println("TSSOAPServiceServer.runRemote debug: Called with input string:\n" + string2);
        }
        if (this.service == null) {
            throw new TSServiceException(80, "Service type was not set.");
        }
        string3 = this.service.runRemote(string2);
        return string3;
    }

    public String getTextDescription() {
        if (this.debugLevel > 0) {
            System.out.println("TSISOAPServiceProxy debug: About to redirect getTextDescription call to actual service.");
        }
        String string = this.service.getTextDescription();
        if (this.debugLevel > 0) {
            System.out.println("TSSOAPServiceServer debug: Have returned from getTextDescription call, value is:\n" + string);
        }
        return string;
    }

    public void setServiceName(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            this.service = (TSService)constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException instantiationException) {
            throw new TSServiceException(80, instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TSServiceException(81, illegalAccessException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TSServiceException(80, classNotFoundException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new TSServiceException(80, noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TSServiceException(80, invocationTargetException.getMessage());
        }
    }
}

