/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Completable;
import org.netbeans.modules.gsf.api.CompletionProposal;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParameterInfo;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.DeclarationFinder;
import org.netbeans.modules.ruby.RDocFormatter;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyParser;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.TypeAnalyzer;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.AstFieldElement;
import org.netbeans.modules.ruby.elements.AstVariableElement;
import org.netbeans.modules.ruby.elements.ClassElement;
import org.netbeans.modules.ruby.elements.CommentElement;
import org.netbeans.modules.ruby.elements.Element;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.elements.KeywordElement;
import org.netbeans.modules.ruby.elements.RubyElement;
import org.netbeans.modules.ruby.lexer.Call;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyStringTokenId;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeCompleter
implements Completable {
    private static final boolean INCLUDE_CALL_ITEMS = true;
    private static final String KEY_REQUIRE = "require";
    private static final String KEY_INSTANCEOF = "instanceof";
    private static final String ATTR_UNUSEDLOCAL = "unusedlocal";
    private static final String KEY_PIPE = "pipe";
    private static final String KEY_METHOD = "method";
    private static final String KEY_METHOD_FQN = "methodfqn";
    private static final String KEY_CLASS = "class";
    private static final String KEY_CLASS_FQN = "classfqn";
    private static final String KEY_SUPERCLASS = "superclass";
    private static final String KEY_FILE = "file";
    private static final String KEY_PATH = "path";
    private static final String ATTR_DEFAULTS = "defaults";
    private static final String[] RUBY_BUILTIN_VARS = new String[]{"__FILE__", "__LINE__", "STDIN", "STDOUT", "STDERR", "ENV", "ARGF", "ARGV", "DATA", "RUBY_VERSION", "RUBY_RELEASE_DATE", "RUBY_PLATFORM", "$DEBUG", "$FILENAME", "$LOAD_PATH", "$stderr", "$stdin", "$stdout", "$VERBOSE"};
    private static final String[] RUBY_REGEXP_WORDS = new String[]{"^", "Start of line", "$", "End of line", "\\A", "Beginning of string", "\\z", "End of string", "\\Z", "End of string (except \\n)", "\\w", "Letter or digit; same as [0-9A-Za-z]", "\\W", "Neither letter or digit", "\\s", "Space character; same as [ \\t\\n\\r\\f]", "\\S", "Non-space character", "\\d", "Digit character; same as [0-9]", "\\D", "Non-digit character", "\\b", "Backspace (0x08) (only if in a range specification)", "\\b", "Word boundary (if not in a range specification)", "\\B", "Non-word boundary", "*", "Zero or more repetitions of the preceding", "+", "One or more repetitions of the preceding", "{m,n}", "At least m and at most n repetitions of the preceding", "?", "At most one repetition of the preceding; same as {0,1}", "|", "Either preceding or next expression may match", "()", "Grouping", "[:alnum:]", "Alphanumeric character class", "[:alpha:]", "Uppercase or lowercase letter", "[:blank:]", "Blank and tab", "[:cntrl:]", "Control characters (at least 0x00-0x1f,0x7f)", "[:digit:]", "Digit", "[:graph:]", "Printable character excluding space", "[:lower:]", "Lowecase letter", "[:print:]", "Any printable letter (including space)", "[:punct:]", "Printable character excluding space and alphanumeric", "[:space:]", "Whitespace (same as \\s)", "[:upper:]", "Uppercase letter", "[:xdigit:]", "Hex digit (0-9, a-f, A-F)"};
    private static final String[] RUBY_PERCENT_WORDS = new String[]{"%q", "String (single-quoting rules)", "%Q", "String (double-quoting rules)", "%r", "Regular Expression", "%x", "Commands", "%W", "String Array (double quoting rules)", "%w", "String Array (single quoting rules)", "%s", "Symbol"};
    private static final String[] RUBY_STRING_PAIRS = new String[]{"(", "(delimiters)", "{", "{delimiters}", "[", "[delimiters]", "x", "<i>x</i>delimiters<i>x</i>"};
    private static final String[] RUBY_DOLLAR_VARIABLES = new String[]{"$!", "Latest error message", "$@", "Location of error", "$_", "String last read by gets", "$.", "Line number last read by interpreter", "$&", "String last matched by regexp", "$~", "The last regexp match, as an array of subexpressions", "$n", "The nth subexpression in the last match (same as $~[n])", "$=", "Case-insensitivity flag", "$/", "Input record separator", "$\\", "Output record separator", "$0", "The name of the ruby script file", "$*", "The command line arguments", "$$", "Interpreter's process ID", "$?", "Exit status of last executed child process"};
    private static final String[] RUBY_QUOTED_STRING_ESCAPES = new String[]{"\\a", "Bell/alert (0x07)", "\\b", "Backspace (0x08)", "\\x", "\\x<i>nn</i>: Hex <i>nn</i>", "\\e", "Escape (0x1b)", "\\c", "Control-<i>x</i>", "\\C-", "Control-<i>x</i>", "\\f", "Formfeed (0x0c)", "\\n", "Newline (0x0a)", "\\M-", "\\M-<i>x</i>: Meta-<i>x</i>", "\\r", "Return (0x0d)", "\\M-\\C-", "Meta-control-<i>x</i>", "\\s", "Space (0x20)", "\\", "\\nnn Octal <i>nnn</i>", "\\t", "Tab (0x09)", "#{", "#{expr}: Value of expr", "\\v", "Vertical tab (0x0b)"};
    private static ImageIcon keywordIcon;
    private static ImageIcon symbolIcon;
    private static final Set<String> selectionTemplates;
    private boolean caseSensitive;
    private int anchor;
    private static int callLineStart;
    private static IndexedMethod callMethod;
    private static final boolean FORCE_COMPLETION_SPACES;

    private boolean startsWith(String string, String string2) {
        if (string2.length() == 0) {
            return true;
        }
        return this.caseSensitive ? string.startsWith(string2) : string.toLowerCase().startsWith(string2.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPrefix(CompilationInfo compilationInfo, int n, boolean bl) {
        try {
            BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            baseDocument.readLock();
            try {
                int n2;
                int n3;
                String string;
                int n4;
                int n5;
                int n6;
                int n7;
                String string2;
                Token token;
                int n8 = LexUtilities.getRequireStringOffset(n, (TokenHierarchy<Document>)tokenHierarchy);
                if (n8 != -1) {
                    String string3 = baseDocument.getText(n8, n - n8);
                    return string3;
                }
                TokenSequence tokenSequence = LexUtilities.getRubyTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
                if (tokenSequence == null) {
                    String string4 = null;
                    return string4;
                }
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    String string5 = null;
                    return string5;
                }
                if (tokenSequence.offset() == n) {
                    tokenSequence.movePrevious();
                }
                if ((token = tokenSequence.token()) != null) {
                    TokenId tokenId = token.id();
                    if (tokenId == RubyTokenId.EMBEDDED_RUBY) {
                        tokenSequence = tokenSequence.embedded();
                        assert (tokenSequence != null);
                        tokenSequence.move(n);
                        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                            String string6 = null;
                            return string6;
                        }
                        token = tokenSequence.token();
                        tokenId = token.id();
                    }
                    string2 = ((Object)token.text()).toString();
                    if ((tokenId == RubyTokenId.STRING_BEGIN || tokenId == RubyTokenId.QUOTED_STRING_BEGIN || tokenId == RubyTokenId.ERROR && string2.equals("%")) && (n7 = tokenSequence.offset()) == n - 1 && string2.length() > 0 && string2.charAt(0) == '%') {
                        String string7 = "%";
                        return string7;
                    }
                }
                if ((n6 = LexUtilities.getDoubleQuotedStringOffset(n, (TokenHierarchy<Document>)tokenHierarchy)) != -1) {
                    if (n6 == n) {
                        string2 = "";
                        return string2;
                    }
                    if (n6 >= n) {
                        string2 = "";
                        return string2;
                    }
                    string2 = baseDocument.getText(n6, n - n6);
                    TokenHierarchy tokenHierarchy2 = TokenHierarchy.create((CharSequence)string2, RubyStringTokenId.languageDouble());
                    TokenSequence tokenSequence2 = tokenHierarchy2.tokenSequence();
                    tokenSequence2.move(n - n6);
                    if (!tokenSequence2.moveNext() && !tokenSequence2.movePrevious()) {
                        String string8 = "";
                        return string8;
                    }
                    TokenId tokenId = tokenSequence2.token().id();
                    String string9 = ((Object)tokenSequence2.token().text()).toString();
                    if (tokenId == RubyStringTokenId.STRING_ESCAPE || tokenId == RubyStringTokenId.STRING_INVALID) {
                        String string10 = string9;
                        return string10;
                    }
                    if (string9.startsWith("\\")) {
                        String string11 = string9;
                        return string11;
                    }
                    String string12 = "";
                    return string12;
                }
                int n9 = LexUtilities.getSingleQuotedStringOffset(n, (TokenHierarchy<Document>)tokenHierarchy);
                if (n9 != -1) {
                    if (n9 == n) {
                        String string13 = "";
                        return string13;
                    }
                    if (n9 >= n) {
                        String string14 = "";
                        return string14;
                    }
                    String string15 = baseDocument.getText(n9, n - n9);
                    TokenHierarchy tokenHierarchy3 = TokenHierarchy.create((CharSequence)string15, RubyStringTokenId.languageSingle());
                    TokenSequence tokenSequence3 = tokenHierarchy3.tokenSequence();
                    tokenSequence3.move(n - n9);
                    if (!tokenSequence3.moveNext() && !tokenSequence3.movePrevious()) {
                        String string16 = "";
                        return string16;
                    }
                    TokenId tokenId = tokenSequence3.token().id();
                    String string17 = ((Object)tokenSequence3.token().text()).toString();
                    if (tokenId == RubyStringTokenId.STRING_ESCAPE || tokenId == RubyStringTokenId.STRING_INVALID) {
                        String string18 = string17;
                        return string18;
                    }
                    if (string17.startsWith("\\")) {
                        String string19 = string17;
                        return string19;
                    }
                    String string20 = "";
                    return string20;
                }
                n7 = LexUtilities.getRegexpOffset(n, (TokenHierarchy<Document>)tokenHierarchy);
                if (n7 != -1 && n7 <= n) {
                    String string21 = ((Object)token.text()).toString();
                    int n10 = n - tokenSequence.offset();
                    if (n10 > 0 && n10 <= string21.length() && string21.charAt(n10 - 1) == '\\') {
                        String string22 = "\\";
                        return string22;
                    }
                    String string23 = "";
                    return string23;
                }
                int n11 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                if (n11 == -1) return null;
                int n12 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                String string24 = baseDocument.getText(n11, n12 - n11);
                int n13 = n5 = n - n11;
                if (n5 > 0) {
                    int n14 = n5 - 1;
                    while (n14 >= 0 && RubyUtils.isIdentifierChar((char)(n4 = (int)string24.charAt(n14)))) {
                        n13 = n14--;
                    }
                }
                if (bl) {
                    string = string24.substring(n13, n5);
                } else if (n5 == string24.length()) {
                    string = string24.substring(n13);
                } else {
                    char c;
                    n4 = string24.length();
                    n3 = n5;
                    for (n2 = n5; n2 < n4 && RubyUtils.isStrictIdentifierChar(c = string24.charAt(n2)); ++n2) {
                        n3 = n2 + 1;
                    }
                    string = string24.substring(n13, n3);
                }
                if (string.length() <= 0) return null;
                if (string.endsWith("::")) {
                    String string25 = "";
                    return string25;
                }
                if (string.endsWith(":") && string.length() > 1) {
                    String string26 = null;
                    return string26;
                }
                n4 = string.lastIndexOf("::");
                if (n4 != -1) {
                    string = string.substring(n4 + 2);
                }
                if (string.length() == 1) {
                    n3 = string.charAt(0);
                    if (!Character.isJavaIdentifierPart((char)n3) && n3 != 64 && n3 != 36 && n3 != 58) {
                        String string27 = null;
                        return string27;
                    }
                } else {
                    for (n3 = string.length() - 2; n3 >= 0; --n3) {
                        n2 = string.charAt(n3);
                        if (n3 == 0 && n2 == 58 || Character.isJavaIdentifierPart((char)n2) || n2 == 64 || n2 == 36) continue;
                        string = string.substring(n3 + 1);
                        break;
                    }
                }
                String string28 = string;
                return string28;
            }
            finally {
                baseDocument.readUnlock();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return null;
    }

    private boolean completeKeywords(List<CompletionProposal> list, CompletionRequest completionRequest, boolean bl) {
        KeywordItem keywordItem;
        String string = completionRequest.prefix;
        if (string.equals("$")) {
            int n = RUBY_DOLLAR_VARIABLES.length;
            for (int i = 0; i < n; i += 2) {
                String string2 = RUBY_DOLLAR_VARIABLES[i];
                String string3 = RUBY_DOLLAR_VARIABLES[i + 1];
                keywordItem = new KeywordItem(string2, string3, this.anchor, completionRequest);
                if (bl) {
                    keywordItem.setSymbol(true);
                }
                list.add(keywordItem);
            }
        }
        for (String string3 : RUBY_BUILTIN_VARS) {
            if (!this.startsWith(string3, string)) continue;
            keywordItem = new KeywordItem(string3, null, this.anchor, completionRequest);
            if (bl) {
                keywordItem.setSymbol(true);
            }
            list.add(keywordItem);
        }
        for (String string3 : RubyUtils.RUBY_KEYWORDS) {
            if (!this.startsWith(string3, string)) continue;
            keywordItem = new KeywordItem(string3, null, this.anchor, completionRequest);
            if (bl) {
                keywordItem.setSymbol(true);
            }
            list.add(keywordItem);
        }
        return false;
    }

    private boolean completeRegexps(List<CompletionProposal> list, CompletionRequest completionRequest) {
        String string = completionRequest.prefix;
        int n = RUBY_REGEXP_WORDS.length;
        for (int i = 0; i < n; i += 2) {
            String string2 = RUBY_REGEXP_WORDS[i];
            String string3 = RUBY_REGEXP_WORDS[i + 1];
            if (!this.startsWith(string2, string)) continue;
            KeywordItem keywordItem = new KeywordItem(string2, string3, this.anchor, completionRequest);
            list.add(keywordItem);
        }
        return true;
    }

    private boolean completePercentWords(List<CompletionProposal> list, CompletionRequest completionRequest) {
        String string = completionRequest.prefix;
        int n = RUBY_PERCENT_WORDS.length;
        for (int i = 0; i < n; i += 2) {
            String string2 = RUBY_PERCENT_WORDS[i];
            String string3 = RUBY_PERCENT_WORDS[i + 1];
            if (!this.startsWith(string2, string)) continue;
            KeywordItem keywordItem = new KeywordItem(string2, string3, this.anchor, completionRequest);
            list.add(keywordItem);
        }
        return true;
    }

    private boolean completeStringBegins(List<CompletionProposal> list, CompletionRequest completionRequest) {
        int n = RUBY_STRING_PAIRS.length;
        for (int i = 0; i < n; i += 2) {
            String string = RUBY_STRING_PAIRS[i];
            String string2 = RUBY_STRING_PAIRS[i + 1];
            KeywordItem keywordItem = new KeywordItem(string, string2, this.anchor, completionRequest);
            list.add(keywordItem);
        }
        return true;
    }

    private boolean completeDefOrInclude(List<CompletionProposal> list, CompletionRequest completionRequest, String string) {
        RubyIndex rubyIndex = completionRequest.index;
        String string2 = completionRequest.prefix;
        int n = completionRequest.lexOffset;
        TokenHierarchy tokenHierarchy = completionRequest.th;
        NameKind nameKind = completionRequest.kind;
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
        if (rubyIndex != null && tokenSequence != null) {
            Token token;
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return false;
            }
            if (tokenSequence.offset() == n) {
                tokenSequence.movePrevious();
            }
            if ((token = tokenSequence.token()) != null) {
                TokenId tokenId = token.id();
                if (tokenId == RubyTokenId.IDENTIFIER || tokenId == RubyTokenId.CONSTANT || tokenId.primaryCategory().equals("keyword")) {
                    if (!tokenSequence.movePrevious()) {
                        return false;
                    }
                    token = tokenSequence.token();
                    tokenId = token.id();
                }
                if (tokenId != RubyTokenId.WHITESPACE) {
                    return false;
                }
                while (tokenSequence.movePrevious() && (token = tokenSequence.token()).id() == RubyTokenId.WHITESPACE) {
                }
                if (token.id() == RubyTokenId.DEF) {
                    Set<IndexedMethod> set = rubyIndex.getInheritedMethods(string, string2, nameKind);
                    for (IndexedMethod indexedMethod : set) {
                        if (string2.length() > 0 && !indexedMethod.getName().startsWith(string2) || string != null && string.equals(indexedMethod.getClz()) || indexedMethod.isNoDoc()) continue;
                        MethodItem methodItem = new MethodItem(indexedMethod, this.anchor, completionRequest);
                        methodItem.setSmart(indexedMethod.isSmart());
                        list.add(methodItem);
                    }
                    return true;
                }
                if (token.id() == RubyTokenId.IDENTIFIER && "include".equals(((Object)token.text()).toString())) {
                    Set<IndexedClass> set = rubyIndex.getClasses(string2, nameKind, false, true, false);
                    for (IndexedClass indexedClass : set) {
                        if (indexedClass.isNoDoc()) continue;
                        ClassItem classItem = new ClassItem(indexedClass, this.anchor, completionRequest);
                        classItem.setSmart(true);
                        list.add(classItem);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean completeObjectMethod(List<CompletionProposal> list, CompletionRequest completionRequest, String string, Call call) {
        RubyIndex rubyIndex = completionRequest.index;
        String string2 = completionRequest.prefix;
        int n = completionRequest.astOffset;
        int n2 = completionRequest.lexOffset;
        TokenHierarchy tokenHierarchy = completionRequest.th;
        BaseDocument baseDocument = completionRequest.doc;
        AstPath astPath = completionRequest.path;
        NameKind nameKind = completionRequest.kind;
        FileObject fileObject = completionRequest.fileObject;
        Node node = completionRequest.node;
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n2);
        if (rubyIndex != null && tokenSequence != null) {
            Object object3;
            Object object2;
            boolean bl = true;
            if (call == Call.LOCAL || call == Call.NONE) {
                return false;
            }
            boolean bl2 = call.isMethodExpected();
            boolean bl3 = call.isStatic();
            Set<Object> set = Collections.emptySet();
            String string3 = call.getType();
            String string4 = call.getLhs();
            if (string3 == null && string4 != null && node != null && call.isSimpleIdentifier() && (object2 = AstUtilities.findLocalScope(node, astPath)) != null) {
                object3 = new TypeAnalyzer(rubyIndex, (Node)object2, node, n, n2, baseDocument, fileObject);
                string3 = ((TypeAnalyzer)object3).getType(string4);
            }
            if (string3 != null && string3.length() > 0) {
                if ("self".equals(string4)) {
                    string3 = string;
                    bl = true;
                } else if ("super".equals(string4)) {
                    bl = true;
                    object2 = rubyIndex.getSuperclass(string);
                    if (object2 != null) {
                        string3 = ((IndexedElement)object2).getFqn();
                    } else {
                        object3 = AstUtilities.findClass(astPath);
                        if (object3 != null) {
                            string3 = AstUtilities.getSuperclass((ClassNode)object3);
                        }
                    }
                    if (string3 == null) {
                        string3 = "Object";
                    }
                }
                if (string3 != null && string3.length() > 0) {
                    while (set.size() == 0) {
                        set = rubyIndex.getInheritedMethods(string + "::" + string3, string2, nameKind);
                        int n3 = string.lastIndexOf("::");
                        if (n3 == -1) break;
                        string = string.substring(0, n3);
                    }
                    if ((object2 = rubyIndex.getInheritedMethods(string3, string2, nameKind)).size() > 0) {
                        set.addAll((Collection<Object>)object2);
                    }
                }
            }
            if (set.size() == 0) {
                set = rubyIndex.getMethods(string2, null, nameKind);
            }
            for (Object object3 : set) {
                RubyCompletionItem rubyCompletionItem;
                if (bl && ((IndexedElement)object3).isPrivate() && !"new".equals(((IndexedMethod)object3).getName()) || bl3 && !((IndexedElement)object3).isStatic() || ((IndexedElement)object3).isNoDoc()) continue;
                if (((IndexedMethod)object3).getMethodType() == IndexedMethod.MethodType.DBCOLUMN) {
                    rubyCompletionItem = new DbItem(((IndexedMethod)object3).getName(), ((IndexedElement)object3).getIn(), this.anchor, completionRequest);
                    list.add(rubyCompletionItem);
                    continue;
                }
                rubyCompletionItem = new MethodItem((IndexedMethod)object3, this.anchor, completionRequest);
                rubyCompletionItem.setSmart(((IndexedMethod)object3).isSmart());
                list.add(rubyCompletionItem);
            }
            return bl2;
        }
        return false;
    }

    private boolean completeClasses(List<CompletionProposal> list, CompletionRequest completionRequest, boolean bl, Call call) {
        RubyIndex rubyIndex = completionRequest.index;
        String string = completionRequest.prefix;
        NameKind nameKind = completionRequest.kind;
        int n = this.anchor;
        int n2 = string.lastIndexOf("::");
        if (n2 != -1) {
            n += n2 + 2;
        }
        String string2 = string;
        if (call.isMethodExpected()) {
            return false;
        }
        String string3 = call.getType();
        String string4 = call.getLhs();
        if (string4 != null && string4.equals(string3)) {
            string2 = string3 + "::" + string;
        }
        AstPath astPath = completionRequest.path;
        String string5 = AstUtilities.getFqnName(astPath);
        HashSet<String> hashSet = new HashSet<String>();
        Set<IndexedClass> set = rubyIndex.getClasses(string2, nameKind, false, false, false, RubyIndex.ALL_SCOPE, hashSet);
        if (string5 != null && string5.length() > 0) {
            Set<IndexedClass> set2 = rubyIndex.getClasses(string5 + "::" + string2, nameKind, false, false, false, RubyIndex.ALL_SCOPE, hashSet);
            set.addAll((Collection<IndexedClass>)set2);
        }
        for (IndexedClass indexedClass : set) {
            if (indexedClass.isNoDoc()) continue;
            ClassItem classItem = new ClassItem(indexedClass, n, completionRequest);
            classItem.setSmart(true);
            if (bl) {
                classItem.setSymbol(true);
            }
            list.add(classItem);
        }
        return false;
    }

    private boolean completeStrings(List<CompletionProposal> list, CompletionRequest completionRequest) {
        RubyIndex rubyIndex = completionRequest.index;
        String string = completionRequest.prefix;
        int n = completionRequest.lexOffset;
        TokenHierarchy tokenHierarchy = completionRequest.th;
        TokenSequence tokenSequence = LexUtilities.getRubyTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
        if (rubyIndex != null && tokenSequence != null) {
            Token token;
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return false;
            }
            if (tokenSequence.offset() == n) {
                tokenSequence.movePrevious();
            }
            if ((token = tokenSequence.token()) != null) {
                int n2;
                TokenId tokenId = token.id();
                if (tokenId == RubyTokenId.LINE_COMMENT || tokenId == RubyTokenId.DOCUMENTATION) {
                    BaseDocument baseDocument;
                    OffsetRange offsetRange;
                    if (completionRequest.queryType == Completable.QueryType.DOCUMENTATION && (offsetRange = LexUtilities.getCommentBlock(baseDocument = completionRequest.doc, n)) != OffsetRange.NONE) {
                        try {
                            String string2 = baseDocument.getText(offsetRange.getStart(), offsetRange.getLength());
                            if (string2.startsWith("=begin\n") && string2.endsWith("=end")) {
                                string2 = string2.substring("=begin\n".length(), string2.length() - "=end".length());
                            }
                            CommentElement commentElement = new CommentElement(string2);
                            ClassItem classItem = new ClassItem(commentElement, this.anchor, completionRequest);
                            list.add(classItem);
                            return true;
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                    return true;
                }
                if (tokenId == RubyTokenId.EMBEDDED_RUBY) {
                    tokenSequence = tokenSequence.embedded();
                    assert (tokenSequence != null);
                    tokenSequence.move(n);
                    if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                        return false;
                    }
                    token = tokenSequence.token();
                    tokenId = token.id();
                }
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                String string3 = ((Object)token.text()).toString();
                if ((tokenId == RubyTokenId.STRING_BEGIN || tokenId == RubyTokenId.QUOTED_STRING_BEGIN || tokenId == RubyTokenId.ERROR && string3.equals("%")) && (n2 = tokenSequence.offset()) == n - 1 && string3.length() > 0 && string3.charAt(0) == '%' && this.completePercentWords(list, completionRequest)) {
                    return true;
                }
                if ((tokenId == RubyTokenId.STRING_BEGIN || tokenId == RubyTokenId.QUOTED_STRING_BEGIN || tokenId == RubyTokenId.REGEXP_BEGIN) && token.length() == 3 && n == tokenSequence.offset() + 2 && Character.isLetter(string3.charAt(1))) {
                    this.completeStringBegins(list, completionRequest);
                    return true;
                }
                while (tokenId == RubyTokenId.ERROR || tokenId == RubyTokenId.STRING_LITERAL || tokenId == RubyTokenId.QUOTED_STRING_LITERAL || tokenId == RubyTokenId.REGEXP_LITERAL || tokenId == RubyTokenId.EMBEDDED_RUBY) {
                    if (tokenId == RubyTokenId.QUOTED_STRING_LITERAL) {
                        bl2 = true;
                    }
                    if (!tokenSequence.movePrevious()) {
                        return false;
                    }
                    token = tokenSequence.token();
                    tokenId = token.id();
                }
                if (tokenId == RubyTokenId.STRING_BEGIN) {
                    bl = true;
                } else if (tokenId == RubyTokenId.QUOTED_STRING_BEGIN) {
                    bl = true;
                    bl2 = true;
                } else if (tokenId == RubyTokenId.REGEXP_BEGIN) {
                    bl3 = true;
                }
                if (bl3) {
                    if (this.completeRegexps(list, completionRequest)) {
                        return true;
                    }
                } else if (bl) {
                    while (tokenSequence.movePrevious()) {
                        String string4;
                        token = tokenSequence.token();
                        if (token.id() == RubyTokenId.WHITESPACE || token.id() == RubyTokenId.LPAREN || token.id() == RubyTokenId.STRING_LITERAL || token.id() == RubyTokenId.QUOTED_STRING_LITERAL || token.id() == RubyTokenId.STRING_BEGIN || token.id() == RubyTokenId.QUOTED_STRING_BEGIN) continue;
                        if (token.id() != RubyTokenId.IDENTIFIER || !(string4 = ((Object)token.text()).toString()).equals(KEY_REQUIRE) && !string4.equals("load")) break;
                        Set<String[]> set = rubyIndex.getRequires(string, this.caseSensitive ? NameKind.PREFIX : NameKind.CASE_INSENSITIVE_PREFIX);
                        for (String[] stringArray : set) {
                            assert (stringArray.length == 2);
                            KeywordItem keywordItem = new KeywordItem(stringArray[0], stringArray[1], this.anchor, completionRequest);
                            list.add(keywordItem);
                        }
                        return true;
                    }
                    if (bl && bl2) {
                        int n3 = RUBY_QUOTED_STRING_ESCAPES.length;
                        for (int i = 0; i < n3; i += 2) {
                            String string5 = RUBY_QUOTED_STRING_ESCAPES[i];
                            String string6 = RUBY_QUOTED_STRING_ESCAPES[i + 1];
                            if (!string5.startsWith(string)) continue;
                            KeywordItem keywordItem = new KeywordItem(string5, string6, this.anchor, completionRequest);
                            list.add(keywordItem);
                        }
                        return true;
                    }
                    if (bl) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static boolean computeMethodCall(CompilationInfo compilationInfo, int n, int n2, IndexedMethod[] indexedMethodArray, int[] nArray, int[] nArray2, Set<IndexedMethod>[] setArray) {
        try {
            boolean bl;
            OffsetRange offsetRange;
            Node node;
            Object object;
            RubyParseResult rubyParseResult;
            OffsetRange offsetRange2;
            Node node2 = AstUtilities.getRoot(compilationInfo);
            if (node2 == null) {
                return false;
            }
            IndexedMethod indexedMethod = null;
            int n3 = -1;
            AstPath astPath = null;
            int n4 = n2;
            BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
            int n5 = LexUtilities.findSpaceBegin(baseDocument, n);
            if (n5 < n) {
                n2 -= n - n5;
            }
            if ((offsetRange2 = (rubyParseResult = AstUtilities.getParseResult(compilationInfo)).getSanitizedRange()) != OffsetRange.NONE && offsetRange2.containsInclusive(n2) && n2 != offsetRange2.getStart()) {
                n2 = offsetRange2.getStart() - 1;
                if (n2 < 0) {
                    n2 = 0;
                }
                astPath = new AstPath(node2, n2);
            }
            if (astPath == null) {
                astPath = new AstPath(node2, n2);
            }
            int n6 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            if (callLineStart == -1 || n6 != callLineStart || (indexedMethod = callMethod) != null) {
                // empty if block
            }
            Node node3 = null;
            int n7 = -1;
            if (indexedMethod != null) {
                ListIterator<Node> listIterator = astPath.leafToRoot();
                object = indexedMethod.getName();
                while (listIterator.hasNext()) {
                    node = (Node)listIterator.next();
                    if (!AstUtilities.isCall(node) || !((String)object).equals(AstUtilities.getCallName(node))) continue;
                    if (node.nodeId == NodeType.CALLNODE) {
                        offsetRange = ((CallNode)node).getArgsNode();
                        if (offsetRange == null) break;
                        n3 = AstUtilities.findArgumentIndex((Node)offsetRange, n2);
                        if (n3 == -1 && n2 < n4) {
                            n3 = AstUtilities.findArgumentIndex((Node)offsetRange, n4);
                        }
                        if (n3 == -1) break;
                        node3 = node;
                        n7 = offsetRange.getPosition().getStartOffset();
                        break;
                    }
                    if (node.nodeId == NodeType.FCALLNODE) {
                        offsetRange = ((FCallNode)node).getArgsNode();
                        if (offsetRange == null) break;
                        n3 = AstUtilities.findArgumentIndex((Node)offsetRange, n2);
                        if (n3 == -1 && n2 < n4) {
                            n3 = AstUtilities.findArgumentIndex((Node)offsetRange, n4);
                        }
                        if (n3 == -1) break;
                        node3 = node;
                        n7 = offsetRange.getPosition().getStartOffset();
                        break;
                    }
                    if (node.nodeId != NodeType.VCALLNODE) break;
                    offsetRange = AstUtilities.getCallRange(node);
                    AstUtilities.getCallName(node);
                    if (n4 <= offsetRange.getEnd()) break;
                    n3 = 0;
                    node3 = node;
                    n7 = offsetRange.getEnd() + 1;
                    break;
                }
            }
            boolean bl2 = bl = rubyParseResult.getSanitized() == RubyParser.Sanitize.EDITED_DOT || rubyParseResult.getSanitized() == RubyParser.Sanitize.ERROR_DOT;
            if (bl && rubyParseResult.getSanitizedContents().indexOf(44) == -1) {
                bl = false;
            }
            if (node3 == null) {
                object = astPath.leafToRoot();
                block4: while (object.hasNext()) {
                    Node node4;
                    node = (Node)object.next();
                    if (node.nodeId == NodeType.CALLNODE) {
                        Node node5;
                        offsetRange = AstUtilities.getCallRange(node);
                        if (bl && n4 > offsetRange.getEnd() && object.hasNext()) {
                            for (int i = 0; i < 3; ++i) {
                                node4 = (Node)object.next();
                                if (!AstUtilities.isCall(node4) || Utilities.getRowStart((BaseDocument)baseDocument, (int)LexUtilities.getLexerOffset(compilationInfo, node4.getPosition().getStartOffset())) != Utilities.getRowStart((BaseDocument)baseDocument, (int)n)) continue;
                                object.previous();
                                continue block4;
                            }
                        }
                        if ((node5 = ((CallNode)node).getArgsNode()) != null) {
                            n3 = AstUtilities.findArgumentIndex(node5, n2);
                            if (n3 == -1 && n2 < n4) {
                                n3 = AstUtilities.findArgumentIndex(node5, n4);
                            }
                            if (n3 == -1) continue;
                            node3 = node;
                            n7 = node5.getPosition().getStartOffset();
                            break;
                        }
                        if (n4 <= offsetRange.getEnd()) continue;
                        n3 = 0;
                        node3 = node;
                        n7 = offsetRange.getEnd() + 1;
                        break;
                    }
                    if (node.nodeId == NodeType.FCALLNODE) {
                        Node node6;
                        offsetRange = AstUtilities.getCallRange(node);
                        if (bl && n4 > offsetRange.getEnd() && object.hasNext()) {
                            for (int i = 0; i < 3; ++i) {
                                node4 = (Node)object.next();
                                if (!AstUtilities.isCall(node4) || Utilities.getRowStart((BaseDocument)baseDocument, (int)LexUtilities.getLexerOffset(compilationInfo, node4.getPosition().getStartOffset())) != Utilities.getRowStart((BaseDocument)baseDocument, (int)n)) continue;
                                object.previous();
                                continue block4;
                            }
                        }
                        if ((node6 = ((FCallNode)node).getArgsNode()) == null) continue;
                        n3 = AstUtilities.findArgumentIndex(node6, n2);
                        if (n3 == -1 && n2 < n4) {
                            n3 = AstUtilities.findArgumentIndex(node6, n4);
                        }
                        if (n3 == -1) continue;
                        node3 = node;
                        n7 = node6.getPosition().getStartOffset();
                        break;
                    }
                    if (node.nodeId != NodeType.VCALLNODE) continue;
                    offsetRange = AstUtilities.getCallRange(node);
                    if (bl && n4 > offsetRange.getEnd() && object.hasNext()) {
                        for (int i = 0; i < 3; ++i) {
                            node4 = (Node)object.next();
                            if (!AstUtilities.isCall(node4) || Utilities.getRowStart((BaseDocument)baseDocument, (int)LexUtilities.getLexerOffset(compilationInfo, node4.getPosition().getStartOffset())) != Utilities.getRowStart((BaseDocument)baseDocument, (int)n)) continue;
                            object.previous();
                            continue block4;
                        }
                    }
                    if (n4 <= offsetRange.getEnd()) continue;
                    n3 = 0;
                    node3 = node;
                    n7 = offsetRange.getEnd() + 1;
                    break;
                }
            }
            if (n3 != -1 && bl && node3 != null) {
                object = null;
                if (node3.nodeId == NodeType.FCALLNODE) {
                    object = ((FCallNode)node3).getArgsNode();
                } else if (node3.nodeId == NodeType.CALLNODE) {
                    object = ((CallNode)node3).getArgsNode();
                }
                if (object != null && n3 < object.childNodes().size() && ((Node)object.childNodes().get((int)n3)).nodeId == NodeType.HASHNODE) {
                    --n3;
                }
                ++n3;
            }
            if (node3 == null || n3 == -1) {
                callLineStart = -1;
                callMethod = null;
                return false;
            }
            if (indexedMethod == null && (indexedMethod = new DeclarationFinder().findMethodDeclaration(compilationInfo, node3, astPath, setArray)) == null) {
                return false;
            }
            callLineStart = n6;
            indexedMethodArray[0] = callMethod = indexedMethod;
            nArray[0] = n3;
            if (n7 == -1) {
                n7 = node3.getPosition().getStartOffset();
            }
            nArray2[0] = n7;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return false;
        }
        return true;
    }

    private boolean addParameters(List<CompletionProposal> list, CompletionRequest completionRequest) {
        String[] stringArray;
        int n;
        int n2;
        IndexedMethod[] indexedMethodArray = new IndexedMethod[1];
        Set[] setArray = new Set[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        CompilationInfo compilationInfo = completionRequest.info;
        if (!CodeCompleter.computeMethodCall(compilationInfo, n2 = completionRequest.lexOffset, n = completionRequest.astOffset, indexedMethodArray, nArray, nArray2, setArray)) {
            return false;
        }
        IndexedMethod indexedMethod = indexedMethodArray[0];
        int n3 = nArray[0];
        Object object = new CallItem(indexedMethod, n3, this.anchor, completionRequest);
        list.add((CompletionProposal)object);
        if (setArray[0] != null) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(indexedMethod.getSignature().substring(indexedMethod.getSignature().indexOf(35) + 1));
            for (IndexedMethod indexedMethod2 : setArray[0]) {
                String string;
                if (indexedMethod2 == indexedMethod || !indexedMethod2.isDocumented() || indexedMethod2.isNoDoc() || hashSet.contains(string = indexedMethod2.getSignature().substring(indexedMethod2.getSignature().indexOf(35) + 1))) continue;
                stringArray = new CallItem(indexedMethod2, n3, this.anchor, completionRequest);
                list.add((CompletionProposal)stringArray);
                hashSet.add(string);
            }
        }
        if ((object = indexedMethod.getParameters()) == null || object.size() == 0) {
            return false;
        }
        if (object.size() <= n3) {
            n3 = object.size() - 1;
        }
        boolean bl = n3 < object.size() - 1;
        Object object2 = indexedMethod.getEncodedAttributes();
        if (object2 != null && ((String)object2).length() > 0) {
            String string;
            int n4 = -1;
            for (int i = 0; i < 3 && (n4 = ((String)object2).indexOf(59, n4 + 1)) != -1; ++i) {
            }
            if (n4 == -1) {
                Node node = null;
                if (compilationInfo != null) {
                    node = AstUtilities.getRoot(compilationInfo);
                }
                if ((stringArray = this.findDocumentationEntry(node, indexedMethod)) == indexedMethod || !(stringArray instanceof IndexedMethod)) {
                    return false;
                }
                indexedMethod = (IndexedMethod)stringArray;
                object2 = indexedMethod.getEncodedAttributes();
                if (object2 != null && ((String)object2).length() > 0) {
                    n4 = -1;
                    for (int i = 0; i < 3 && (n4 = ((String)object2).indexOf(59, n4 + 1)) != -1; ++i) {
                    }
                }
            }
            if ((string = (String)object.get(n3)).startsWith("*")) {
                string = string.substring(1);
            } else if (string.startsWith("&")) {
                string = string.substring(1);
            }
            if (n4 != -1) {
                if (((String)(object2 = ((String)object2).substring(n4 + 1))).length() == 0) {
                    return false;
                }
                for (String string2 : stringArray = ((String)object2).split(",")) {
                    int n5 = string2.indexOf(40);
                    assert (n5 != -1) : object2;
                    String string3 = string2.substring(0, n5);
                    if (!string.equals(string3)) continue;
                    int n6 = string2.indexOf(41, n5);
                    assert (n6 != -1);
                    String string4 = string2.substring(n5 + 1, n6);
                    if (string4.length() > 0 && string4.charAt(0) == '-') {
                        if ("-table".equals(string4)) {
                            this.completeDbTables(list, indexedMethod, completionRequest, bl);
                            continue;
                        }
                        if ("-column".equals(string4)) {
                            this.completeDbColumns(list, indexedMethod, completionRequest, bl);
                            continue;
                        }
                        if (!"-model".equals(string4)) continue;
                        this.completeModels(list, indexedMethod, completionRequest, bl);
                        continue;
                    }
                    if (string4.startsWith("=>")) {
                        this.completeHash(list, completionRequest, indexedMethod, string4, bl);
                        continue;
                    }
                    this.completeFixed(list, completionRequest, indexedMethod, string4, bl);
                }
            }
        }
        return true;
    }

    private boolean completeHash(List<CompletionProposal> list, CompletionRequest completionRequest, IndexedMethod indexedMethod, String string, boolean bl) {
        Object object;
        int n;
        Object object2;
        Object object3;
        assert (string.startsWith("=>"));
        string = string.substring(2);
        String string2 = completionRequest.prefix;
        boolean bl2 = false;
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(completionRequest.doc, this.anchor);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(this.anchor);
        String string3 = null;
        while (tokenSequence.movePrevious()) {
            object3 = tokenSequence.token();
            if (object3.id() == RubyTokenId.WHITESPACE) continue;
            if (object3.id() != RubyTokenId.NONUNARY_OP || !((Object)object3.text()).toString().equals("=>")) break;
            bl2 = true;
            try {
                object2 = completionRequest.doc;
                int n2 = Utilities.getRowStart((BaseDocument)object2, (int)tokenSequence.offset());
                string3 = object2.getText(n2, tokenSequence.offset() - n2).trim();
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                return false;
            }
        }
        object3 = new ArrayList();
        object2 = null;
        String[] stringArray = string.split("\\|");
        if (bl2) {
            for (String string4 : stringArray) {
                List<String> list2;
                n = string4.indexOf(58);
                if (n == -1 || !string3.endsWith((String)(object = string4.substring(0, n)))) continue;
                object2 = object;
                String string5 = string4.substring(n + 1);
                if ("nil".equals(string5)) {
                    object3.add("nil");
                    continue;
                }
                if ("bool".equals(string5)) {
                    object3.add("true");
                    object3.add("false");
                    continue;
                }
                if ("submitmethod".equals(string5)) {
                    object3.add("post");
                    object3.add("get");
                    continue;
                }
                if ("validationactive".equals(string5)) {
                    object3.add(":save");
                    object3.add(":create");
                    object3.add(":update");
                    continue;
                }
                if ("string".equals(string5)) {
                    object3.add("\"");
                    continue;
                }
                if ("hash".equals(string5)) {
                    object3.add("{");
                    continue;
                }
                if ("controller".equals(string5)) {
                    list2 = RubyUtils.getControllerNames(completionRequest.fileObject, true);
                    for (String string6 : list2) {
                        object3.add("'" + string6 + "'");
                    }
                    continue;
                }
                if (!"action".equals(string5)) continue;
                list2 = this.getActionNames(completionRequest);
                for (String string6 : list2) {
                    object3.add("'" + string6 + "'");
                }
            }
        } else {
            for (String string4 : stringArray) {
                n = string4.indexOf(58);
                if (n != -1) {
                    string4 = string4.substring(0, n);
                }
                string4 = ":" + string4 + " => ";
                object3.add(string4);
            }
        }
        String string7 = ":" + string2;
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            String string4;
            String string8 = (String)iterator.next();
            if (!this.startsWith(string8, string2) && !this.startsWith(string8, string7)) continue;
            string4 = string8;
            String string9 = null;
            if (bl2) {
                if (!bl) {
                    string4 = string4 + ", ";
                }
                if (object2 != null) {
                    string9 = ":" + (String)object2 + " = " + string8;
                }
            }
            object = new ParameterItem(indexedMethod, string8, string9, string4, this.anchor, completionRequest);
            ((RubyCompletionItem)object).setSymbol(true);
            ((RubyCompletionItem)object).setSmart(true);
            list.add((CompletionProposal)object);
        }
        return true;
    }

    private List<String> getActionNames(CompletionRequest completionRequest) {
        FileObject fileObject = completionRequest.fileObject;
        FileObject fileObject2 = null;
        fileObject2 = fileObject.getNameExt().endsWith("_controller.rb") ? fileObject : RubyUtils.getRailsControllerFor(fileObject);
        if (fileObject2 == null) {
            return Collections.emptyList();
        }
        String string = RubyUtils.getControllerClass(fileObject2);
        if (string != null) {
            String string2 = completionRequest.prefix;
            Set<IndexedMethod> set = completionRequest.index.getMethods(string2, string, completionRequest.kind);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (IndexedMethod indexedMethod : set) {
                if ((!indexedMethod.isPublic() || indexedMethod.getArgs() != null) && indexedMethod.getArgs().length != 0) continue;
                arrayList.add(indexedMethod.getName());
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private void completeFixed(List<CompletionProposal> list, CompletionRequest completionRequest, IndexedMethod indexedMethod, String string, boolean bl) {
        String[] stringArray = string.split("\\|");
        String string2 = completionRequest.prefix;
        String string3 = ":" + string2;
        for (String string4 : stringArray) {
            if (!this.startsWith(string4, string2) && !this.startsWith(string4, string3)) continue;
            String string5 = bl ? string4 : string4 + ", ";
            ParameterItem parameterItem = new ParameterItem(indexedMethod, string4, null, string5, this.anchor, completionRequest);
            parameterItem.setSymbol(true);
            parameterItem.setSmart(true);
            list.add(parameterItem);
        }
    }

    private void completeDbTables(List<CompletionProposal> list, IndexedMethod indexedMethod, CompletionRequest completionRequest, boolean bl) {
        String string;
        String string2 = string = completionRequest.prefix;
        if (":".equals(string)) {
            string = "";
        } else {
            string2 = ":" + string;
        }
        Set<String> set = completionRequest.index.getDatabaseTables(string, completionRequest.kind);
        String string3 = completionRequest.prefix;
        for (String string4 : set) {
            String string5 = ":" + string4;
            if (!this.startsWith(string5, string3) && !this.startsWith(string5, string2)) continue;
            String string6 = bl ? string5 : string5 + ", ";
            ParameterItem parameterItem = new ParameterItem(indexedMethod, string5, null, string6, this.anchor, completionRequest);
            parameterItem.setSymbol(true);
            parameterItem.setSmart(true);
            list.add(parameterItem);
        }
    }

    private void completeModels(List<CompletionProposal> list, IndexedMethod indexedMethod, CompletionRequest completionRequest, boolean bl) {
        Set<IndexedClass> set = completionRequest.index.getSubClasses(completionRequest.prefix, "ActiveRecord::Base", completionRequest.kind, RubyIndex.SOURCE_SCOPE);
        String string = completionRequest.prefix;
        String string2 = ":" + string;
        for (IndexedClass indexedClass : set) {
            String string3 = indexedClass.getName();
            String string4 = ":" + RubyUtils.camelToUnderlinedName(string3);
            if (!this.startsWith(string4, string) && !this.startsWith(string4, string2)) continue;
            String string5 = bl ? string4 : string4 + ", ";
            ParameterItem parameterItem = new ParameterItem(indexedMethod, string4, string3, string5, this.anchor, completionRequest);
            parameterItem.setSymbol(true);
            parameterItem.setSmart(true);
            list.add(parameterItem);
        }
    }

    private void completeDbColumns(List<CompletionProposal> list, IndexedMethod indexedMethod, CompletionRequest completionRequest, boolean bl) {
        Set<String> set = completionRequest.index.getDatabaseTables(completionRequest.prefix, completionRequest.kind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompletionProposal> complete(CompilationInfo compilationInfo, int n, String string, NameKind nameKind, Completable.QueryType queryType, boolean bl, HtmlFormatter htmlFormatter) {
        Document document;
        this.caseSensitive = bl;
        int n2 = AstUtilities.getAstOffset(compilationInfo, n);
        if (n2 == -1) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        List<CompletionProposal> list = new ArrayList<CompletionProposal>();
        this.anchor = n - string.length();
        RubyIndex rubyIndex = RubyIndex.get(compilationInfo.getIndex("text/x-ruby"));
        try {
            document = compilationInfo.getDocument();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
        n = AstUtilities.boundCaretOffset(compilationInfo, n);
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        BaseDocument baseDocument = (BaseDocument)document;
        FileObject fileObject = compilationInfo.getFileObject();
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        char c = '\u0000';
        baseDocument.readLock();
        try {
            Object object;
            String[] stringArray;
            Object object22;
            Object object3;
            int n3;
            int n4;
            if (string.length() > 0) {
                c = string.charAt(0);
                int n5 = string.lastIndexOf("::");
                if (n5 != -1 && n5 < string.length() - 2) {
                    c = string.charAt(n5 + 2);
                }
                bl2 = Character.isLowerCase(c);
                bl3 = Character.isUpperCase(c);
                if (c == ':') {
                    bl4 = true;
                    if (string.length() > 1) {
                        char c2 = string.charAt(1);
                        string = string.substring(1);
                        bl2 = Character.isLowerCase(c2);
                        bl3 = Character.isUpperCase(c2);
                    }
                }
            }
            CompletionRequest completionRequest = new CompletionRequest();
            completionRequest.formatter = htmlFormatter;
            completionRequest.lexOffset = n;
            completionRequest.astOffset = n2;
            completionRequest.index = rubyIndex;
            completionRequest.doc = baseDocument;
            completionRequest.info = compilationInfo;
            completionRequest.prefix = string;
            completionRequest.th = tokenHierarchy;
            completionRequest.kind = nameKind;
            completionRequest.queryType = queryType;
            completionRequest.fileObject = fileObject;
            if (this.completeStrings(list, completionRequest)) {
                ArrayList<CompletionProposal> arrayList = list;
                return arrayList;
            }
            Call call = Call.getCallType(baseDocument, (TokenHierarchy<Document>)tokenHierarchy, n);
            Node node = AstUtilities.getRoot(compilationInfo);
            if (node == null) {
                this.completeKeywords(list, completionRequest, bl4);
                ArrayList<CompletionProposal> arrayList = list;
                return arrayList;
            }
            try {
                n4 = AstUtilities.getAstOffset(compilationInfo, Utilities.getRowStart((BaseDocument)baseDocument, (int)n));
                n3 = AstUtilities.getAstOffset(compilationInfo, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n));
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                List<CompletionProposal> list2 = null;
                baseDocument.readUnlock();
                return list2;
            }
            AstPath astPath = new AstPath(node, n2);
            completionRequest.path = astPath;
            HashMap<String, Node> hashMap = new HashMap<String, Node>();
            HashMap hashMap2 = new HashMap();
            HashMap<String, Node> hashMap3 = new HashMap<String, Node>();
            HashMap<String, Node> hashMap4 = new HashMap<String, Node>();
            Node node2 = astPath.leaf();
            completionRequest.node = node2;
            if (call.getLhs() == null) {
                Object object4;
                if (bl2 && node2 != null) {
                    object4 = AstUtilities.getApplicableBlocks(astPath, false);
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object22 = (Node)object3.next();
                        CodeCompleter.addDynamic((Node)object22, hashMap);
                    }
                    object3 = AstUtilities.findLocalScope(node2, astPath);
                    object22 = object3.childNodes();
                    stringArray = object22.iterator();
                    while (stringArray.hasNext()) {
                        object = (Node)stringArray.next();
                        CodeCompleter.addLocals((Node)object, hashMap);
                    }
                }
                if (string.length() == 0 || c == '@' || bl4) {
                    object4 = AstUtilities.getFqnName(astPath);
                    if (object4 == null || ((String)object4).length() == 0) {
                        object4 = "Object";
                    }
                    if (RubyUtils.isRhtmlFile(fileObject) || RubyUtils.isMarkabyFile(fileObject)) {
                        object3 = new HashSet();
                        this.addActionViewFields((Set<IndexedField>)object3, fileObject, rubyIndex, string, nameKind);
                    } else {
                        object3 = rubyIndex.getInheritedFields((String)object4, string, nameKind, false);
                    }
                    object22 = object3.iterator();
                    while (object22.hasNext()) {
                        stringArray = (IndexedField)object22.next();
                        object = new FieldItem((Element)stringArray, this.anchor, completionRequest);
                        ((RubyCompletionItem)object).setSmart(stringArray.isSmart());
                        if (bl4) {
                            ((RubyCompletionItem)object).setSymbol(true);
                        }
                        list.add((CompletionProposal)object);
                    }
                }
                if (string.length() == 0 || c == '$' || bl4) {
                    object4 = node.childNodes();
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object22 = (Node)object3.next();
                        this.addGlobals((Node)object22, hashMap3);
                    }
                }
            }
            if (bl3 || bl4) {
                this.addConstants(node, hashMap4);
            }
            boolean bl5 = this.addParameters(list, completionRequest);
            if (rubyIndex != null) {
                if (bl2 || bl4) {
                    object3 = AstUtilities.getFqnName(astPath);
                    if (object3 == null || ((String)object3).length() == 0) {
                        object3 = "Object";
                    }
                    if (object3 != null && queryType == Completable.QueryType.COMPLETION && this.completeDefOrInclude(list, completionRequest, (String)object3)) {
                        object22 = list;
                        return object22;
                    }
                    if (object3 != null && this.completeObjectMethod(list, completionRequest, (String)object3, call)) {
                        object22 = list;
                        return object22;
                    }
                    if (call.getLhs() == null) {
                        object22 = rubyIndex.getInheritedMethods((String)object3, string, nameKind);
                        if (RubyUtils.isRhtmlFile(fileObject) || RubyUtils.isMarkabyFile(fileObject)) {
                            this.addActionViewMethods((Set<IndexedMethod>)object22, fileObject, rubyIndex, string, nameKind);
                        } else if (fileObject.getName().endsWith("_spec")) {
                            stringArray = new String[]{"Spec::Matchers", "Spec::Expectations::ObjectExpectations", "Spec::DSL::BehaviourEval::InstanceMethods"};
                            for (String string2 : stringArray) {
                                Set<IndexedMethod> set = rubyIndex.getInheritedMethods(string2, string, nameKind);
                                object22.addAll(set);
                            }
                        }
                        stringArray = object22.iterator();
                        while (stringArray.hasNext()) {
                            object = (IndexedMethod)stringArray.next();
                            if (string.length() > 0 && !((IndexedMethod)object).getName().startsWith(string) || ((IndexedElement)object).isNoDoc()) continue;
                            MethodItem methodItem = new MethodItem((IndexedMethod)object, this.anchor, completionRequest);
                            methodItem.setSmart(((IndexedMethod)object).isSmart());
                            if (bl4) {
                                methodItem.setSymbol(true);
                            }
                            list.add(methodItem);
                        }
                    }
                }
                if (bl3 && queryType == Completable.QueryType.COMPLETION && this.completeDefOrInclude(list, completionRequest, "")) {
                    object3 = list;
                    return object3;
                }
                if (bl3 && (string != null && string.length() > 0 || !call.isMethodExpected() && call.getLhs() != null && call.getLhs().length() > 0) || bl4 && !bl5) {
                    this.completeClasses(list, completionRequest, bl4, call);
                }
            }
            assert (nameKind == NameKind.PREFIX || nameKind == NameKind.CASE_INSENSITIVE_PREFIX || nameKind == NameKind.EXACT_NAME);
            for (Object object22 : hashMap.keySet()) {
                if ((nameKind != NameKind.EXACT_NAME || !string.equals(object22)) && (nameKind == NameKind.EXACT_NAME || !this.startsWith((String)object22, string)) || this.overlapsLine((Node)(stringArray = (Node)hashMap.get(object22)), n4, n3)) continue;
                object = new AstVariableElement(compilationInfo, (Node)stringArray, (String)object22);
                PlainItem plainItem = new PlainItem((Element)object, this.anchor, completionRequest);
                plainItem.setSmart(true);
                if (bl4) {
                    plainItem.setSymbol(true);
                }
                list.add(plainItem);
            }
            for (Object object22 : hashMap2.keySet()) {
                if ((nameKind != NameKind.EXACT_NAME || !string.equals(object22)) && (nameKind == NameKind.EXACT_NAME || !this.startsWith((String)object22, string)) || this.overlapsLine((Node)(stringArray = (Node)hashMap2.get(object22)), n4, n3)) continue;
                object = new AstFieldElement(compilationInfo, (Node)stringArray);
                FieldItem fieldItem = new FieldItem((Element)object, this.anchor, completionRequest);
                fieldItem.setSmart(true);
                if (bl4) {
                    fieldItem.setSymbol(true);
                }
                list.add(fieldItem);
            }
            for (Object object22 : hashMap3.keySet()) {
                if (!this.startsWith((String)object22, string) && (!bl4 || !this.startsWith(((String)object22).substring(1), string)) || this.overlapsLine((Node)(stringArray = (Node)hashMap3.get(object22)), n4, n3)) continue;
                object = new AstVariableElement(compilationInfo, (Node)stringArray, (String)object22);
                PlainItem plainItem = new PlainItem((Element)object, this.anchor, completionRequest);
                plainItem.setSmart(true);
                if (bl4) {
                    plainItem.setSymbol(true);
                }
                list.add(plainItem);
            }
            for (Object object22 : hashMap4.keySet()) {
                if ((nameKind != NameKind.EXACT_NAME || !string.equals(object22)) && (nameKind == NameKind.EXACT_NAME || !this.startsWith((String)object22, string)) || this.overlapsLine((Node)(stringArray = (String[])hashMap4.get(object22)), n4, n3)) continue;
                object = new AstVariableElement(compilationInfo, (Node)stringArray, (String)object22);
                PlainItem plainItem = new PlainItem((Element)object, this.anchor, completionRequest);
                plainItem.setSmart(true);
                if (bl4) {
                    plainItem.setSymbol(true);
                }
                list.add(plainItem);
            }
            if (this.completeKeywords(list, completionRequest, bl4)) {
                object3 = list;
                return object3;
            }
            if (queryType == Completable.QueryType.DOCUMENTATION) {
                list = this.filterDocumentation(list, node, baseDocument, compilationInfo, n2, n, string, astPath, rubyIndex);
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        return list;
    }

    private void addActionViewMethods(Set<IndexedMethod> set, FileObject fileObject, RubyIndex rubyIndex, String string, NameKind nameKind) {
        FileObject fileObject2;
        boolean bl = RubyUtils.isMarkabyFile(fileObject);
        if (bl) {
            fileObject2 = rubyIndex.getInheritedMethods("ActionView::Base", string, nameKind);
            set.addAll((Collection<IndexedMethod>)fileObject2);
        }
        if (RubyUtils.isRhtmlFile(fileObject) || bl) {
            Object object;
            Object object2 = null;
            for (fileObject2 = fileObject.getParent(); fileObject2 != null && !fileObject2.getName().equals("views"); fileObject2 = fileObject2.getParent()) {
                object = RubyUtils.underlinedNameToCamel(fileObject2.getName());
                object2 = object2 == null ? object : (String)object + "::" + (String)object2;
            }
            object = rubyIndex.getInheritedMethods(object2 + "Helper", string, nameKind);
            set.addAll((Collection<IndexedMethod>)object);
        }
    }

    private void addActionViewFields(Set<IndexedField> set, FileObject fileObject, RubyIndex rubyIndex, String string, NameKind nameKind) {
        Object object;
        boolean bl = RubyUtils.isMarkabyFile(fileObject);
        if (bl) {
            object = rubyIndex.getInheritedFields("ActionView::Base", string, nameKind, true);
            set.addAll((Collection<IndexedField>)object);
        }
        if (RubyUtils.isRhtmlFile(fileObject) || bl) {
            String string2;
            String string3 = null;
            for (object = fileObject.getParent(); object != null && !object.getName().equals("views"); object = object.getParent()) {
                string2 = RubyUtils.underlinedNameToCamel(object.getName());
                string3 = string3 == null ? string2 : string2 + "::" + string3;
            }
            string2 = string3 + "Controller";
            Set<IndexedField> set2 = rubyIndex.getInheritedFields(string2, string, nameKind, true);
            for (IndexedField indexedField : set2) {
                if ("ActionController::Base".equals(indexedField.getIn())) continue;
                set.add(indexedField);
            }
        }
    }

    private List<CompletionProposal> filterDocumentation(List<CompletionProposal> list, Node node, BaseDocument baseDocument, CompilationInfo compilationInfo, int n, int n2, String string, AstPath astPath, RubyIndex rubyIndex) {
        IndexedElement indexedElement;
        RubyElement rubyElement;
        Object object2;
        ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>();
        FileObject fileObject = compilationInfo.getFileObject();
        HashMap<IndexedElement, CompletionProposal> hashMap = new HashMap<IndexedElement, CompletionProposal>();
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>();
        HashSet<IndexedClass> hashSet2 = new HashSet<IndexedClass>();
        for (Object object2 : list) {
            rubyElement = (RubyElement)object2.getElement();
            if (!(rubyElement instanceof IndexedElement)) continue;
            indexedElement = (IndexedElement)rubyElement;
            if (indexedElement instanceof IndexedClass) {
                hashSet2.add((IndexedClass)indexedElement);
                hashMap.put(indexedElement, (CompletionProposal)object2);
            } else if (indexedElement instanceof IndexedMethod) {
                hashSet.add((IndexedMethod)indexedElement);
                hashMap.put(indexedElement, (CompletionProposal)object2);
            }
            if (indexedElement.getFileObject() != fileObject) continue;
            arrayList.add((CompletionProposal)object2);
        }
        for (Object object2 : arrayList) {
            String string2;
            Node node2;
            rubyElement = (RubyElement)object2.getElement();
            if (!(rubyElement instanceof IndexedElement) || (node2 = AstUtilities.findBySignature(node, string2 = (indexedElement = (IndexedElement)rubyElement).getSignature())) == null) continue;
            ISourcePosition iSourcePosition = node2.getPosition();
            int n3 = LexUtilities.getLexerOffset(compilationInfo, iSourcePosition.getStartOffset());
            try {
                List<String> list2;
                int n4 = AstUtilities.getAstOffset(compilationInfo, Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n3));
                int n5 = AstUtilities.getAstOffset(compilationInfo, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3));
                if (n < n4 || n > n5 || (list2 = AstUtilities.gatherDocumentation(compilationInfo, baseDocument, node2)) == null || list2.size() <= 0) continue;
                return Collections.singletonList(object2);
            }
            catch (BadLocationException badLocationException) {
            }
        }
        DeclarationFinder declarationFinder = new DeclarationFinder();
        object2 = null;
        if (hashSet2.size() > 0) {
            object2 = declarationFinder.findBestClassMatch(hashSet2, baseDocument, astPath, astPath.leaf(), rubyIndex);
        } else if (hashSet.size() > 0) {
            object2 = declarationFinder.findBestMethodMatch(string, hashSet, baseDocument, n, n2, astPath, astPath.leaf(), rubyIndex);
        }
        if (object2 != null && (rubyElement = (CompletionProposal)hashMap.get(object2)) != null) {
            return Collections.singletonList(rubyElement);
        }
        return list;
    }

    private boolean overlapsLine(Node node, int n, int n2) {
        ISourcePosition iSourcePosition = node.getPosition();
        return iSourcePosition.getStartOffset() >= n && iSourcePosition.getStartOffset() <= n2;
    }

    static void addLocals(Node node, Map<String, Node> map) {
        Node node2;
        Object object;
        Object object2;
        switch (node.nodeId) {
            case LOCALASGNNODE: {
                object2 = ((INameNode)node).getName();
                if (map.containsKey(object2)) break;
                map.put((String)object2, node);
                break;
            }
            case ARGSNODE: {
                object2 = (ArgsNode)node;
                if (object2.getRequiredArgsCount() > 0) {
                    object = object2.childNodes();
                    node2 = object.iterator();
                    while (node2.hasNext()) {
                        Node node3 = (Node)node2.next();
                        if (!(node3 instanceof ListNode)) continue;
                        List list = node3.childNodes();
                        for (Node node4 : list) {
                            if (node4 instanceof ArgumentNode) {
                                map.put(((ArgumentNode)node4).getName(), node4);
                                continue;
                            }
                            if (!(node4 instanceof LocalAsgnNode)) continue;
                            map.put(((INameNode)node4).getName(), node4);
                        }
                    }
                }
                if (object2.getRestArgNode() != null) {
                    object = object2.getRestArgNode().getName();
                    map.put((String)object, (Node)object2.getRestArgNode());
                }
                if (object2.getBlockArgNode() == null) break;
                object = object2.getBlockArgNode().getName();
                map.put((String)object, (Node)object2.getBlockArgNode());
                break;
            }
        }
        object2 = node.childNodes();
        object = object2.iterator();
        block9: while (object.hasNext()) {
            node2 = (Node)object.next();
            switch (node2.nodeId) {
                case DEFNNODE: 
                case DEFSNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: {
                    continue block9;
                }
            }
            CodeCompleter.addLocals(node2, map);
        }
    }

    static void addDynamic(Node node, Map<String, Node> map) {
        Object object;
        if (node.nodeId == NodeType.DASGNNODE && !map.containsKey(object = ((INameNode)node).getName())) {
            map.put((String)object, node);
        }
        object = node.childNodes();
        Iterator iterator = object.iterator();
        block3: while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            switch (node2.nodeId) {
                case DEFNNODE: 
                case DEFSNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: 
                case ITERNODE: {
                    continue block3;
                }
            }
            CodeCompleter.addDynamic(node2, map);
        }
    }

    private void addGlobals(Node node, Map<String, Node> map) {
        Object object;
        if (node.nodeId == NodeType.GLOBALASGNNODE && !map.containsKey(object = ((INameNode)node).getName())) {
            map.put((String)object, node);
        }
        object = node.childNodes();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            this.addGlobals(node2, map);
        }
    }

    private void addConstants(Node node, Map<String, Node> map) {
        if (node.nodeId == NodeType.CONSTDECLNODE) {
            map.put(((INameNode)node).getName(), node);
        }
        List list = node.childNodes();
        for (Node node2 : list) {
            this.addConstants(node2, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadResource(String string) {
        InputStream inputStream = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            inputStream = new BufferedInputStream(CodeCompleter.class.getResourceAsStream("resources/" + string));
            while ((n = inputStream.read()) != -1) {
                stringBuilder.append((char)n);
            }
            if (stringBuilder.length() > 0) {
                String string2 = stringBuilder.toString();
                return string2;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    private String getKeywordHelp(String string) {
        if (string.equals("if") || string.equals("elsif") || string.equals("else") || string.equals("then") || string.equals("unless")) {
            return this.loadResource("ifelse.html");
        }
        if (string.equals("case") || string.equals("when") || string.equals("else")) {
            return this.loadResource("case.html");
        }
        if (string.equals("rescue") || string.equals("ensure")) {
            return this.loadResource("rescue.html");
        }
        if (string.equals("yield")) {
            return this.loadResource("yield.html");
        }
        return null;
    }

    private IndexedElement findDocumentationEntry(Node node, IndexedElement indexedElement) {
        HashSet<? extends IndexedElement> hashSet;
        String string = indexedElement.getSignature();
        Set<? extends IndexedElement> set = indexedElement.getIndex().getDocumented(string);
        if (set == null || set.size() == 0) {
            return null;
        }
        if (set.size() == 1) {
            return set.iterator().next();
        }
        if (node != null) {
            hashSet = new HashSet<IndexedElement>();
            Set<String> set2 = AstUtilities.getRequires(node);
            for (IndexedElement indexedElement2 : set) {
                String string2 = indexedElement2.getRequire();
                if (!set2.contains(string2)) continue;
                hashSet.add(indexedElement2);
            }
            if (hashSet.size() == 1) {
                return (IndexedElement)hashSet.iterator().next();
            }
            if (!hashSet.isEmpty()) {
                set = hashSet;
            }
        }
        hashSet = new HashSet();
        for (IndexedElement indexedElement3 : set) {
            String string3 = indexedElement3.getFileUrl();
            if (string3.indexOf("rubystubs") == -1) continue;
            hashSet.add(indexedElement3);
        }
        if (hashSet.size() == 1) {
            return (IndexedElement)hashSet.iterator().next();
        }
        if (!hashSet.isEmpty()) {
            set = hashSet;
        }
        return set.iterator().next();
    }

    private List<String> getComments(CompilationInfo compilationInfo, Element object) {
        List<String> list;
        Node node;
        Object object2;
        assert (compilationInfo != null || object instanceof IndexedElement);
        if (object == null) {
            return null;
        }
        Node node2 = null;
        if (object instanceof AstElement) {
            node2 = ((AstElement)object).getNode();
        } else if (object instanceof IndexedElement) {
            object2 = (IndexedElement)object;
            node = null;
            if (compilationInfo != null) {
                node = AstUtilities.getRoot(compilationInfo);
            }
            if ((list = this.findDocumentationEntry(node, (IndexedElement)object2)) != null) {
                object = object2 = list;
            }
            if ((node2 = AstUtilities.getForeignNode((IndexedElement)object2, null)) == null) {
                return null;
            }
        } else {
            assert (false) : object;
            return null;
        }
        object2 = null;
        node = null;
        try {
            if (object instanceof IndexedElement) {
                object2 = ((IndexedElement)object).getDocument();
                compilationInfo = null;
            } else if (compilationInfo != null) {
                object2 = compilationInfo.getDocument();
            }
            if (!(object2 instanceof BaseDocument)) {
                return null;
            }
            node = (BaseDocument)object2;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        list = null;
        if (node2 instanceof ClassNode && !(object instanceof IndexedElement)) {
            ClassNode classNode;
            String string;
            String string2 = AstUtilities.getClassOrModuleName((IScopingNode)((ClassNode)node2));
            List<ClassNode> list2 = AstUtilities.getClasses(AstUtilities.getRoot(compilationInfo));
            for (int i = list2.size() - 1; !(i < 0 || (string = AstUtilities.getClassOrModuleName((IScopingNode)(classNode = list2.get(i)))).equals(string2) && (list = AstUtilities.gatherDocumentation(compilationInfo, (BaseDocument)node, (Node)classNode)) != null && list.size() > 0); --i) {
            }
        } else {
            list = AstUtilities.gatherDocumentation(compilationInfo, (BaseDocument)node, node2);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public String document(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        void var7_12;
        Object object;
        Object object2;
        List<String> list;
        RubyElement rubyElement = null;
        if (elementHandle instanceof ElementHandle.UrlHandle) {
            list = ((ElementHandle.UrlHandle)elementHandle).getUrl();
            object2 = new DeclarationFinder().findLinkedMethod(compilationInfo, (String)((Object)list));
            if (object2 != DeclarationFinder.DeclarationLocation.NONE) {
                object = object2.getElement();
                if (elementHandle != null && (rubyElement = RubyParser.resolveHandle(compilationInfo, (ElementHandle)object)) == null) {
                    return null;
                }
            }
        } else {
            rubyElement = RubyParser.resolveHandle(compilationInfo, elementHandle);
        }
        if (rubyElement == null) {
            return null;
        }
        if (rubyElement instanceof KeywordElement) {
            return this.getKeywordHelp(((KeywordElement)rubyElement).getName());
        }
        if (rubyElement instanceof CommentElement) {
            list = rubyElement.getName();
            object2 = new RDocFormatter();
            object = ((String)((Object)list)).split("\n");
            for (String string : object) {
                int n = string.length();
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (c == '#') {
                        if (i <= 0) continue;
                        string = string.substring(i);
                        break;
                    }
                    if (!Character.isWhitespace(c)) break;
                }
                ((RDocFormatter)object2).appendLine(string);
            }
            String object4 = ((RDocFormatter)object2).toHtml();
            return object4;
        }
        list = this.getComments(compilationInfo, rubyElement);
        if (list == null) {
            if (rubyElement.getName().startsWith("find_by_") || rubyElement.getName().startsWith("find_all_by_")) {
                return new RDocFormatter().getSignature(rubyElement) + NbBundle.getMessage(CodeCompleter.class, (String)"DynamicMethod");
            }
            object2 = new RDocFormatter().getSignature(rubyElement) + "\n<hr>\n<i>" + NbBundle.getMessage(CodeCompleter.class, (String)"NoCommentFound") + "</i>";
            return object2;
        }
        object2 = new RDocFormatter();
        object = rubyElement.getName();
        if (object != null && ((String)object).length() > 0) {
            ((RDocFormatter)object2).setSeqName((String)object);
        }
        for (String string : list) {
            ((RDocFormatter)object2).appendLine(string);
        }
        String string = ((RDocFormatter)object2).toHtml();
        if (!((RDocFormatter)object2).wroteSignature()) {
            String string2 = ((RDocFormatter)object2).getSignature(rubyElement) + "\n<hr>\n" + string;
        }
        return var7_12;
    }

    public ElementHandle resolveLink(String string, ElementHandle elementHandle) {
        if (string.indexOf("#") != -1 && elementHandle.getMimeType().equals("text/x-ruby")) {
            RubyParser rubyParser = new RubyParser();
            if (string.startsWith("#")) {
                RubyElement rubyElement = RubyParser.resolveHandle(null, elementHandle);
                if (rubyElement != null && rubyElement.getKind() != ElementKind.KEYWORD) {
                    String string2 = rubyElement.getName();
                    ElementKind elementKind = rubyElement.getKind();
                    if (elementKind != ElementKind.CLASS && elementKind != ElementKind.MODULE) {
                        int n;
                        String string3 = rubyElement.getIn();
                        if (string3 != null && string3.length() > 0) {
                            string2 = string3;
                        } else if (string2 != null && (n = string2.indexOf(35)) > 0) {
                            string2 = string2.substring(0, n);
                        }
                    }
                    if (string2 != null) {
                        string = string2 + string;
                    }
                }
            }
            return new ElementHandle.UrlHandle(string);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Set<String> getApplicableTemplates(CompilationInfo var1_1, int var2_2, int var3_3) {
        var4_4 = false;
        if (var3_3 != -1) {
            try {
                if (var2_2 == var3_3) {
                    return Collections.emptySet();
                }
                if (var3_3 < var2_2) {
                    var5_5 = var2_2;
                    var2_2 = var3_3;
                    var3_3 = var5_5;
                }
                var5_6 = (BaseDocument)var1_1.getDocument();
                var6_9 = Utilities.isRowEmpty((BaseDocument)var5_6, (int)var2_2);
                var7_10 = Utilities.isRowEmpty((BaseDocument)var5_6, (int)var3_3);
                if (!var6_9 && var2_2 > Utilities.getRowFirstNonWhite((BaseDocument)var5_6, (int)var2_2) || !var7_10 && var3_3 <= Utilities.getRowLastNonWhite((BaseDocument)var5_6, (int)var3_3)) ** GOTO lbl29
                var8_11 = var5_6.getText(var2_2, var3_3 - var2_2);
                for (var9_12 = 0; var9_12 < var8_11.length(); ++var9_12) {
                    if (Character.isWhitespace(var8_11.charAt(var9_12))) continue;
                    var10_13 = LexUtilities.getToken(var5_6, var2_2);
                    if (var10_13 == null || (var11_14 = var10_13.id()) == RubyTokenId.STRING_LITERAL || var11_14 == RubyTokenId.LINE_COMMENT || var11_14 == RubyTokenId.QUOTED_STRING_LITERAL || var11_14 == RubyTokenId.REGEXP_LITERAL || var11_14 == RubyTokenId.DOCUMENTATION) break;
                    var4_4 = true;
                }
            }
            catch (BadLocationException var5_7) {
                Exceptions.printStackTrace((Throwable)var5_7);
            }
            catch (IOException var5_8) {
                Exceptions.printStackTrace((Throwable)var5_8);
            }
        } else {
            var4_4 = true;
        }
lbl29:
        // 7 sources

        if (var4_4) {
            return CodeCompleter.selectionTemplates;
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    private String suggestName(CompilationInfo compilationInfo, int n, String string, Map map) {
        n = AstUtilities.boundCaretOffset(compilationInfo, n);
        Node node = AstUtilities.getRoot(compilationInfo);
        if (node == null) {
            return null;
        }
        AstPath astPath = new AstPath(node, n);
        Node node2 = astPath.leaf();
        if (string.startsWith("$")) {
            return null;
        }
        if (string.startsWith("@@")) {
            return null;
        }
        if (string.startsWith("@")) {
            return null;
        }
        if (node2 != null) {
            void var12_16;
            Object object;
            Node node3 = AstUtilities.findLocalScope(node2, astPath);
            HashMap<String, Node> hashMap = new HashMap<String, Node>();
            CodeCompleter.addLocals(node3, hashMap);
            List<Node> list = AstUtilities.getApplicableBlocks(astPath, false);
            for (Node stringArray : list) {
                CodeCompleter.addDynamic(stringArray, hashMap);
            }
            String string2 = (String)map.get(ATTR_DEFAULTS);
            if (string2 != null && string2.length() > 0) {
                String[] i = string2.split(",");
                for (String string3 : i) {
                    if (hashMap.containsKey(string3)) continue;
                    return string3;
                }
                object = i;
                int n2 = ((Object)object).length;
                for (int j = 0; j < n2; ++j) {
                    Object object2 = object[j];
                    for (int k = 2; k < 5; ++k) {
                        String string4 = (String)object2 + k;
                        if (string4.length() <= 0 || hashMap.containsKey(string4)) continue;
                        return string4;
                    }
                }
            }
            if (string.length() > 0 && !hashMap.containsKey(string)) {
                return string;
            }
            if (string.length() == 0) {
                string = "var";
            }
            boolean bl = true;
            while (var12_16 < 15) {
                Object object3 = object = var12_16 == true ? string : string + (int)var12_16;
                if (((String)object).length() > 0 && !hashMap.containsKey(object)) {
                    return object;
                }
                ++var12_16;
            }
        }
        return null;
    }

    public String resolveTemplateVariable(String string, CompilationInfo compilationInfo, int n, String string2, Map map) {
        if (string.equals(KEY_PIPE)) {
            return "||";
        }
        if (string.equals(ATTR_UNUSEDLOCAL)) {
            return this.suggestName(compilationInfo, n, string2, map);
        }
        if (map != null && map.containsKey(ATTR_UNUSEDLOCAL)) {
            return this.suggestName(compilationInfo, n, string2, map);
        }
        if (!(string.equals(KEY_METHOD) || string.equals(KEY_METHOD_FQN) || string.equals(KEY_CLASS) || string.equals(KEY_CLASS_FQN) || string.equals(KEY_SUPERCLASS) || string.equals(KEY_PATH) || string.equals(KEY_FILE))) {
            return null;
        }
        n = AstUtilities.boundCaretOffset(compilationInfo, n);
        Node node = AstUtilities.getRoot(compilationInfo);
        if (node == null) {
            return null;
        }
        AstPath astPath = new AstPath(node, n);
        if (string.equals(KEY_METHOD)) {
            MethodDefNode methodDefNode = AstUtilities.findMethod(astPath);
            if (methodDefNode != null) {
                return AstUtilities.getDefName((Node)methodDefNode);
            }
        } else if (string.equals(KEY_METHOD_FQN)) {
            MethodDefNode methodDefNode = AstUtilities.findMethod(astPath);
            if (methodDefNode != null) {
                String string3 = AstUtilities.getFqnName(astPath);
                String string4 = AstUtilities.getDefName((Node)methodDefNode);
                if (string3 != null && string3.length() > 0) {
                    return string3 + "#" + string4;
                }
                return string4;
            }
        } else if (string.equals(KEY_CLASS)) {
            ClassNode classNode = AstUtilities.findClass(astPath);
            if (classNode != null) {
                return classNode.getCPath().getName();
            }
        } else if (string.equals(KEY_SUPERCLASS)) {
            ClassNode classNode = AstUtilities.findClass(astPath);
            if (classNode != null) {
                Object object;
                IndexedClass indexedClass;
                Index index = compilationInfo.getIndex("text/x-ruby");
                if (index != null && (indexedClass = ((RubyIndex)(object = RubyIndex.get(index))).getSuperclass(AstUtilities.getFqnName(astPath))) != null) {
                    return indexedClass.getFqn();
                }
                object = AstUtilities.getSuperclass(classNode);
                if (object != null) {
                    return object;
                }
                return "Object";
            }
        } else {
            if (string.equals(KEY_CLASS_FQN)) {
                return AstUtilities.getFqnName(astPath);
            }
            if (string.equals(KEY_FILE)) {
                return FileUtil.toFile((FileObject)compilationInfo.getFileObject()).getName();
            }
            if (string.equals(KEY_PATH)) {
                return FileUtil.toFile((FileObject)compilationInfo.getFileObject()).getPath();
            }
        }
        return null;
    }

    public ParameterInfo parameters(CompilationInfo compilationInfo, int n, CompletionProposal completionProposal) {
        IndexedMethod[] indexedMethodArray = new IndexedMethod[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n2 = AstUtilities.getAstOffset(compilationInfo, n);
        if (!CodeCompleter.computeMethodCall(compilationInfo, n, n2, indexedMethodArray, nArray, nArray2, null)) {
            return ParameterInfo.NONE;
        }
        IndexedMethod indexedMethod = indexedMethodArray[0];
        if (indexedMethod == null) {
            return ParameterInfo.NONE;
        }
        int n3 = nArray[0];
        int n4 = nArray2[0];
        List<String> list = indexedMethod.getParameters();
        if (list != null && list.size() > 0) {
            return new ParameterInfo(list, n3, n4);
        }
        return ParameterInfo.NONE;
    }

    private static boolean forceCompletionSpaces() {
        return FORCE_COMPLETION_SPACES;
    }

    public Completable.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        char c = string.charAt(0);
        if (c == '\n' || c == '(' || c == '[' || c == '{') {
            return Completable.QueryType.STOP;
        }
        if (c != '.' && c != ':') {
            return Completable.QueryType.NONE;
        }
        int n = jTextComponent.getCaretPosition();
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        if (".".equals(string)) {
            TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
            if (tokenSequence == null) {
                return Completable.QueryType.NONE;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return Completable.QueryType.NONE;
            }
            if (tokenSequence.offset() == n && !tokenSequence.movePrevious()) {
                return Completable.QueryType.NONE;
            }
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if (tokenId == RubyTokenId.RANGE) {
                return Completable.QueryType.NONE;
            }
            if ("comment".equals(tokenId.primaryCategory()) || "string".equals(tokenId.primaryCategory()) || "regexp".equals(tokenId.primaryCategory())) {
                return Completable.QueryType.NONE;
            }
            return Completable.QueryType.COMPLETION;
        }
        if (":".equals(string)) {
            int n2 = jTextComponent.getSelectionStart();
            try {
                if (n2 > 1 && jTextComponent.getText(n2 - 2, 1).charAt(0) == ':' && CodeCompleter.isRubyContext(baseDocument, n2 - 1)) {
                    return Completable.QueryType.COMPLETION;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return Completable.QueryType.NONE;
    }

    public static boolean isRubyContext(BaseDocument baseDocument, int n) {
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.movePrevious() && !tokenSequence.moveNext()) {
            return true;
        }
        TokenId tokenId = tokenSequence.token().id();
        return !"comment".equals(tokenId.primaryCategory()) && !"string".equals(tokenId.primaryCategory()) && !"regexp".equals(tokenId.primaryCategory());
    }

    static {
        selectionTemplates = new HashSet<String>();
        selectionTemplates.add("begin");
        selectionTemplates.add("do");
        selectionTemplates.add("doc");
        selectionTemplates.add("if");
        selectionTemplates.add("ife");
        callLineStart = -1;
        FORCE_COMPLETION_SPACES = Boolean.getBoolean("ruby.complete.spaces");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DbItem
    extends RubyCompletionItem {
        private String name;
        private String type;

        DbItem(String string, String string2, int n, CompletionRequest completionRequest) {
            super(null, n, completionRequest);
            this.name = string;
            this.type = string2;
        }

        @Override
        public String getLhsHtml() {
            HtmlFormatter htmlFormatter = this.request.formatter;
            htmlFormatter.reset();
            htmlFormatter.emphasis(true);
            htmlFormatter.name(ElementKind.DB, true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(ElementKind.DB, false);
            htmlFormatter.emphasis(false);
            return htmlFormatter.getText();
        }

        @Override
        public String getInsertPrefix() {
            return this.name;
        }

        @Override
        public String getRhsHtml() {
            HtmlFormatter htmlFormatter = this.request.formatter;
            htmlFormatter.reset();
            htmlFormatter.appendText(this.type);
            return htmlFormatter.getText();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.DB;
        }

        @Override
        public ImageIcon getIcon() {
            return null;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public boolean isSmart() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CallItem
    extends MethodItem {
        private IndexedMethod method;
        private int index;

        CallItem(IndexedMethod indexedMethod, int n, int n2, CompletionRequest completionRequest) {
            super(indexedMethod, n2, completionRequest);
            this.method = indexedMethod;
            this.index = n;
        }

        @Override
        public String getRhsHtml() {
            return super.getRhsHtml();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CALL;
        }

        @Override
        public String getInsertPrefix() {
            return "";
        }

        @Override
        public String getLhsHtml() {
            ElementKind elementKind = this.getKind();
            HtmlFormatter htmlFormatter = this.request.formatter;
            htmlFormatter.reset();
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.getName());
            List<String> list = this.method.getParameters();
            if (list != null && list.size() > 0) {
                htmlFormatter.appendHtml("(");
                if (this.index > 0 && this.index < list.size()) {
                    htmlFormatter.appendText("... , ");
                }
                htmlFormatter.active(true);
                htmlFormatter.appendText(list.get(Math.min(list.size() - 1, this.index)));
                htmlFormatter.active(false);
                if (this.index < list.size() - 1) {
                    htmlFormatter.appendText(", ...");
                }
                htmlFormatter.appendHtml(")");
            }
            if (this.method.hasBlock() && !this.method.isBlockOptional()) {
                htmlFormatter.appendText(" { }");
            }
            htmlFormatter.name(elementKind, false);
            return htmlFormatter.getText();
        }

        @Override
        public boolean isSmart() {
            return true;
        }

        @Override
        public List<String> getInsertParams() {
            return null;
        }

        @Override
        public String getCustomInsertTemplate() {
            return null;
        }
    }

    private class ParameterItem
    extends RubyCompletionItem {
        private static final String CONSTANT_ICON = "org/netbeans/modules/ruby/symbol.png";
        private final String name;
        private final String desc;
        private final String insert;

        ParameterItem(IndexedMethod indexedMethod, String string, String string2, String string3, int n, CompletionRequest completionRequest) {
            super(indexedMethod, n, completionRequest);
            this.name = string;
            this.desc = string2;
            this.insert = string3;
        }

        public String getRhsHtml() {
            if (this.desc != null) {
                HtmlFormatter htmlFormatter = this.request.formatter;
                htmlFormatter.reset();
                htmlFormatter.appendText(this.desc);
                return htmlFormatter.getText();
            }
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.PARAMETER;
        }

        public ImageIcon getIcon() {
            if (symbolIcon == null) {
                symbolIcon = new ImageIcon(org.openide.util.Utilities.loadImage((String)CONSTANT_ICON));
            }
            return symbolIcon;
        }

        public String getName() {
            return this.name;
        }

        public String getInsertPrefix() {
            return this.insert;
        }
    }

    private class FieldItem
    extends RubyCompletionItem {
        FieldItem(Element element, int n, CompletionRequest completionRequest) {
            super(element, n, completionRequest);
        }

        public String getLhsHtml() {
            if (this.element instanceof IndexedField) {
                boolean bl;
                HtmlFormatter htmlFormatter = this.request.formatter;
                htmlFormatter.reset();
                IndexedField indexedField = (IndexedField)this.element;
                boolean bl2 = bl = !indexedField.isInherited();
                if (bl) {
                    htmlFormatter.emphasis(true);
                }
                htmlFormatter.name(ElementKind.FIELD, true);
                htmlFormatter.appendText(this.getName());
                htmlFormatter.name(ElementKind.FIELD, false);
                if (bl) {
                    htmlFormatter.emphasis(false);
                }
                return htmlFormatter.getText();
            }
            return super.getLhsHtml();
        }

        public String getInsertPrefix() {
            String string = this.element.getModifiers().contains(Modifier.STATIC) ? "@@" + this.getName() : "@" + this.getName();
            if (this.symbol) {
                string = ":" + string;
            }
            return string;
        }

        public String getRhsHtml() {
            IndexedField indexedField;
            String string;
            HtmlFormatter htmlFormatter = this.request.formatter;
            htmlFormatter.reset();
            if (this.element instanceof IndexedField && (string = (indexedField = (IndexedField)this.element).getIn()) != null) {
                htmlFormatter.appendText(string);
                return htmlFormatter.getText();
            }
            return null;
        }
    }

    private class PlainItem
    extends RubyCompletionItem {
        PlainItem(Element element, int n, CompletionRequest completionRequest) {
            super(element, n, completionRequest);
        }
    }

    private class ClassItem
    extends RubyCompletionItem {
        ClassItem(Element element, int n, CompletionRequest completionRequest) {
            super(element, n, completionRequest);
        }

        public String getRhsHtml() {
            HtmlFormatter htmlFormatter = this.request.formatter;
            htmlFormatter.reset();
            String string = ((ClassElement)this.element).getIn();
            if (string == null) {
                return null;
            }
            htmlFormatter.appendText(string);
            return htmlFormatter.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeywordItem
    extends RubyCompletionItem {
        private static final String RUBY_KEYWORD = "org/netbeans/modules/ruby/jruby.png";
        private final String keyword;
        private final String description;

        KeywordItem(String string, String string2, int n, CompletionRequest completionRequest) {
            super(null, n, completionRequest);
            this.keyword = string;
            this.description = string2;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        @Override
        public String getRhsHtml() {
            if (this.description != null) {
                HtmlFormatter htmlFormatter = this.request.formatter;
                htmlFormatter.reset();
                htmlFormatter.appendHtml(this.description);
                return htmlFormatter.getText();
            }
            return null;
        }

        @Override
        public ImageIcon getIcon() {
            if (keywordIcon == null) {
                keywordIcon = new ImageIcon(org.openide.util.Utilities.loadImage((String)RUBY_KEYWORD));
            }
            return keywordIcon;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return new KeywordElement(this.keyword);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodItem
    extends RubyCompletionItem {
        private IndexedMethod method;

        MethodItem(IndexedMethod indexedMethod, int n, CompletionRequest completionRequest) {
            super(indexedMethod, n, completionRequest);
            this.method = indexedMethod;
        }

        @Override
        public String getLhsHtml() {
            List<String> list;
            boolean bl;
            ElementKind elementKind = this.getKind();
            HtmlFormatter htmlFormatter = this.request.formatter;
            htmlFormatter.reset();
            boolean bl2 = bl = !this.method.isInherited();
            if (bl) {
                htmlFormatter.emphasis(true);
            }
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(elementKind, false);
            if (bl) {
                htmlFormatter.emphasis(false);
            }
            if ((list = this.method.getParameters()) != null && list.size() > 0) {
                htmlFormatter.appendHtml("(");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    htmlFormatter.parameters(true);
                    htmlFormatter.appendText((String)iterator.next());
                    htmlFormatter.parameters(false);
                    if (!iterator.hasNext()) continue;
                    htmlFormatter.appendText(", ");
                }
                htmlFormatter.appendHtml(")");
            }
            if (this.method.hasBlock() && !this.method.isBlockOptional()) {
                htmlFormatter.appendText(" { }");
            }
            return htmlFormatter.getText();
        }

        @Override
        public String getRhsHtml() {
            HtmlFormatter htmlFormatter = this.request.formatter;
            htmlFormatter.reset();
            if (this.method.isTopLevel() && this.method.getRequire() != null) {
                htmlFormatter.appendText(this.method.getRequire());
                return htmlFormatter.getText();
            }
            String string = this.method.getIn();
            if (string != null) {
                htmlFormatter.appendText(string);
                return htmlFormatter.getText();
            }
            return null;
        }

        @Override
        public List<String> getInsertParams() {
            return this.method.getParameters();
        }

        @Override
        public String getCustomInsertTemplate() {
            String string;
            Object object;
            String string2;
            String string3;
            boolean bl;
            int n;
            String string4 = this.getInsertPrefix();
            List<String> list = this.getInsertParams();
            boolean bl2 = false;
            int n2 = n = list.size();
            boolean bl3 = bl = this.method.getEncodedAttributes() != null && this.method.getEncodedAttributes().indexOf("=>") != -1;
            if (n > 0 && list.get(n - 1).startsWith("&")) {
                bl2 = true;
                --n2;
                string3 = "(";
                string2 = ")";
            } else if (this.method.hasBlock()) {
                bl2 = true;
                if (n > 0) {
                    string3 = "(";
                    string2 = ")";
                } else {
                    string3 = "";
                    string2 = "";
                }
            } else {
                object = this.getParamListDelimiters();
                assert (((String[])object).length == 2);
                string3 = object[0];
                string2 = object[1];
                if (n2 == 0) {
                    string3 = "";
                    string2 = "";
                }
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(string4);
            if (bl) {
                ((StringBuilder)object).append(" ");
                return ((StringBuilder)object).toString();
            }
            ((StringBuilder)object).append(string3);
            int n3 = 1;
            for (int i = 0; i < n2; ++i) {
                string = list.get(i);
                ((StringBuilder)object).append("${");
                ((StringBuilder)object).append("ruby-cc-");
                ((StringBuilder)object).append(Integer.toString(n3++));
                ((StringBuilder)object).append(" default=\"");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append("\"");
                ((StringBuilder)object).append("}");
                if (i >= n2 - 1) continue;
                ((StringBuilder)object).append(", ");
            }
            ((StringBuilder)object).append(string2);
            if (bl2) {
                int n4;
                String[] stringArray = null;
                string = this.method.getEncodedAttributes();
                int n5 = string.indexOf(59);
                if (n5 != -1 && (n4 = string.indexOf(59, n5 + 1)) != -1) {
                    stringArray = string.substring(n5 + 1, n4).split(",");
                }
                ((StringBuilder)object).append(" { |");
                if (stringArray != null && stringArray.length > 0) {
                    for (n4 = 0; n4 < stringArray.length; ++n4) {
                        if (n4 > 0) {
                            ((StringBuilder)object).append(",");
                        }
                        String string5 = stringArray[n4];
                        ((StringBuilder)object).append("${unusedlocal defaults=\"");
                        ((StringBuilder)object).append(string5);
                        ((StringBuilder)object).append("\"}");
                    }
                } else {
                    ((StringBuilder)object).append("${unusedlocal defaults=\"i,e\"}");
                }
                ((StringBuilder)object).append("| ${");
                ((StringBuilder)object).append("ruby-cc-");
                ((StringBuilder)object).append(Integer.toString(n3++));
                ((StringBuilder)object).append(" default=\"\"} }${cursor}");
            } else {
                ((StringBuilder)object).append("${cursor}");
            }
            try {
                callLineStart = Utilities.getRowStart((BaseDocument)this.request.doc, (int)this.anchorOffset);
                callMethod = this.method;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            return ((StringBuilder)object).toString();
        }

        @Override
        public String[] getParamListDelimiters() {
            List list;
            String string = this.getName();
            String string2 = this.element.getIn();
            if ("Module".equals(string2)) {
                if (string.startsWith("attr_")) {
                    return new String[]{" :", " "};
                }
                if (string.equals("include") || string.equals("import")) {
                    return new String[]{" ", " "};
                }
                if (string.equals("include_package")) {
                    return new String[]{" '", "'"};
                }
            } else if ("Kernel".equals(string2)) {
                if (string.equals(CodeCompleter.KEY_REQUIRE)) {
                    return new String[]{" '", "'"};
                }
                if (string.equals("p")) {
                    return new String[]{" ", " "};
                }
            } else if ("Object".equals(string2) && string.equals("include_class")) {
                return new String[]{" '", "'"};
            }
            if (CodeCompleter.forceCompletionSpaces()) {
                boolean bl = false;
                AstPath astPath = this.request.path;
                if (astPath != null) {
                    ListIterator<Node> listIterator = astPath.leafToRoot();
                    while (listIterator.hasNext()) {
                        Node node = (Node)listIterator.next();
                        if (!AstUtilities.isCall(node) || node == this.request.node) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    return new String[]{"(", ")"};
                }
                return new String[]{" ", " "};
            }
            if (this.element instanceof IndexedElement && (list = CodeCompleter.this.getComments(null, this.element)) != null && list.size() > 0) {
                String string3 = this.getName();
                boolean bl = false;
                boolean bl2 = false;
                for (String string4 : list) {
                    int n;
                    if (!string4.startsWith("#  ")) continue;
                    int n2 = 0;
                    int n3 = string4.length();
                    while ((n = string4.indexOf(string3, n2)) != -1) {
                        n2 = n += string3.length();
                        if (n >= n3) continue;
                        char c = string4.charAt(n);
                        if (c == ' ') {
                            bl = true;
                            continue;
                        }
                        if (c != '(') continue;
                        bl2 = true;
                    }
                }
                if (!bl2 && bl) {
                    return new String[]{" ", " "};
                }
            }
            return super.getParamListDelimiters();
        }

        @Override
        public ElementKind getKind() {
            if (this.method.getMethodType() == IndexedMethod.MethodType.ATTRIBUTE) {
                return ElementKind.ATTRIBUTE;
            }
            return this.element.getKind();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class RubyCompletionItem
    implements CompletionProposal {
        protected CompletionRequest request;
        protected Element element;
        protected int anchorOffset;
        protected boolean symbol;
        protected boolean smart;

        private RubyCompletionItem(Element element, int n, CompletionRequest completionRequest) {
            this.element = element;
            this.anchorOffset = n;
            this.request = completionRequest;
        }

        public int getAnchorOffset() {
            return this.anchorOffset;
        }

        public String getName() {
            return this.element.getName();
        }

        public void setSymbol(boolean bl) {
            this.symbol = bl;
        }

        public String getInsertPrefix() {
            if (this.symbol) {
                return ":" + this.getName();
            }
            return this.getName();
        }

        public String getSortText() {
            return this.getName();
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public ElementKind getKind() {
            return this.element.getKind();
        }

        public ImageIcon getIcon() {
            return null;
        }

        public String getLhsHtml() {
            ElementKind elementKind = this.getKind();
            HtmlFormatter htmlFormatter = this.request.formatter;
            htmlFormatter.reset();
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(elementKind, false);
            return htmlFormatter.getText();
        }

        public String getRhsHtml() {
            return null;
        }

        public Set<Modifier> getModifiers() {
            return this.element.getModifiers();
        }

        public String toString() {
            String string = this.getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            return string + "(" + this.getKind() + "): " + this.getName();
        }

        void setSmart(boolean bl) {
            this.smart = bl;
        }

        public boolean isSmart() {
            return this.smart;
        }

        public List<String> getInsertParams() {
            return null;
        }

        public String[] getParamListDelimiters() {
            return new String[]{"(", ")"};
        }

        public String getCustomInsertTemplate() {
            return null;
        }
    }

    private static class CompletionRequest {
        private TokenHierarchy<Document> th;
        private CompilationInfo info;
        private AstPath path;
        private Node node;
        private int lexOffset;
        private int astOffset;
        private BaseDocument doc;
        private String prefix;
        private RubyIndex index;
        private NameKind kind;
        private Completable.QueryType queryType;
        private FileObject fileObject;
        private HtmlFormatter formatter;

        private CompletionRequest() {
        }
    }
}

