/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyUtils {
    private static final String S = "s";
    private static final String ES = "es";
    public static final String[] RUBY_KEYWORDS = new String[]{"alias", "and", "BEGIN", "begin", "break", "case", "class", "def", "defined?", "do", "else", "elsif", "END", "end", "ensure", "false", "for", "if", "in", "module", "next", "nil", "not", "or", "redo", "rescue", "retry", "return", "self", "super", "then", "true", "undef", "unless", "until", "when", "while", "yield"};
    private static final String CONTROLLER_SUFFIX = "_controller.rb";
    public static final String[] RUBY_VIEW_EXTS = new String[]{"rhtml", "erb", "dryml", "mab", "rjs", "haml", "rxml", "dryml", "html.erb"};

    private RubyUtils() {
    }

    public static boolean isRubyFile(FileObject fileObject) {
        return "text/x-ruby".equals(fileObject.getMIMEType());
    }

    public static boolean isMarkabyFile(FileObject fileObject) {
        return "mab".equals(fileObject.getExt());
    }

    public static boolean isRhtmlFile(FileObject fileObject) {
        return "application/x-httpd-eruby".equals(fileObject.getMIMEType());
    }

    public static boolean isRhtmlDocument(Document document) {
        String string = (String)document.getProperty("mimeType");
        return "application/x-httpd-eruby".equals(string);
    }

    public static boolean isRubyOrRhtmlFile(FileObject fileObject) {
        return RubyUtils.isRubyFile(fileObject) || RubyUtils.isRhtmlFile(fileObject);
    }

    public static String camelToUnderlinedName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl2 = Character.isUpperCase(c);
            if (bl2) {
                if (i > 0 && !bl) {
                    stringBuilder.append('_');
                    bl = true;
                }
                c = Character.toLowerCase(c);
            }
            stringBuilder.append(c);
            bl = c == '_';
        }
        return stringBuilder.toString();
    }

    public static String pluralize(String string) {
        char c = string.charAt(string.length() - 1);
        switch (c) {
            case 'T': 
            case 't': {
                if (!RubyUtils.endsWithIgnoreCase(string, "equipment")) break;
                return string;
            }
            case 'P': 
            case 'p': {
                if (!RubyUtils.endsWithIgnoreCase(string, "sheep")) break;
                return string;
            }
            case 'D': 
            case 'd': {
                if (!RubyUtils.endsWithIgnoreCase(string, "child")) break;
                return string + "ren";
            }
            case 'N': 
            case 'n': {
                if (RubyUtils.endsWithIgnoreCase(string, "information")) {
                    return string;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "man")) {
                    return string.substring(0, string.length() - 2) + "en";
                }
                if (!RubyUtils.endsWithIgnoreCase(string, "person")) break;
                return string.substring(0, string.length() - 5) + "eople";
            }
            case 'S': 
            case 's': {
                if (RubyUtils.endsWithIgnoreCase(string, "species") || RubyUtils.endsWithIgnoreCase(string, "series")) {
                    return string;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "axis") || RubyUtils.endsWithIgnoreCase(string, "testis")) {
                    return string.substring(0, string.length() - 2) + ES;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "ss")) {
                    return string + ES;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "alias") || RubyUtils.endsWithIgnoreCase(string, "status")) {
                    return string + ES;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "us")) {
                    return string.substring(0, string.length() - 2) + "i";
                }
                if (RubyUtils.endsWithIgnoreCase(string, "bus")) {
                    return string.substring(0, string.length() - 1) + "ses";
                }
                if (RubyUtils.endsWithIgnoreCase(string, "sis")) {
                    return string.substring(0, string.length() - 2) + ES;
                }
                return string;
            }
            case 'O': 
            case 'o': {
                if (!RubyUtils.endsWithIgnoreCase(string, "buffalo") && !RubyUtils.endsWithIgnoreCase(string, "tomato")) break;
                return string + ES;
            }
            case 'M': 
            case 'm': {
                if (!RubyUtils.endsWithIgnoreCase(string, "tum") && !RubyUtils.endsWithIgnoreCase(string, "ium")) break;
                return string.substring(0, string.length() - 2) + "a";
            }
            case 'F': 
            case 'f': {
                if (!RubyUtils.endsWithIgnoreCase(string, "lf") && !RubyUtils.endsWithIgnoreCase(string, "rf")) break;
                return string.substring(0, string.length() - 1) + "ves";
            }
            case 'E': 
            case 'e': {
                if (RubyUtils.endsWithIgnoreCase(string, "rice")) {
                    return string;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "move")) {
                    return string + S;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "mouse") || RubyUtils.endsWithIgnoreCase(string, "louse")) {
                    return string.substring(0, string.length() - 4) + "ice";
                }
                if (RubyUtils.endsWithIgnoreCase(string, "fe") && !RubyUtils.endsWithIgnoreCase(string, "ffe")) {
                    return string.substring(0, string.length() - 2) + "ves";
                }
                if (!RubyUtils.endsWithIgnoreCase(string, "hive")) break;
                return string + S;
            }
            case 'Y': 
            case 'y': {
                if (RubyUtils.endsWithIgnoreCase(string, "money")) {
                    return string;
                }
                if (!string.matches(".*([^aeiouy]|qu)y$")) break;
                return string.substring(0, string.length() - 1) + "ies";
            }
            case 'X': 
            case 'x': {
                if (RubyUtils.endsWithIgnoreCase(string, "sex")) {
                    return string + ES;
                }
                if (RubyUtils.endsWithIgnoreCase(string, "matrix") || RubyUtils.endsWithIgnoreCase(string, "vertex") || RubyUtils.endsWithIgnoreCase(string, "index")) {
                    return string.substring(0, string.length() - 2) + "ices";
                }
                if (string.equalsIgnoreCase("ox")) {
                    return "oxen";
                }
                return string + ES;
            }
            case 'H': 
            case 'h': {
                if (RubyUtils.endsWithIgnoreCase(string, "fish")) {
                    return string;
                }
                if (!RubyUtils.endsWithIgnoreCase(string, "ch") && !RubyUtils.endsWithIgnoreCase(string, "sh")) break;
                return string + ES;
            }
            case 'Z': 
            case 'z': {
                if (!RubyUtils.endsWithIgnoreCase(string, "quiz")) break;
                return string + "zes";
            }
        }
        return string + S;
    }

    private static boolean endsWithIgnoreCase(String string, String string2) {
        if (string2.length() > string.length()) {
            return false;
        }
        return string.regionMatches(true, string.length() - string2.length(), string2, 0, string2.length());
    }

    public static String tableize(String string) {
        return RubyUtils.pluralize(RubyUtils.camelToUnderlinedName(string));
    }

    public static boolean isOperator(String string) {
        if (string.length() == 0) {
            return false;
        }
        switch (string.charAt(0)) {
            case '+': {
                return string.equals("+") || string.equals("+@");
            }
            case '-': {
                return string.equals("-") || string.equals("-@");
            }
            case '*': {
                return string.equals("*") || string.equals("**");
            }
            case '<': {
                return string.equals("<") || string.equals("<<") || string.equals("<=") || string.equals("<=>");
            }
            case '>': {
                return string.equals(">") || string.equals(">>") || string.equals(">=");
            }
            case '=': {
                return string.equals("=") || string.equals("==") || string.equals("===") || string.equals("=~");
            }
            case '!': {
                return string.equals("!=") || string.equals("!~");
            }
            case '&': {
                return string.equals("&") || string.equals("&&");
            }
            case '|': {
                return string.equals("|") || string.equals("||");
            }
            case '[': {
                return string.equals("[]") || string.equals("[]=");
            }
            case '%': {
                return string.equals("%");
            }
            case '/': {
                return string.equals("/");
            }
            case '~': {
                return string.equals("~");
            }
            case '^': {
                return string.equals("^");
            }
            case '`': {
                return string.equals("`");
            }
        }
        return false;
    }

    public static boolean isSafeIdentifierName(String string, int n) {
        char c;
        int n2;
        for (n2 = n; n2 < string.length() && ((c = string.charAt(n2)) == '$' || c == '@' || c == ':'); ++n2) {
        }
        while (n2 < string.length()) {
            c = string.charAt(n2);
            if (!(c >= 'a' && c <= 'z' || c == '_' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '?' || c == '=' || c == '!')) {
                return RubyUtils.isOperator(string);
            }
            ++n2;
        }
        return true;
    }

    public static String getIdentifierWarning(String string, int n) {
        if (RubyUtils.isSafeIdentifierName(string, n)) {
            return null;
        }
        return NbBundle.getMessage(RubyUtils.class, (String)"UnsafeIdentifierName");
    }

    public static String underlinedNameToCamel(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                bl = true;
                continue;
            }
            if (c == '/') {
                bl = true;
                stringBuilder.append("::");
                continue;
            }
            if (bl) {
                c = Character.toUpperCase(c);
                bl = false;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isValidRubyModuleName(String string) {
        String[] stringArray;
        if (string.trim().length() == 0) {
            return false;
        }
        for (String string2 : stringArray = string.split("::")) {
            if (RubyUtils.isValidRubyClassName(string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidRubyClassName(String string) {
        if (RubyUtils.isRubyKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (!Character.isUpperCase(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!RubyUtils.isStrictIdentifierChar(c)) {
                return false;
            }
            if (c != '!' && c != '=' && c != '?') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidRubyLocalVarName(String string) {
        if (RubyUtils.isRubyKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (Character.isUpperCase(string.charAt(0)) || Character.isWhitespace(string.charAt(0))) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                return false;
            }
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidRubyMethodName(String string) {
        if (RubyUtils.isRubyKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (RubyUtils.isOperator(string)) {
            return true;
        }
        if (Character.isUpperCase(string.charAt(0)) || Character.isWhitespace(string.charAt(0))) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return i == string.length() - 1 && (c == '!' || c == '=' || c == '?');
        }
        return true;
    }

    public static boolean isValidRubyIdentifier(String string) {
        if (RubyUtils.isRubyKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isRubyKeyword(String string) {
        for (String string2 : RUBY_KEYWORDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String getLineCommentPrefix() {
        return "#";
    }

    public static boolean isIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '$' || c == '@' || c == '&' || c == ':' || c == '!' || c == '?' || c == '=';
    }

    public static boolean isStrictIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '!' || c == '?' || c == '=';
    }

    public static String getControllerClass(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        FileObject fileObject2 = project.getProjectDirectory().getFileObject("app/controllers");
        if (fileObject2 != null) {
            String string = fileObject.getName();
            for (FileObject fileObject3 = fileObject.getParent(); fileObject3 != fileObject2 && fileObject3 != null; fileObject3 = fileObject3.getParent()) {
                string = fileObject3.getName() + "/" + string;
            }
            return RubyUtils.underlinedNameToCamel(string);
        }
        return null;
    }

    public static List<String> getControllerNames(FileObject fileObject, boolean bl) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        FileObject fileObject2 = project.getProjectDirectory().getFileObject("app/controllers");
        if (fileObject2 != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            RubyUtils.addControllerNames(fileObject2, arrayList, bl);
            return arrayList;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private static void addControllerNames(FileObject fileObject, List<String> list, boolean bl) {
        String string = fileObject.getNameExt();
        if (string.endsWith(CONTROLLER_SUFFIX)) {
            void var4_6;
            String object = string.substring(0, string.length() - CONTROLLER_SUFFIX.length());
            if (!bl) {
                String string2 = RubyUtils.underlinedNameToCamel(object);
            }
            list.add((String)var4_6);
        }
        for (FileObject fileObject2 : fileObject.getChildren()) {
            RubyUtils.addControllerNames(fileObject2, list, bl);
        }
    }

    public static String getControllerName(FileObject fileObject) {
        String string;
        String string2 = "_controller";
        String string3 = "controllers";
        String string4 = string = fileObject.getName().substring(0, fileObject.getName().length() - string2.length());
        for (FileObject fileObject2 = fileObject.getParent(); fileObject2 != null; fileObject2 = fileObject2.getParent()) {
            if (fileObject2.getName().equals(string3) && (fileObject2.getParent() == null || fileObject2.getParent().getName().equals("app"))) {
                fileObject2 = fileObject2.getParent();
                break;
            }
            string4 = fileObject2.getNameExt() + "/" + string4;
        }
        return string4;
    }

    public static FileObject getRailsViewFor(FileObject fileObject, String string, boolean bl, boolean bl2) {
        String string2 = bl ? "_helper" : "_controller";
        String string3 = bl ? "helpers" : "controllers";
        Object object = null;
        try {
            FileObject fileObject2;
            String string4;
            String string5 = string4 = fileObject.getName().substring(0, fileObject.getName().length() - string2.length());
            for (fileObject2 = fileObject.getParent(); fileObject2 != null; fileObject2 = fileObject2.getParent()) {
                if (fileObject2.getName().equals(string3) && (fileObject2.getParent() == null || fileObject2.getParent().getName().equals("app"))) {
                    fileObject2 = fileObject2.getParent();
                    break;
                }
                string5 = fileObject2.getNameExt() + "/" + string5;
            }
            if (fileObject2 == null) {
                return null;
            }
            FileObject fileObject3 = fileObject2.getFileObject("views/" + string5);
            if (fileObject3 == null) {
                return null;
            }
            if (string != null) {
                String string6;
                String[] stringArray = RUBY_VIEW_EXTS;
                int n = stringArray.length;
                for (int i = 0; i < n && (object = fileObject3.getFileObject(string, string6 = stringArray[i])) == null; ++i) {
                }
                if (object == null && bl2) {
                    return null;
                }
            }
            if (object == null && (object = fileObject3.getFileObject("index.rhtml")) == null) {
                block4: for (String string6 : fileObject3.getChildren()) {
                    String string7 = string6.getExt();
                    for (String string8 : RUBY_VIEW_EXTS) {
                        if (!string7.equalsIgnoreCase(string8)) continue;
                        object = string6;
                        continue block4;
                    }
                }
            }
            if (object == null) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (object == null) {
            return null;
        }
        return object;
    }

    public static FileObject getRailsControllerFor(FileObject fileObject) {
        FileObject fileObject2 = null;
        try {
            FileObject fileObject3;
            fileObject = fileObject.getParent();
            String string = fileObject.getName();
            String string2 = "";
            if (!string.startsWith("_")) {
                string2 = string;
            }
            for (fileObject3 = fileObject.getParent(); fileObject3 != null; fileObject3 = fileObject3.getParent()) {
                if (fileObject3.getName().equals("views") && (fileObject3.getParent() == null || fileObject3.getParent().getName().equals("app"))) {
                    fileObject3 = fileObject3.getParent();
                    break;
                }
                string2 = fileObject3.getNameExt() + "/" + string2;
            }
            if (fileObject3 == null) {
                return null;
            }
            fileObject2 = fileObject3.getFileObject("controllers/" + string2 + CONTROLLER_SUFFIX);
        }
        catch (Exception exception) {
            return null;
        }
        return fileObject2;
    }

    public static boolean isRowWhite(String string, int n) throws BadLocationException {
        try {
            char c;
            int n2;
            for (n2 = n; n2 < string.length() && (c = string.charAt(n2)) != '\n'; ++n2) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            for (n2 = n - 1; n2 >= 0 && (c = string.charAt(n2)) != '\n'; --n2) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static boolean isRowEmpty(String string, int n) throws BadLocationException {
        try {
            char c;
            if (n < string.length() && (c = string.charAt(n)) != '\n' && (c != '\r' || n != string.length() - 1 && string.charAt(n + 1) != '\n')) {
                return false;
            }
            return n == 0 || string.charAt(n - 1) == '\n';
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static int getRowLastNonWhite(String string, int n) throws BadLocationException {
        try {
            char c;
            int n2;
            for (n2 = n; n2 < string.length() && (c = string.charAt(n2)) != '\n' && (c != '\r' || n2 != string.length() - 1 && string.charAt(n2 + 1) != '\n'); ++n2) {
            }
            --n2;
            while (n2 >= 0) {
                c = string.charAt(n2);
                if (c == '\n') {
                    return -1;
                }
                if (!Character.isWhitespace(c)) {
                    return n2;
                }
                --n2;
            }
            return -1;
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static int getRowFirstNonWhite(String string, int n) throws BadLocationException {
        try {
            char c;
            int n2;
            if (n2 < string.length()) {
                for (n2 = n - 1; n2 >= 0 && (c = string.charAt(n2)) != '\n'; --n2) {
                }
                ++n2;
            }
            while (n2 < string.length()) {
                c = string.charAt(n2);
                if (c == '\n') {
                    return -1;
                }
                if (!Character.isWhitespace(c)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static int getRowStart(String string, int n) throws BadLocationException {
        try {
            for (int i = n - 1; i >= 0; --i) {
                char c = string.charAt(i);
                if (c != '\n') continue;
                return i + 1;
            }
            return 0;
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static boolean endsWith(StringBuilder stringBuilder, String string) {
        int n = string.length();
        if (stringBuilder.length() < n) {
            return false;
        }
        int n2 = stringBuilder.length() - n;
        for (int i = 0; i < n; ++i) {
            if (stringBuilder.charAt(n2) != string.charAt(i)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String truncate(String string, int n) {
        assert (n > 3);
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n - 3) + "...";
    }
}

