/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf.embedding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssModel {
    private static final Logger LOGGER = Logger.getLogger(CssModel.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    public static final String HTML_MIME_TYPE = "text/html";
    protected final Document doc;
    protected final ArrayList<CodeBlockData> codeBlocks = new ArrayList();
    protected String code;
    protected boolean documentDirty = true;
    protected int prevAstOffset;
    protected int prevLexOffset;
    protected static final String END_OF_LAST_SEQUENCE = "end_of_last_sequence";
    protected static final String IN_STYLE = "in_style";
    protected static final String IN_INLINED_STYLE = "in_inlined_style";
    private static final String QUTE_CUT = "quote_cut";

    public static CssModel get(Document document) {
        CssModel cssModel = (CssModel)document.getProperty(CssModel.class);
        if (cssModel == null) {
            cssModel = new CssModel(document);
            document.putProperty(CssModel.class, cssModel);
        }
        return cssModel;
    }

    protected CssModel(Document document) {
        this.doc = document;
        if (document != null) {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            tokenHierarchy.addTokenHierarchyListener(new TokenHierarchyListener(){

                public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
                    CssModel.this.documentDirty = true;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCode() {
        if (this.documentDirty) {
            this.documentDirty = false;
            this.codeBlocks.clear();
            StringBuilder stringBuilder = new StringBuilder();
            BaseDocument baseDocument = (BaseDocument)this.doc;
            try {
                baseDocument.readLock();
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                HashMap<String, Object> hashMap = new HashMap<String, Object>(6);
                this.extractCssFromHTML((TokenSequence<HTMLTokenId>)tokenSequence, stringBuilder, hashMap);
            }
            finally {
                baseDocument.readUnlock();
            }
            this.code = stringBuilder.toString();
        }
        if (LOG) {
            LOGGER.log(Level.FINE, this.dumpCode());
        }
        return this.code;
    }

    protected String dumpCode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CSS Virtual Source:\n");
        stringBuilder.append("-------------------\n");
        stringBuilder.append(this.code);
        stringBuilder.append('\n');
        stringBuilder.append("-------------------\n");
        return stringBuilder.toString();
    }

    protected void extractCssFromHTML(TokenSequence<HTMLTokenId> tokenSequence, StringBuilder stringBuilder, HashMap<String, Object> hashMap) {
        block0: while (tokenSequence.moveNext()) {
            Token token;
            TokenId tokenId;
            int n;
            String string;
            int n2;
            Token token2 = tokenSequence.token();
            TokenId tokenId2 = token2.id();
            if (tokenId2 == HTMLTokenId.STYLE) {
                hashMap.put(IN_STYLE, Boolean.TRUE);
                n2 = tokenSequence.offset();
                string = ((Object)token2.text()).toString();
                int n3 = n2 + string.length();
                n = stringBuilder.length();
                stringBuilder.append(string);
                int n4 = stringBuilder.length();
                CodeBlockData codeBlockData = new CodeBlockData(n2, n3, n, n4);
                this.codeBlocks.add(codeBlockData);
                continue;
            }
            hashMap.remove(IN_STYLE);
            if (hashMap.get(IN_INLINED_STYLE) != null) {
                if (tokenId2 == HTMLTokenId.VALUE) {
                    n2 = tokenSequence.offset();
                    string = ((Object)token2.text()).toString();
                    int n5 = n2 + string.length();
                    if (string.endsWith("\"") || string.endsWith("'")) {
                        --n5;
                        string = string.substring(0, string.length() - 1);
                    }
                    n = stringBuilder.length();
                    stringBuilder.append(string);
                    int n6 = stringBuilder.length();
                    CodeBlockData codeBlockData = new CodeBlockData(n2, n5, n, n6);
                    this.codeBlocks.add(codeBlockData);
                } else {
                    hashMap.remove(IN_INLINED_STYLE);
                    n2 = tokenSequence.offset();
                    if (hashMap.get(QUTE_CUT) != null) {
                        --n2;
                    }
                    hashMap.remove(QUTE_CUT);
                    int n7 = stringBuilder.length();
                    stringBuilder.append("\n}\n");
                    int n8 = stringBuilder.length();
                    CodeBlockData codeBlockData = new CodeBlockData(n2, n2, n7, n8);
                    this.codeBlocks.add(codeBlockData);
                }
            }
            if (tokenId2 != HTMLTokenId.TAG_OPEN) continue;
            n2 = 0;
            while (tokenSequence.moveNext() && (tokenId = (token = tokenSequence.token()).id()) != HTMLTokenId.TAG_CLOSE_SYMBOL) {
                if (tokenId == HTMLTokenId.ARGUMENT) {
                    if (!"style".equalsIgnoreCase(((Object)token.text()).toString())) continue;
                    n2 = 1;
                    continue;
                }
                if (tokenId != HTMLTokenId.VALUE || n2 == 0) continue;
                int n9 = tokenSequence.offset();
                String string2 = ((Object)token.text()).toString();
                if (string2.startsWith("\"") || string2.startsWith("'")) {
                    ++n9;
                    string2 = string2.substring(1);
                }
                int n10 = n9 + string2.length();
                if (string2.endsWith("\"") || string2.endsWith("'")) {
                    --n10;
                    hashMap.put(QUTE_CUT, Boolean.TRUE);
                    string2 = string2.substring(0, string2.length() - 1);
                }
                int n11 = stringBuilder.length();
                stringBuilder.append("\n SELECTOR {\n\t");
                int n12 = stringBuilder.length();
                CodeBlockData codeBlockData = new CodeBlockData(n9, n9, n11, n12);
                this.codeBlocks.add(codeBlockData);
                n11 = stringBuilder.length();
                stringBuilder.append(string2);
                n12 = stringBuilder.length();
                codeBlockData = new CodeBlockData(n9, n10, n11, n12);
                this.codeBlocks.add(codeBlockData);
                hashMap.put(IN_INLINED_STYLE, Boolean.TRUE);
                continue block0;
            }
        }
    }

    public int sourceToGeneratedPos(int n) {
        if (this.prevLexOffset == n) {
            return this.prevAstOffset;
        }
        this.prevLexOffset = n;
        CodeBlockData codeBlockData = this.getCodeBlockAtSourceOffset(n);
        if (codeBlockData == null) {
            return -1;
        }
        int n2 = n - codeBlockData.sourceStart;
        int n3 = codeBlockData.generatedStart + n2;
        this.prevAstOffset = n3 <= codeBlockData.generatedEnd ? n3 : codeBlockData.generatedEnd;
        return this.prevAstOffset;
    }

    public int generatedToSourcePos(int n) {
        if (this.prevAstOffset == n) {
            return this.prevLexOffset;
        }
        this.prevAstOffset = n;
        CodeBlockData codeBlockData = this.getCodeBlockAtGeneratedOffset(n);
        if (codeBlockData == null) {
            return -1;
        }
        int n2 = n - codeBlockData.generatedStart;
        int n3 = codeBlockData.sourceStart + n2;
        this.prevLexOffset = n3 <= codeBlockData.sourceEnd ? n3 : codeBlockData.sourceEnd;
        return this.prevLexOffset;
    }

    private CodeBlockData getCodeBlockAtSourceOffset(int n) {
        CodeBlockData codeBlockData = null;
        for (CodeBlockData codeBlockData2 : this.codeBlocks) {
            if (codeBlockData2.sourceStart > n || codeBlockData2.sourceEnd <= n) continue;
            if (codeBlockData2.sourceStart == codeBlockData2.sourceEnd) {
                codeBlockData = codeBlockData2;
                continue;
            }
            return codeBlockData2;
        }
        return codeBlockData;
    }

    private CodeBlockData getCodeBlockAtGeneratedOffset(int n) {
        for (CodeBlockData codeBlockData : this.codeBlocks) {
            if (codeBlockData.generatedStart > n || codeBlockData.generatedEnd <= n) continue;
            return codeBlockData;
        }
        return null;
    }

    protected class CodeBlockData {
        private int sourceStart;
        private int sourceEnd;
        private int generatedStart;
        private int generatedEnd;

        public CodeBlockData(int n, int n2, int n3, int n4) {
            this.sourceStart = n;
            this.generatedStart = n3;
            this.sourceEnd = n2;
            this.generatedEnd = n4;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CodeBlockData[");
            stringBuilder.append("\n  SOURCE(" + this.sourceStart + "," + this.sourceEnd + ")");
            stringBuilder.append("=\"");
            try {
                stringBuilder.append(CssModel.this.doc.getText(this.sourceStart, this.sourceEnd - this.sourceStart));
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            stringBuilder.append("\"");
            stringBuilder.append(",\n  CSS(" + this.generatedStart + "," + this.generatedEnd + ")");
            stringBuilder.append("=\"");
            stringBuilder.append(CssModel.this.code.substring(this.generatedStart, this.generatedEnd));
            stringBuilder.append("\"");
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

