/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfpath.platform;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.gsfpath.spi.platform.CustomPlatformInstall;
import org.netbeans.modules.gsfpath.spi.platform.GeneralPlatformInstall;
import org.netbeans.modules.gsfpath.spi.platform.PlatformInstall;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerRegistry {
    static final String INSTALLER_REGISTRY_FOLDER = "org-netbeans-modules-gsfpath-api/platform/installers";
    static Reference<InstallerRegistry> defaultInstance = new WeakReference<Object>(null);
    private Provider provider;
    private List<GeneralPlatformInstall> platformInstalls;

    InstallerRegistry(FileObject fileObject) {
        assert (fileObject != null);
        this.provider = new Provider(fileObject);
    }

    InstallerRegistry(GeneralPlatformInstall[] generalPlatformInstallArray) {
        assert (generalPlatformInstallArray != null);
        this.platformInstalls = Arrays.asList(generalPlatformInstallArray);
    }

    public List<PlatformInstall> getInstallers() {
        return InstallerRegistry.filter(this.getAllInstallers(), PlatformInstall.class);
    }

    public List<CustomPlatformInstall> getCustomInstallers() {
        return InstallerRegistry.filter(this.getAllInstallers(), CustomPlatformInstall.class);
    }

    public List<GeneralPlatformInstall> getAllInstallers() {
        if (this.platformInstalls != null) {
            return this.platformInstalls;
        }
        List list = Collections.emptyList();
        try {
            assert (this.provider != null);
            list = NbCollections.checkedListByCopy((List)((List)this.provider.instanceCreate()), GeneralPlatformInstall.class, (boolean)true);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return list;
    }

    public static InstallerRegistry getDefault() {
        InstallerRegistry installerRegistry = defaultInstance.get();
        if (installerRegistry != null) {
            return installerRegistry;
        }
        installerRegistry = new InstallerRegistry(Repository.getDefault().getDefaultFileSystem().findResource(INSTALLER_REGISTRY_FOLDER));
        defaultInstance = new WeakReference<InstallerRegistry>(installerRegistry);
        return installerRegistry;
    }

    static InstallerRegistry prepareForUnitTest(GeneralPlatformInstall[] generalPlatformInstallArray) {
        InstallerRegistry installerRegistry = new InstallerRegistry(generalPlatformInstallArray);
        defaultInstance = new WeakReference<InstallerRegistry>(installerRegistry);
        return installerRegistry;
    }

    private static <T> List<T> filter(List<?> list, Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        for (Object obj : list) {
            if (!clazz.isInstance(obj)) continue;
            arrayList.add(clazz.cast(obj));
        }
        return arrayList;
    }

    private static class Provider
    extends FolderInstance {
        Provider(FileObject fileObject) {
            super(DataFolder.findFolder((FileObject)fileObject));
        }

        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            ArrayList<Object> arrayList = new ArrayList<Object>(instanceCookieArray.length);
            for (int i = 0; i < instanceCookieArray.length; ++i) {
                InstanceCookie instanceCookie = instanceCookieArray[i];
                Object object = null;
                try {
                    if (instanceCookie instanceof InstanceCookie.Of && !((InstanceCookie.Of)instanceCookie).instanceOf(PlatformInstall.class) && !((InstanceCookie.Of)instanceCookie).instanceOf(CustomPlatformInstall.class)) continue;
                    object = instanceCookie.instanceCreate();
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (object == null) continue;
                arrayList.add(object);
            }
            return arrayList;
        }
    }
}

