/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.bpel.debugger.api.BpelSourcesRegistry;
import org.netbeans.modules.bpel.project.BpelproProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class BpelSourcesRegistryHelper {
    private final BpelproProject myProject;
    private final List<String> myRegisteredSources = new LinkedList<String>();
    private final BpelSourcesRegistry mySourcesRegistry;

    public BpelSourcesRegistryHelper(BpelproProject bpelproProject) {
        this.myProject = bpelproProject;
        this.mySourcesRegistry = (BpelSourcesRegistry)Lookup.getDefault().lookup(BpelSourcesRegistry.class);
    }

    public synchronized void register() {
        if (this.mySourcesRegistry == null) {
            return;
        }
        Sources sources = ProjectUtils.getSources((Project)this.myProject);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("BIZPRO");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            String string;
            File file;
            FileObject fileObject = sourceGroupArray[i].getRootFolder();
            if (fileObject == null || (file = FileUtil.toFile((FileObject)fileObject)) == null || !this.mySourcesRegistry.addSourceRoot(string = file.getPath())) continue;
            this.myRegisteredSources.add(string);
        }
    }

    public synchronized void unregister() {
        if (this.mySourcesRegistry == null) {
            return;
        }
        for (String string : this.myRegisteredSources) {
            this.mySourcesRegistry.removeSourceRoot(string);
        }
        this.myRegisteredSources.clear();
    }
}

