/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.general;

import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebBrowsersOptionsModel
extends DefaultListModel {
    private static final String BROWSERS_FOLDER = "Services/Browsers";
    private static final String BROWSER_TEMPLATE = "Templates/Services/Browsers/ExtWebBrowser.settings";
    private static final String EA_HIDDEN = "hidden";
    private List<WebBrowserDesc> browsersList = new ArrayList<WebBrowserDesc>();
    private Map<Integer, WebBrowserDesc> index2desc = new TreeMap<Integer, WebBrowserDesc>();
    private boolean isAdjusting = false;
    private Object selectedValue = null;

    public WebBrowsersOptionsModel() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(BROWSERS_FOLDER);
        if (fileObject != null) {
            Object object;
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            for (Object object2 : object = dataFolder.getChildren()) {
                InstanceCookie instanceCookie = (InstanceCookie)object2.getCookie(InstanceCookie.class);
                FileObject fileObject2 = object2.getPrimaryFile();
                if (instanceCookie == null || Boolean.TRUE.equals(fileObject2.getAttribute(EA_HIDDEN))) continue;
                WebBrowserDesc webBrowserDesc = new WebBrowserDesc((DataObject)object2);
                this.browsersList.add(webBrowserDesc);
            }
        }
        int n = 0;
        for (WebBrowserDesc webBrowserDesc : this.browsersList) {
            this.addElement(webBrowserDesc.getOrigName());
            this.index2desc.put(n++, webBrowserDesc);
        }
    }

    public void addBrowser() {
        WebBrowserDesc webBrowserDesc = new WebBrowserDesc();
        webBrowserDesc.setChangeStatus(ChangeStatus.ADDED);
        this.browsersList.add(webBrowserDesc);
        this.adjustListItems();
    }

    public void removeBrowser(int n) {
        this.index2desc.get(n).setChangeStatus(ChangeStatus.REMOVED);
        this.adjustListItems();
    }

    private void adjustListItems() {
        this.isAdjusting = true;
        this.removeAllElements();
        this.index2desc.clear();
        int n = 0;
        for (WebBrowserDesc webBrowserDesc : this.browsersList) {
            if (webBrowserDesc.getChangeStatus().equals((Object)ChangeStatus.REMOVED)) continue;
            String string = webBrowserDesc.getNewName();
            if (string != null) {
                this.addElement(string);
            } else {
                this.addElement(webBrowserDesc.getOrigName());
            }
            this.index2desc.put(n++, webBrowserDesc);
        }
        this.isAdjusting = false;
    }

    public boolean isAdjusting() {
        return this.isAdjusting;
    }

    public void updateList() {
        this.adjustListItems();
    }

    public PropertyPanel getPropertyPanel(int n) {
        return this.index2desc.get(n).getPropertyPanel();
    }

    public String getPropertyPanelID(int n) {
        return this.index2desc.get(n).getPropertyPanelID();
    }

    public String getBrowserName(int n) {
        String string = null;
        String string2 = this.index2desc.get(n).getNewName();
        string = string2 != null ? string2 : this.index2desc.get(n).getOrigName();
        return string;
    }

    public void setBrowserName(int n, String string) {
        this.index2desc.get(n).setNewName(string);
    }

    public void setSelectedValue(Object object) {
        this.selectedValue = object;
    }

    public Object getSelectedValue() {
        return this.selectedValue;
    }

    public void applyChanges() {
        for (WebBrowserDesc webBrowserDesc : this.browsersList) {
            webBrowserDesc.applyChanges();
        }
    }

    public void discardChanges() {
        for (WebBrowserDesc webBrowserDesc : this.browsersList) {
            webBrowserDesc.discardChanges();
        }
    }

    public List<PropertyPanelDesc> getPropertyPanels() {
        ArrayList<PropertyPanelDesc> arrayList = new ArrayList<PropertyPanelDesc>();
        Collection<WebBrowserDesc> collection = this.index2desc.values();
        for (WebBrowserDesc webBrowserDesc : collection) {
            arrayList.add(new PropertyPanelDesc(webBrowserDesc.getPropertyPanel(), webBrowserDesc.getPropertyPanelID()));
        }
        return arrayList;
    }

    private static class WebBrowsersPropertyPanel
    extends PropertyPanel {
        private WebBrowsersPropertyPanel(Object object, String string, int n) {
            super(object, string, n);
        }

        public void removeNotify() {
        }
    }

    private static class WebBrowserDesc {
        private String origName = null;
        private String newName = null;
        private ChangeStatus changeStatus = ChangeStatus.NONE;
        private DataObject browserSettings;
        private PropertyPanel propertyPanel = null;
        private String propertyPanelID;
        private static int propertyPanelIDCounter = 0;

        public WebBrowserDesc() {
            this.newName = NbBundle.getBundle(WebBrowsersOptionsModel.class).getString("LBL_ExternalBrowser_Name");
            this.browserSettings = this.createNewBrowserSettings(this.newName);
            this.findPropertyPanel();
        }

        public WebBrowserDesc(DataObject dataObject) {
            this.browserSettings = dataObject;
            this.origName = this.browserSettings.getNodeDelegate().getDisplayName();
            this.findPropertyPanel();
        }

        private void findPropertyPanel() {
            try {
                InstanceCookie instanceCookie = (InstanceCookie)this.browserSettings.getCookie(InstanceCookie.class);
                PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(instanceCookie.instanceClass()).getPropertyDescriptors();
                FeatureDescriptor featureDescriptor = null;
                for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                    if (featureDescriptor == null && !propertyDescriptor.isExpert() && !propertyDescriptor.isHidden()) {
                        featureDescriptor = propertyDescriptor;
                    }
                    if (!propertyDescriptor.isPreferred() || propertyDescriptor.isExpert() || propertyDescriptor.isHidden()) continue;
                    this.propertyPanel = new WebBrowsersPropertyPanel(instanceCookie.instanceCreate(), propertyDescriptor.getName(), 2);
                    this.propertyPanelID = "PROPERTY_PANEL_" + propertyPanelIDCounter++;
                    break;
                }
                if (this.propertyPanel == null) {
                    this.propertyPanel = new WebBrowsersPropertyPanel(instanceCookie.instanceCreate(), featureDescriptor.getName(), 2);
                    this.propertyPanelID = "PROPERTY_PANEL_" + propertyPanelIDCounter++;
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        public PropertyPanel getPropertyPanel() {
            return this.propertyPanel;
        }

        public String getPropertyPanelID() {
            return this.propertyPanelID;
        }

        public String getOrigName() {
            return this.origName;
        }

        public String getNewName() {
            return this.newName;
        }

        public void setNewName(String string) {
            this.newName = string;
        }

        public void setChangeStatus(ChangeStatus changeStatus) {
            this.changeStatus = changeStatus;
        }

        public ChangeStatus getChangeStatus() {
            return this.changeStatus;
        }

        public void applyChanges() {
            this.propertyPanel.updateValue();
            if (this.getChangeStatus() == ChangeStatus.REMOVED && this.browserSettings != null) {
                try {
                    this.browserSettings.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (this.newName != null && !this.newName.equals(this.origName)) {
                try {
                    this.browserSettings.rename(this.newName);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        public void discardChanges() {
            ChangeStatus changeStatus = this.getChangeStatus();
            if (changeStatus == ChangeStatus.ADDED && this.browserSettings != null) {
                try {
                    this.browserSettings.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        private DataObject createNewBrowserSettings(String string) {
            DataObject dataObject = null;
            try {
                FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(WebBrowsersOptionsModel.BROWSER_TEMPLATE);
                FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().findResource(WebBrowsersOptionsModel.BROWSERS_FOLDER);
                if (fileObject == null) {
                    return null;
                }
                DataObject dataObject2 = DataObject.find((FileObject)fileObject);
                DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject2);
                dataObject = dataObject2.createFromTemplate(dataFolder, string);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return dataObject;
        }
    }

    public static class PropertyPanelDesc {
        public PropertyPanel panel;
        public String id;

        public PropertyPanelDesc(PropertyPanel propertyPanel, String string) {
            this.panel = propertyPanel;
            this.id = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ChangeStatus {
        NONE,
        REMOVED,
        ADDED;

    }
}

