/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.warmup;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class MenuWarmUpTask
implements Runnable {
    private Component[] comps;

    public void run() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Frame frame = WindowManager.getDefault().getMainWindow();
                    assert (frame != null);
                    frame.addWindowListener(new NbWindowsAdapter());
                    if (frame instanceof JFrame) {
                        MenuWarmUpTask.access$102(MenuWarmUpTask.this, ((JFrame)frame).getJMenuBar().getComponents());
                    }
                }
            });
        }
        catch (Exception exception) {
            return;
        }
        if (this.comps != null) {
            this.walkMenu(this.comps);
            this.comps = null;
        }
    }

    private void walkMenu(Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenu)) continue;
            try {
                Class<?> clazz = componentArray[i].getClass();
                Method method = clazz.getDeclaredMethod("doInitialize", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)componentArray[i], new Object[0]);
                this.walkMenu(((JMenu)componentArray[i]).getMenuComponents());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Component[] access$102(MenuWarmUpTask menuWarmUpTask, Component[] componentArray) {
        menuWarmUpTask.comps = componentArray;
        return componentArray;
    }

    private static class NbWindowsAdapter
    extends WindowAdapter
    implements Runnable {
        private static final RequestProcessor rp = new RequestProcessor("Refresh-After-WindowActivated");
        private RequestProcessor.Task task = null;

        private NbWindowsAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowActivated(WindowEvent windowEvent) {
            RequestProcessor requestProcessor = rp;
            synchronized (requestProcessor) {
                if (this.task != null) {
                    this.task.cancel();
                } else {
                    this.task = rp.create((Runnable)this);
                }
                this.task.schedule(1500);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowDeactivated(WindowEvent windowEvent) {
            RequestProcessor requestProcessor = rp;
            synchronized (requestProcessor) {
                if (this.task != null) {
                    this.task.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FileUtil.refreshAll();
            RequestProcessor requestProcessor = rp;
            synchronized (requestProcessor) {
                this.task = null;
            }
        }
    }
}

