/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.ReferenceType;
import java.text.MessageFormat;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.debugger.jpda.ui.models.SourcesModel;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class ClassesNodeModel
implements NodeModel {
    private static final String CLASS = "org/netbeans/modules/debugger/jpda/resources/class";
    private static final String INTERFACE = "org/netbeans/modules/debugger/jpda/resources/interface";
    private static final String PACKAGE = "org/netbeans/modules/debugger/jpda/resources/package";
    private static final String FIELD = "org/netbeans/modules/debugger/jpda/resources/field";
    private static final String CLASS_LOADER = "org/netbeans/modules/debugger/jpda/resources/classLoader";
    private Properties classesProperties = Properties.getDefault().getProperties("debugger").getProperties("classesView");

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle(ClassesNodeModel.class).getString("CTL_ClassesModel_Column_Name_Name");
        }
        if (object instanceof Object[]) {
            int n;
            String string = (String)((Object[])object)[0];
            boolean bl = this.classesProperties.getBoolean("flat", true);
            if (!bl && (n = string.lastIndexOf(46)) >= 0) {
                string = string.substring(n + 1);
            }
            return string;
        }
        if (object instanceof ReferenceType) {
            String string = ((ReferenceType)object).name();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            if ((n = string.lastIndexOf(36)) >= 0) {
                string = string.substring(n + 1);
            }
            return string;
        }
        if (object instanceof ClassLoaderReference) {
            String string = ((ClassLoaderReference)object).referenceType().name();
            if (string.endsWith("AppClassLoader")) {
                return NbBundle.getBundle(ClassesNodeModel.class).getString("CTL_ClassesModel_Column_Name_AppClassLoader");
            }
            return MessageFormat.format(NbBundle.getBundle(ClassesNodeModel.class).getString("CTL_ClassesModel_Column_Name_ClassLoader"), string);
        }
        if (object instanceof Integer) {
            return NbBundle.getBundle(ClassesNodeModel.class).getString("CTL_ClassesModel_Column_Name_SystemClassLoader");
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle(ClassesNodeModel.class).getString("CTL_ClassesModel_Column_Name_Desc");
        }
        if (object instanceof Object[]) {
            return MessageFormat.format(NbBundle.getBundle(ClassesNodeModel.class).getString("CTL_ClassesModel_Column_Name_Package"), (Object[])object);
        }
        if (object instanceof ReferenceType) {
            String string = object instanceof ClassType ? NbBundle.getBundle(ClassesNodeModel.class).getString("CTL_ClassesModel_Column_Name_Class") : NbBundle.getBundle(ClassesNodeModel.class).getString("CTL_ClassesModel_Column_Name_Interface");
            String string2 = MessageFormat.format(string, ((ReferenceType)object).name());
            ClassLoaderReference classLoaderReference = ((ReferenceType)object).classLoader();
            if (classLoaderReference != null) {
                string2 = string2 + " " + MessageFormat.format(NbBundle.getBundle(ClassesNodeModel.class).getString("CTL_ClassesModel_Column_Name_LoadedBy"), classLoaderReference.referenceType().name());
            }
            return string2;
        }
        if (object instanceof ClassLoaderReference) {
            return null;
        }
        if (object instanceof Integer) {
            return null;
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return CLASS;
        }
        if (object instanceof Object[]) {
            return PACKAGE;
        }
        if (object instanceof ClassType) {
            return CLASS;
        }
        if (object instanceof InterfaceType) {
            return INTERFACE;
        }
        if (object instanceof ClassLoaderReference) {
            return CLASS_LOADER;
        }
        if (object instanceof Integer) {
            return CLASS_LOADER;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    public static class DefaultClassesColumn
    extends SourcesModel.AbstractColumn {
        public String getID() {
            return "DefaultClassesColumn";
        }

        public String getDisplayName() {
            return NbBundle.getBundle(DefaultClassesColumn.class).getString("CTL_ClassesModel_Column_Name_Name");
        }

        public Character getDisplayedMnemonic() {
            return new Character(NbBundle.getBundle(DefaultClassesColumn.class).getString("CTL_ClassesModel_Column_Name_Mnc").charAt(0));
        }

        public String getShortDescription() {
            return NbBundle.getBundle(DefaultClassesColumn.class).getString("CTL_ClassesModel_Column_Name_Desc");
        }

        public Class getType() {
            return null;
        }
    }
}

