/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.HashSet;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.spi.debugger.jpda.VariablesFilterAdapter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;

public class JavaVariablesFilter
extends VariablesFilterAdapter {
    private static HashSet getValueType;
    private static HashSet leafType;
    private static HashSet toStringValueType;
    private static HashSet mapEntryType;
    private static HashSet mapMapType;
    private static HashSet toArrayType;

    public String[] getSupportedTypes() {
        return new String[]{"java.lang.String", "java.lang.StringBuffer", "java.lang.Character", "java.lang.Integer", "java.lang.Float", "java.lang.Byte", "java.lang.Boolean", "java.lang.Double", "java.lang.Long", "java.lang.Short", "java.lang.ref.WeakReference", "java.util.ArrayList", "java.util.HashSet", "java.util.LinkedHashSet", "java.util.LinkedList", "java.util.Stack", "java.util.TreeSet", "java.util.Vector", "java.util.Hashtable", "java.util.Hashtable$Entry", "java.util.HashMap", "java.util.HashMap$Entry", "java.util.IdentityHashMap", "java.util.AbstractMap$SimpleEntry", "java.util.TreeMap", "java.util.TreeMap$Entry", "java.util.WeakHashMap", "java.util.LinkedHashMap", "java.util.LinkedHashMap$Entry", "java.beans.PropertyChangeSupport"};
    }

    public String[] getSupportedAncestors() {
        return new String[0];
    }

    public Object[] getChildren(TreeModel treeModel, Variable variable, int n, int n2) throws UnknownTypeException {
        ObjectVariable objectVariable;
        String string = variable.getType();
        if (JavaVariablesFilter.isToArrayType(string)) {
            objectVariable = (ObjectVariable)variable;
            try {
                objectVariable = (ObjectVariable)objectVariable.invokeMethod("toArray", "()[Ljava/lang/Object;", new Variable[0]);
                if (objectVariable == null) {
                    return new Object[0];
                }
                return treeModel.getChildren((Object)objectVariable, n, n2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Field field = objectVariable.getField("elementData");
                if (field != null) {
                    return treeModel.getChildren((Object)field, n, n2);
                }
                ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                Logger.getLogger(JavaVariablesFilter.class.getName()).fine("invokeMethod(toArray) " + invalidExpressionException.getLocalizedMessage());
                return treeModel.getChildren((Object)variable, n, n2);
            }
        }
        if (JavaVariablesFilter.isMapMapType(string)) {
            try {
                objectVariable = (ObjectVariable)variable;
                objectVariable = (ObjectVariable)objectVariable.invokeMethod("entrySet", "()Ljava/util/Set;", new Variable[0]);
                if (objectVariable == null) {
                    return new Object[0];
                }
                if ((objectVariable = (ObjectVariable)objectVariable.invokeMethod("toArray", "()[Ljava/lang/Object;", new Variable[0])) == null) {
                    return new Object[0];
                }
                return treeModel.getChildren((Object)objectVariable, n, n2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                Logger.getLogger(JavaVariablesFilter.class.getName()).fine("invokeMethod(entrySet) " + invalidExpressionException.getLocalizedMessage());
                return treeModel.getChildren((Object)variable, n, n2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
            }
        }
        if (JavaVariablesFilter.isMapEntryType(string)) {
            objectVariable = (ObjectVariable)variable;
            Object[] objectArray = new Field[]{objectVariable.getField("key"), objectVariable.getField("value")};
            return objectArray;
        }
        if ("java.beans.PropertyChangeSupport".equals(string)) {
            try {
                objectVariable = (ObjectVariable)variable;
                return ((ObjectVariable)objectVariable.invokeMethod("getPropertyChangeListeners", "()[Ljava/beans/PropertyChangeListener;", new Variable[0])).getFields(n, n2);
            }
            catch (InvalidExpressionException invalidExpressionException) {
                Logger.getLogger(JavaVariablesFilter.class.getName()).fine("invokeMethod(getPropertyChangeListeners) " + invalidExpressionException.getLocalizedMessage());
                return treeModel.getChildren((Object)variable, n, n2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ErrorManager.getDefault().notify((Throwable)noSuchMethodException);
            }
        }
        if ("java.lang.ref.WeakReference".equals(string)) {
            objectVariable = (ObjectVariable)variable;
            return new Object[]{objectVariable.getField("referent")};
        }
        return treeModel.getChildren((Object)variable, n, n2);
    }

    public int getChildrenCount(TreeModel treeModel, Variable variable) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public boolean isLeaf(TreeModel treeModel, Variable variable) throws UnknownTypeException {
        String string = variable.getType();
        if (JavaVariablesFilter.isLeafType(string)) {
            return true;
        }
        return treeModel.isLeaf((Object)variable);
    }

    public Object getValueAt(TableModel tableModel, Variable variable, String string) throws UnknownTypeException {
        if (!(variable instanceof ObjectVariable)) {
            return tableModel.getValueAt((Object)variable, string);
        }
        String string2 = variable.getType();
        ObjectVariable objectVariable = (ObjectVariable)variable;
        if (JavaVariablesFilter.isMapEntryType(string2) && (string == "LocalsValue" || string == "WatchValue")) {
            return objectVariable.getField("key").getValue() + "=>" + objectVariable.getField("value").getValue();
        }
        if (JavaVariablesFilter.isGetValueType(string2) && (string == "LocalsValue" || string == "WatchValue")) {
            return objectVariable.getField("value").getValue();
        }
        if (JavaVariablesFilter.isToStringValueType(string2) && (string == "LocalsValue" || string == "WatchValue")) {
            try {
                return "\"" + objectVariable.getToStringValue() + "\"";
            }
            catch (InvalidExpressionException invalidExpressionException) {
                Logger.getLogger(JavaVariablesFilter.class.getName()).fine("getToStringValue() " + invalidExpressionException.getLocalizedMessage());
                if (invalidExpressionException.getTargetException() != null && invalidExpressionException.getTargetException() instanceof UnsupportedOperationException) {
                    return tableModel.getValueAt((Object)variable, string);
                }
                return invalidExpressionException.getLocalizedMessage();
            }
        }
        return tableModel.getValueAt((Object)variable, string);
    }

    public void setValueAt(TableModel tableModel, Variable variable, String string, Object object) throws UnknownTypeException {
        String string2;
        String string3 = variable.getType();
        if (JavaVariablesFilter.isToStringValueType(string3) && (string == "LocalsValue" || string == "WatchValue") && (string2 = (String)object).startsWith("\"") && string2.endsWith("\"") && string2.length() > 1) {
            string2 = "new " + string3 + "(\"" + JavaVariablesFilter.convertToStringInitializer(string2.substring(1, string2.length() - 1)) + "\")";
            tableModel.setValueAt((Object)variable, string, (Object)string2);
            return;
        }
        tableModel.setValueAt((Object)variable, string, object);
    }

    private static String convertToStringInitializer(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block9: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block9;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    private static boolean isGetValueType(String string) {
        if (getValueType == null) {
            getValueType = new HashSet();
            getValueType.add("java.lang.Character");
            getValueType.add("java.lang.Integer");
            getValueType.add("java.lang.Float");
            getValueType.add("java.lang.Byte");
            getValueType.add("java.lang.Boolean");
            getValueType.add("java.lang.Double");
            getValueType.add("java.lang.Long");
            getValueType.add("java.lang.Short");
        }
        return getValueType.contains(string);
    }

    private static boolean isLeafType(String string) {
        if (leafType == null) {
            leafType = new HashSet();
            leafType.add("java.lang.String");
            leafType.add("java.lang.Character");
            leafType.add("java.lang.Integer");
            leafType.add("java.lang.Float");
            leafType.add("java.lang.Byte");
            leafType.add("java.lang.Boolean");
            leafType.add("java.lang.Double");
            leafType.add("java.lang.Long");
            leafType.add("java.lang.Short");
        }
        return leafType.contains(string);
    }

    private static boolean isToStringValueType(String string) {
        if (toStringValueType == null) {
            toStringValueType = new HashSet();
            toStringValueType.add("java.lang.StringBuffer");
        }
        return toStringValueType.contains(string);
    }

    private static boolean isMapEntryType(String string) {
        if (mapEntryType == null) {
            mapEntryType = new HashSet();
            mapEntryType.add("java.util.HashMap$Entry");
            mapEntryType.add("java.util.Hashtable$Entry");
            mapEntryType.add("java.util.AbstractMap$SimpleEntry");
            mapEntryType.add("java.util.LinkedHashMap$Entry");
            mapEntryType.add("java.util.TreeMap$Entry");
        }
        return mapEntryType.contains(string);
    }

    private static boolean isMapMapType(String string) {
        if (mapMapType == null) {
            mapMapType = new HashSet();
            mapMapType.add("java.util.HashMap");
            mapMapType.add("java.util.IdentityHashMap");
            mapMapType.add("java.util.Hashtable");
            mapMapType.add("java.util.TreeMap");
            mapMapType.add("java.util.WeakHashMap");
            mapMapType.add("java.util.LinkedHashMap");
            mapMapType.add("java.util.concurrent.ConcurrentHashMap");
            mapMapType.add("java.util.EnumMap");
        }
        return mapMapType.contains(string);
    }

    private static boolean isToArrayType(String string) {
        if (toArrayType == null) {
            toArrayType = new HashSet();
            toArrayType.add("java.util.ArrayList");
            toArrayType.add("java.util.HashSet");
            toArrayType.add("java.util.LinkedHashSet");
            toArrayType.add("java.util.LinkedList");
            toArrayType.add("java.util.Stack");
            toArrayType.add("java.util.TreeSet");
            toArrayType.add("java.util.Vector");
            toArrayType.add("java.util.concurrent.CopyOnWriteArraySet");
            toArrayType.add("java.util.EnumSet");
        }
        return toArrayType.contains(string);
    }
}

