/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.deployment;

import java.io.File;
import java.util.Collection;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.deployment.MobilityDeploymentProperties;
import org.netbeans.spi.mobility.deployment.DeploymentPlugin;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentPropertiesHandler {
    public static void loadDeploymentProperties(final Collection<Lookup.Result> collection) {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() throws Exception {
                    MobilityDeploymentProperties mobilityDeploymentProperties = new MobilityDeploymentProperties();
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    for (DeploymentPlugin deploymentPlugin : collection) {
                        String string = deploymentPlugin.getDeploymentMethodName();
                        String string2 = deploymentPlugin.getAntScriptLocation();
                        if (string2 != null) {
                            File file = new File(string2);
                            if (!file.isFile()) {
                                file = InstalledFileLocator.getDefault().locate(string2, null, false);
                            }
                            if (string != null && file != null && Utilities.isJavaIdentifier((String)string)) {
                                editableProperties.setProperty("deployment." + string + ".scriptfile", file.getAbsolutePath());
                            }
                        }
                        if (mobilityDeploymentProperties.getInstanceList(string).contains("default")) continue;
                        mobilityDeploymentProperties.createInstance(string, "default");
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)mutexException.getException());
        }
    }
}

