/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.modules.mobility.project.GlobalAbilitiesCache;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ui.customizer.AddAbilityPanel;
import org.netbeans.modules.mobility.project.ui.customizer.AddAttributePanel;
import org.netbeans.modules.mobility.project.ui.customizer.CustomizerAbilities;
import org.netbeans.spi.navigator.NavigatorLookupHint;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AbilitiesPanel
implements NavigatorPanel {
    private static ABPanel instance = null;
    static ABHint hintInstance = new ABHint();
    private static String MULTIPLE_VALUES = NbBundle.getMessage(AbilitiesPanel.class, (String)"LBL_MultipleValues");
    private static String REMOVE = NbBundle.getMessage(AbilitiesPanel.class, (String)"LBL_RemoveAbility");
    private static String ADD = NbBundle.getMessage(AbilitiesPanel.class, (String)"LBL_AddAbility");
    private static String COPY = NbBundle.getMessage(AbilitiesPanel.class, (String)"LBL_CopyAbility");
    private static String PASTE = NbBundle.getMessage(AbilitiesPanel.class, (String)"LBL_PasteAbility");

    public synchronized JComponent getComponent() {
        return ABPanel.getInstance();
    }

    public String getDisplayName() {
        String string = "";
        if (ABPanel.selectedNodes != null) {
            string = ABPanel.selectedNodes.length == 1 ? " : " + ((ProjectConfiguration)ABPanel.selectedNodes[0].getLookup().lookup(ProjectConfiguration.class)).getDisplayName() : " : " + NbBundle.getMessage(AbilitiesPanel.class, (String)"LBL_MultipleConfigs");
        }
        return "Abilities" + string;
    }

    public String getDisplayHint() {
        return "Abilities";
    }

    public synchronized void panelActivated(Lookup lookup) {
    }

    public synchronized void panelDeactivated() {
    }

    public Lookup getLookup() {
        return null;
    }

    static class EditableTableModel
    extends CustomizerAbilities.StorableTableModel {
        private boolean editable = true;

        EditableTableModel() {
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 && this.editable;
        }

        void setEditable(boolean bl) {
            this.editable = bl;
        }

        void removeListeners() {
            Object[] objectArray;
            for (Object object : objectArray = this.listenerList.getListenerList()) {
                if (!(object instanceof TableModelListener) || object instanceof JTable) continue;
                this.listenerList.remove(TableModelListener.class, (TableModelListener)object);
            }
        }
    }

    static class ABPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private static JScrollPane scrollPane;
        private static final EditableTableModel tableModel;
        private static final JTable table;
        private static final Object[] emptyTable;
        private static J2MEProject project;
        private static Node[] selectedNodes;
        private static Node defaultConfig;
        private static Action[] actions;
        private static ExplorerManager manager;
        private static HashMap<String, String> copiedAbilities;

        static void addAbility(EditableProperties editableProperties, AntProjectHelper antProjectHelper, String string, String string2) {
            if (defaultConfig != null) {
                String object = editableProperties.getProperty("abilities");
                Map map = CommentingPreProcessor.decodeAbilitiesMap((String)object);
                if (!map.containsKey(string)) {
                    map.put(string, string2);
                    String string3 = CommentingPreProcessor.encodeAbilitiesMap((Map)map);
                    editableProperties.put("abilities", string3);
                    antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                } else {
                    ErrorManager.getDefault().log(16, "Ability " + string + " already exist in the configuration " + "DefaultConfiguration" + ". Its value will not be modified");
                }
            }
            for (Node node : selectedNodes) {
                if (node == defaultConfig) continue;
                ProjectConfiguration projectConfiguration = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class);
                String string4 = editableProperties.getProperty("configs." + projectConfiguration.getDisplayName() + "." + "abilities");
                if (string4 == null) {
                    string4 = editableProperties.getProperty("abilities");
                }
                Map map = CommentingPreProcessor.decodeAbilitiesMap((String)string4);
                String string5 = (String)map.get(string);
                if (!map.containsKey(string)) {
                    map.put(string, string2);
                    string4 = CommentingPreProcessor.encodeAbilitiesMap((Map)map);
                    editableProperties.put("configs." + projectConfiguration.getDisplayName() + "." + "abilities", string4);
                    continue;
                }
                ErrorManager.getDefault().log(16, "Ability " + string + " already exist in the configuration " + projectConfiguration.getDisplayName() + ". Its value will not be modified");
            }
            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        }

        private ABPanel() {
            this.initComponents();
            scrollPane.setViewportView(table);
            table.setSelectionMode(1);
            final TableCellEditor tableCellEditor = table.getDefaultEditor(String.class);
            final JPopupMenu jPopupMenu = new JPopupMenu();
            for (Action action : actions) {
                jPopupMenu.add(action);
            }
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    this.showPopup(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    this.showPopup(mouseEvent);
                }

                private void showPopup(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        int n = table.rowAtPoint(mouseEvent.getPoint());
                        int[] nArray = table.getSelectedRows();
                        if (n >= 0 && (nArray.length >= 2 && (n < nArray[0] || n > nArray[nArray.length - 1]) || nArray.length < 2)) {
                            table.setRowSelectionInterval(n, n);
                        }
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            };
            scrollPane.addMouseListener(mouseAdapter);
            table.addMouseListener(mouseAdapter);
            tableCellEditor.addCellEditorListener(new CellEditorListener(){

                public void editingStopped(ChangeEvent changeEvent) {
                    String string;
                    int n = table.getSelectedRow();
                    int n2 = table.getSelectedColumn();
                    if (n < 0 || n2 < 0) {
                        return;
                    }
                    final String string2 = tableModel.getValueAt(n, 0);
                    String string3 = tableModel.getValueAt(n, 1);
                    if (!string3.equals(string = (String)tableCellEditor.getCellEditorValue())) {
                        tableModel.editRow(string2, string);
                        ProjectManager.mutex().writeAccess(new Runnable(){

                            public void run() {
                                AntProjectHelper antProjectHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
                                EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                                if (defaultConfig != null) {
                                    String object = editableProperties.getProperty("abilities");
                                    Map map = CommentingPreProcessor.decodeAbilitiesMap((String)object);
                                    map.put(string2, string);
                                    String exception = CommentingPreProcessor.encodeAbilitiesMap((Map)map);
                                    editableProperties.put("abilities", exception);
                                    antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                                }
                                for (Node node : selectedNodes) {
                                    Map map;
                                    String string3;
                                    if (node == defaultConfig) continue;
                                    ProjectConfiguration projectConfiguration = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class);
                                    String string22 = editableProperties.getProperty("configs." + projectConfiguration.getDisplayName() + "." + "abilities");
                                    if (string22 == null) {
                                        string22 = editableProperties.getProperty("abilities");
                                    }
                                    if (((string3 = (String)(map = CommentingPreProcessor.decodeAbilitiesMap((String)string22)).get(string2)) != null || string == null) && string3.equals(string)) continue;
                                    map.put(string2, string);
                                    string22 = CommentingPreProcessor.encodeAbilitiesMap((Map)map);
                                    editableProperties.put("configs." + projectConfiguration.getDisplayName() + "." + "abilities", string22);
                                }
                                antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                                try {
                                    ProjectManager.getDefault().saveProject((Project)project);
                                }
                                catch (Exception exception) {
                                    ErrorManager.getDefault().notify((Throwable)exception);
                                }
                            }
                        });
                    }
                }

                public void editingCanceled(ChangeEvent changeEvent) {
                }
            });
        }

        public Action[] getActions() {
            return actions;
        }

        public static void setAbilities(Node[] nodeArray) {
            HashSet hashSet = new HashSet();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            J2MEProject j2MEProject = null;
            boolean bl = false;
            defaultConfig = null;
            for (Node node : nodeArray) {
                AntProjectHelper antProjectHelper;
                EditableProperties editableProperties;
                String string;
                ABHint aBHint;
                Lookup lookup = node.getLookup();
                if (lookup == null || (aBHint = (ABHint)lookup.lookup(ABHint.class)) == null) continue;
                tableModel.removeListeners();
                Node node2 = (Node)lookup.lookup(Node.class);
                project = (J2MEProject)node2.getLookup().lookup(J2MEProject.class);
                ProjectConfiguration projectConfiguration = (ProjectConfiguration)node2.getLookup().lookup(ProjectConfiguration.class);
                assert (project != null);
                if (projectConfiguration.getDisplayName().equals("DefaultConfiguration")) {
                    defaultConfig = node;
                }
                if ((string = (editableProperties = (antProjectHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class)).getProperties("nbproject/project.properties")).getProperty("configs." + projectConfiguration.getDisplayName() + "." + "abilities")) == null) {
                    string = editableProperties.getProperty("abilities");
                }
                Map map = CommentingPreProcessor.decodeAbilitiesMap((String)string);
                if (bl) {
                    if (j2MEProject != project) {
                        defaultConfig = null;
                        tableModel.setDataDelegates(emptyTable);
                        return;
                    }
                    hashSet.retainAll(map.keySet());
                    for (String string2 : hashSet) {
                        if (hashMap.containsKey(string2)) {
                            String string3 = (String)hashMap.get(string2);
                            String string4 = (String)map.get(string2);
                            if ((string3 == null || string3.equals(string4)) && (string3 != null || string4 == null)) continue;
                            hashMap.put(string2, MULTIPLE_VALUES);
                            continue;
                        }
                        hashMap.put(string2, (String)map.get(string2));
                    }
                    continue;
                }
                j2MEProject = project;
                bl = true;
                hashSet.addAll(map.keySet());
                hashMap.putAll(map);
            }
            hashMap.keySet().retainAll(hashSet);
            tableModel.setEditable(true);
            table.setBackground(UIManager.getDefaults().getColor("Table.background"));
            tableModel.setDataDelegates(new Object[]{hashMap});
            selectedNodes = nodeArray;
        }

        private void initComponents() {
            scrollPane = new JScrollPane();
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridheight = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            this.add((Component)scrollPane, gridBagConstraints);
        }

        private static JComponent getInstance() {
            if (instance == null) {
                instance = new ABPanel();
            }
            return instance;
        }

        public ExplorerManager getExplorerManager() {
            return manager;
        }

        static {
            tableModel = new EditableTableModel();
            table = new JTable(tableModel);
            emptyTable = new Object[]{new HashMap()};
            project = null;
            selectedNodes = null;
            defaultConfig = null;
            actions = new Action[]{new AddAction(), new RemoveAction(), new CopyAction(), new PasteAction()};
            manager = new ExplorerManager();
            copiedAbilities = new HashMap();
            actions[3].setEnabled(false);
        }

        private static class RemoveAction
        extends AbstractAction {
            private RemoveAction() {
                this.putValue("Name", REMOVE);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                final int[] nArray = table.getSelectedRows();
                if (project == null) {
                    return;
                }
                ProjectManager.mutex().writeAccess(new Runnable(){

                    public void run() {
                        for (int n : nArray) {
                            String string = tableModel.getValueAt(nArray[0], 0);
                            tableModel.removeRow(nArray[0]);
                            AntProjectHelper antProjectHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
                            EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                            if (defaultConfig != null) {
                                String string2 = editableProperties.getProperty("abilities");
                                Map map = CommentingPreProcessor.decodeAbilitiesMap((String)string2);
                                map.remove(string);
                                String string3 = CommentingPreProcessor.encodeAbilitiesMap((Map)map);
                                editableProperties.put("abilities", string3);
                                antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                            }
                            for (Node node : selectedNodes) {
                                Map map;
                                if (node == defaultConfig) continue;
                                ProjectConfiguration projectConfiguration = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class);
                                String string4 = editableProperties.getProperty("configs." + projectConfiguration.getDisplayName() + "." + "abilities");
                                if (string4 == null) {
                                    string4 = editableProperties.getProperty("abilities");
                                }
                                if (!(map = CommentingPreProcessor.decodeAbilitiesMap((String)string4)).containsKey(string)) continue;
                                map.remove(string);
                                string4 = CommentingPreProcessor.encodeAbilitiesMap((Map)map);
                                editableProperties.put("configs." + projectConfiguration.getDisplayName() + "." + "abilities", string4);
                            }
                            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                        }
                        try {
                            ProjectManager.getDefault().saveProject((Project)project);
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify((Throwable)exception);
                        }
                    }
                });
            }
        }

        private static class AddAction
        extends AbstractAction {
            private AddAction() {
                this.putValue("Name", ADD);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                final AddAbilityPanel addAbilityPanel = new AddAbilityPanel();
                HashSet<String> hashSet = new HashSet<String>();
                final AntProjectHelper antProjectHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
                final EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                for (Node node : selectedNodes) {
                    ProjectConfiguration projectConfiguration = (ProjectConfiguration)node.getLookup().lookup(ProjectConfiguration.class);
                    String string = editableProperties.getProperty("configs." + projectConfiguration.getDisplayName() + "." + "abilities");
                    if (string == null) {
                        string = editableProperties.getProperty("abilities");
                    }
                    Map map = CommentingPreProcessor.decodeAbilitiesMap((String)string);
                    hashSet.addAll(map.keySet());
                }
                Vector<String> vector = new Vector<String>(GlobalAbilitiesCache.getDefault().getAllAbilities());
                vector.removeAll(hashSet);
                addAbilityPanel.init(false, vector, hashSet, null, null);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addAbilityPanel, NbBundle.getMessage(CustomizerAbilities.class, (String)"TITLE_AddAbility"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(AddAttributePanel.class), new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (NotifyDescriptor.OK_OPTION.equals(actionEvent.getSource())) {
                            final String string = addAbilityPanel.getKey();
                            final String string2 = addAbilityPanel.getValue();
                            GlobalAbilitiesCache.getDefault().addAbility(string);
                            int n = tableModel.addRow(string, string2);
                            table.getSelectionModel().setSelectionInterval(n, n);
                            ProjectManager.mutex().writeAccess(new Runnable(){

                                public void run() {
                                    ABPanel.addAbility(editableProperties, antProjectHelper, string, string2);
                                    try {
                                        ProjectManager.getDefault().saveProject((Project)project);
                                    }
                                    catch (Exception exception) {
                                        ErrorManager.getDefault().notify((Throwable)exception);
                                    }
                                }
                            });
                        }
                    }
                });
                addAbilityPanel.setDialogDescriptor(dialogDescriptor);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
            }
        }

        private static class PasteAction
        extends AbstractAction {
            private PasteAction() {
                this.putValue("Name", PASTE);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl V"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectManager.mutex().writeAccess(new Runnable(){

                    public void run() {
                        AntProjectHelper antProjectHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
                        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                        for (Map.Entry entry : copiedAbilities.entrySet()) {
                            String string = (String)entry.getValue();
                            if (MULTIPLE_VALUES.equals(string)) {
                                string = "";
                            }
                            ABPanel.addAbility(editableProperties, antProjectHelper, (String)entry.getKey(), string);
                            tableModel.addRow((String)entry.getKey(), string);
                        }
                        try {
                            ProjectManager.getDefault().saveProject((Project)project);
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify((Throwable)exception);
                        }
                    }
                });
            }
        }

        private static class CopyAction
        extends AbstractAction {
            private CopyAction() {
                this.putValue("Name", COPY);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl C"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = table.getSelectedRows();
                copiedAbilities = new HashMap(nArray.length);
                for (int n : nArray) {
                    String string = tableModel.getValueAt(n, 0);
                    String string2 = tableModel.getValueAt(n, 1);
                    copiedAbilities.put(string, string2);
                }
                actions[3].setEnabled(true);
            }
        }
    }

    static class ABHint
    implements NavigatorLookupHint {
        static String hint = "j2me/abilities";

        ABHint() {
        }

        public String getContentType() {
            return hint;
        }
    }
}

