/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.ui.LibResViewProvider;
import org.netbeans.modules.mobility.project.ui.NodeCache;
import org.netbeans.modules.mobility.project.ui.ResViewProvider;
import org.netbeans.modules.mobility.project.ui.SourcesViewProvider;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.XMLUtil;

public class J2MEPhysicalViewProvider
implements LogicalViewProvider {
    protected final ReferenceHelper refHelper;
    protected final ProjectConfigurationsHelper pcp;
    protected final AntProjectHelper helper;
    protected final J2MEProject project;
    J2MEProjectRootNode rootNode;

    public J2MEPhysicalViewProvider(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, ProjectConfigurationsHelper projectConfigurationsHelper) {
        this.project = (J2MEProject)project;
        assert (project != null);
        this.helper = antProjectHelper;
        assert (antProjectHelper != null);
        this.refHelper = referenceHelper;
        assert (referenceHelper != null);
        this.pcp = projectConfigurationsHelper;
        assert (projectConfigurationsHelper != null);
    }

    public Node createLogicalView() {
        try {
            this.rootNode = new J2MEProjectRootNode();
            return this.rootNode;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return Node.EMPTY;
        }
    }

    public Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!project.equals(project2)) {
                return null;
            }
            for (Node node2 : node.getChildren().getNodes(true)) {
                Node node3 = PackageView.findPath((Node)node2, (Object)object);
                if (node3 == null) continue;
                return node3;
            }
        }
        return null;
    }

    protected String[] getBreakableProperties() {
        ProjectConfiguration[] projectConfigurationArray = this.pcp.getConfigurations().toArray(new ProjectConfiguration[0]);
        String[] stringArray = new String[2 * projectConfigurationArray.length + 1];
        stringArray[0] = "src.dir";
        for (int i = 0; i < projectConfigurationArray.length; ++i) {
            if (this.pcp.getDefaultConfiguration().equals(projectConfigurationArray[i])) {
                stringArray[2 * i + 1] = "libs.classpath";
                stringArray[2 * i + 2] = "sign.keystore";
                continue;
            }
            stringArray[2 * i + 1] = "configs." + projectConfigurationArray[i].getDisplayName() + "." + "libs.classpath";
            stringArray[2 * i + 2] = "configs." + projectConfigurationArray[i].getDisplayName() + "." + "sign.keystore";
        }
        return stringArray;
    }

    protected String[] getBreakablePlatformProperties() {
        ProjectConfiguration[] projectConfigurationArray = this.pcp.getConfigurations().toArray(new ProjectConfiguration[0]);
        String[] stringArray = new String[projectConfigurationArray.length];
        for (int i = 0; i < projectConfigurationArray.length; ++i) {
            stringArray[i] = this.pcp.getDefaultConfiguration().equals(projectConfigurationArray[i]) ? "platform.active" : "configs." + projectConfigurationArray[i].getDisplayName() + "." + "platform.active";
        }
        return stringArray;
    }

    public void refreshNode(String string) {
        if (this.rootNode != null) {
            LogicalViewChildren logicalViewChildren = (LogicalViewChildren)this.rootNode.getChildren();
            logicalViewChildren.refreshNode(string);
            this.rootNode.checkBroken();
        }
    }

    public boolean hasBrokenLinks() {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)this.helper, (ReferenceHelper)this.refHelper, (String[])this.getBreakableProperties(), (String[])this.getBreakablePlatformProperties());
    }

    private class RefreshPackagesAction
    extends AbstractAction {
        public RefreshPackagesAction() {
            super(NbBundle.getMessage(J2MEPhysicalViewProvider.class, (String)"LAB_RefreshFolders"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.refreshRecursivelly(J2MEPhysicalViewProvider.this.helper.resolveFileObject(J2MEPhysicalViewProvider.this.helper.getStandardPropertyEvaluator().getProperty("src.dir")));
        }

        private void refreshRecursivelly(FileObject fileObject) {
            if (fileObject == null) {
                return;
            }
            fileObject.refresh();
            Enumeration enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                this.refreshRecursivelly((FileObject)enumeration.nextElement());
            }
        }
    }

    final class J2MEProjectRootNode
    extends AbstractNode
    implements AntProjectListener,
    PropertyChangeListener,
    FileStatusListener,
    Runnable {
        private Action[] actions;
        private Action[] actionsBroken;
        boolean broken;
        Image icon;
        final RequestProcessor.Task nodeUpdateTask;
        PropertyChangeListener ref1;
        PropertyChangeListener ref3;
        FileStatusListener ref2;

        public J2MEProjectRootNode() {
            super((Children)new LogicalViewChildren(J2MEPhysicalViewProvider.this.project), Lookups.singleton((Object)J2MEPhysicalViewProvider.this.project));
            this.broken = J2MEPhysicalViewProvider.this.hasBrokenLinks();
            this.nodeUpdateTask = RequestProcessor.getDefault().create((Runnable)this);
            this.setName(ProjectUtils.getInformation((Project)J2MEPhysicalViewProvider.this.project).getDisplayName());
            J2MEPhysicalViewProvider.this.helper.addAntProjectListener((AntProjectListener)this);
            this.ref1 = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)JavaPlatformManager.getDefault());
            this.ref3 = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)LibraryManager.getDefault());
            LibraryManager.getDefault().addPropertyChangeListener(this.ref3);
            JavaPlatformManager.getDefault().addPropertyChangeListener(this.ref1);
            try {
                FileSystem fileSystem = J2MEPhysicalViewProvider.this.helper.getProjectDirectory().getFileSystem();
                this.ref2 = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileSystem);
                fileSystem.addFileStatusListener(this.ref2);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }

        protected boolean testSourceRoot() {
            return J2MEPhysicalViewProvider.this.helper.resolveFileObject(J2MEPhysicalViewProvider.this.helper.getStandardPropertyEvaluator().getProperty("src.dir")) != null;
        }

        protected void checkBroken() {
            this.nodeUpdateTask.schedule(50);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = J2MEPhysicalViewProvider.this.hasBrokenLinks();
            boolean bl2 = false;
            J2MEProjectRootNode j2MEProjectRootNode = this;
            synchronized (j2MEProjectRootNode) {
                if (this.broken != bl) {
                    this.broken ^= true;
                    bl2 = true;
                }
            }
            if (bl2) {
                this.icon = this.createIcon();
            }
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        protected boolean isBroken() {
            return J2MEPhysicalViewProvider.this.hasBrokenLinks();
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        protected Image createIcon() {
            Image image = Utilities.loadImage((String)"org/netbeans/modules/mobility/project/ui/resources/mobile-project.png", (boolean)true);
            return this.broken ? Utilities.mergeImages((Image)image, (Image)Utilities.loadImage((String)"org/netbeans/modules/mobility/project/ui/resources/brokenProjectBadge.gif"), (int)8, (int)0) : image;
        }

        public Image getIcon(int n) {
            Sources sources;
            if (this.icon == null) {
                this.icon = this.createIcon();
            }
            if ((sources = ProjectUtils.getSources((Project)J2MEPhysicalViewProvider.this.project)) != null) {
                HashSet<FileObject> hashSet = new HashSet<FileObject>();
                for (SourceGroup sourceGroup : sources.getSourceGroups("generic")) {
                    hashSet.add(sourceGroup.getRootFolder());
                }
                try {
                    FileSystem.Status status = J2MEPhysicalViewProvider.this.helper.getProjectDirectory().getFileSystem().getStatus();
                    return status.annotateIcon(this.icon, n, hashSet);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                }
            }
            return this.icon;
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public String getHtmlDisplayName() {
            String string = super.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                // empty catch block
            }
            return this.broken ? "<font color=\"#A40000\">" + string + "</font>" : null;
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[0];
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(J2MEProjectRootNode.class);
        }

        public synchronized Action[] getActions(boolean bl) {
            if (bl) {
                return new Action[0];
            }
            if (this.actions == null) {
                ArrayList<Action> arrayList = new ArrayList<Action>();
                ResourceBundle resourceBundle = NbBundle.getBundle(J2MEPhysicalViewProvider.class);
                arrayList.add(CommonProjectActions.newFileAction());
                arrayList.add(null);
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildAction_Name"), null));
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)resourceBundle.getString("LBL_RebuildAction_Name"), null));
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null));
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"javadoc", (String)resourceBundle.getString("LBL_JavadocAction_Name"), null));
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"deploy", (String)resourceBundle.getString("LBL_DeployAction_Name"), null));
                arrayList.add(null);
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build-all", (String)resourceBundle.getString("LBL_BuildAllAction_Name"), null));
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild-all", (String)resourceBundle.getString("LBL_RebuildAllAction_Name"), null));
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean-all", (String)resourceBundle.getString("LBL_CleanAllAction_Name"), null));
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"deploy-all", (String)resourceBundle.getString("LBL_DeployAllAction_Name"), null));
                arrayList.add(null);
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null));
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"runwith", (String)resourceBundle.getString("LBL_RunWithAction_Name"), null));
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)resourceBundle.getString("LBL_DebugAction_Name"), null));
                arrayList.add(null);
                arrayList.add(CommonProjectActions.setAsMainProjectAction());
                arrayList.add(CommonProjectActions.openSubprojectsAction());
                arrayList.add(CommonProjectActions.closeProjectAction());
                arrayList.add(null);
                arrayList.add(CommonProjectActions.renameProjectAction());
                arrayList.add(CommonProjectActions.moveProjectAction());
                arrayList.add(CommonProjectActions.copyProjectAction());
                arrayList.add(CommonProjectActions.deleteProjectAction());
                arrayList.add(null);
                arrayList.add((Action)SystemAction.get(FindAction.class));
                arrayList.add(null);
                arrayList.add(new RefreshPackagesAction());
                arrayList.add(null);
                try {
                    Repository repository = Repository.getDefault();
                    FileSystem fileSystem = repository.getDefaultFileSystem();
                    FileObject fileObject = fileSystem.findResource("Projects/Actions");
                    if (fileObject != null) {
                        DataObject dataObject = DataObject.find((FileObject)fileObject);
                        FolderLookup folderLookup = new FolderLookup((DataObject.Container)((DataFolder)dataObject));
                        Lookup.Template template = new Lookup.Template(Object.class);
                        Lookup lookup = folderLookup.getLookup();
                        Iterator iterator = lookup.lookup(template).allInstances().iterator();
                        if (iterator.hasNext()) {
                            arrayList.add(null);
                        }
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            if (e instanceof Action) {
                                arrayList.add((Action)e);
                                continue;
                            }
                            if (!(e instanceof JSeparator)) continue;
                            arrayList.add(null);
                        }
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
                }
                arrayList.add(null);
                arrayList.add(CommonProjectActions.customizeProjectAction());
                this.actions = arrayList.toArray(new Action[arrayList.size()]);
                arrayList.add(arrayList.size() - 1, this.createBrokenLinksAction());
                this.actionsBroken = arrayList.toArray(new Action[arrayList.size()]);
            }
            return this.broken ? this.actionsBroken : this.actions;
        }

        private Action createBrokenLinksAction() {
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BrokenReferencesSupport.showCustomizer((AntProjectHelper)J2MEPhysicalViewProvider.this.helper, (ReferenceHelper)J2MEPhysicalViewProvider.this.refHelper, (String[])J2MEPhysicalViewProvider.this.getBreakableProperties(), (String[])J2MEPhysicalViewProvider.this.getBreakablePlatformProperties());
                    J2MEProjectRootNode.this.checkBroken();
                }
            };
            abstractAction.putValue("Name", NbBundle.getMessage(J2MEPhysicalViewProvider.class, (String)"LAB_ResolveReferenceProblems"));
            return abstractAction;
        }

        public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        }

        public void propertiesChanged(AntProjectEvent antProjectEvent) {
            this.checkBroken();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.checkBroken();
        }

        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            this.checkBroken();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class LogicalViewChildren
    extends Children.Keys {
        private final J2MEProject project;
        private final NodeCache cache;
        private final HashMap<String, ChildLookup> keyMap = new HashMap();

        LogicalViewChildren(J2MEProject j2MEProject) {
            this.project = j2MEProject;
            this.cache = new NodeCache(j2MEProject);
            this.keyMap.put("Sources", new SourcesViewProvider());
            this.keyMap.put("Resources", new ResViewProvider(this.cache));
            this.keyMap.put("Configurations", new LibResViewProvider(this.cache));
            this.project.getConfigurationHelper().addPropertyChangeListener(new CfgListener());
            this.setKeys(this.getKeys());
        }

        public void refreshResources() {
            this.refreshKey("Resources");
        }

        public void refreshConfigurations() {
            this.refreshKey("Configurations");
        }

        public void refreshNode(String string) {
            this.cache.update(string);
        }

        protected Node[] createNodes(Object object) {
            ChildLookup childLookup = this.keyMap.get(object);
            return childLookup != null ? childLookup.createNodes(this.project) : null;
        }

        private Collection<String> getKeys() {
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("Sources");
            arrayList.add("Resources");
            arrayList.add("Configurations");
            return arrayList;
        }

        private class CfgListener
        implements PropertyChangeListener,
        Runnable {
            private CfgListener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RequestProcessor.getDefault().post((Runnable)this);
            }

            public void run() {
                LogicalViewChildren.this.refreshResources();
            }
        }
    }

    static abstract class ChildLookup
    extends ProxyLookup {
        ChildLookup() {
        }

        public abstract Node[] createNodes(J2MEProject var1);
    }
}

