/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicBorders;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.regex.CheckedTreeBeanView;
import org.netbeans.modules.mobility.project.ui.customizer.regex.FileObjectCookie;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class CustomizerFiltering
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ActionListener {
    private static final String GENERAL_EXCLUDES = "^(.*/)?(([^/]*\\.class)|([^/]*\\.form)|(\\.nbintdb)|([^/]*\\.mvd)|([^/]*\\.wsclient)";
    private static final String STANDARD_ANT_EXCLUDES = "([^/]*~)|(#[^/]*#)|(\\.#[^/]*)|(%[^/]*%)|(\\._[^/]*)|(CVS)|(CVS/.*)|(\\.cvsignore)|(SCCS)|(SCCS/.*)|(vssver\\.scc)|(\\.svn)|(\\.svn/.*)|(\\.DS_Store)";
    private static final String TEST_EXCLUDES = "([^/]*Test\\.java)|(test)|(test/.*)";
    static final String[] PROPERTY_GROUP = new String[]{"filter.use.standard", "filter.exclude.tests", "filter.excludes", "filter.more.excludes"};
    private VisualPropertySupport vps;
    private CheckedTreeBeanView treeView;
    private ExplorerManager manager;
    private ExplorerPanel sourceExplorer;
    private Pattern filter;
    private Map<String, Object> properties;
    private String configuration;
    private FileObject srcRoot;
    private String excludesTranslatedPropertyName;
    private JCheckBox defaultCheck;
    private JCheckBox jCheckBoxCVS;
    private JCheckBox jCheckBoxTests;
    private JLabel jLabelExcludes;
    private JLabel jLabelTree;
    private JPanel jPanelTree;
    private JTextField jTextFieldExcludes;

    public CustomizerFiltering() {
        this.initComponents();
        this.initAccessibility();
        this.jPanelTree.setBorder(BasicBorders.getTextFieldBorder());
        this.sourceExplorer = new ExplorerPanel();
        this.manager = this.sourceExplorer.getExplorerManager();
        this.treeView = new CheckedTreeBeanView();
        this.jLabelTree.setLabelFor((Component)((Object)this.treeView));
        this.treeView.setPopupAllowed(false);
        this.treeView.setRootVisible(false);
        this.treeView.setDefaultActionAllowed(false);
        this.sourceExplorer.setLayout(new BorderLayout());
        this.sourceExplorer.add((Component)((Object)this.treeView), "Center");
        this.sourceExplorer.setPreferredSize(new Dimension(200, 250));
        this.jPanelTree.add((Component)this.sourceExplorer, "Center");
    }

    private void initComponents() {
        this.defaultCheck = new JCheckBox();
        this.jCheckBoxCVS = new JCheckBox();
        this.jCheckBoxTests = new JCheckBox();
        this.jLabelTree = new JLabel();
        this.jPanelTree = new JPanel();
        this.jLabelExcludes = new JLabel();
        this.jTextFieldExcludes = new JTextField();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.defaultCheck, (String)NbBundle.getMessage(CustomizerFiltering.class, (String)"LBL_Use_Default"));
        this.defaultCheck.setMargin(new Insets(0, 0, 0, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        this.add((Component)this.defaultCheck, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxCVS, (String)NbBundle.getMessage(CustomizerFiltering.class, (String)"LBL_CustFilter_DefaultExcludes"));
        this.jCheckBoxCVS.setToolTipText(NbBundle.getMessage(CustomizerFiltering.class, (String)"TTT_CustFilter_DefaultExcludes"));
        this.jCheckBoxCVS.setMargin(new Insets(0, 0, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jCheckBoxCVS, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxTests, (String)NbBundle.getMessage(CustomizerFiltering.class, (String)"LBL_CustFilter_ExcludeTests"));
        this.jCheckBoxTests.setToolTipText(NbBundle.getMessage(CustomizerFiltering.class, (String)"TTT_CustFilter_ExcludeTests"));
        this.jCheckBoxTests.setMargin(new Insets(0, 0, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jCheckBoxTests, gridBagConstraints);
        this.jLabelTree.setLabelFor(this.sourceExplorer);
        Mnemonics.setLocalizedText((JLabel)this.jLabelTree, (String)NbBundle.getMessage(CustomizerFiltering.class, (String)"LBL_CustFilter_SelectFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabelTree, gridBagConstraints);
        this.jPanelTree.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jPanelTree, gridBagConstraints);
        this.jLabelExcludes.setLabelFor(this.jTextFieldExcludes);
        Mnemonics.setLocalizedText((JLabel)this.jLabelExcludes, (String)NbBundle.getMessage(CustomizerFiltering.class, (String)"LBL_CustFilter_Excludes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabelExcludes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 0);
        this.add((Component)this.jTextFieldExcludes, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerFiltering.class, (String)"ACSN_CustFilter"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerFiltering.class, (String)"ACSD_CustFilter"));
    }

    public void initValues(ProjectProperties projectProperties, String string) {
        this.vps = VisualPropertySupport.getDefault(projectProperties);
        this.properties = projectProperties;
        this.configuration = string;
        this.srcRoot = projectProperties.getSourceRoot();
        this.treeView.setSrcRoot(this.srcRoot);
        this.vps.register(this.defaultCheck, string, this);
    }

    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }

    public void initGroupValues(boolean bl) {
        this.jCheckBoxCVS.removeActionListener(this);
        this.jCheckBoxTests.removeActionListener(this);
        this.vps.register(this.jCheckBoxCVS, "filter.use.standard", bl);
        this.vps.register(this.jCheckBoxTests, "filter.exclude.tests", bl);
        this.vps.register(this.jTextFieldExcludes, "filter.more.excludes", bl);
        this.excludesTranslatedPropertyName = VisualPropertySupport.translatePropertyName(this.configuration, "filter.excludes", bl);
        this.initTree();
        this.treeView.setEditable(!bl);
        this.jLabelTree.setEnabled(!bl);
        this.jLabelExcludes.setEnabled(!bl);
        this.jCheckBoxCVS.addActionListener(this);
        this.jCheckBoxTests.addActionListener(this);
    }

    private void initTree() {
        String string = this.jCheckBoxCVS.isSelected() ? (this.jCheckBoxTests.isSelected() ? "^(.*/)?(([^/]*\\.class)|([^/]*\\.form)|(\\.nbintdb)|([^/]*\\.mvd)|([^/]*\\.wsclient)|([^/]*~)|(#[^/]*#)|(\\.#[^/]*)|(%[^/]*%)|(\\._[^/]*)|(CVS)|(CVS/.*)|(\\.cvsignore)|(SCCS)|(SCCS/.*)|(vssver\\.scc)|(\\.svn)|(\\.svn/.*)|(\\.DS_Store)|([^/]*Test\\.java)|(test)|(test/.*))$" : "^(.*/)?(([^/]*\\.class)|([^/]*\\.form)|(\\.nbintdb)|([^/]*\\.mvd)|([^/]*\\.wsclient)|([^/]*~)|(#[^/]*#)|(\\.#[^/]*)|(%[^/]*%)|(\\._[^/]*)|(CVS)|(CVS/.*)|(\\.cvsignore)|(SCCS)|(SCCS/.*)|(vssver\\.scc)|(\\.svn)|(\\.svn/.*)|(\\.DS_Store))$") : (this.jCheckBoxTests.isSelected() ? "^(.*/)?(([^/]*\\.class)|([^/]*\\.form)|(\\.nbintdb)|([^/]*\\.mvd)|([^/]*\\.wsclient)|([^/]*Test\\.java)|(test)|(test/.*))$" : "^(.*/)?(([^/]*\\.class)|([^/]*\\.form)|(\\.nbintdb)|([^/]*\\.mvd)|([^/]*\\.wsclient))$");
        this.filter = Pattern.compile(string);
        try {
            DataObject dataObject = DataObject.find((FileObject)this.srcRoot);
            this.manager.setRootContext((Node)new FOBNode(dataObject.getNodeDelegate().cloneNode(), dataObject.getPrimaryFile()));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            this.manager.setRootContext(Node.EMPTY);
        }
        this.treeView.registerProperty(this.properties, this.excludesTranslatedPropertyName, this.filter);
    }

    boolean acceptFileObject(FileObject fileObject) {
        String string = FileUtil.getRelativePath((FileObject)this.srcRoot, (FileObject)fileObject);
        return string != null && !this.filter.matcher(string).matches();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.initTree();
    }

    private static class ExplorerPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private final ExplorerManager manager = new ExplorerManager();

        private ExplorerPanel() {
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }
    }

    private class FOBChildren
    extends FilterNode.Children {
        public FOBChildren(Node node) {
            super(node);
        }

        protected Node[] createNodes(Node node) {
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject == null) {
                return new Node[0];
            }
            ArrayList<FOBNode> arrayList = new ArrayList<FOBNode>();
            for (FileObject fileObject : dataObject.files()) {
                if (!CustomizerFiltering.this.acceptFileObject(fileObject)) continue;
                arrayList.add(new FOBNode(node.cloneNode(), fileObject));
            }
            return arrayList.toArray(new Node[arrayList.size()]);
        }
    }

    private class FOBNode
    extends FilterNode
    implements FileObjectCookie {
        private final FileObject fo;

        public FOBNode(Node node, FileObject fileObject) {
            super(node, (Children)(fileObject.isData() ? Children.LEAF : new FOBChildren(node)));
            this.fo = fileObject;
            this.disableDelegation(15);
            this.setName(fileObject.getNameExt());
            this.setDisplayName(fileObject.getNameExt());
        }

        public Node.Cookie getCookie(Class clazz) {
            if (FileObjectCookie.class.isAssignableFrom(clazz)) {
                return this;
            }
            return super.getCookie(clazz);
        }

        public FileObject getFileObject() {
            return this.fo;
        }
    }
}

