/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard.i18n;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.mobility.project.ui.wizard.FileWizardIterator;
import org.netbeans.modules.mobility.project.ui.wizard.i18n.LocalizationSupportPanel;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizationSupportIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = -1789843546389L;
    protected static final String JAVA_EXTENSION = "java";
    protected static LocalizationSupportIterator instance;
    protected transient int panelIndex = 0;
    protected transient WizardDescriptor.Panel[] panels;
    protected transient TemplateWizard wizardInstance;
    public static final String MESSAGE_BUNDLE_FILENAME = "MESSAGE_BUNDLE_FILENAME";
    public static final String MESSAGE_BUNDLE_RESOURCE_NAME_KEYWORD = "__MESSAGE_BUNDLE_RESOURCE_NAME__";
    public static final String DEFAULT_STRING_KEYWORD = "__DEFAULT_STRING__";
    public static final String DEFAULT_ERROR_KEYWORD = "__DEFAULT_ERROR__";

    public static synchronized LocalizationSupportIterator singleton() {
        if (instance == null) {
            instance = new LocalizationSupportIterator();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException, IllegalArgumentException {
        Object object;
        InputStreamReader inputStreamReader = null;
        OutputStreamWriter outputStreamWriter = null;
        FileLock fileLock = null;
        this.wizardInstance = templateWizard;
        String string = (String)this.wizardInstance.getProperty(MESSAGE_BUNDLE_FILENAME);
        String string2 = (String)this.wizardInstance.getProperty(MESSAGE_BUNDLE_RESOURCE_NAME_KEYWORD);
        String string3 = (String)this.wizardInstance.getProperty(DEFAULT_STRING_KEYWORD);
        String string4 = (String)this.wizardInstance.getProperty(DEFAULT_ERROR_KEYWORD);
        HashSet<DataObject> hashSet = new HashSet<DataObject>();
        DataObject dataObject = this.instantiateTemplate(templateWizard.getTemplate(), templateWizard.getTargetFolder(), templateWizard.getTargetName(), true);
        FileObject fileObject = templateWizard.getTemplate().getPrimaryFile().getParent();
        DataObject dataObject2 = DataObject.find((FileObject)fileObject.getFileObject("LocalizationSupport", "properties"));
        DataObject dataObject3 = this.instantiateTemplate(dataObject2, templateWizard.getTargetFolder(), string, false);
        hashSet.add(dataObject);
        hashSet.add(dataObject3);
        try {
            object = dataObject.getPrimaryFile();
            inputStreamReader = new InputStreamReader(object.getInputStream());
            char[] cArray = new char[40];
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while ((n = inputStreamReader.read(cArray)) >= 0) {
                stringBuffer.append(cArray, 0, n);
            }
            inputStreamReader.close();
            inputStreamReader = null;
            String string5 = stringBuffer.toString();
            string5 = string5.replaceAll(MESSAGE_BUNDLE_RESOURCE_NAME_KEYWORD, string2);
            string5 = string5.replaceAll(DEFAULT_STRING_KEYWORD, string3);
            string5 = string5.replaceAll(DEFAULT_ERROR_KEYWORD, string4);
            fileLock = object.lock();
            outputStreamWriter = new OutputStreamWriter(object.getOutputStream(fileLock));
            outputStreamWriter.write(string5);
        }
        finally {
            object = null;
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {
                object = iOException;
            }
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {
                object = iOException;
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            if (object != null) {
                throw object;
            }
        }
        return hashSet;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.panelIndex];
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wizardInstance = templateWizard;
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new LocalizationSupportPanel()};
        }
        this.panelIndex = 0;
        this.updateStepsList();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.wizardInstance = null;
        this.panels = null;
        this.panelIndex = -1;
    }

    private DataObject instantiateTemplate(DataObject dataObject, DataFolder dataFolder, String string, boolean bl) throws IOException {
        if (string == null) {
            string = this.getDefaultName(dataObject, dataFolder);
        }
        this.checkValidPackageName(dataFolder);
        if (bl) {
            this.checkTargetName(string);
        }
        return dataObject.createFromTemplate(dataFolder, string);
    }

    private boolean isValidPackageName(String string) {
        if ("".equals(string)) {
            return true;
        }
        return Utilities.isJavaIdentifier((String)string);
    }

    private void checkValidPackageName(DataFolder dataFolder) throws IllegalStateException {
        FileObject fileObject = dataFolder.getPrimaryFile();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        String string = null;
        if (classPath != null) {
            String string2 = classPath.getResourceName(fileObject, '.', false);
            if (this.isValidPackageName(string2)) {
                return;
            }
            string = MessageFormat.format(LocalizationSupportIterator.getString("ERR_File_IllegalFolderName"), fileObject.getPath(), string2);
        } else {
            string = LocalizationSupportIterator.getString("ERR_File_NotInSourcePath");
        }
        throw (IllegalStateException)ErrorManager.getDefault().annotate((Throwable)new IllegalStateException(string), 256, null, string, null, null);
    }

    private boolean checkTargetName(String string) {
        if (!Utilities.isJavaIdentifier((String)string)) {
            String string2 = MessageFormat.format(LocalizationSupportIterator.getString("ERR_File_IllegalTargetName"), string);
            this.notifyError(string2);
            return false;
        }
        return true;
    }

    private void notifyError(String string) {
        this.wizardInstance.putProperty("WizardPanel_errorMessage", (Object)string);
        IllegalStateException illegalStateException = new IllegalStateException(string);
        ErrorManager.getDefault().annotate((Throwable)illegalStateException, 256, null, string, null, null);
        throw illegalStateException;
    }

    private String getDefaultName(DataObject dataObject, DataFolder dataFolder) {
        String string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)dataObject.getName(), (String)JAVA_EXTENSION);
        return string;
    }

    static String getString(String string) {
        return NbBundle.getMessage(FileWizardIterator.class, (String)string);
    }

    static char getMnemonic(String string) {
        return LocalizationSupportIterator.getString(string).charAt(0);
    }

    private void updateStepsList() {
        JComponent jComponent = (JComponent)this.current().getComponent();
        jComponent.putClientProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(LocalizationSupportIterator.class, (String)"TITLE_File")});
        jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.panelIndex));
    }
}

